#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
#*******************************************************************************
#
#  Copyright 2026 RIEGL Laser Measurement Systems
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#  SPDX-License-Identifier: Apache-2.0
#
#*******************************************************************************
#
"""
rdb-example-07-fill-points.py

This example shows how to open an existing database and to fill (set)
a point attribute with a constant value for all points. Please note
that this could also be accomplished by combining select and update
queries as shown in "rdb-example-4-update-points.py", but the fill
query might be faster (lower processing time) and easier to use.
This example is based on the database of rdb-example-1-create-database.
"""

import riegl.rdb

# Access existing database
with riegl.rdb.rdb_open("pointcloud.rdbx") as rdb:
    # Before we can modify the database, we must start a transaction
    with riegl.rdb.Transaction(
        rdb,  # point cloud object
        "Fill",  # transaction title
        "Point Classifier v1.0"  # software name
    ) as transaction:

        # Set point class and color to a fixed value for all points
        with rdb.fill() as fill:
            fill.value(rdb.point_attributes["riegl.class"], 0)
            fill.value(rdb.point_attributes["riegl.rgba"], (255, 255, 255, 255))
            while fill.next(10000) > 0:
                print(f"{fill.progress()}% done")

        # Set different class and color for points that have a reflectance of
        # at least 10 dB. This is actually the same as above but with different
        # constants and a filter expression supplied to the fill() function.
        with rdb.fill("riegl.reflectance >= 10") as fill:
            fill.value(rdb.point_attributes["riegl.class"], 101)
            fill.value(rdb.point_attributes["riegl.rgba"], (255, 102, 0, 255))
            while fill.next(10000) > 0:
                print(f"{fill.progress()}% done")

        # Finally commit transaction
        transaction.commit()
