/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    dataTypes.inc
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Point attribute access data types
 * \version 2015-10-14/AW: Initial version
 *
 *******************************************************************************
 */

//---< INCLUDES >---------------------------------------------------------------

#include <cstdlib>

#include "riegl/rdb/pointcloud/dataTypes.h"
#include "riegl/rdb/pointcloud/dataTypes.hpp"

//---< TOOLS >------------------------------------------------------------------

namespace {

//______________________________________________________________________________
/*!
 * \brief Convert data type
 *
 * This function converts the given buffer data type from integer to enum.
 */
riegl::rdb::pointcloud::DataType convertDataType(const std::uint32_t &value)
{
    switch (value)
    {
        case RDBDataTypeUINT8:   return riegl::rdb::pointcloud::UINT8;
        case RDBDataTypeINT8:    return riegl::rdb::pointcloud::INT8;
        case RDBDataTypeUINT16:  return riegl::rdb::pointcloud::UINT16;
        case RDBDataTypeINT16:   return riegl::rdb::pointcloud::INT16;
        case RDBDataTypeUINT32:  return riegl::rdb::pointcloud::UINT32;
        case RDBDataTypeINT32:   return riegl::rdb::pointcloud::INT32;
        case RDBDataTypeUINT64:  return riegl::rdb::pointcloud::UINT64;
        case RDBDataTypeINT64:   return riegl::rdb::pointcloud::INT64;
        case RDBDataTypeSINGLE:  return riegl::rdb::pointcloud::SINGLE;
        case RDBDataTypeDOUBLE:  return riegl::rdb::pointcloud::DOUBLE;
        default:                 return riegl::rdb::pointcloud::NONE;
    }
} // convertDataType()

} // anonymous namespace
