/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    dataTypes.h
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Point attribute access data types
 * \version 2015-10-14/AW: Initial version
 *
 *******************************************************************************
 */

#ifndef RIEGL_RDB_POINTCLOUD_DATATYPES_H
#define RIEGL_RDB_POINTCLOUD_DATATYPES_H

//---< CONSTANTS >--------------------------------------------------------------

#define RDBDataTypeNONE    0 //!< undefined data type
#define RDBDataTypeUINT8   1 //!<  8 bit unsigned integer
#define RDBDataTypeINT8    2 //!<  8 bit   signed integer
#define RDBDataTypeUINT16  3 //!< 16 bit unsigned integer
#define RDBDataTypeINT16   4 //!< 16 bit   signed integer
#define RDBDataTypeUINT32  5 //!< 32 bit unsigned integer
#define RDBDataTypeINT32   6 //!< 32 bit   signed integer
#define RDBDataTypeUINT64  7 //!< 64 bit unsigned integer
#define RDBDataTypeINT64   8 //!< 64 bit   signed integer
#define RDBDataTypeSINGLE  9 //!< 32 bit single precision floating point value
#define RDBDataTypeDOUBLE 10 //!< 64 bit double precision floating point value

#endif // RIEGL_RDB_POINTCLOUD_DATATYPES_H
