/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    graphNode.cpp
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Index graph node (C++ wrapper code)
 * \version 2015-10-14/AW: Initial version
 *
 *******************************************************************************
 */

//---< INCLUDES >---------------------------------------------------------------

#include "riegl/rdb.h"
#include "riegl/rdb.hpp"

//---< NAMESPACE >--------------------------------------------------------------

namespace riegl {
namespace rdb {
namespace pointcloud {

//---< GraphNodeWrapper >-------------------------------------------------------

struct GraphNodeWrapper
{
    RDBContext             *context;
    RDBPointcloudGraphNode *handle;

    GraphNodeWrapper(RDBContext *context):
        context(context)
    {
        ErrorImpl::check(context, rdb_pointcloud_graph_node_new(context, &handle));
    }

    ~GraphNodeWrapper()
    {
        ErrorImpl::check(context, rdb_pointcloud_graph_node_delete(context, &handle));
    }
};

//---< GraphNode::PUBLIC >------------------------------------------------------

GraphNode::GraphNode():
    id(0),
    revision(0),
    children(),
    pointCountTotal(0),
    pointCountNode(0)
{
}

}}} // namespace riegl::rdb::pointcloud
