#*
#*******************************************************************************
#*
#*  Copyright 2026 RIEGL Laser Measurement Systems
#*
#*  Licensed under the Apache License, Version 2.0 (the "License");
#*  you may not use this file except in compliance with the License.
#*  You may obtain a copy of the License at
#*
#*      http://www.apache.org/licenses/LICENSE-2.0
#*
#*  Unless required by applicable law or agreed to in writing, software
#*  distributed under the License is distributed on an "AS IS" BASIS,
#*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#*  See the License for the specific language governing permissions and
#*  limitations under the License.
#*
#*  SPDX-License-Identifier: Apache-2.0
#*
#*******************************************************************************
#*
#*
#*******************************************************************************
#*
#* \file    rdb-config.pri
#* \author  RIEGL LMS GmbH, Austria
#* \brief   qmake config file for the RDB C/C++ interface with dynamic linking
#* \version 2015-12-10/AW: Initial version
#* \version 2017-01-10/AW: rdb-config.pri moved up one folder
#* \version 2017-03-24/AW: Library search paths fixed
#*
#*  In the project's .pro file write (adjust <rdb-root> to your needs):
#*
#*      include(<rdb-root>/interface/cpp/rdb-config.pri)
#*
#*  Compiling the interface sources should be automatic and
#*  fully transparent.
#*
#*******************************************************************************
#*

RDB_ROOT = $${PWD}/../..

INCLUDEPATH += \
    $${RDB_ROOT}/interface/c \
    $${RDB_ROOT}/interface/cpp

SOURCES += \
    $${RDB_ROOT}/interface/cpp/riegl/rdb.cpp

win32 {
    LIBS += -L$${RDB_ROOT}/library -lrdblib
}
unix {
    darwin {
        LIBS += -L$${RDB_ROOT}/library -lrdb
    } else: {
        LIBS += -L$${RDB_ROOT}/library -lrdb
    }
    QMAKE_CXXFLAGS += -std=c++11
}
