#*
#*******************************************************************************
#*
#*  Copyright 2025 RIEGL Laser Measurement Systems
#*
#*  Licensed under the Apache License, Version 2.0 (the "License");
#*  you may not use this file except in compliance with the License.
#*  You may obtain a copy of the License at
#*
#*      http://www.apache.org/licenses/LICENSE-2.0
#*
#*  Unless required by applicable law or agreed to in writing, software
#*  distributed under the License is distributed on an "AS IS" BASIS,
#*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#*  See the License for the specific language governing permissions and
#*  limitations under the License.
#*
#*  SPDX-License-Identifier: Apache-2.0
#*
#*******************************************************************************
#*
#*
#*******************************************************************************
#*
#* \file    rdb-config-rtl.pri
#* \author  RIEGL LMS GmbH, Austria
#* \brief   qmake config file for the RDB C/C++ interface with run-time linking
#* \version 2020-04-10/AW: Initial version
#*
#*  In the project's .pro file write (adjust <rdb-root> to your needs):
#*
#*      include(<rdb-root>/interface/cpp/rdb-config-rtl.pri)
#*
#*  In this case, the library is not automatically loaded on application startup
#*  and must be manually loaded by calling the function riegl::rdb::library::load().
#*
#*******************************************************************************
#*

RDB_ROOT = $${PWD}/../..

DEFINES += RDB_RUNTIME_LINKING

INCLUDEPATH += \
    $${RDB_ROOT}/interface/c \
    $${RDB_ROOT}/interface/cpp

SOURCES += \
    $${RDB_ROOT}/interface/cpp/riegl/rdb.cpp

unix {
    QMAKE_CXXFLAGS += -std=c++11
    LIBS += -ldl
}
