/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    progress.h
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Operation progress feedback tools
 * \version 2016-06-14/AW: Initial version
 *
 *******************************************************************************
 */

#ifndef RIEGL_RDB_PROGRESS_H
#define RIEGL_RDB_PROGRESS_H

//---< INCLUDES >---------------------------------------------------------------

#include <stdint.h>
#include "riegl/rdb.h"

RDB_LIBRARY_API_BEGIN

//---< TYPE DEFINITIONS >-------------------------------------------------------

//______________________________________________________________________________
/*!
 * \brief Progress callback function type
 *
 * Various RDB API functions may accept an optional progress function pointer.
 * That progress function will be called by the API function on a regular basis
 * to communicate the progress of the operation to the client application.
 *
 * Along with the function pointer a pointer to some user data may be provided
 * to the API function. This pointer will then be provided to the callback
 * function which can use it to get or store some context information. Please
 * note that the library doesn't use the user data in any way - it is just
 * relayed from the caller to the progress callback function.
 *
 * It is guaranteed that the callback function is only called from within the
 * API function (i.e. it is not called after the API function returned). But
 * it is =NOT= guaranteed that the callback function is called from within the
 * same thread context as the API function.
 */
typedef void (*RDBProgress)(
    uint8_t progress, //!< progress value in percent [0..100%]
    void   *userdata  //!< pointer to user (client) data
);

RDB_LIBRARY_API_END

#endif // RIEGL_RDB_PROGRESS_H
