{*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *}
{*!
 *******************************************************************************
 *
 * \file    riegl.rdb.pas
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Main RDB library include file (Pascal wrapper code)
 * \version 2015-10-14/AW: Initial version
 * \version 2017-11-10/AW: Type 'TRDBInt32' changed from 'Integer' to 'Longint'
 * \version 2018-07-06/AW: Fix 'TRDBUInt64', add 'Float32|64' and array types
 * \version 2020-07-03/AW: Add context-free function result type (TRDBResultCF)
 *
 *******************************************************************************
 *}

unit riegl.rdb;

{******************************************************************************}
{***} INTERFACE {**************************************************************}
{******************************************************************************}

//---< TYPE DEFINITIONS >-------------------------------------------------------

type
  TRDBResult   = System.Longint;   //!< function return value type
  TRDBResultCF = System.Pointer;   //!< cf-function return value type
  TRDBString   = System.PAnsiChar; //!< simple string type
  PRDBString   = ^TRDBString;      //!< pointer to string

type
  TRDBInt8    = System.Shortint;   PRDBInt8    = ^TRDBInt8;    //!<  8 bit   signed integer
  TRDBUInt8   = System.Byte;       PRDBUInt8   = ^TRDBUInt8;   //!<  8 bit unsigned integer
  TRDBInt16   = System.Smallint;   PRDBInt16   = ^TRDBInt16;   //!< 16 bit   signed integer
  TRDBUInt16  = System.Word;       PRDBUInt16  = ^TRDBUInt16;  //!< 16 bit unsigned integer
  TRDBInt32   = System.Longint;    PRDBInt32   = ^TRDBInt32;   //!< 32 bit   signed integer
  TRDBUInt32  = System.Cardinal;   PRDBUInt32  = ^TRDBUInt32;  //!< 32 bit unsigned integer
  TRDBInt64   = System.Int64;      PRDBInt64   = ^TRDBInt64;   //!< 64 bit   signed integer
  TRDBUInt64  = System.UInt64;     PRDBUInt64  = ^TRDBUInt64;  //!< 64 bit unsigned integer
  TRDBFloat32 = System.Single;     PRDBFloat32 = ^TRDBFloat32; //!< 32 bit single precision floating point value
  TRDBFloat64 = System.Double;     PRDBFloat64 = ^TRDBFloat64; //!< 64 bit double precision floating point value

type
  TRDBArrayOfInt8    = array of TRDBInt8;    //!<  8 bit   signed integer
  TRDBArrayOfUInt8   = array of TRDBUInt8;   //!<  8 bit unsigned integer
  TRDBArrayOfInt16   = array of TRDBInt16;   //!< 16 bit   signed integer
  TRDBArrayOfUInt16  = array of TRDBUInt16;  //!< 16 bit unsigned integer
  TRDBArrayOfInt32   = array of TRDBInt32;   //!< 32 bit   signed integer
  TRDBArrayOfUInt32  = array of TRDBUInt32;  //!< 32 bit unsigned integer
  TRDBArrayOfInt64   = array of TRDBInt64;   //!< 64 bit   signed integer
  TRDBArrayOfUInt64  = array of TRDBUInt64;  //!< 64 bit unsigned integer
  TRDBArrayOfFloat32 = array of TRDBFloat32; //!< 32 bit single precision floating point value
  TRDBArrayOfFloat64 = array of TRDBFloat64; //!< 64 bit double precision floating point value

type
  TRDBContextHandle                  = System.Pointer;   PRDBContextHandle                  = ^TRDBContextHandle;
  TRDBPointcloudHandle               = System.Pointer;   PRDBPointcloudHandle               = ^TRDBPointcloudHandle;
  TRDBPointcloudPointAttributeHandle = System.Pointer;   PRDBPointcloudPointAttributeHandle = ^TRDBPointcloudPointAttributeHandle;
  TRDBPointcloudCreateSettingsHandle = System.Pointer;   PRDBPointcloudCreateSettingsHandle = ^TRDBPointcloudCreateSettingsHandle;
  TRDBPointcloudOpenSettingsHandle   = System.Pointer;   PRDBPointcloudOpenSettingsHandle   = ^TRDBPointcloudOpenSettingsHandle;
  TRDBPointcloudTransactionHandle    = System.Pointer;   PRDBPointcloudTransactionHandle    = ^TRDBPointcloudTransactionHandle;
  TRDBPointcloudQueryInsertHandle    = System.Pointer;   PRDBPointcloudQueryInsertHandle    = ^TRDBPointcloudQueryInsertHandle;
  TRDBPointcloudQueryUpdateHandle    = System.Pointer;   PRDBPointcloudQueryUpdateHandle    = ^TRDBPointcloudQueryUpdateHandle;
  TRDBPointcloudQueryRemoveHandle    = System.Pointer;   PRDBPointcloudQueryRemoveHandle    = ^TRDBPointcloudQueryRemoveHandle;
  TRDBPointcloudQuerySelectHandle    = System.Pointer;   PRDBPointcloudQuerySelectHandle    = ^TRDBPointcloudQuerySelectHandle;
  TRDBPointcloudQueryStatHandle      = System.Pointer;   PRDBPointcloudQueryStatHandle      = ^TRDBPointcloudQueryStatHandle;
  TRDBPointcloudQueryFillHandle      = System.Pointer;   PRDBPointcloudQueryFillHandle      = ^TRDBPointcloudQueryFillHandle;
  TRDBPointcloudQueryInvertHandle    = System.Pointer;   PRDBPointcloudQueryInvertHandle    = ^TRDBPointcloudQueryInvertHandle;

//---< CONSTANTS >--------------------------------------------------------------

const
{$IFDEF LINUX} // Lazarus on Linux
  RDB_LIBRARY_FILENAME = 'librdb'; //!< RDB library filename
{$ELSE} // Delphi or Lazarus on Windows
  RDB_LIBRARY_FILENAME = 'rdblib'; //!< RDB library filename
{$ENDIF}

const
  RDB_SUCCESS = 1; //!< function terminated successfully
  RDB_FAILURE = 0; //!< function execution failed

//---< TOOLS >------------------------------------------------------------------

function AsSTDString(const Value : TRDBString) : System.String;

{******************************************************************************}
{***} IMPLEMENTATION {*********************************************************}
{******************************************************************************}

//---< TOOLS >------------------------------------------------------------------

function AsSTDString(const Value : TRDBString) : System.String;
begin
  Result := Utf8ToAnsi(System.AnsiString(Value));
end; // AsSTDString()

end.