#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
#*******************************************************************************
#
#  Copyright 2025 RIEGL Laser Measurement Systems
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#  SPDX-License-Identifier: Apache-2.0
#
#*******************************************************************************
#
"""
rdb-example-10-attribute-groups.py

This example shows how to open an existing database and output the
point attribute group names and the point attributes in each group.

Example output:

  Coordinates/Vectors:
    - XYZ (riegl.xyz)
  Time:
    - Timestamp (riegl.timestamp)
  Primary Attributes:
    - Reflectance (riegl.reflectance)
    - Amplitude (riegl.amplitude)
    - Deviation (riegl.deviation)
    - True Color (riegl.rgba)
    - Target Index (riegl.target_index)
    - Target Count (riegl.target_count)
  Secondary Attributes:
    - Mirror Facet (riegl.mirror_facet)
    - PID (riegl.id)
  Other Attributes:
    - Selected (riegl.selected)
    - Visible (riegl.visible)
"""

import riegl.rdb

# Open existing database using default settings
with riegl.rdb.rdb_open("pointcloud.rdbx") as rdb:
    current_group = None
    for attribute in rdb.point_attributes.values():
        # Query point attribute group
        group, index = rdb.point_attributes.group(attribute.name)
        if current_group != group:  # print name of new group:
            print(group)
            current_group = group

        # Print point attribute details
        print(f"  - {attribute.title} ({attribute.name})")
