/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    changelog.cpp
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Manage point cloud changelog
 * \version 2020-06-29/AW: Initial version
 *
 *******************************************************************************
 */

//---< INCLUDES >---------------------------------------------------------------

#include <cstdlib>

#include "riegl/rdb.h"
#include "riegl/rdb.hpp"

//---< NAMESPACE >--------------------------------------------------------------

namespace riegl {
namespace rdb {
namespace pointcloud {

//---< Changelog::PUBLIC >------------------------------------------------------

Changelog::Changelog(riegl::rdb::PointcloudData* pointcloud): data(pointcloud)
{
}

void Changelog::appendMessage(const std::string &message)
{
    ErrorImpl::check(data->contextHandle(), rdb_pointcloud_changelog_append_log_message(
        data->contextHandle(), data->pointcloud, message.c_str()
    ));
}

bool Changelog::verifyLogEntry(
    const std::string  &entry,
    const std::uint32_t method,
    const std::uint32_t key_size,
    const void* const   key_data
)
{
    std::uint32_t valid(0);
    ErrorImpl::check(rdb_pointcloud_changelog_verify_log_entry_cf(
        entry.c_str(), method, key_size, key_data, &valid
    ));
    return (valid != 0);
}

void Changelog::exportToTextfile(const std::string &filename)
{
    ErrorImpl::check(data->contextHandle(), rdb_pointcloud_changelog_export_to_textfile(
        data->contextHandle(), data->pointcloud, filename.c_str()
    ));
}

void Changelog::importFromDatabase(const std::string &filename)
{
    ErrorImpl::check(data->contextHandle(), rdb_pointcloud_changelog_import_from_database(
        data->contextHandle(), data->pointcloud, filename.c_str()
    ));
}

}}} // namespace riegl::rdb::pointcloud
