{*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *}
{*!
 *******************************************************************************
 *
 * \file    riegl.rdb.result.pas
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Function result for context-free functions
 * \version 2020-02-21/AW: Initial version
 *
 *******************************************************************************
 *}

unit riegl.rdb.result;

{******************************************************************************}
{***} INTERFACE {**************************************************************}
{******************************************************************************}

//---< INCLUDES >---------------------------------------------------------------

uses
  riegl.rdb;

//---< RDB LIBRARY IMPORTS >----------------------------------------------------

//______________________________________________________________________________
{*!
 * \brief Query function result error code
 *}
function rdb_result_get_error_code_cf(
  Handle    : TRDBResultCF; //!< [in]  function result handle
  var Value : TRDBInt32     //!< [out] result error code
) : TRDBResultCF; cdecl; external riegl.rdb.RDB_LIBRARY_FILENAME;

//______________________________________________________________________________
{*!
 * \brief Query function result error text
 *}
function rdb_result_get_error_text_cf(
  Handle    : TRDBResultCF; //!< [in]  function result handle
  var Value : TRDBString    //!< [out] result error text
) : TRDBResultCF; cdecl; external riegl.rdb.RDB_LIBRARY_FILENAME;

//______________________________________________________________________________
{*!
 * \brief Query function result error details
 *}
function rdb_result_get_error_details_cf(
  Handle    : TRDBResultCF; //!< [in]  function result handle
  var Value : TRDBString    //!< [out] result error details
) : TRDBResultCF; cdecl; external riegl.rdb.RDB_LIBRARY_FILENAME;

//______________________________________________________________________________
{*!
 * \brief Delete function result structure
 *}
function rdb_result_delete_cf(
  var Handle : TRDBResultCF //!< [in] function result handle
) : TRDBResultCF; cdecl; external riegl.rdb.RDB_LIBRARY_FILENAME;

//______________________________________________________________________________
{*!
 * \brief Delete string
 *
 * All strings returned by context-free functions ("*_cf") must be deleted.
 *}
function rdb_string_delete_cf(
  var Handle : TRDBString //!< [in] string to be deleted
) : TRDBResultCF; cdecl; external riegl.rdb.RDB_LIBRARY_FILENAME;

{******************************************************************************}
{***} IMPLEMENTATION {*********************************************************}
{******************************************************************************}

end.

