{*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *}
{*!
 *******************************************************************************
 *
 * \file    riegl.rdb.pointcloud.dataTypes.pas
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Point attribute access data types (Pascal wrapper code)
 * \version 2015-10-14/AW: Initial version
 * \version 2018-07-06/AW: Add 'RDBPointcloudDataTypeFLOAT32|64' aliases
 *
 *******************************************************************************
 *}

unit riegl.rdb.pointcloud.dataTypes;

{******************************************************************************}
{***} INTERFACE {**************************************************************}
{******************************************************************************}

//---< INCLUDES >---------------------------------------------------------------

uses
  riegl.rdb;

//---< TRDBPointcloudDataType >-------------------------------------------------
{*!
 * \brief Point attribute access data type
 *}
type
  TRDBPointcloudDataType =
  (
    RDBPointcloudDataTypeNONE    =  0, //!< undefined data type
    RDBPointcloudDataTypeUINT8   =  1, //!<  8 bit unsigned integer
    RDBPointcloudDataTypeINT8    =  2, //!<  8 bit   signed integer
    RDBPointcloudDataTypeUINT16  =  3, //!< 16 bit unsigned integer
    RDBPointcloudDataTypeINT16   =  4, //!< 16 bit   signed integer
    RDBPointcloudDataTypeUINT32  =  5, //!< 32 bit unsigned integer
    RDBPointcloudDataTypeINT32   =  6, //!< 32 bit   signed integer
    RDBPointcloudDataTypeUINT64  =  7, //!< 64 bit unsigned integer
    RDBPointcloudDataTypeINT64   =  8, //!< 64 bit   signed integer
    RDBPointcloudDataTypeSINGLE  =  9, //!< 32 bit single precision floating point value
    RDBPointcloudDataTypeDOUBLE  = 10, //!< 64 bit double precision floating point value
    RDBPointcloudDataTypeFLOAT32 =  9, //!< 32 bit single precision floating point value
    RDBPointcloudDataTypeFLOAT64 = 10  //!< 64 bit double precision floating point value
  );

//______________________________________________________________________________
{*!
 * \brief Convert data type
 *
 * This function converts the given buffer data type from integer to enum.
 *}
function ConvertDataType(const Value : TRDBUInt32) : TRDBPointcloudDataType;

{******************************************************************************}
{***} IMPLEMENTATION {*********************************************************}
{******************************************************************************}

//______________________________________________________________________________
function ConvertDataType(const Value : TRDBUInt32) : TRDBPointcloudDataType;
begin
  for Result := Low(Result) to High(Result) do
  begin
    if (TRDBUInt32(Ord(Result)) = Value) then Exit; // done
  end;
  Result := RDBPointcloudDataTypeNONE;
end; // ConvertDataType()

end.
