{*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *}
{*!
 *******************************************************************************
 *
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Description of RIEGL RDB 2 database meta data items.
 * \version 2015-10-27/AW: Initial version
 * \version 2015-11-25/AW: Item "Geo Tag" added
 * \version 2016-10-27/AW: Item "Voxel Information" added
 * \version 2016-11-17/AW: Item "Voxel Information" updated
 * \version 2016-12-12/AW: Item "Range Statistics" added
 * \version 2017-03-08/AW: Item "Plane Patch Statistics" added
 * \version 2017-04-05/AW: Items "Atmosphere" and "Geometric Scale Factor" added
 * \version 2017-08-22/AW: Items for waveform sample block and value files added
 * \version 2017-10-24/AW: Item "Gaussian Decomposition" added
 * \version 2017-11-13/AW: Item "riegl.scan_pattern" updated
 * \version 2017-11-21/AW: Item "riegl.trajectory_info" added
 * \version 2018-01-11/AW: Item "riegl.beam_geometry" added
 * \version 2018-01-15/AW: Item "riegl.reflectance_calculation" added
 * \version 2018-01-15/AW: Item "riegl.near_range_correction" added
 * \version 2018-01-15/AW: Item "riegl.device_geometry" added
 * \version 2018-02-13/AW: Item "riegl.notch_filter" added
 * \version 2018-03-08/AW: Item "riegl.window_echo_correction" added
 * \version 2018-03-15/AW: Item "riegl.pulse_position_modulation" added
 * \version 2018-05-24/AW: Item "riegl.pixel_info" added
 * \version 2018-06-08/AW: Item "riegl.shot_info" added
 * \version 2018-06-08/AW: Item "riegl.echo_info" added
 * \version 2018-06-14/AW: Item "riegl.mta_settings" added
 * \version 2018-06-14/AW: Item "riegl.receiver_internals" added
 * \version 2018-06-14/AW: Item "riegl.device_output_limits" added
 * \version 2018-06-26/AW: Schema: replace "number" with "integer" if applicable
 * \version 2018-07-09/AW: Item "riegl.pose_estimation" added
 * \version 2018-07-09/AW: Item "riegl.pose_sensors" added
 * \version 2018-09-20/AW: Item "riegl.pointcloud_info" added
 * \version 2018-11-08/AW: Item "riegl.scan_pattern" updated
 * \version 2018-11-13/AW: Item "riegl.receiver_internals" updated
 * \version 2019-03-06/AW: Item "riegl.receiver_internals" updated
 * \version 2019-03-21/AW: Item "riegl.device_geometry" updated
 * \version 2019-04-15/AW: Item "riegl.point_attribute_groups" added
 * \version 2019-04-30/AW: Item "riegl.waveform_settings" added
 * \version 2019-10-03/AW: Item "riegl.angular_notch_filter" added
 * \version 2019-10-03/AW: Item "riegl.noise_estimates" added
 * \version 2019-10-25/AW: Item "riegl.window_analysis" added
 * \version 2019-11-06/AW: Item "riegl.georeferencing_parameters" added
 * \version 2019-11-27/AW: Item "riegl.plane_patch_matching" added
 * \version 2019-12-13/AW: Items for tie-/control objects added
 * \version 2019-12-19/AW: Items for tie-/control objects added
 * \version 2020-02-04/AW: Item "riegl.detection_probability" added
 * \version 2020-02-04/AW: Item "riegl.licenses" added
 * \version 2020-04-27/AW: Item "riegl.waveform_info" updated (schema+example)
 * \version 2020-09-03/AW: Item "riegl.reflectance_correction" added
 * \version 2020-09-10/AW: Item "riegl.device_geometry_passive_channel" added
 * \version 2020-09-25/AW: Item "riegl.georeferencing_parameters" updated
 * \version 2020-09-25/AW: Item "riegl.trajectory_info" updated
 * \version 2020-09-29/AW: Item "riegl.temperature_calculation" added
 * \version 2020-10-23/AW: Item "riegl.exponential_decomposition" added (#3709)
 * \version 2020-11-30/AW: Item "riegl.notch_filter" updated (schema)
 * \version 2020-12-02/AW: Item "riegl.georeferencing_parameters" updated (schema)
 * \version 2021-02-02/AW: Item "riegl.plane_slope_class_info" added (rdbplanes/#7)
 * \version 2021-02-16/AW: Item "riegl.device_output_limits" updated (schema, #3811)
 * \version 2021-03-03/AW: Item "riegl.exponential_decomposition" updated (schema, #3822)
 * \version 2021-03-03/AW: Item "riegl.waveform_averaging_settings" added (#3821)
 * \version 2021-04-01/AW: Item "riegl.voxel_info" updated (schema, #3854)
 * \version 2021-04-16/AW: Item "riegl.voxel_info" updated (schema, #3866)
 * \version 2021-09-30/AW: Item "riegl.waveform_info" updated (schema+example, #4016)
 * \version 2021-10-04/AW: Improved spelling of the descriptions of some items
 * \version 2021-11-04/AW: Rename "riegl.record_names" to "riegl.item_names" (#4034)
 * \version 2022-03-11/AW: Item "riegl.devices" added (#4162)
 * \version 2022-03-14/AW: Item "riegl.stored_filters" added (#4164)
 * \version 2022-09-20/AW: Fix typos in schema of "riegl.georeferencing_parameters"
 * \version 2022-09-30/AW: Item "riegl.system_description" added (#4368)
 * \version 2022-10-10/AW: Correction of typos in the titles of some entries
 * \version 2022-10-20/AW: Item "riegl.stored_filters" updated (example, #4164)
 * \version 2023-01-19/AW: Item "riegl.ttip_configuration" added (#4449)
 * \version 2024-09-26/AW: Item "riegl.dyntrig" added (#5310)
 * \version 2025-03-21/AW: Item "riegl.dmi_config" added (#5571)
 * \version 2025-07-01/AW: Item "riegl.gnss_processing_info" added (#5777)
 * \version 2025-07-01/AW: Item "riegl.riloc_processing_info" added (#5777)
 * \version 2025-11-11/AW: Item "riegl.lag_angle_correction" added (#6068)
 *
 *******************************************************************************
 *}

unit riegl.rdb.default.metadata;

{$WRITEABLECONST ON} // see section "initialization"

interface

// Meta data items definition version
const
  RDB_META_DATA_ITEMS_VERSION = '1.1.57';
  RDB_META_DATA_ITEMS_DATE = '2025-11-11';

// Meta data item states
const
  RDB_STATUS_REQUIRED = 1; // mandatory item
  RDB_STATUS_OPTIONAL = 2; // optional item

// Container record for meta data item details
type
  TRDBPointcloudMetaDataItemInfo = record
    Name        : System.String;
    Title       : System.String;
    Description : System.String;
    Status      : System.Byte;
    Schema      : System.String;
    Example     : System.String;
  end;
  PRDBPointcloudMetaDataItemInfo = ^TRDBPointcloudMetaDataItemInfo;

// Angular notch filter parameters for window glass echoes
const
  RDB_RIEGL_ANGULAR_NOTCH_FILTER : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.angular_notch_filter';
    Title       : 'Angular Notch Filter';
    Description : 'Angular notch filter parameters for window glass echoes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Angular '
      + 'Notch Filter","description":"Angular notch filter parameters for '
      + 'window glass echoes","type":"object","properties":{"angle":{"type":"ar'
      + 'ray","description":"Angle [deg]","items":{"type":"number"}},"range_mea'
      + 'n":{"type":"array","description":"Mean range [m]","items":{"type":"num'
      + 'ber"}},"amplitude_mean":{"type":"array","description":"Mean amplitude '
      + '[dB]","items":{"type":"number"}}},"required":["angle","range_mean","am'
      + 'plitude_mean"]}'
    );

    Example : (''
      + '{"angle":[14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,22.0,23.0,24.0],"ran'
      + 'ge_mean":[0.094,0.094,0.09075,0.08675,0.0815,0.0775,0.074,0.071,0.068,'
      + '0.0675,0.06475],"amplitude_mean":[3.780913,3.780913,3.480913,3.120913,'
      + '2.850913,2.720913,2.680913,2.610913,2.530913,2.570913,2.570913]}'
    );
  );

// Atmospheric parameters
const
  RDB_RIEGL_ATMOSPHERE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.atmosphere';
    Title       : 'Atmosphere';
    Description : 'Atmospheric parameters';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Atmosphe'
      + 'ric Parameters","description":"Atmospheric parameters","type":"object"'
      + ',"properties":{"temperature":{"type":"number","description":"Temperatu'
      + 're along measurement path '
      + '[\u00b0C]"},"pressure":{"type":"number","description":"Pressure along '
      + 'measurment path '
      + '[mbar]"},"rel_humidity":{"type":"number","description":"Relative '
      + 'humidity along measurement path '
      + '[%]"},"pressure_sl":{"type":"number","description":"Atmospheric '
      + 'pressure at sea level '
      + '[mbar]"},"amsl":{"type":"number","description":"Height above mean sea '
      + 'level (AMSL) '
      + '[m]"},"group_velocity":{"type":"number","description":"Group velocity '
      + 'of laser beam '
      + '[m/s]"},"attenuation":{"type":"number","description":"Atmospheric '
      + 'attenuation '
      + '[1/km]"},"wavelength":{"type":"number","description":"Laser wavelength'
      + ' [nm]"}},"required":["temperature","pressure","rel_humidity","pressure'
      + '_sl","amsl","group_velocity","attenuation","wavelength"]}'
    );

    Example : (''
      + '{"temperature":7,"pressure":970,"rel_humidity":63,"pressure_sl":970,"a'
      + 'msl":0,"group_velocity":299711000.0,"attenuation":0.028125,"wavelength'
      + '":1550}'
    );
  );

// Laser beam geometry details
const
  RDB_RIEGL_BEAM_GEOMETRY : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.beam_geometry';
    Title       : 'Beam Geometry';
    Description : 'Laser beam geometry details';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Beam '
      + 'Geometry","description":"Laser beam geometry details","type":"object",'
      + '"properties":{"beam_exit_diameter":{"description":"Beam width at exit '
      + 'aperture [m]","type":"number","minimum":0,"exclusiveMinimum":false},"b'
      + 'eam_divergence":{"description":"Beam divergence in far field [rad]","t'
      + 'ype":"number","minimum":0,"exclusiveMinimum":false}},"required":["beam'
      + '_exit_diameter","beam_divergence"]}'
    );

    Example : (''
      + '{"beam_exit_diameter":0.0072,"beam_divergence":0.0003}'
    );
  );

// List of control object type definitions
const
  RDB_RIEGL_CONTROL_OBJECT_CATALOG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.control_object_catalog';
    Title       : 'Control Object Catalog';
    Description : 'List of control object type definitions';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Control '
      + 'Object Catalog","description":"List of control object type '
      + 'definitions","definitions":{"common":{"description":"common object pro'
      + 'perties","type":"object","properties":{"name":{"description":"unique '
      + 'type identifier","type":"string","minLength":3},"description":{"descri'
      + 'ption":"string describing the '
      + 'object","type":"string"},"shape":{"description":"shape identifier","ty'
      + 'pe":"string","enum":["rectangle","checkerboard2x2","chevron","circular'
      + '_disk","cylinder","sphere","round_corner_cube_prism"]},"surface_type":'
      + '{"description":"surface material type","type":"string","enum":["retro_'
      + 'reflective_foil","diffuse"]}},"required":["name","shape"]},"rectangle"'
      + ':{"description":"rectangle","type":"object","allOf":[{"$ref":"#/defini'
      + 'tions/common"},{"description":"rectangle specific properties","type":"'
      + 'object","properties":{"shape":{"type":"string","enum":["rectangle"]},"'
      + 'length":{"description":"length in meters","type":"number","minimum":0,'
      + '"exclusiveMinimum":true},"width":{"description":"width in meters","typ'
      + 'e":"number","minimum":0,"exclusiveMinimum":true}},"required":["shape",'
      + '"length","width"]}]},"checkerboard2x2":{"description":"checkerboard 2 '
      + 'by 2","type":"object","allOf":[{"$ref":"#/definitions/common"},{"descr'
      + 'iption":"checkerboard specific properties","type":"object","properties'
      + '":{"shape":{"description":"shape identifier","type":"string","enum":["'
      + 'checkerboard2x2"]},"square_length":{"description":"length of a square '
      + 'of the checkerboard in meters","type":"number","minimum":0,"exclusiveM'
      + 'inimum":true}},"required":["shape","square_length"]}]},"chevron":{"des'
      + 'cription":"chevron","type":"object","allOf":[{"$ref":"#/definitions/co'
      + 'mmon"},{"description":"chevron specific properties","type":"object","p'
      + 'roperties":{"shape":{"description":"shape identifier","type":"string",'
      + '"enum":["chevron"]},"outside_edge_length":{"description":"length of '
      + 'the two outer edges in meters","type":"number","minimum":0,"exclusiveM'
      + 'inimum":true},"thickness":{"description":"thickness in meters","type":'
      + '"number","minimum":0,"exclusiveMinimum":true}},"required":["shape","ou'
      + 'tside_edge_length","thickness"]}]},"circular_disk":{"description":"cir'
      + 'cular disk","type":"object","allOf":[{"$ref":"#/definitions/common"},{'
      + '"description":"circular disk specific properties","type":"object","pro'
      + 'perties":{"shape":{"description":"shape identifier","type":"string","e'
      + 'num":["circular_disk"]},"diameter":{"description":"diameter in meters"'
      + ',"type":"number","minimum":0,"exclusiveMinimum":true},"offset":{"descr'
      + 'iption":"offset in meters, e.g. reflector constant (optional)","type":'
      + '"number"}},"required":["shape","diameter"]}]},"cylinder":{"description'
      + '":"cylinder","type":"object","allOf":[{"$ref":"#/definitions/common"},'
      + '{"description":"cylinder specific properties","type":"object","propert'
      + 'ies":{"shape":{"description":"shape identifier","type":"string","enum"'
      + ':["cylinder"]},"diameter":{"description":"diameter in meters","type":"'
      + 'number","minimum":0,"exclusiveMinimum":true},"height":{"description":"'
      + 'height in meters","type":"number","minimum":0,"exclusiveMinimum":true}'
      + '},"required":["shape","diameter","height"]}]},"sphere":{"description":'
      + '"sphere","type":"object","allOf":[{"$ref":"#/definitions/common"},{"de'
      + 'scription":"sphere specific properties","type":"object","properties":{'
      + '"shape":{"description":"shape identifier","type":"string","enum":["sph'
      + 'ere"]},"diameter":{"description":"diameter in meters","type":"number",'
      + '"minimum":0,"exclusiveMinimum":true}},"required":["shape","diameter"]}'
      + ']},"round_corner_cube_prism":{"description":"round corner cube prism",'
      + '"type":"object","allOf":[{"$ref":"#/definitions/common"},{"description'
      + '":"round corner cube prism specific properties","type":"object","prope'
      + 'rties":{"shape":{"description":"shape identifier","type":"string","enu'
      + 'm":["round_corner_cube_prism"]},"diameter":{"description":"diameter in'
      + ' meters","type":"number","minimum":0,"exclusiveMinimum":true},"offset"'
      + ':{"description":"offset in meters, e.g. reflector constant (optional)"'
      + ',"type":"number"}},"required":["shape","diameter"]}]}},"type":"object"'
      + ',"properties":{"types":{"type":"array","items":{"type":"object","oneOf'
      + '":[{"$ref":"#/definitions/rectangle"},{"$ref":"#/definitions/checkerbo'
      + 'ard2x2"},{"$ref":"#/definitions/chevron"},{"$ref":"#/definitions/circu'
      + 'lar_disk"},{"$ref":"#/definitions/cylinder"},{"$ref":"#/definitions/sp'
      + 'here"},{"$ref":"#/definitions/round_corner_cube_prism"}]},"uniqueItems'
      + '":true}},"required":["types"]}'
    );

    Example : (''
      + '{"comments":["This file contains a list of control object types (aka. '
      + '''catalog'').","Each type is described by an object,","which must '
      + 'contain at least the following parameters:","  - name: unique '
      + 'identifier of the type","  - shape: one of the following supported '
      + 'shapes:","      - rectangle","      - checkerboard2x2","      - '
      + 'chevron","      - circular_disk","      - cylinder","      - sphere","'
      + '      - round_corner_cube_prism","Depending on ''shape'', the following '
      + 'parameters must/may be specified:","  - rectangle:","      - length: '
      + 'length in meters","      - width: width in meters","  - '
      + 'checkerboard2x2:","      - square_length: length of a square of the '
      + 'checkerboard in meters","  - circular_disk:","      - diameter: '
      + 'diameter in meters","      - offset: offset in meters, e.g. reflector '
      + 'constant (optional)","  - chevron:","      - outside_edge_length: '
      + 'length of the two outer edges in meters","      - thickness: thickness'
      + ' in meters","  - cylinder:","      - diameter: diameter in meters","'
      + '      - height: height in meters","  - sphere:","      - diameter: '
      + 'diameter in meters","  - round_corner_cube_prism:","      - diameter: '
      + 'diameter in meters","      - offset: offset in meters, e.g. reflector '
      + 'constant (optional)","Optional parameters:","    - description: string'
      + ' describing the object","    - surface_type: surface material type '
      + '(either ''retro_reflective_foil'' or '
      + '''diffuse'')"],"types":[{"name":"Rectangle '
      + '60x30","description":"Rectangle (60cm x 30cm)","shape":"rectangle","le'
      + 'ngth":0.6,"width":0.3},{"name":"Rectangle '
      + '80x40","description":"Rectangle (80cm x 40cm)","shape":"rectangle","le'
      + 'ngth":0.8,"width":0.4},{"name":"Checkerboard2x2 '
      + '30","description":"Checkerboard (square length: 30cm)","shape":"checke'
      + 'rboard2x2","square_length":0.3},{"name":"Checkerboard2x2 '
      + '50","description":"Checkerboard (square length: '
      + '50cm)","shape":"checkerboard2x2","square_length":0.5},{"name":"Chevron'
      + ' 24''''/4''''","description":"Chevron (a=24''''; b=4'''')","shape":"chevron","'
      + 'outside_edge_length":0.6096,"thickness":0.1016},{"name":"Circular Disk'
      + ' 50","description":" Circular Disk (diameter: 50cm)","shape":"circular'
      + '_disk","diameter":0.5,"surface_type":"diffuse"},{"name":"RIEGL flat '
      + 'reflector 50 mm","description":"flat circular reflector from '
      + 'retro-reflective foil","shape":"circular_disk","diameter":0.05,"offset'
      + '":0.0,"surface_type":"retro_reflective_foil"},{"name":"RIEGL flat '
      + 'reflector 100 mm","description":"flat circular reflector from '
      + 'retro-reflective foil","shape":"circular_disk","diameter":0.1,"offset"'
      + ':0.0,"surface_type":"retro_reflective_foil"},{"name":"RIEGL flat '
      + 'reflector 150 mm","description":"flat circular reflector from '
      + 'retro-reflective foil","shape":"circular_disk","diameter":0.15,"offset'
      + '":0.0,"surface_type":"retro_reflective_foil"},{"name":"RIEGL '
      + 'cylindrical reflector 50 mm","description":"cylindrical reflector from'
      + ' retro-reflective foil","shape":"cylinder","diameter":0.05,"height":0.'
      + '05,"surface_type":"retro_reflective_foil"},{"name":"RIEGL cylindrical '
      + 'reflector 100 mm","description":"cylindrical reflector from '
      + 'retro-reflective foil","shape":"cylinder","diameter":0.1,"height":0.1,'
      + '"surface_type":"retro_reflective_foil"},{"name":"Sphere 200 '
      + 'mm","description":"Sphere (diameter: 200 '
      + 'mm)","shape":"sphere","diameter":0.2},{"name":"Corner Cube Prism 50 '
      + 'mm","description":"round corner cube prism","shape":"round_corner_cube'
      + '_prism","diameter":0.05,"offset":0.0}]}'
    );
  );

// Details about the control object reference file
const
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.control_object_reference_file';
    Title       : 'Control Object Reference file';
    Description : 'Details about the control object reference file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Control '
      + 'Object Reference file","description":"Details about the control object'
      + ' reference file","type":"object","properties":{"reference_file":{"type'
      + '":"object","description":"Reference to a control object '
      + 'file","properties":{"file_uuid":{"description":"Control object file''s '
      + 'Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_path":{"description":"Path of the '
      + 'control object file relative to referring '
      + 'file","type":"string"}},"required":["file_uuid","file_path"]}}}'
    );

    Example : (''
      + '{"reference_file":{"file_uuid":"810f5d57-eccf-49ed-b07a-0cdd109b4213",'
      + '"file_path":"../../../10_CONTROL_OBJECTS/ControlPoints.cpx"}}'
    );
  );

// Detection probability as a function of amplitude
const
  RDB_RIEGL_DETECTION_PROBABILITY : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.detection_probability';
    Title       : 'Detection Probability';
    Description : 'Detection probability as a function of amplitude';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Detectio'
      + 'n Probability","description":"Detection probability as a function of a'
      + 'mplitude","type":"object","properties":{"amplitude":{"type":"array","d'
      + 'escription":"Amplitude [dB]","items":{"type":"number"}},"detection_pro'
      + 'bability":{"type":"array","description":"Detection probability [0..1]"'
      + ',"items":{"type":"number"}}},"required":["amplitude","detection_probab'
      + 'ility"]}'
    );

    Example : (''
      + '{"amplitude":[0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0],"detection'
      + '_probability":[0.0,0.5,0.8,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0]}'
    );
  );

// Details about the device used to acquire the point cloud
const
  RDB_RIEGL_DEVICE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device';
    Title       : 'Device Information';
    Description : 'Details about the device used to acquire the point cloud';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Device '
      + 'Information","description":"Details about the device used to acquire '
      + 'the point cloud","type":"object","properties":{"device_name":{"descrip'
      + 'tion":"Optional device name (e.g. ''Scanner 1'' for multi-scanner '
      + 'systems)","type":"string"},"device_type":{"description":"Device type '
      + 'identifier (e.g. '
      + 'VZ-400i)","type":"string"},"device_build":{"description":"Device build'
      + ' variant","type":"string"},"serial_number":{"description":"Device '
      + 'serial number (e.g. '
      + 'S2221234)","type":"string"},"channel_number":{"description":"Laser '
      + 'channel number (not defined or 0: single channel device)","type":"inte'
      + 'ger","minimum":0,"exclusiveMinimum":false},"channel_text":{"descriptio'
      + 'n":"Optional channel description (e.g. ''Green Channel'' for '
      + 'multi-channel devices)","type":"string"}},"required":["device_type","s'
      + 'erial_number"]}'
    );

    Example : (''
      + '{"device_name":"Scanner 1","device_type":"VZ-400i","device_build":"","'
      + 'serial_number":"S2221234","channel_number":0,"channel_text":""}'
    );
  );

// Scanner device geometry details
const
  RDB_RIEGL_DEVICE_GEOMETRY : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device_geometry';
    Title       : 'Device Geometry';
    Description : 'Scanner device geometry details';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Device '
      + 'Geometry","description":"Scanner device geometry details","type":"obje'
      + 'ct","properties":{"primary":{"description":"Primary device geometry '
      + 'structure (mandatory)","type":"object","properties":{"ID":{"descriptio'
      + 'n":"Structure identifier","type":"array","items":{"type":"integer"},"m'
      + 'inItems":2,"maxItems":2},"content":{"description":"Internal '
      + 'calibration values","type":"array","items":{"type":"number"}}},"requir'
      + 'ed":["ID","content"]},"secondary":{"description":"Additional device '
      + 'geometry structure (optional)","type":"object","properties":{"ID":{"de'
      + 'scription":"Structure identifier","type":"array","items":{"type":"inte'
      + 'ger"},"minItems":2,"maxItems":2},"content":{"description":"Internal '
      + 'calibration values","type":"array","items":{"type":"number"}}},"requir'
      + 'ed":["ID","content"]},"amu":{"description":"Angle Measurement '
      + 'Unit","type":"object","properties":{"lineCC":{"description":"Line '
      + 'Circle Count (number of LSBs per full rotation about line axis)","type'
      + '":"number","minimum":0,"exclusiveMinimum":false},"frameCC":{"descripti'
      + 'on":"Frame Circle Count (number of LSBs per full rotation about frame '
      + 'axis)","type":"number","minimum":0,"exclusiveMinimum":false}}}},"requi'
      + 'red":["primary"]}'
    );

    Example : (''
      + '{"primary":{"ID":[4,0],"content":[0]},"secondary":{"ID":[91,0],"conten'
      + 't":[0]},"amu":{"lineCC":124000,"frameCC":124000}}'
    );
  );

// Scanner passive channel device geometry details
const
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device_geometry_passive_channel';
    Title       : 'Device Geometry Passive Channel';
    Description : 'Scanner passive channel device geometry details';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Device '
      + 'Geometry Passive Channel","description":"Scanner passive channel '
      + 'device geometry details","type":"object","properties":{"primary":{"des'
      + 'cription":"Primary device geometry structure (mandatory)","type":"obje'
      + 'ct","properties":{"ID":{"description":"Structure identifier","type":"a'
      + 'rray","items":{"type":"integer"},"minItems":2,"maxItems":2},"content":'
      + '{"description":"Internal calibration values","type":"array","items":{"'
      + 'type":"number"}}},"required":["ID","content"]}},"required":["primary"]'
      + '}'
    );

    Example : (''
      + '{"primary":{"ID":[143,0],"content":[0]}}'
    );
  );

// Limits of the measured values output by the device
const
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device_output_limits';
    Title       : 'Device Output Limits';
    Description : 'Limits of the measured values output by the device';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Device '
      + 'Output Limits","description":"Limits of the measured values output by '
      + 'the device. The limits depend on the device type, measurement program '
      + 'and/or scan pattern.","type":"object","properties":{"range_minimum":{"'
      + 'type":"number","description":"Minimum possible range in '
      + 'meters."},"range_maximum":{"type":"number","description":"Maximum '
      + 'possible range in '
      + 'meters."},"amplitude_minimum":{"type":"number","description":"Minimum '
      + 'possible amplitude in '
      + 'dB."},"amplitude_maximum":{"type":"number","description":"Maximum '
      + 'possible amplitude in '
      + 'dB."},"reflectance_minimum":{"type":"number","description":"Minimum '
      + 'possible reflectance in '
      + 'dB."},"reflectance_maximum":{"type":"number","description":"Maximum '
      + 'possible reflectance in '
      + 'dB."},"deviation_minimum":{"type":"number","description":"Minimum '
      + 'possible pulse shape deviation."},"deviation_maximum":{"type":"number"'
      + ',"description":"Maximum possible pulse shape deviation."},"background_'
      + 'radiation_minimum":{"type":"number","description":"Minimum possible '
      + 'background radiation."},"background_radiation_maximum":{"type":"number'
      + '","description":"Maximum possible background radiation."},"mta_zone_co'
      + 'unt_maximum":{"type":"number","description":"Maximum number of MTA '
      + 'zones."},"echo_count_maximum":{"type":"number","description":"Maximum '
      + 'number of echoes a laser shot can have."}}}'
    );

    Example : (''
      + '{"range_minimum":2.9,"range_maximum":10000.0,"amplitude_minimum":0.0,"'
      + 'amplitude_maximum":100.0,"reflectance_minimum":-100.0,"reflectance_max'
      + 'imum":100.0,"deviation_minimum":-1,"deviation_maximum":32767,"backgrou'
      + 'nd_radiation_minimum":0,"background_radiation_maximum":0,"mta_zone_cou'
      + 'nt_maximum":7}'
    );
  );

// Details about the devices used to acquire the point cloud
const
  RDB_RIEGL_DEVICES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.devices';
    Title       : 'Devices Information';
    Description : 'Details about the devices used to acquire the point cloud';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Devices '
      + 'Information","description":"Details about the devices used to acquire '
      + 'the point cloud (e.g. when merging point clouds of different devices)"'
      + ',"type":"array","items":{"type":"object","properties":{"device_name":{'
      + '"description":"Optional device name (e.g. ''Scanner 1'' for '
      + 'multi-scanner '
      + 'systems)","type":"string"},"device_type":{"description":"Device type '
      + 'identifier (e.g. '
      + 'VZ-400i)","type":"string"},"device_build":{"description":"Device build'
      + ' variant","type":"string"},"serial_number":{"description":"Device '
      + 'serial number (e.g. '
      + 'S2221234)","type":"string"},"channel_number":{"description":"Laser '
      + 'channel number (not defined or 0: single channel device)","type":"inte'
      + 'ger","minimum":0,"exclusiveMinimum":false},"channel_text":{"descriptio'
      + 'n":"Optional channel description (e.g. ''Green Channel'' for '
      + 'multi-channel devices)","type":"string"},"signed":{"description":"Flag'
      + ' that is set when the original ''riegl.device'' entry in the source file'
      + ' was correctly signed.","type":"boolean"}},"required":["device_type","'
      + 'serial_number"]}}'
    );

    Example : (''
      + '[{"device_name":"Scanner 1","device_type":"VZ-400i","device_build":"",'
      + '"serial_number":"S2221234","channel_number":0,"channel_text":"","signe'
      + 'd":false},{"device_name":"Scanner 2","device_type":"VQ-1560i-DW","devi'
      + 'ce_build":"","serial_number":"S2222680","channel_number":1,"channel_te'
      + 'xt":"","signed":true},{"device_name":"Scanner 3","device_type":"VQ-156'
      + '0i-DW","device_build":"","serial_number":"S2222680","channel_number":2'
      + ',"channel_text":"","signed":true}]'
    );
  );

// Distance measuring instrument configuration
const
  RDB_RIEGL_DMI_CONFIG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.dmi_config';
    Title       : 'DMI Configuration';
    Description : 'Distance measuring instrument configuration';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"DMI '
      + 'Configuration","description":"Distance measuring instrument configurat'
      + 'ion","type":"object","properties":{"dmi_count_dir":{"description":"DMI'
      + ' count direction is inverted","type":"integer","minimum":0,"maximum":1'
      + ',"exclusiveMinimum":false,"exclusiveMaximum":false},"dmi_incr":{"descr'
      + 'iption":"Increment in ticks, 0 means distance trigger is deactivated",'
      + '"type":"integer","minimum":0,"maximum":2147483647,"exclusiveMinimum":f'
      + 'alse,"exclusiveMaximum":false},"dmi_min_time":{"description":"Minimum '
      + 'time interval between trigger events, 0 means rate limitation is '
      + 'inactive [0.1 msec]","type":"integer","minimum":0,"maximum":65535,"exc'
      + 'lusiveMinimum":false,"exclusiveMaximum":false},"dmi_max_time":{"descri'
      + 'ption":"Maximum time interval between trigger events, 0 means timeout '
      + 'is inactive [0.1 msec]","type":"integer","minimum":0,"maximum":65535,"'
      + 'exclusiveMinimum":false,"exclusiveMaximum":false},"dmi_dist_per_tick":'
      + '{"description":"Distance per tick, just informative [m]","type":"numbe'
      + 'r"}},"required":["dmi_count_dir","dmi_incr","dmi_min_time","dmi_max_ti'
      + 'me","dmi_dist_per_tick"]}'
    );

    Example : (''
      + '{"dmi_count_dir":0,"dmi_incr":0,"dmi_min_time":0,"dmi_max_time":100,"d'
      + 'mi_dist_per_tick":0.00024399999529123306}'
    );
  );

// Dyntrig
const
  RDB_RIEGL_DYNTRIG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.dyntrig';
    Title       : 'Dyntrig';
    Description : 'Dyntrig';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Dyntrig"'
      + ',"description":"Dyntrig","properties":{"offset":{"type":"number","desc'
      + 'ription":"Offset in units of dB, for calculation of '
      + 'line"},"scale":{"type":"number","description":"Scale in units of dB, '
      + 'for calculation of line: line number N=(amplitude-offset)/scale"},"tab'
      + '":{"type":"array","items":{"description":"...","type":"object","proper'
      + 'ties":{"thra1":{"description":"Post-trigger threshold in units of '
      + 'dB","type":"number"},"del1":{"description":"Length of constant '
      + 'post-trigger threshold elevation in units of '
      + 'm","type":"number"},"dec1":{"description":"Decay of post-trigger '
      + 'threshold after del1 in units of '
      + 'dB/m","type":"number"},"thra2":{"description":"Pre-trigger threshold '
      + 'in units of dB","type":"number"},"del2":{"description":"Length of '
      + 'constant pre-trigger threshold elevation in units of '
      + 'm","type":"number"},"dec2":{"description":"Rise of pre-trigger '
      + 'threshold after del2 in units of dB/m","type":"number"}},"required":["'
      + 'thra1","del1","dec1","thra2","del2","dec2"]},"minItems":1,"maxItems":1'
      + '28,"description":"..."},"pre":{"type":"object","description":"Dyntrig '
      + 'pre values","properties":{"nc":{"type":"integer","minimum":0,"maximum"'
      + ':255,"description":"Number of entries"},"a":{"type":"array","items":{"'
      + 'type":"number"},"minItems":1,"maxItems":2080,"description":"..."}},"re'
      + 'quired":["nc","a"]},"post":{"type":"object","description":"Dyntrig '
      + 'post values","properties":{"nc":{"type":"integer","minimum":0,"maximum'
      + '":255,"description":"Number of entries"},"a":{"type":"array","items":{'
      + '"type":"number"},"minItems":1,"maxItems":2080,"description":"..."}},"r'
      + 'equired":["nc","a"]}}}'
    );

    Example : (''
      + '{"offset":0.0,"scale":1.0,"tab":[{"thra1":0.0,"del1":0.0,"dec1":0.0,"t'
      + 'hra2":0.0,"del2":0.0,"dec2":0.0}],"pre":{"nc":128,"a":[78,86,126,134,3'
      + '1]},"post":{"nc":128,"a":[78,86,126,134,31]}}'
    );
  );

// Details about echo files
const
  RDB_RIEGL_ECHO_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.echo_info';
    Title       : 'Echo Information';
    Description : 'Details about echo files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Echo '
      + 'Information","description":"Details about echo files","type":"object",'
      + '"properties":{"echo_file":{"type":"object","properties":{"file_uuid":{'
      + '"description":"File''s Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_extension":{"description":"Echo file '
      + 'extension, without the leading dot","type":"string"}},"required":["fil'
      + 'e_extension"]}},"required":["echo_file"]}'
    );

    Example : (''
      + '{"echo_file":{"file_uuid":"26a03615-67c0-4bea-8fe8-c577378fe661","file'
      + '_extension":"owp"}}'
    );
  );

// Details for exponential decomposition of full waveform data
const
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.exponential_decomposition';
    Title       : 'Exponential Decomposition';
    Description : 'Details for exponential decomposition of full waveform data';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Exponent'
      + 'ial Decomposition","description":"Details for exponential '
      + 'decomposition of full waveform data","definitions":{"channel":{"type":'
      + '"object","properties":{"delay":{"description":"delay calibration in '
      + 'seconds","type":"number"},"scale":{"description":"amplitude '
      + 'calibration","type":"number"},"a_lin":{"description":"relative linear '
      + 'amplitude range [0..1]","type":"number","minimum":0,"maximum":1,"exclu'
      + 'siveMinimum":false,"exclusiveMaximum":false},"parameter":{"description'
      + '":"parameters of the syswave exponential '
      + 'sum","type":"object","properties":{"A":{"description":"real part of '
      + 'amplitude factor in units of full-scale","type":"array","items":{"type'
      + '":"number"}},"B":{"description":"imaginary part of amplitude factor in'
      + ' units of full-scale","type":"array","items":{"type":"number"}},"gamma'
      + '":{"description":"decay in 1/second","type":"array","items":{"type":"n'
      + 'umber"}},"omega":{"description":"angular frequency in Hz","type":"arra'
      + 'y","items":{"type":"number"}}},"required":["A","B","gamma","omega"]}},'
      + '"required":["delay","scale","parameter"]}},"type":"object","patternPro'
      + 'perties":{"^[0-9]+$":{"description":"one field per channel, field name'
      + ' is channel '
      + 'index","$ref":"#/definitions/channel"}},"additionalProperties":false}'
    );

    Example : (''
      + '{"1":{"delay":3.5e-09,"scale":1.0,"a_lin":0.9,"parameter":{"A":[0.9,0.'
      + '3,-1.3],"B":[-3.9,0.0,-0.3],"gamma":[-1094726528.0,-769562752.0,-84800'
      + '0064.0],"omega":[352020896.0,3647927552.0,-1977987072.0]}},"0":{"delay'
      + '":3.783458418887631e-09,"scale":1.0,"a_lin":0.27,"parameter":{"A":[0.9'
      + '772450923919678,0.3354335129261017,-1.312678575515747],"B":[-3.9813032'
      + '150268555,0.08622030913829803,-0.3152860999107361],"gamma":[-109472652'
      + '8.0,-769562752.0,-848000064.0],"omega":[352020896.0,3647927552.0,-1977'
      + '987072.0]}}}'
    );
  );

// Details for Gaussian decomposition of full waveform data
const
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.gaussian_decomposition';
    Title       : 'Gaussian Decomposition';
    Description : 'Details for Gaussian decomposition of full waveform data';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Gaussian'
      + ' Decomposition","description":"riegl.gaussian_decomposition contains '
      + 'information relevant for extracting calibrated amplitudes and '
      + 'calibrated ranges from a Gaussian decomposition of full waveform data.'
      + ' This information is contained in a table with five columns. Two '
      + 'columns are to be used as input: amplitude_lsb_low_power and '
      + 'amplitude_lsb_high_power. The other three columns provide the outputs.'
      + ' Amplitude_db gives the calibrated amplitude in the optical regime in '
      + 'decibels. The range offset columns provide additive range offsets, '
      + 'given in units of seconds, for each channel.","type":"object","propert'
      + 'ies":{"amplitude_lsb_low_power":{"type":"array","items":{"type":"numbe'
      + 'r"}},"amplitude_lsb_high_power":{"type":"array","items":{"type":"numbe'
      + 'r"}},"amplitude_db":{"type":"array","items":{"type":"number"}},"range_'
      + 'offset_sec_low_power":{"type":"array","items":{"type":"number"}},"rang'
      + 'e_offset_sec_high_power":{"type":"array","items":{"type":"number"}}},"'
      + 'required":["amplitude_lsb_low_power","amplitude_lsb_high_power","ampli'
      + 'tude_db","range_offset_sec_low_power","range_offset_sec_high_power"]}'
    );

    Example : (''
      + '{"amplitude_lsb_low_power":[],"amplitude_lsb_high_power":[],"amplitude'
      + '_db":[],"range_offset_sec_low_power":[],"range_offset_sec_high_power":'
      + '[]}'
    );
  );

// Point cloud georeferencing information
const
  RDB_RIEGL_GEO_TAG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.geo_tag';
    Title       : 'Geo Tag';
    Description : 'Point cloud georeferencing information';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Geo '
      + 'Tag","description":"Point cloud georeferencing information","type":"ob'
      + 'ject","properties":{"crs":{"type":"object","description":"Global '
      + 'Coordinate Reference System. Please note that only 3D Cartesian '
      + 'Coordinate Systems are '
      + 'allowed.","properties":{"name":{"description":"Coordinate reference '
      + 'system name","type":"string"},"epsg":{"description":"EPSG '
      + 'code","type":"integer","minimum":0},"wkt":{"description":"\"Well-Known'
      + ' Text\" string, OGC WKT dialect (see http://www.opengeospatial.org/sta'
      + 'ndards/wkt-crs)","type":"string"}}},"pose":{"type":"array","descriptio'
      + 'n":"Coordinate Transformation Matrix to transform from File Coordinate'
      + ' System to Global Coordinate Reference System. 4x4 matrix stored as '
      + 'two dimensional array, row major order.","items":{"description":"rows"'
      + ',"type":"array","items":{"description":"columns","type":"number"},"max'
      + 'Items":4,"minItems":4},"maxItems":4,"minItems":4}}}'
    );

    Example : (''
      + '{"crs":{"name":"WGS84 Geocentric","epsg":4978,"wkt":"GEOCCS[\"WGS84 Ge'
      + 'ocentric\",DATUM[\"WGS84\",SPHEROID[\"WGS84\",6378137.000,298.25722356'
      + '3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\'
      + '"Greenwich\",0.0000000000000000,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"M'
      + 'eter\",1.00000000000000000000,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"'
      + ',OTHER],AXIS[\"Y\",EAST],AXIS[\"Z\",NORTH],AUTHORITY[\"EPSG\",\"4978\"'
      + ']]"},"pose":[[-0.269827776749716,-0.723017716139738,0.635954678449952,'
      + '4063882.500831],[0.962908599449764,-0.20260517250352,0.178208229833847'
      + ',1138787.607461],[0.0,0.660451759194338,0.7508684796801,4766084.550196'
      + '],[0.0,0.0,0.0,1.0]]}'
    );
  );

// Geometric scale factor applied to point coordinates
const
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.geometric_scale_factor';
    Title       : 'Geometric Scale Factor';
    Description : 'Geometric scale factor applied to point coordinates';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Ge'
      + 'ometric scale factor applied to point '
      + 'coordinates","type":"number","minimum":0,"exclusiveMinimum":true}'
    );

    Example : (''
      + '1.0'
    );
  );

// Parameters used for georeferencing of the point cloud
const
  RDB_RIEGL_GEOREFERENCING_PARAMETERS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.georeferencing_parameters';
    Title       : 'Georeferencing Parameters';
    Description : 'Parameters used for georeferencing of the point cloud';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Georefer'
      + 'encing Parameters","description":"Parameters used for georeferencing '
      + 'of the point cloud","type":"object","properties":{"trajectory_file":{"'
      + 'type":"object","description":"Trajectory data used for georeferencing '
      + 'of the point cloud","properties":{"file_uuid":{"description":"File''s '
      + 'Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_extension":{"description":"Trajectory '
      + 'file extension, without the leading dot","type":"string"}},"required":'
      + '["file_extension"]},"trajectory_offsets":{"type":"object","description'
      + '":"Correction offsets applied to the trajectory '
      + 'data","properties":{"version":{"type":"integer","description":"Meaning'
      + ' of offset values and how to apply them; version 0: '
      + 'Rz(yaw+offset_yaw)*Ry(pitch+offset_pitch)*Rx(roll+offset_roll), '
      + 'version 1: Rz(yaw)*Ry(pitch)*Rx(roll) * Rz(offset_yaw)*Ry(offset_pitch'
      + ')*Rx(offset_roll)"},"offset_east":{"type":"number","description":"[m]"'
      + '},"offset_north":{"type":"number","description":"[m]"},"offset_height"'
      + ':{"type":"number","description":"[m]"},"offset_roll":{"type":"number",'
      + '"description":"[deg]"},"offset_pitch":{"type":"number","description":"'
      + '[deg]"},"offset_yaw":{"type":"number","description":"[deg]"},"offset_t'
      + 'ime":{"type":"number","description":"[s]"}}},"socs_to_body_matrix":{"t'
      + 'ype":"array","description":"Coordinate Transformation Matrix to '
      + 'transform from Scanner''s Own Coordinate System to Body Coordinate '
      + 'System. 4x4 matrix stored as two dimensional array, row major order.",'
      + '"items":{"description":"rows","type":"array","items":{"description":"c'
      + 'olumns","type":"number"},"maxItems":4,"minItems":4},"maxItems":4,"minI'
      + 'tems":4},"socs_to_rocs_matrix":{"type":"array","description":"Coordina'
      + 'te Transformation Matrix to transform from Scanner''s Own Coordinate '
      + 'System to Record Coordinate System. 4x4 matrix stored as two '
      + 'dimensional array, row major order.","items":{"description":"rows","ty'
      + 'pe":"array","items":{"description":"columns","type":"number"},"maxItem'
      + 's":4,"minItems":4},"maxItems":4,"minItems":4},"body_coordinate_system_'
      + 'type":{"type":"string","description":"BODY coordinate frame (NED: '
      + 'North-East-Down, ENU: East-North-Up), default: '
      + 'NED","enum":["NED","ENU"]}}}'
    );

    Example : (''
      + '{"trajectory_file":{"file_uuid":"93a03615-66c0-4bea-8ff8-c577378fe660"'
      + ',"file_extension":"pofx"},"trajectory_offsets":{"version":0,"offset_ea'
      + 'st":0.15,"offset_north":0.07,"offset_height":-0.2,"offset_roll":0.03,"'
      + 'offset_pitch":0.01,"offset_yaw":-0.45,"offset_time":18.007},"socs_to_b'
      + 'ody_matrix":[[-0.269827776749716,-0.723017716139738,0.635954678449952,'
      + '0.0],[0.962908599449764,-0.20260517250352,0.178208229833847,0.0],[0.0,'
      + '0.660451759194338,0.7508684796801,0.0],[0.0,0.0,0.0,1.0]],"body_coordi'
      + 'nate_system_type":"NED"}'
    );
  );

// Details about GNSS processing
const
  RDB_RIEGL_GNSS_PROCESSING_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.gnss_processing_info';
    Title       : 'GNSS Processing Information';
    Description : 'Details about GNSS processing';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"GNSS '
      + 'Processing Information","description":"Details about GNSS processing",'
      + '"type":"object","properties":{"base_stations":{"description":"List of '
      + 'GNSS base stations","type":"array","items":{"description":"GNSS base '
      + 'station details","type":"object","properties":{"latitude":{"descriptio'
      + 'n":"Latitude '
      + '[deg]","type":"number"},"longitude":{"description":"Longitude '
      + '[deg]","type":"number"},"altitude":{"description":"Altitude [m]","type'
      + '":"number"}},"required":["latitude","longitude","altitude"]}}}}'
    );

    Example : (''
      + '{"base_stations":[{"latitude":48.658391162,"longitude":15.663389822,"a'
      + 'ltitude":379.8004150390625}]}'
    );
  );

// Map of item names
const
  RDB_RIEGL_ITEM_NAMES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.item_names';
    Title       : 'Item Names';
    Description : 'Map of item names';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Item '
      + 'Names","description":"Map of item names","type":"object","patternPrope'
      + 'rties":{"^-?[0-9]+$":{"description":"One field per item, field name is'
      + ' item id, field value is item '
      + 'name","type":"string"}},"additionalProperties":false}'
    );

    Example : (''
      + '{"1":"Name of item with id 1","2":"Name of item with id 2","47":"Name '
      + 'of item with id 47","-1":"Name of item with id -1"}'
    );
  );

// Lag angle depended range and reflectance correction
const
  RDB_RIEGL_LAG_ANGLE_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.lag_angle_correction';
    Title       : 'Lag Angle Correction';
    Description : 'Lag angle depended range and reflectance correction';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Lag '
      + 'Angle Correction","description":"Lag angle depended range and '
      + 'reflectance correction","type":"object","properties":{"ranges_m":{"typ'
      + 'e":"array","description":"Range [m]","items":{"type":"number"}},"range'
      + '_correction_m":{"type":"array","description":"Range correction [m] as '
      + 'a function of the range and for applied scanrate, which defines the '
      + 'lag angle","items":{"type":"number"}},"reflectance_correction_db":{"ty'
      + 'pe":"array","description":"Reflectance correction [db] as a function '
      + 'of the range and for applied scanrate","items":{"type":"number"}}},"re'
      + 'quired":["ranges_m","range_correction_m","reflectance_correction_db"]}'
    );

    Example : (''
      + '{"ranges_m":[0.0,4.795,31.964,63.928,95.892,127.856,10000.0],"range_co'
      + 'rrection_m":[0.0,0.0,0.0004,0.0023,0.0039,0.0053,0.0053],"reflectance_'
      + 'correction_db":[0.0,0.0,0.16,0.46,1.18,2.97,2.97]}'
    );
  );

// License keys for software features
const
  RDB_RIEGL_LICENSES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.licenses';
    Title       : 'Software License Keys';
    Description : 'License keys for software features';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Software'
      + ' License Keys","description":"License keys for software features","typ'
      + 'e":"object","patternProperties":{"^.*$":{"description":"Each field of '
      + 'the object represents a feature and holds a list of license keys, '
      + 'where the field name is the feature '
      + 'name.","type":"array","items":{"description":"License key (example: '
      + '''46AE032A - 39882AC4 - 9EC0A184 - 6F163D73'')","type":"string"},"minIte'
      + 'ms":1}},"additionalProperties":false}'
    );

    Example : (''
      + '{"Full Waveform Analysis Topography":["0FD5FF07 - 011A1255 - 9F76CACA '
      + '- 8D2ED557"],"Full Waveform Analysis Topography with GPU '
      + 'support":["8AB44126 - 23B92250 - 16E2689F - 34EF7E7B"],"MTA '
      + 'resolution":["468E020A - 39A922E4 - B681A184 - '
      + '673E3D72"],"Georeferencing":["46AE032A - 39882AC4 - 9EC0A184 - '
      + '6F163D73"]}'
    );
  );

// Parameters for MTA processing
const
  RDB_RIEGL_MTA_SETTINGS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.mta_settings';
    Title       : 'MTA Settings';
    Description : 'Parameters for MTA processing';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"MTA '
      + 'Settings","description":"Parameters for MTA processing","type":"object'
      + '","properties":{"modulation_depth":{"type":"number","description":"Dep'
      + 'th of pulse position modulation in meter.","minimum":0},"zone_width":{'
      + '"type":"number","description":"Width of a MTA zone in meter.","minimum'
      + '":0},"zone_count":{"type":"integer","description":"Maximum number of '
      + 'MTA zones.","minimum":0,"maximum":255}}}'
    );

    Example : (''
      + '{"modulation_depth":9.368514,"zone_width":149.896225,"zone_count":23}'
    );
  );

// Lookup table for range correction based on raw range
const
  RDB_RIEGL_NEAR_RANGE_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.near_range_correction';
    Title       : 'Near Range Correction Table';
    Description : 'Lookup table for range correction based on raw range';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Near '
      + 'Range Correction Table","description":"Lookup table for range '
      + 'correction based on raw '
      + 'range","type":"object","properties":{"delta":{"description":"Delta '
      + 'between table entries [m], first entry is at range = 0 '
      + 'm","type":"number"},"content":{"description":"Correction value [m] to '
      + 'be added to the raw range","type":"array","items":{"type":"number"},"m'
      + 'inItems":1,"maxItems":2000}},"required":["delta","content"]}'
    );

    Example : (''
      + '{"delta":0.512,"content":[0.0]}'
    );
  );

// Standard deviation for range and amplitude as a function of amplitude
const
  RDB_RIEGL_NOISE_ESTIMATES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.noise_estimates';
    Title       : 'Noise Estimates';
    Description : 'Standard deviation for range and amplitude as a function of amplitude';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Noise '
      + 'Estimates","description":"Standard deviation for range and amplitude '
      + 'as a function of amplitude","type":"object","properties":{"amplitude":'
      + '{"type":"array","description":"Amplitude [dB]","items":{"type":"number'
      + '"}},"range_sigma":{"type":"array","description":"Sigma range [m]","ite'
      + 'ms":{"type":"number"}},"amplitude_sigma":{"type":"array","description"'
      + ':"Sigma amplitude [dB]","items":{"type":"number"}}},"required":["ampli'
      + 'tude","range_sigma","amplitude_sigma"]}'
    );

    Example : (''
      + '{"amplitude":[0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0],"range_sig'
      + 'ma":[0.065,0.056,0.046,0.038,0.032,0.027,0.024,0.021,0.018,0.016,0.014'
      + '],"amplitude_sigma":[0.988,0.988,0.875,0.774,0.686,0.608,0.54,0.482,0.'
      + '432,0.39,0.354]}'
    );
  );

// Notch filter parameters for window glass echoes
const
  RDB_RIEGL_NOTCH_FILTER : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.notch_filter';
    Title       : 'Notch Filter';
    Description : 'Notch filter parameters for window glass echoes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Notch '
      + 'Filter","description":"Notch filter parameters for window glass echoes'
      + '","type":"object","properties":{"range_minimum":{"type":"number","desc'
      + 'ription":"Minimum range '
      + '[m]"},"range_maximum":{"type":"number","description":"Maximum range [m'
      + ']"},"amplitude_maximum":{"type":"number","minimum":0,"description":"Ma'
      + 'ximum amplitude [dB]"}},"required":["range_minimum","range_maximum","a'
      + 'mplitude_maximum"]}'
    );

    Example : (''
      + '{"range_minimum":-0.5,"range_maximum":0.2,"amplitude_maximum":18.0}'
    );
  );

// Details about the pixels contained in the file
const
  RDB_RIEGL_PIXEL_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pixel_info';
    Title       : 'Pixel Information';
    Description : 'Details about the pixels contained in the file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Pixel '
      + 'Information","description":"Details about the pixels contained in the '
      + 'file","definitions":{"pixel_size":{"type":"array","description":"Size '
      + 'of pixels.","items":{"type":"number","description":"Length of pixel '
      + 'edge [m].","minimum":0},"maxItems":2,"minItems":2}},"type":"object","p'
      + 'roperties":{"size":{"$ref":"#/definitions/pixel_size","description":"S'
      + 'ize of pixels in file coordinate system."},"size_llcs":{"$ref":"#/defi'
      + 'nitions/pixel_size","description":"Size of pixels in a locally '
      + 'levelled cartesian coordinate system (xy). This is only used for '
      + 'pixels based on a map projection."}},"required":["size"]}'
    );

    Example : (''
      + '{"size":[0.5971642834779395,0.5971642834779395],"size_llcs":[0.5156575'
      + '252891171,0.5130835356683303]}'
    );
  );

// Details about the plane patch matching process
const
  RDB_RIEGL_PLANE_PATCH_MATCHING : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.plane_patch_matching';
    Title       : 'Plane Patch Matching';
    Description : 'Details about the plane patch matching process';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Plane '
      + 'Patch Matching","description":"Details about the plane patch matching '
      + 'process","definitions":{"file_reference":{"type":"object","description'
      + '":"Reference to a plane patch '
      + 'file","properties":{"file_uuid":{"description":"Plane patch file''s '
      + 'Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_path":{"description":"Path of the plane '
      + 'patch file relative to the match file","type":"string"}},"required":["'
      + 'file_uuid","file_path"]}},"type":"object","properties":{"plane_patch_f'
      + 'ile_one":{"$ref":"#/definitions/file_reference","description":"Referen'
      + 'ce to the plane patch file one"},"plane_patch_file_two":{"$ref":"#/def'
      + 'initions/file_reference","description":"Reference to the plane patch '
      + 'file '
      + 'two"}},"required":["plane_patch_file_one","plane_patch_file_two"]}'
    );

    Example : (''
      + '{"plane_patch_file_one":{"file_uuid":"810f5d57-eccf-49ed-b07a-0cdd109b'
      + '4213","file_path":"Record009_Line001/191025_121410_Scanner_1.ptch"},"p'
      + 'lane_patch_file_two":{"file_uuid":"fa47d509-a64e-49ce-8b14-ff3130fbefa'
      + '9","file_path":"project.ptch"}}'
    );
  );

// Statistics about plane patches found by plane patch extractor
const
  RDB_RIEGL_PLANE_PATCH_STATISTICS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.plane_patch_statistics';
    Title       : 'Plane Patch Statistics';
    Description : 'Statistics about plane patches found by plane patch extractor';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Plane '
      + 'Patch Statistics","description":"Statistics about plane patches found '
      + 'by plane patch extractor","type":"object","properties":{"total_area":{'
      + '"type":"number","description":"sum of all plane patch areas [m\u00b2]"'
      + '},"total_horizontal_area":{"type":"number","description":"sum of all '
      + 'plane patch areas projected to horizontal plane [m\u00b2]"}}}'
    );

    Example : (''
      + '{"total_area":14007.965,"total_horizontal_area":13954.601}'
    );
  );

// Settings and classes for plane slope classification
const
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.plane_slope_class_info';
    Title       : 'Plane Slope Class Info';
    Description : 'Settings and classes for plane slope classification';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Plane '
      + 'Slope Class Info","description":"Settings and classes for plane slope '
      + 'classification","type":"object","definitions":{"method-1":{"type":"obj'
      + 'ect","description":"Classification method 1","properties":{"plane_clas'
      + 'sification_method":{"type":"integer","description":"method ID (=1)","m'
      + 'inimum":1,"maximum":1},"maximum_inclination_angle_horizontal":{"type":'
      + '"number","description":"maximum inclination angle of horizontal plane '
      + 'patches [deg]","minimum":-360.0,"maximum":360.0}},"required":["plane_c'
      + 'lassification_method","maximum_inclination_angle_horizontal"]},"method'
      + '-2":{"type":"object","description":"Classification method 2","properti'
      + 'es":{"plane_classification_method":{"type":"integer","description":"me'
      + 'thod ID (=2)","minimum":2,"maximum":2},"sloping_plane_classes_minimum_'
      + 'angle":{"type":"number","description":"minimum inclination angle of '
      + 'sloping plane patches [deg]","minimum":-360.0,"maximum":360.0},"slopin'
      + 'g_plane_classes_maximum_angle":{"type":"number","description":"maximum'
      + ' inclination angle of sloping plane patches [deg]","minimum":-360.0,"m'
      + 'aximum":360.0}},"required":["plane_classification_method","sloping_pla'
      + 'ne_classes_minimum_angle","sloping_plane_classes_maximum_angle"]}},"pr'
      + 'operties":{"settings":{"type":"object","description":"Classification '
      + 'settings, details see documentation of rdbplanes","oneOf":[{"$ref":"#/'
      + 'definitions/method-1"},{"$ref":"#/definitions/method-2"}]},"classes":{'
      + '"type":"object","description":"Class definition '
      + 'table","patternProperties":{"^[0-9]+$":{"description":"one field per '
      + 'class, field name is class number, field value is class name","type":"'
      + 'string"}},"additionalProperties":false}},"required":["settings","class'
      + 'es"]}'
    );

    Example : (''
      + '{"settings":{"plane_classification_method":2,"sloping_plane_classes_mi'
      + 'nimum_angle":10.0,"sloping_plane_classes_maximum_angle":70.0},"classes'
      + '":{"1":"horizontal, pointing up","2":"sloping, pointing up and '
      + 'east","3":"sloping, pointing up and south","4":"sloping, pointing up '
      + 'and north","5":"sloping, pointing up and west","6":"vertical, pointing'
      + ' east","7":"vertical, pointing south","8":"vertical, pointing '
      + 'north","9":"vertical, pointing west","10":"sloping, pointing down and '
      + 'east","11":"sloping, pointing down and south","12":"sloping, pointing '
      + 'down and north","13":"sloping, pointing down and '
      + 'west","14":"horizontal, pointing down"}}'
    );
  );

// Grouping and sorting of point attributes for visualization purposes
const
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.point_attribute_groups';
    Title       : 'Point Attribute Groups';
    Description : 'Grouping and sorting of point attributes for visualization purposes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Point '
      + 'Attribute Groups","description":"Grouping and sorting of point '
      + 'attributes for visualization purposes","type":"object","patternPropert'
      + 'ies":{"^.*$":{"description":"Each field of the object represents a '
      + 'point attribute group and holds a list of point attributes, where the '
      + 'field name is the group '
      + 'name.","type":"array","items":{"description":"Point attribute full '
      + 'name or name pattern (perl regular expression '
      + 'syntax)","type":"string"},"minItems":1}},"additionalProperties":false}'
    );

    Example : (''
      + '{"Coordinates/Vectors":["riegl.xyz","riegl.range","riegl.theta","riegl'
      + '.phi"],"Time":["riegl.timestamp"],"Primary Attributes":["riegl.reflect'
      + 'ance","riegl.amplitude","riegl.deviation"],"Secondary '
      + 'Attributes":["riegl.mirror_facet","riegl.waveform_available"],"Other '
      + 'Attributes":["riegl.selected","riegl.visible"]}'
    );
  );

// Details about point cloud files
const
  RDB_RIEGL_POINTCLOUD_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pointcloud_info';
    Title       : 'Point Cloud Information';
    Description : 'Details about point cloud files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Point '
      + 'Cloud Information","description":"Details about point cloud files","ty'
      + 'pe":"object","properties":{"field_of_application":{"description":"Fiel'
      + 'd of application","type":"string","enum":["unknown","SLS","TLS","KLS",'
      + '"MLS","ULS","ALS","BLS","ILS"]},"project":{"description":"Project name'
      + '","type":"string"},"comments":{"description":"Comments","type":"string'
      + '"}}}'
    );

    Example : (''
      + '{"field_of_application":"ALS","project":"Campaign 4","comments":"Line '
      + '3"}'
    );
  );

// Estimated position and orientation information
const
  RDB_RIEGL_POSE_ESTIMATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pose_estimation';
    Title       : 'Pose Estimation';
    Description : 'Estimated position and orientation information';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Pose '
      + 'Estimation","description":"Estimated position and orientation '
      + 'information as measured by GNSS, IMU or inclination sensors","type":"o'
      + 'bject","properties":{"position":{"description":"Position coordinates '
      + 'and position accuracy values as measured by GNSS in the specified '
      + 'Coordinate Reference System (CRS)","type":"object","properties":{"coor'
      + 'dinate_1":{"description":"Coordinate 1 as defined by axis 1 of the '
      + 'specified CRS (e.g., X, '
      + 'Latitude)","type":"number"},"coordinate_2":{"description":"Coordinate '
      + '2 as defined by axis 2 of the specified CRS (e.g., Y, '
      + 'Longitude)","type":"number"},"coordinate_3":{"description":"Coordinate'
      + ' 3 as defined by axis 3 of the specified CRS (e.g., Z, Altitude)","typ'
      + 'e":"number"},"horizontal_accuracy":{"description":"Horizontal accuracy'
      + ' [m]","type":"number","minimum":0,"exclusiveMinimum":true},"vertical_a'
      + 'ccuracy":{"description":"Vertical accuracy [m]","type":"number","minim'
      + 'um":0,"exclusiveMinimum":true},"crs":{"type":"object","description":"G'
      + 'lobal Coordinate Reference '
      + 'System","properties":{"epsg":{"description":"EPSG '
      + 'code","type":"integer","minimum":0},"wkt":{"description":"\"Well-Known'
      + ' Text\" string, OGC WKT dialect (see http://www.opengeospatial.org/sta'
      + 'ndards/wkt-crs)","type":"string"}},"required":["epsg"]}},"required":["'
      + 'coordinate_1","coordinate_2","coordinate_3","horizontal_accuracy","ver'
      + 'tical_accuracy","crs"]},"orientation":{"description":"Orientation '
      + 'values and orientation accuracies, measured with IMU or inclination '
      + 'sensors.","type":"object","properties":{"roll":{"description":"Roll '
      + 'angle about scanner X-axis [deg]","type":"number","minimum":-360,"maxi'
      + 'mum":360},"pitch":{"description":"Pitch angle about scanner Y-axis [de'
      + 'g]","type":"number","minimum":-360,"maximum":360},"yaw":{"description"'
      + ':"Yaw angle about scanner Z-axis [deg]","type":"number","minimum":-360'
      + ',"maximum":360},"roll_accuracy":{"description":"Roll angle accuracy [d'
      + 'eg]","type":"number","minimum":0,"exclusiveMinimum":true},"pitch_accur'
      + 'acy":{"description":"Pitch angle accuracy [deg]","type":"number","mini'
      + 'mum":0,"exclusiveMinimum":true},"yaw_accuracy":{"description":"Yaw '
      + 'angle accuracy [deg]","type":"number","minimum":0,"exclusiveMinimum":t'
      + 'rue}},"required":["roll","pitch","yaw","roll_accuracy","pitch_accuracy'
      + '","yaw_accuracy"]},"barometric_height_amsl":{"description":"Altitude '
      + 'determined based on the atmospheric pressure according to the standard'
      + ' atmosphere laws [m].","type":"number"}},"required":["orientation"]}'
    );

    Example : (''
      + '{"position":{"coordinate_1":48.655799473,"coordinate_2":15.645033406,"'
      + 'coordinate_3":362.7124938964844,"horizontal_accuracy":0.81069999933242'
      + '8,"vertical_accuracy":1.3314999341964722,"crs":{"epsg":4979,"wkt":"GEO'
      + 'GCS[\"WGS84 / Geographic\",DATUM[\"WGS84\",SPHEROID[\"WGS84\",6378137.'
      + '000,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6'
      + '326\"]],PRIMEM[\"Greenwich\",0.0000000000000000,AUTHORITY[\"EPSG\",\"8'
      + '901\"]],UNIT[\"Degree\",0.01745329251994329547,AUTHORITY[\"EPSG\",\"91'
      + '02\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E'
      + 'PSG\",\"4979\"]]"}},"orientation":{"roll":3.14743073066123,"pitch":1.5'
      + '09153024827064,"yaw":101.87293630292045,"roll_accuracy":0.009433783936'
      + '875745,"pitch_accuracy":0.009433783936875745,"yaw_accuracy":1.00943378'
      + '39368757},"barometric_height_amsl":386.7457796227932}'
    );
  );

// Details on position and orientation sensors
const
  RDB_RIEGL_POSE_SENSORS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pose_sensors';
    Title       : 'Pose Sensors';
    Description : 'Details on position and orientation sensors';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Pose '
      + 'Sensors","description":"Details on position and orientation sensors","'
      + 'definitions":{"vector":{"type":"array","items":{"type":"number","descr'
      + 'iption":"Index 0=X, 1=Y, 2=Z component"},"minItems":3,"maxItems":3}},"'
      + 'type":"object","properties":{"gyroscope":{"type":"object","description'
      + '":"Gyroscope '
      + 'details","properties":{"unit":{"type":"number","description":"Unit of '
      + 'raw data and calibration values, 1 LSB in rad/s","minimum":0,"exclusiv'
      + 'eMinimum":true},"x_axis":{"$ref":"#/definitions/vector","description":'
      + '"Sensitive X axis of sensor at frame angle = '
      + '0"},"y_axis":{"$ref":"#/definitions/vector","description":"Sensitive Y'
      + ' axis of sensor at frame angle = '
      + '0"},"z_axis":{"$ref":"#/definitions/vector","description":"Sensitive Z'
      + ' axis of sensor at frame angle = '
      + '0"},"offset":{"$ref":"#/definitions/vector","description":"Value to be'
      + ' subtracted from raw measurement '
      + 'values"},"origin":{"$ref":"#/definitions/vector","description":"Sensor'
      + ' origin in SOCS [m] at frame angle = 0"},"relative_nonlinearity":{"$re'
      + 'f":"#/definitions/vector","description":"Relative nonlinearity, dimens'
      + 'ionless"}},"required":["unit","x_axis","y_axis","z_axis","offset","ori'
      + 'gin","relative_nonlinearity"]},"accelerometer":{"type":"object","descr'
      + 'iption":"Accelerometer '
      + 'details","properties":{"unit":{"type":"number","description":"Unit of '
      + 'raw data and calibration values, 1 LSB in 9.81 m/s\u00b2","minimum":0,'
      + '"exclusiveMinimum":true},"x_axis":{"$ref":"#/definitions/vector","desc'
      + 'ription":"Sensitive X axis of sensor at frame angle = '
      + '0"},"y_axis":{"$ref":"#/definitions/vector","description":"Sensitive Y'
      + ' axis of sensor at frame angle = '
      + '0"},"z_axis":{"$ref":"#/definitions/vector","description":"Sensitive Z'
      + ' axis of sensor at frame angle = '
      + '0"},"offset":{"$ref":"#/definitions/vector","description":"Value to be'
      + ' subtracted from raw measurement '
      + 'values"},"origin":{"$ref":"#/definitions/vector","description":"Sensor'
      + ' origin in SOCS [m] at frame angle = 0"},"relative_nonlinearity":{"$re'
      + 'f":"#/definitions/vector","description":"Relative nonlinearity, dimens'
      + 'ionless"}},"required":["unit","x_axis","y_axis","z_axis","offset","ori'
      + 'gin","relative_nonlinearity"]},"magnetic_field_sensor":{"type":"object'
      + '","description":"Magnetic Field Sensor '
      + 'details","properties":{"unit":{"type":"number","description":"Unit of '
      + 'raw data and calibration values, 1 LSB in nT","minimum":0,"exclusiveMi'
      + 'nimum":true},"x_axis":{"$ref":"#/definitions/vector","description":"Se'
      + 'nsitive X axis of sensor at frame angle = '
      + '0"},"y_axis":{"$ref":"#/definitions/vector","description":"Sensitive Y'
      + ' axis of sensor at frame angle = '
      + '0"},"z_axis":{"$ref":"#/definitions/vector","description":"Sensitive Z'
      + ' axis of sensor at frame angle = '
      + '0"},"offset":{"$ref":"#/definitions/vector","description":"Value to be'
      + ' subtracted from raw measurement values"},"fixed":{"$ref":"#/definitio'
      + 'ns/vector","description":"Distortion of magnetic field caused by '
      + 'non-rotating scanner part"},"relative_nonlinearity":{"$ref":"#/definit'
      + 'ions/vector","description":"Relative nonlinearity, dimensionless"}},"r'
      + 'equired":["unit","x_axis","y_axis","z_axis","offset","fixed","relative'
      + '_nonlinearity"]}},"required":["gyroscope","accelerometer","magnetic_fi'
      + 'eld_sensor"]}'
    );

    Example : (''
      + '{"gyroscope":{"unit":0.00014544410805683583,"x_axis":[-121.19555664062'
      + '5,0.8219714164733887,0.2313031703233719],"y_axis":[-0.440765917301178,'
      + '-0.7897399663925171,119.5894775390625],"z_axis":[0.555869996547699,119'
      + '.22135162353516,0.467585027217865],"offset":[-50.92609786987305,146.15'
      + '643310546875,62.4327278137207],"origin":[0.026900000870227814,-0.03999'
      + '999910593033,-0.08950000256299973],"relative_nonlinearity":[2.88817631'
      + '1444113e-07,1.06274164579645e-07,-1.7186295080634935e-39]},"accelerome'
      + 'ter":{"unit":6.666666740784422e-05,"x_axis":[-15008.123046875,56.95639'
      + '0380859375,-60.5175666809082],"y_axis":[-7.027288913726807,-44.1233367'
      + '9199219,14952.3701171875],"z_axis":[1.639882206916809,15166.744140625,'
      + '-116.99742889404297],"offset":[-733.3636474609375,58.969032287597656,1'
      + '060.2550048828125],"origin":[0.026900000870227814,-0.03999999910593033'
      + ',-0.08950000256299973],"relative_nonlinearity":[0.0,0.0,0.0]},"magneti'
      + 'c_field_sensor":{"unit":91.74311828613281,"x_axis":[-0.011162743903696'
      + '537,-2.315962774446234e-05,0.00016818844596855342],"y_axis":[0.0002788'
      + '8521435670555,-0.011427424848079681,-5.204829722060822e-05],"z_axis":['
      + '0.00041987866279669106,7.876977906562388e-05,0.011407104320824146],"of'
      + 'fset":[-23812.052734375,5606.57666015625,2493.28125],"fixed":[-1576.01'
      + '0498046875,1596.081787109375,0.0],"relative_nonlinearity":[0.0,0.0,0.0'
      + ']}}'
    );
  );

// Laser pulse position modulation used for MTA resolution
const
  RDB_RIEGL_PULSE_POSITION_MODULATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pulse_position_modulation';
    Title       : 'Pulse Position Modulation';
    Description : 'Laser pulse position modulation used for MTA resolution';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Pulse '
      + 'Position Modulation","description":"Laser pulse position modulation '
      + 'used for MTA resolution","type":"object","properties":{"length":{"type'
      + '":"integer","description":"Length of code","minimum":0,"maximum":255},'
      + '"num_mod_ampl":{"type":"integer","description":"Number of different '
      + 'modulation amplitudes (2: binary modulation)","minimum":0,"maximum":25'
      + '5},"code_phase_mode":{"type":"integer","description":"0: no '
      + 'synchronization, 1: toggle between 2 phases, 2: increment with phase_i'
      + 'ncrement","minimum":0,"maximum":255},"phase_step":{"type":"integer","d'
      + 'escription":"Step width in phase of modulation code from line to line"'
      + ',"minimum":0,"maximum":255},"pulse_interval":{"type":"array","descript'
      + 'ion":"Explicit table of the pulse position modulation used for MTA '
      + 'resolution. Table gives times between successive laser pulses in secon'
      + 'ds.","items":{"type":"number","minimum":0}}},"required":["length","num'
      + '_mod_ampl","pulse_interval"]}'
    );

    Example : (''
      + '{"length":31,"num_mod_ampl":2,"code_phase_mode":2,"phase_step":5,"puls'
      + 'e_interval":[2.759375e-06,2.759375e-06,2.759375e-06,2.759375e-06,2.821'
      + '875e-06,2.759375e-06,2.759375e-06,2.821875e-06,2.759375e-06,2.821875e-'
      + '06,2.821875e-06,2.759375e-06,2.759375e-06,2.821875e-06,2.821875e-06,2.'
      + '821875e-06,2.821875e-06,2.821875e-06,2.759375e-06,2.759375e-06,2.75937'
      + '5e-06,2.821875e-06,2.821875e-06,2.759375e-06,2.821875e-06,2.821875e-06'
      + ',2.821875e-06,2.759375e-06,2.821875e-06,2.759375e-06,2.821875e-06]}'
    );
  );

// Statistics about target distance wrt. SOCS origin
const
  RDB_RIEGL_RANGE_STATISTICS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.range_statistics';
    Title       : 'Range Statistics';
    Description : 'Statistics about target distance wrt. SOCS origin';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Range '
      + 'Statistics","description":"Statistics about target distance wrt. SOCS '
      + 'origin","type":"object","properties":{"minimum":{"type":"number","desc'
      + 'ription":"Minimum '
      + 'value"},"average":{"type":"number","description":"Average '
      + 'value"},"maximum":{"type":"number","description":"Maximum '
      + 'value"},"std_dev":{"type":"number","description":"Standard '
      + 'deviation"}},"required":["minimum","average","maximum","std_dev"]}'
    );

    Example : (''
      + '{"minimum":0.919,"average":15.49738,"maximum":574.35,"std_dev":24.349}'
    );
  );

// Receiver Internals
const
  RDB_RIEGL_RECEIVER_INTERNALS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.receiver_internals';
    Title       : 'Receiver Internals';
    Description : 'Receiver Internals';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Receiver'
      + ' Internals","description":"Receiver Internals","definitions":{"fp":{"t'
      + 'ype":"object","description":"Fingerprint values","properties":{"s":{"t'
      + 'ype":"array","items":{"type":"array","items":{"type":"number"},"minIte'
      + 'ms":1,"maxItems":4096},"minItems":1,"maxItems":256},"w":{"type":"array'
      + '","items":{"type":"array","items":{"type":"number"},"minItems":5,"maxI'
      + 'tems":5},"minItems":1,"maxItems":256}},"required":["s","w"]},"fp_table'
      + '":{"type":"object","desription":"scanner internal data","properties":{'
      + '"ch":{"type":"integer","min":0,"max":255,"description":"channel '
      + 'number"},"tc":{"type":"integer","min":0,"max":255,"description":"table'
      + ' data type '
      + 'code"},"nx":{"type":"integer","min":1,"max":2048,"description":"number'
      + ' of x entries"},"ny":{"type":"integer","min":1,"max":2048,"description'
      + '":"number of y entries"},"tv":{"type":"array","minItems":1,"maxItems":'
      + '2048,"items":{"oneOf":[{"$ref":"#/definitions/fp_table_row"},{"type":"'
      + 'number"}]}}},"required":["ch","tc","nx","ny","tv"]},"fp_table_row":{"t'
      + 'ype":"array","minItems":1,"maxItems":2048,"items":{"type":"number"}}},'
      + '"type":"object","properties":{"nt":{"type":"integer","minimum":0,"maxi'
      + 'mum":255,"description":"Number of traces"},"ns":{"type":"integer","min'
      + 'imum":0,"maximum":4095,"description":"Number of samples"},"sr":{"type"'
      + ':"number","minimum":0,"exclusiveMinimum":true,"description":"Sample '
      + 'rate [Hz]"},"mw":{"type":"number","minimum":0,"maximum":4095,"exclusiv'
      + 'eMinimum":true,"description":"Maximum weight"},"si":{"type":"number","'
      + 'minimum":0,"maximum":255,"description":"Start index (hw_start)"},"a":{'
      + '"type":"array","items":{"type":"number"},"minItems":1,"maxItems":256,"'
      + 'description":"Amplitude [dB]"},"t":{"type":"object","patternProperties'
      + '":{"^[0-9]+$":{"description":"one field per channel, field name is '
      + 'channel index","$ref":"#/definitions/fp"}},"additionalProperties":fals'
      + 'e},"ex":{"type":"object","description":"DEPRECATED, use '
      + '''riegl.exponential_decomposition'' instead"},"tbl":{"type":"array","ite'
      + 'ms":{"$ref":"#/definitions/fp_table"},"minItems":1,"description":"vari'
      + 'ous internal data"}}}'
    );

    Example : (''
      + '{"nt":128,"ns":400,"sr":7959997000.0,"mw":31,"si":48,"a":[-1.55],"t":{'
      + '"0":{"s":[[1.23,4.56],[7.89,0.12]],"w":[[78,86,126,134,31],[78,86,126,'
      + '134,31]]},"1":{"s":[[1.23,4.56],[7.89,0.12]],"w":[[78,86,126,134,31],['
      + '78,86,126,134,31]]}},"tbl":[{"ch":0,"tc":1,"nx":5,"ny":2,"tv":[[1,2,3,'
      + '4,5],[1.1,2.2,3.3,4.4,5.5]]}]}'
    );
  );

// Lookup table for reflectance calculation based on amplitude and range
const
  RDB_RIEGL_REFLECTANCE_CALCULATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.reflectance_calculation';
    Title       : 'Reflectance Calculation Table';
    Description : 'Lookup table for reflectance calculation based on amplitude and range';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Reflecta'
      + 'nce Calculation Table","description":"Lookup table for reflectance '
      + 'calculation based on amplitude and '
      + 'range","type":"object","properties":{"delta":{"description":"Delta '
      + 'between table entries [m], first entry is at range = 0 '
      + 'm","type":"number"},"content":{"description":"Correction value [dB] to'
      + ' be added to the amplitude","type":"array","items":{"type":"number"},"'
      + 'minItems":1,"maxItems":2000}},"required":["delta","content"]}'
    );

    Example : (''
      + '{"delta":0.150918,"content":[-33.01]}'
    );
  );

// Range-dependent and scan-angle-dependent correction of reflectance reading
const
  RDB_RIEGL_REFLECTANCE_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.reflectance_correction';
    Title       : 'Near-Range Reflectance Correction';
    Description : 'Range-dependent and scan-angle-dependent correction of reflectance reading';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Near-ran'
      + 'ge reflectance correction","description":"Range-dependent and '
      + 'scan-angle-dependent correction of reflectance reading","type":"object'
      + '","properties":{"ranges_m":{"type":"array","description":"Range [m]","'
      + 'items":{"type":"number"}},"line_angles_deg":{"type":"array","descripti'
      + 'on":"Angle [deg]","items":{"type":"number"}},"reflectance_correction_d'
      + 'b":{"type":"array","description":"Near range reflectance correction in'
      + ' dB as a function of range over angle","items":{"description":"rows '
      + '(each array corresponds to a '
      + 'range)","type":"array","items":{"description":"columns (each value '
      + 'corresponds to an angle)","type":"number"}}}},"required":["ranges_m","'
      + 'line_angles_deg","reflectance_correction_db"]}'
    );

    Example : (''
      + '{"ranges_m":[0.0,1.0,2.0,3.0],"line_angles_deg":[0.0,0.5,1.0,1.5,1.0,2'
      + '.0,2.5,3.0,3.5,4.0],"reflectance_correction_db":[[0.8,0.7,0.6,0.5,0.4,'
      + '0.3,0.2,0.1,0.05,0.01],[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01],[0.'
      + '8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01],[0.8,0.7,0.6,0.5,0.4,0.3,0.2,'
      + '0.1,0.05,0.01]]}'
    );
  );

// Details about RiLOC processing
const
  RDB_RIEGL_RILOC_PROCESSING_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.riloc_processing_info';
    Title       : 'RiLOC Processing Information';
    Description : 'Details about RiLOC processing';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"RiLOC '
      + 'Processing Information","description":"Details about RiLOC processing"'
      + ',"type":"object","properties":{"trajectory":{"description":"Trajectory'
      + ' information and statistics.","type":"object","properties":{}},"optimi'
      + 'zer":{"description":"Optimization result information and statistics.",'
      + '"type":"object","properties":{}},"planes":{"description":"Information '
      + 'on plane correspondences and used extraction/matching templates.","typ'
      + 'e":"object","properties":{}},"georeferencing":{"description":"Internal'
      + ' georeferencing parameters.","type":"object","properties":{}}},"requir'
      + 'ed":["trajectory","optimizer","georeferencing"]}'
    );

    Example : (''
      + '{"trajectory":{},"optimizer":{},"planes":{},"georeferencing":{}}'
    );
  );

// Scan pattern description
const
  RDB_RIEGL_SCAN_PATTERN : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.scan_pattern';
    Title       : 'Scan Pattern';
    Description : 'Scan pattern description';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Scan '
      + 'Pattern","description":"Scan pattern '
      + 'description","definitions":{"program":{"description":"Measurement '
      + 'program","type":"object","properties":{"name":{"description":"Name of '
      + 'measurement '
      + 'program","type":"string"},"laser_prr":{"description":"Laser Pulse '
      + 'Repetition Rate [Hz]","type":"number","minimum":0,"exclusiveMinimum":f'
      + 'alse}},"required":["name"]}},"properties":{"rectangular":{"description'
      + '":"Rectangular Field Of View Scan Pattern","type":"object","properties'
      + '":{"phi_start":{"description":"Start phi angle in SOCS [deg]","type":"'
      + 'number","minimum":0.0,"maximum":360.0},"phi_stop":{"description":"Stop'
      + ' phi angle in SOCS [deg]","type":"number","minimum":0.0,"maximum":720.'
      + '0},"phi_increment":{"description":"Increment of phi angle in SOCS [deg'
      + ']","type":"number","minimum":0.0,"maximum":90.0},"theta_start":{"descr'
      + 'iption":"Start theta angle in SOCS [deg]","type":"number","minimum":0.'
      + '0,"maximum":180.0},"theta_stop":{"description":"Stop theta angle in '
      + 'SOCS [deg]","type":"number","minimum":0.0,"maximum":180.0},"theta_incr'
      + 'ement":{"description":"Increment of theta angle in SOCS [deg]","type":'
      + '"number","minimum":0.0,"maximum":90.0},"program":{"$ref":"#/definition'
      + 's/program"}},"required":["phi_start","phi_stop","phi_increment","theta'
      + '_start","theta_stop","theta_increment"]},"line":{"description":"Line '
      + 'Scan '
      + 'Pattern","type":"object","properties":{"start":{"description":"Start '
      + 'angle in SOCS [deg]","type":"number","minimum":0.0,"maximum":360.0},"s'
      + 'top":{"description":"Stop angle in SOCS [deg]","type":"number","minimu'
      + 'm":0.0,"maximum":720.0},"increment":{"description":"Increment of angle'
      + ' in SOCS [deg]","type":"number","minimum":0.0,"maximum":90.0},"program'
      + '":{"$ref":"#/definitions/program"}},"required":["start","stop","increm'
      + 'ent"]},"segments":{"description":"Segmented Line Scan Pattern","type":'
      + '"object","properties":{"list":{"type":"array","items":{"description":"'
      + 'Line Scan '
      + 'Segment","type":"object","properties":{"start":{"description":"Start '
      + 'angle in SOCS [deg]","type":"number","minimum":0.0,"maximum":360.0},"s'
      + 'top":{"description":"Stop angle in SOCS [deg]","type":"number","minimu'
      + 'm":0.0,"maximum":720.0},"increment":{"description":"Increment of angle'
      + ' in SOCS [deg]","type":"number","minimum":0.0,"maximum":90.0}},"requir'
      + 'ed":["start","stop","increment"]}},"program":{"$ref":"#/definitions/pr'
      + 'ogram"}},"required":["list"]}}}'
    );

    Example : (''
      + '{"rectangular":{"phi_start":45.0,"phi_stop":270.0,"phi_increment":0.04'
      + ',"theta_start":30.0,"theta_stop":130.0,"theta_increment":0.04,"program'
      + '":{"name":"High Speed","laser_prr":100000.0}}}'
    );
  );

// Details about laser shot files
const
  RDB_RIEGL_SHOT_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.shot_info';
    Title       : 'Shot Information';
    Description : 'Details about laser shot files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Shot '
      + 'Information","description":"Details about laser shot files","type":"ob'
      + 'ject","properties":{"shot_file":{"type":"object","properties":{"file_u'
      + 'uid":{"description":"File''s Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_extension":{"description":"Shot file '
      + 'extension, without the leading '
      + 'dot","type":"string"}},"required":["file_extension"]}}}'
    );

    Example : (''
      + '{"shot_file":{"file_uuid":"26a00815-67c0-4bff-8fe8-c577378fe663","file'
      + '_extension":"sodx"}}'
    );
  );

// Point filters applied in addition to the application-defined filters
const
  RDB_RIEGL_STORED_FILTERS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.stored_filters';
    Title       : 'Stored Filters';
    Description : 'Point filters applied in addition to the application-defined filters';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Stored '
      + 'filters","description":"Point filters applied in addition to the '
      + 'application-defined filters","type":"object","properties":{"activated"'
      + ':{"description":"Apply (''true'') or ignore (''false'') all '
      + 'filters","type":"boolean"},"filters":{"description":"List of point '
      + 'filters","type":"array","items":{"description":"Point filter definitio'
      + 'n","type":"object","properties":{"activated":{"description":"Apply '
      + '(''true'') or ignore (''false'') this '
      + 'filter","type":"boolean"},"title":{"description":"A short filter title'
      + ' (e.g. for display in a selection '
      + 'list)","type":"string"},"description":{"description":"A brief '
      + 'description of the filter (e.g. for display in a '
      + 'tooltip)","type":"string"},"filter":{"description":"The RDB filter '
      + 'string to apply (e.g. when reading points or index), details see '
      + 'documentation of function select()","type":"string"}},"required":["act'
      + 'ivated","title","description","filter"]}}},"required":["activated","fi'
      + 'lters"]}'
    );

    Example : (''
      + '{"activated":true,"filters":[{"activated":false,"title":"Ignore '
      + 'uncertain points from MTA resolution","description":"Ignore points '
      + 'with uncertain MTA zone '
      + 'assignment","filter":"riegl.mta_uncertain_point == '
      + '0"},{"activated":false,"title":"Ignore points below dynamic trigger '
      + 'level","description":"Ignore points with an echo signal amplitude '
      + 'below the dynamic trigger","filter":"riegl.dyntrig_uncertain_point == '
      + '0"},{"activated":false,"title":"Ignore points outside outer '
      + 'AABB","description":"Ignore points that are outside the outer AABB in '
      + 'BOCS","filter":"riegl.point_outside_aabb_bocs == '
      + '0"},{"activated":false,"title":"Ignore points inside inner '
      + 'AABB","description":"Ignore points that are inside the inner AABB in '
      + 'BOCS","filter":"riegl.point_inside_aabb_bocs == 0"}]}'
    );
  );

// Details of major system components like lidar sensors, cameras and navigation devices
const
  RDB_RIEGL_SYSTEM_DESCRIPTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.system_description';
    Title       : 'System Description';
    Description : 'Details of major system components like lidar sensors, cameras and navigation devices';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"System '
      + 'Description","description":"Details of major system components like '
      + 'lidar sensors, cameras and navigation '
      + 'devices","type":"object","properties":{"$class":{"description":"Object'
      + ' class name","type":"string","enum":["Document"]},"version":{"descript'
      + 'ion":"Document format '
      + 'version","type":"string"},"author":{"description":"Name of the author '
      + 'that created the '
      + 'document","type":"string"},"timestamp":{"description":"Date and time '
      + 'of creation (e.g. 2019-06-19T13:32:10+02:00)","type":"string"},"system'
      + '":{"description":"The actual system description, details see '
      + 'documentation of RIEGL System Description","type":"object"}},"required'
      + '":["$class","version","author","timestamp","system"]}'
    );

    Example : (''
      + '{"$class":"Document","version":"1.2.1","author":"RIEGL LMS GmbH, Austr'
      + 'ia","timestamp":"2022-09-30T11:56:26+00:00","system":{"details":"see '
      + 'documentation of RIEGL System Description"}}'
    );
  );

// Conversion of background radiation raw values to temperatures in °C
const
  RDB_RIEGL_TEMPERATURE_CALCULATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.temperature_calculation';
    Title       : 'Temperature Calculation Table';
    Description : 'Conversion of background radiation raw values to temperatures in °C';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Temperat'
      + 'ure Calculation Table","description":"Conversion of background '
      + 'radiation raw values to temperatures in \u00b0C","definitions":{"conve'
      + 'rsion_table":{"type":"object","properties":{"value":{"type":"array","d'
      + 'escription":"LSB [1]","items":{"type":"number"}},"temperature":{"type"'
      + ':"array","description":"Temperature [\u00b0C]","items":{"type":"number'
      + '"}}},"required":["value","temperature"]}},"type":"object","properties"'
      + ':{"InGaAs":{"$ref":"#/definitions/conversion_table","description":"Con'
      + 'version table for InGaAs channel"},"Si":{"$ref":"#/definitions/convers'
      + 'ion_table","description":"Conversion table for Si channel"},"InGaAs_Si'
      + '_Difference":{"$ref":"#/definitions/conversion_table","description":"C'
      + 'onversion table for InGaAs - Si difference"}}}'
    );

    Example : (''
      + '{"InGaAs":{"value":[0.0,64.00097659230323,128.0019531846065,192.002929'
      + '7769097,256.0039063692129,320.00488296151616,384.0058595538194,448.006'
      + '8361461226,512.0078127384259],"temperature":[307.22196722535614,309.11'
      + '53478247277,311.1188086915047,313.10025350480055,315.2137946389828,317'
      + '.2172555057597,319.2207163725366,321.2021611858325,323.3157023200148]}'
      + ',"Si":{"value":[0.0,64.00097659230323,128.0019531846065,192.0029297769'
      + '097,256.0039063692129,320.00488296151616,384.0058595538194,448.0068361'
      + '461226,512.0078127384259],"temperature":[546.300048828125,548.81640512'
      + '12026,551.3143938500972,554.0144257850053,556.604252334815,559.2124464'
      + '488079,561.8022729986177,564.4104671126105,567.0002936624203]},"InGaAs'
      + '_Si_Difference":{"value":[1000.0,1100.090029602954,1200.04425183874,13'
      + '00.1342814416948,1400.0885036774805,1500.0427259132668,1600.1327555162'
      + '209,1700.0869777520065,1800.0411999877924],"temperature":[1749.9771111'
      + '17893,1749.977111117893,1749.977111117893,1749.977111117893,1749.97711'
      + '1117893,1749.977111117893,1744.7813348796044,1681.9971312601092,1622.3'
      + '944822534868]}}'
    );
  );

// Base of timestamps (epoch)
const
  RDB_RIEGL_TIME_BASE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.time_base';
    Title       : 'Time Base';
    Description : 'Base of timestamps (epoch)';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Time '
      + 'Base","description":"Base of timestamps '
      + '(epoch)","type":"object","properties":{"epoch":{"description":"Date '
      + 'and time of timestamp ''0'' as proposed by RFC 3339 (e.g. 2015-10-27T00:'
      + '00:00+01:00).","type":"string"},"source":{"description":"Timestamp sou'
      + 'rce","type":"string","enum":["unknown","RTC","GNSS"]},"system":{"descr'
      + 'iption":"Time system (time standard)","type":"string","enum":["unknown'
      + '","UTC","GPS"]}},"required":["epoch","source"]}'
    );

    Example : (''
      + '{"epoch":"2015-10-27T00:00:00+00:00","source":"GNSS","system":"UTC"}'
    );
  );

// Details about position+orientation files
const
  RDB_RIEGL_TRAJECTORY_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.trajectory_info';
    Title       : 'Trajectory Information';
    Description : 'Details about position+orientation files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Trajecto'
      + 'ry Information","description":"Details about position+orientation file'
      + 's","type":"object","properties":{"time_interval":{"description":"Time '
      + 'interval statistics","type":"object","properties":{"minimum":{"descrip'
      + 'tion":"Minimum time interval '
      + '[s]","type":"number"},"average":{"description":"Average time interval '
      + '[s]","type":"number"},"maximum":{"description":"Maximum time interval '
      + '[s]","type":"number"},"std_dev":{"description":"Standard deviation of '
      + 'intervals [s]","type":"number"}},"required":["minimum","average","maxi'
      + 'mum","std_dev"]},"navigation_frame":{"description":"Navigation frame '
      + '(NED: North-East-Down, ENU: East-North-Up)","type":"string","enum":["u'
      + 'nknown","NED","ENU"]},"field_of_application":{"description":"Field of '
      + 'application","type":"string","enum":["unknown","SLS","TLS","KLS","MLS"'
      + ',"ULS","ALS","BLS","ILS"]},"company":{"description":"Company '
      + 'name","type":"string"},"project":{"description":"Project '
      + 'name","type":"string"},"location":{"description":"Project location, '
      + 'e.g. city/state/country","type":"string"},"device":{"description":"Nav'
      + 'igation device, e.g. '
      + 'name/type/serial","type":"string"},"software":{"description":"Software'
      + ' that calculated the trajectory (this may be the same or different '
      + 'software than the one that created the '
      + 'file)","type":"string"},"settings":{"description":"Settings used to '
      + 'calculate the trajectory (descriptive text)","type":"string"}},"requir'
      + 'ed":["time_interval","navigation_frame"]}'
    );

    Example : (''
      + '{"time_interval":{"minimum":0.00500032,"average":0.00500053,"maximum":'
      + '0.005004883,"std_dev":5.51e-07},"navigation_frame":"NED","field_of_app'
      + 'lication":"MLS","company":"RIEGL LMS","project":"Campaign '
      + '3","location":"Horn","device":"IMU Model 12/1, Serial# '
      + '12345","software":"Navigation Software XYZ","settings":"default"}'
    );
  );

// Trigger-Timestamping-Unit/IP configuration
const
  RDB_RIEGL_TTIP_CONFIGURATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.ttip_configuration';
    Title       : 'TTIP Configuration';
    Description : 'Trigger-Timestamping-Unit/IP configuration';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"TTIP '
      + 'Configuration","description":"Trigger-Timestamping-Unit/IP configurati'
      + 'on","type":"object","properties":{"ttip_version":{"description":"follo'
      + 'wing main.sub.ss.sss","type":"integer","minimum":0},"num_channel":{"de'
      + 'scription":"number of input/output channels","type":"integer","minimum'
      + '":0},"ext_channel":{"description":"ID of channel used as external '
      + 'trigger input, 32 indicates '
      + 'none","type":"integer","minimum":0},"ext_signal":{"description":"0 .. '
      + 'use input signal, 1 .. use output signal of channel","type":"integer",'
      + '"minimum":0},"ext_delay":{"description":"external trigger, time delay '
      + '[0.1 msec]","type":"integer","minimum":0},"ext_subdivider":{"descripti'
      + 'on":"reduces the frequency, default '
      + '1","type":"integer","minimum":0},"ext_bitmask":{"description":"defines'
      + ' which of the internal pulse generators are to be '
      + 'started","type":"integer","minimum":0},"dmi_incr":{"description":"dmi,'
      + ' increment in '
      + 'ticks","type":"integer"},"dmi_min_time":{"description":"dmi, minimum '
      + 'time interval between trigger events [0.1 msec]","type":"integer","min'
      + 'imum":0},"dmi_max_time":{"description":"dmi, maximum time interval '
      + 'between trigger events [0.1 msec]","type":"integer","minimum":0},"dmi_'
      + 'dist_per_tick":{"description":"dmi, distance per tick, just '
      + 'informative [m]","type":"number"},"channel":{"description":"ID of '
      + 'input/output channel","type":"integer","minimum":0},"output_descr":{"d'
      + 'escription":"descriptive '
      + 'string","type":"string"},"input_descr":{"description":"descriptive '
      + 'string","type":"string"},"output_usage":{"description":"0 .. no '
      + 'output, 1 .. output derived from internal clock, 2 .. output derived '
      + 'from dmi, 3 .. output derived from external signal, 4 .. output static'
      + ' low, 5 .. output static '
      + 'high","type":"integer","minimum":0},"input_usage":{"description":"0 ..'
      + ' deactivated, 1 .. just detecting and timestamping","type":"integer","'
      + 'minimum":0},"out_polarity":{"description":"0 .. positive edge, 1 .. '
      + 'negative edge","type":"integer","minimum":0},"out_duration":{"descript'
      + 'ion":"output pulse duration [0.1 msec]","type":"integer","minimum":0},'
      + '"out_interval":{"description":"output pulse interval [0.1 msec]","type'
      + '":"integer","minimum":0},"out_delay":{"description":"output pulse '
      + 'initial delay after start [0.1 msec]","type":"integer","minimum":0},"o'
      + 'ut_num_pulses":{"description":"number of output pulses to be '
      + 'generated, 0 .. infinite","type":"integer","minimum":0},"in_polarity":'
      + '{"description":"0 .. positive edge, 1 .. negative edge","type":"intege'
      + 'r","minimum":0},"in_min_duration":{"description":"input signals with '
      + 'smaller pulse durations are ignored [0.1 msec]","type":"integer","mini'
      + 'mum":0},"in_max_duration":{"description":"stops measurement of pulse '
      + 'duration of input signal [0.1 msec]","type":"integer","minimum":0},"in'
      + '_max_delay":{"description":"maximum delay to output pulse before fake '
      + 'event is generated [0.1 msec], zero indicates that no fake events are '
      + 'generated","type":"integer","minimum":0}},"required":["ttip_version","'
      + 'num_channel","ext_channel","ext_signal","ext_delay","ext_subdivider","'
      + 'ext_bitmask","dmi_incr","dmi_min_time","dmi_max_time","dmi_dist_per_ti'
      + 'ck","channel","output_descr","input_descr","output_usage","input_usage'
      + '","out_polarity","out_duration","out_interval","out_delay","out_num_pu'
      + 'lses","in_polarity","in_min_duration","in_max_duration","in_max_delay"'
      + ']}'
    );

    Example : (''
      + '{"ttip_version":1,"num_channel":9,"ext_channel":32,"ext_signal":0,"ext'
      + '_delay":0,"ext_subdivider":1,"ext_bitmask":0,"dmi_incr":0,"dmi_min_tim'
      + 'e":0,"dmi_max_time":0,"dmi_dist_per_tick":0.0,"channel":0,"output_desc'
      + 'r":"Port 1 - Trigger","input_descr":"Port 1 - Exposure","output_usage"'
      + ':1,"input_usage":1,"out_polarity":0,"out_duration":300,"out_interval":'
      + '10000,"out_delay":0,"out_num_pulses":1,"in_polarity":0,"in_min_duratio'
      + 'n":0,"in_max_duration":10000,"in_max_delay":9990}'
    );
  );

// Details about vertex file
const
  RDB_RIEGL_VERTEX_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.vertex_info';
    Title       : 'Vertex Information';
    Description : 'Details about vertex file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Vertex '
      + 'Information","description":"Details about vertex file","type":"object"'
      + ',"properties":{"vertex_file":{"type":"object","properties":{"file_uuid'
      + '":{"description":"File''s Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_extension":{"description":"Vertex file '
      + 'extension, without the leading '
      + 'dot","type":"string"}},"required":["file_extension"]}}}'
    );

    Example : (''
      + '{"vertex_file":{"file_uuid":"51534d95-d71f-4f36-ae1a-3e63a21fd1c7","fi'
      + 'le_extension":"vtx"}}'
    );
  );

// Details about the voxels contained in the file
const
  RDB_RIEGL_VOXEL_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.voxel_info';
    Title       : 'Voxel Information';
    Description : 'Details about the voxels contained in the file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Voxel '
      + 'Information","description":"Details about the voxels contained in the '
      + 'file","type":"object","oneOf":[{"properties":{"shape_thresholds":{"$re'
      + 'f":"#/definitions/shape_thresholds"},"size":{"description":"Size of '
      + 'voxels in file coordinate system.","oneOf":[{"$ref":"#/definitions/vox'
      + 'el_size"},{"$ref":"#/definitions/voxel_size_cubic"}]},"voxel_origin":{'
      + '"$ref":"#/definitions/voxel_origin_enum"},"voxel_type":{"$ref":"#/defi'
      + 'nitions/voxel_type"}},"additionalProperties":false,"required":["size",'
      + '"voxel_origin","voxel_type"]},{"properties":{"reference_point":{"items'
      + '":{"type":"number","minimum":-180,"maximum":180},"description":"Point '
      + 'in WGS84 geodetic decimal degree (EPSG:4326) that was used to compute '
      + 'the projection distortion parameters. The coefficient order is '
      + 'latitude, longitude. Only voxels with corresponding geo_tag, '
      + 'voxel_size and reference_point can be reliably processed together. '
      + 'This entry is available for voxel files in projected CRS only.","type"'
      + ':"array","minItems":2,"maxItems":2},"shape_thresholds":{"$ref":"#/defi'
      + 'nitions/shape_thresholds"},"size":{"$ref":"#/definitions/voxel_size","'
      + 'description":"Size of voxels in file coordinate system."},"size_llcs":'
      + '{"$ref":"#/definitions/voxel_size","description":"Size of voxels in a '
      + 'locally levelled cartesian coordinate system (xyz). This is only used '
      + 'for voxels based on a map projection."},"voxel_origin":{"oneOf":[{"$re'
      + 'f":"#/definitions/voxel_origin_enum"},{"description":"The base point '
      + 'of the voxel grid. Used together with <tt>voxel_size</tt> and '
      + '<tt>voxel_index</tt> to compute actual point coordinates.","$ref":"#/d'
      + 'efinitions/voxel_origin_point"}]},"voxel_type":{"$ref":"#/definitions/'
      + 'voxel_type"}},"additionalProperties":false,"required":["reference_poin'
      + 't","size_llcs","size","voxel_origin","voxel_type"]}],"definitions":{"e'
      + 'dge_length":{"description":"Length of voxel edge [m].","exclusiveMinim'
      + 'um":true,"type":"number","minimum":0},"shape_thresholds":{"description'
      + '":"Thresholds used to compute the voxel''s shape_id value.","required":'
      + '["plane","line"],"type":"object","properties":{"line":{"description":"'
      + 'If the biggest eigenvalue is bigger than the median eigenvalue * '
      + 'line_threshold, the voxel is considered a line.","exclusiveMinimum":tr'
      + 'ue,"type":"number","minimum":1},"plane":{"description":"If the '
      + 'smallest eigenvalue is smaller than the median eigenvalue * '
      + 'plane_threshold, the voxel is considered a plane.","maximum":1,"minimu'
      + 'm":0,"type":"number","exclusiveMinimum":true,"exclusiveMaximum":true}}'
      + '},"voxel_size":{"items":{"$ref":"#/definitions/edge_length"},"descript'
      + 'ion":"Size of voxels.","type":"array","minItems":3,"maxItems":3},"voxe'
      + 'l_size_cubic":{"$ref":"#/definitions/edge_length","type":"number"},"vo'
      + 'xel_origin_enum":{"description":"Defines whether the voxel''s center or'
      + ' a corner is placed on CRS origin <tt>(0/0/0)</tt>.","enum":["center",'
      + '"corner"],"default":"corner"},"voxel_origin_point":{"description":"Ori'
      + 'gin point for all voxel indices in voxel CRS.","items":{"type":"number'
      + '"},"type":"array","minItems":3,"maxItems":3},"voxel_type":{"descriptio'
      + 'n":"Whether a point in a voxel represents its center or its centroid. '
      + 'If type is <tt>index</tt> there is no point but only an integer voxel '
      + 'index.","enum":["center","centroid","index"],"default":"centroid"}}}'
    );

    Example : (''
      + '{"size":[0.5971642834779395,0.5971642834779395,0.5143705304787237],"si'
      + 'ze_llcs":[0.5156575252891171,0.5130835356683303,0.5143705304787237],"r'
      + 'eference_point":[48,16],"shape_thresholds":{"plane":0.16,"line":6},"vo'
      + 'xel_origin":"corner","voxel_type":"centroid"}'
    );
  );

// Settings for waveform averaging
const
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.waveform_averaging_settings';
    Title       : 'Waveform Averaging Settings';
    Description : 'Settings for waveform averaging';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Waveform'
      + ' Averaging Settings","description":"Settings for waveform averaging","'
      + 'type":"object","properties":{"num_shots":{"type":"integer","descriptio'
      + 'n":"Number of consecutive shots to be used for averaging.","minimum":1'
      + '},"mta_zone":{"type":"integer","description":"Fixed MTA zone for avera'
      + 'ging.","minimum":1},"trim":{"type":"number","description":"Percentage '
      + 'for robust averaging.","minimum":0,"maximum":0.5,"default":0}},"requir'
      + 'ed":["num_shots","mta_zone"]}'
    );

    Example : (''
      + '{"num_shots":7,"mta_zone":1,"trim":0.05}'
    );
  );

// Details about waveform files
const
  RDB_RIEGL_WAVEFORM_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.waveform_info';
    Title       : 'Waveform Information';
    Description : 'Details about waveform files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","type":"object","'
      + 'title":"Waveform Information","description":"Details about waveform fi'
      + 'les","required":["sample_block_file","sample_data_files"],"properties"'
      + ':{"sample_data_files":{"type":"array","items":{"type":"object","requir'
      + 'ed":["channel","channel_name","sample_interval","sample_bits","laser_w'
      + 'avelength","delta_st","file_extension"],"properties":{"channel":{"excl'
      + 'usiveMinimum":false,"type":"integer","minimum":0,"maximum":255,"descri'
      + 'ption":"Sample block channel number (255 = invalid)","exclusiveMaximum'
      + '":false},"file_extension":{"description":"Sample data file extension, '
      + 'without the leading '
      + 'dot","type":"string"},"file_uuid":{"description":"File''s Universally '
      + 'Unique Identifier (RFC '
      + '4122)","type":"string"},"sample_interval":{"description":"Sampling '
      + 'interval in seconds","type":"number","exclusiveMinimum":false,"minimum'
      + '":0},"channel_name":{"description":"Sample block channel name","type":'
      + '"string"},"sample_bits":{"exclusiveMinimum":false,"type":"integer","mi'
      + 'nimum":0,"maximum":32,"description":"Bitwidth of samples (e.g. 10 bit,'
      + ' 12 bit)","exclusiveMaximum":false},"laser_wavelength":{"description":'
      + '"Laser wavelength in meters (0 = unknown)","type":"number","exclusiveM'
      + 'inimum":false,"minimum":0},"delta_st":{"description":"reserved","type"'
      + ':"number"}}}},"sample_block_file":{"type":"object","required":["file_e'
      + 'xtension"],"properties":{"file_uuid":{"description":"File''s '
      + 'Universally Unique Identifier (RFC '
      + '4122)","type":"string"},"file_extension":{"description":"Sample block '
      + 'file extension, without the leading '
      + 'dot","type":"string"}}},"range_offset_m":{"description":"Calibrated '
      + 'device specific range offset for waveform analysis by system response '
      + 'fitting in meters.","type":"number"},"range_offset_waveform_samples_m"'
      + ':{"description":"Calibrated device specific range offset for waveform '
      + 'samples in meters.","type":"number"}}}'
    );

    Example : (''
      + '{"sample_block_file":{"file_uuid":"93a03615-66c0-4bea-8ff8-c577378fe66'
      + '0","file_extension":"sbx"},"sample_data_files":[{"channel":0,"channel_'
      + 'name":"high_power","sample_interval":1.00503e-09,"sample_bits":12,"las'
      + 'er_wavelength":0,"delta_st":0,"file_uuid":"da084413-e3e8-4655-a122-071'
      + 'de8490d8e","file_extension":"sp0"},{"channel":1,"channel_name":"low_po'
      + 'wer","sample_interval":1.00503e-09,"sample_bits":12,"laser_wavelength"'
      + ':0,"delta_st":0,"file_uuid":"93585b5e-5ea9-43a1-947b-e7ba3be642d2","fi'
      + 'le_extension":"sp1"},{"channel":5,"channel_name":"wwf","sample_interva'
      + 'l":1.00503e-09,"sample_bits":12,"laser_wavelength":0,"delta_st":0,"fil'
      + 'e_uuid":"9d2298c4-1036-464f-b5cb-1cf8e517f3a0","file_extension":"sp5"}'
      + '],"range_offset_m":3.1415,"range_offset_waveform_samples_m ":7.283}'
    );
  );

// Scanner settings for waveform output
const
  RDB_RIEGL_WAVEFORM_SETTINGS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.waveform_settings';
    Title       : 'Waveform Settings';
    Description : 'Scanner settings for waveform output';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Waveform'
      + ' Settings","description":"Scanner settings for waveform output","type"'
      + ':"array","items":{"type":"object","properties":{"sbl_name":{"descripti'
      + 'on":"Name of sample block, e.g.: wfm, '
      + 'wwf","type":"string"},"enabled":{"description":"Waveform output '
      + 'enabled","type":"boolean"},"smart_enabled":{"description":"Smart '
      + 'waveform output '
      + 'enabled","type":"boolean"},"pass_rng_less":{"description":"Threshold '
      + 'for range less than '
      + '[m]","type":"number"},"pass_rng_greater":{"description":"Threshold for'
      + ' range greater than '
      + '[m]","type":"number"},"pass_ampl_less":{"description":"Threshold for '
      + 'amplitude less than '
      + '[dB]","type":"number"},"pass_ampl_greater":{"description":"Threshold '
      + 'for amplitude greater than '
      + '[dB]","type":"number"},"pass_dev_less":{"description":"Threshold for '
      + 'deviation less than '
      + '[1]","type":"integer"},"pass_dev_greater":{"description":"Threshold '
      + 'for deviation greater than '
      + '[1]","type":"integer"},"logic_expression":{"description":"Logic '
      + 'expression of smart waveforms '
      + 'filter","type":"string"},"channel_idx_mask":{"description":"Bit mask '
      + 'for channels which belong to sbl_name: Channel 0 = Bit0, Channel 1 = '
      + 'Bit1, ...","type":"integer"}},"required":["sbl_name","enabled","channe'
      + 'l_idx_mask"]}}'
    );

    Example : (''
      + '[{"sbl_name":"wfm","enabled":true,"smart_enabled":true,"pass_rng_less"'
      + ':13.11,"pass_rng_greater":9.27,"pass_ampl_less":5.0,"pass_ampl_greater'
      + '":1.0,"channel_idx_mask":11},{"sbl_name":"wwf","enabled":false,"channe'
      + 'l_idx_mask":32}]'
    );
  );

// Window analysis data estimated from scandata and resulting filter parameters
const
  RDB_RIEGL_WINDOW_ANALYSIS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.window_analysis';
    Title       : 'Window Analysis';
    Description : 'Window analysis data estimated from scandata and resulting filter parameters';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Window '
      + 'Analysis","description":"Window analysis data estimated from scandata '
      + 'and resulting filter parameters","type":"object","properties":{"result'
      + '":{"type":"object","properties":{"angle":{"type":"array","items":{"typ'
      + 'e":"number"},"description":"[deg]"},"range_mean":{"type":"array","item'
      + 's":{"type":"number"},"description":"[m]"},"range_sigma":{"type":"array'
      + '","items":{"type":"number"},"description":"[m]"},"amplitude_mean":{"ty'
      + 'pe":"array","items":{"type":"number"},"description":"[dB]"},"amplitude'
      + '_sigma":{"type":"array","items":{"type":"number"},"description":"[dB]"'
      + '},"timestamp":{"type":"array","items":{"type":"number"},"description":'
      + '"[s]"},"amplitude_offset":{"type":"array","items":{"type":"number"},"d'
      + 'escription":"[dB]"}},"required":["angle","range_mean","range_sigma","a'
      + 'mplitude_mean","amplitude_sigma","amplitude_offset"]},"filter":{"type"'
      + ':"object","properties":{"angle":{"type":"array","items":{"type":"numbe'
      + 'r"},"description":"[deg]"},"range_min":{"type":"array","items":{"type"'
      + ':"number"},"description":"[m]"},"range_max":{"type":"array","items":{"'
      + 'type":"number"},"description":"[m]"},"amplitude_max":{"type":"array","'
      + 'items":{"type":"number"},"description":"[dB]"}},"required":["angle","r'
      + 'ange_min","range_max","amplitude_max"]},"settings":{"type":"object","p'
      + 'roperties":{"range":{"type":"object","properties":{"sigma_factor":{"ty'
      + 'pe":"number"},"additive_value":{"type":"number"}},"required":["sigma_f'
      + 'actor","additive_value"]},"amplitude":{"type":"object","properties":{"'
      + 'sigma_factor":{"type":"number"},"additive_value":{"type":"number"}},"r'
      + 'equired":["sigma_factor","additive_value"]}},"required":["range","ampl'
      + 'itude"]}},"required":["result","filter","settings"]}'
    );

    Example : (''
      + '{"result":{"angle":[14.9,15.0,15.1,15.2,15.3,15.4,15.5,15.6,15.7,15.8,'
      + '15.9],"range_mean":[0.1105621,0.1079564,0.1087088,0.1067261,0.1054582,'
      + '0.1090412,0.102871,0.1019044,0.1051523,0.1058445,0.1031261],"range_sig'
      + 'ma":[0.01869652,0.02151435,0.01747969,0.01918765,0.01945776,0.01934862'
      + ',0.01955329,0.02225589,0.02229977,0.01899122,0.02009433],"amplitude_me'
      + 'an":[5.347396,5.263155,5.224655,5.179926,5.097782,5.116479,5.051756,4.'
      + '983473,5.007885,5.002441,4.982],"amplitude_sigma":[0.4272844,0.4298479'
      + ',0.4236816,0.4283583,0.4362353,0.4315141,0.4373984,0.4472798,0.4346001'
      + ',0.4345487,0.4540681],"timestamp":[408.4441,411.4443],"amplitude_offse'
      + 't":[1.9,1.9]},"filter":{"angle":[14.9,15.0,15.1,15.2,15.3,15.4,15.5,15'
      + '.6,15.7,15.8,15.9],"range_min":[-0.208,-0.21,-0.212,-0.214,-0.216,-0.2'
      + '18,-0.219,-0.221,-0.223,-0.225,-0.227],"range_max":[0.424,0.425,0.426,'
      + '0.427,0.428,0.428,0.429,0.43,0.431,0.431,0.432],"amplitude_max":[8.04,'
      + '8.01,7.99,7.96,7.93,7.9,7.88,7.85,7.83,7.8,7.78]},"settings":{"range":'
      + '{"sigma_factor":8,"additive_value":0.1},"amplitude":{"sigma_factor":4,'
      + '"additive_value":1.0}}}'
    );
  );

// Correction parameters for window glass echoes
const
  RDB_RIEGL_WINDOW_ECHO_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.window_echo_correction';
    Title       : 'Window Echo Correction';
    Description : 'Correction parameters for window glass echoes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","title":"Window '
      + 'Echo Correction","description":"Correction parameters for window glass'
      + ' echoes","type":"object","properties":{"amplitude":{"type":"object","d'
      + 'escription":"Amplitude axis of correction '
      + 'table","properties":{"minimum":{"type":"number","description":"Minimum'
      + ' amplitude in '
      + 'dB","minimum":0.0},"maximum":{"type":"number","description":"Maximum '
      + 'amplitude in '
      + 'dB","minimum":0.0},"entries":{"type":"integer","description":"Number '
      + 'of amplitude entries","minimum":1}},"required":["minimum","maximum","e'
      + 'ntries"]},"range":{"type":"object","description":"Range axis of '
      + 'correction '
      + 'table","properties":{"minimum":{"type":"number","description":"Minimum'
      + ' range in m","minimum":-2.0,"maximum":2.0},"maximum":{"type":"number",'
      + '"description":"Maximum range in m","minimum":-2.0,"maximum":2.0},"entr'
      + 'ies":{"type":"integer","description":"Number of range entries","minimu'
      + 'm":1}},"required":["minimum","maximum","entries"]},"slices":{"type":"a'
      + 'rray","items":{"type":"object","description":"Window echo correction '
      + 'parameter slice","properties":{"amplitude":{"type":"number","descripti'
      + 'on":"Window echo amplitude of slice in '
      + 'dB"},"table":{"type":"array","description":"Correction table '
      + '(dimension defined by the ''amplitude'' and ''range'' '
      + 'objects)","items":{"type":"array","description":"Table row (= '
      + 'amplitude axis)","items":{"type":"array","description":"Table column '
      + '(= range axis)","items":{"description":"Table cell (item 0: amplitude '
      + 'in dB, 1: range in m, 2: flags)","type":"number"},"minItems":3,"maxIte'
      + 'ms":3},"minItems":1},"minItems":1}},"required":["amplitude","table"]}}'
      + '},"required":["amplitude","range","slices"]}'
    );

    Example : (''
      + '{"amplitude":{"minimum":2,"maximum":20,"entries":128},"range":{"minimu'
      + 'm":-1.5060822940732335,"maximum":1.5060822940732335,"entries":128},"sl'
      + 'ices":[{"amplitude":1.5,"table":[[[6.23,0.3535,1]],[[5.54,0.72375,1]]]'
      + '},{"amplitude":2.0,"table":[[[6.23,0.3535,1]],[[5.54,0.72375,1]]]}]}'
    );
  );

// Table of all meta data item details records
const
  RDB_META_DATA_ITEMS : array of PRDBPointcloudMetaDataItemInfo = nil; // filled during initialization

implementation

procedure FixStringEncoding;
begin
  // As the unit (.pas file) doesn't contain a BOM, we need to convert all strings
  // from UTF-8 to "native" encoding at runtime (tested on Delphi 7 and Delphi XE5)

  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Name)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Title)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Description)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Schema)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Example)));

  RDB_RIEGL_ATMOSPHERE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Name)));
  RDB_RIEGL_ATMOSPHERE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Title)));
  RDB_RIEGL_ATMOSPHERE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Description)));
  RDB_RIEGL_ATMOSPHERE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Schema)));
  RDB_RIEGL_ATMOSPHERE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Example)));

  RDB_RIEGL_BEAM_GEOMETRY.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Name)));
  RDB_RIEGL_BEAM_GEOMETRY.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Title)));
  RDB_RIEGL_BEAM_GEOMETRY.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Description)));
  RDB_RIEGL_BEAM_GEOMETRY.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Schema)));
  RDB_RIEGL_BEAM_GEOMETRY.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Example)));

  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Name)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Title)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Description)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Schema)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Example)));

  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Name)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Title)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Description)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Schema)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Example)));

  RDB_RIEGL_DETECTION_PROBABILITY.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Name)));
  RDB_RIEGL_DETECTION_PROBABILITY.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Title)));
  RDB_RIEGL_DETECTION_PROBABILITY.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Description)));
  RDB_RIEGL_DETECTION_PROBABILITY.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Schema)));
  RDB_RIEGL_DETECTION_PROBABILITY.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Example)));

  RDB_RIEGL_DEVICE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Name)));
  RDB_RIEGL_DEVICE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Title)));
  RDB_RIEGL_DEVICE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Description)));
  RDB_RIEGL_DEVICE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Schema)));
  RDB_RIEGL_DEVICE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Example)));

  RDB_RIEGL_DEVICE_GEOMETRY.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Name)));
  RDB_RIEGL_DEVICE_GEOMETRY.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Title)));
  RDB_RIEGL_DEVICE_GEOMETRY.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Description)));
  RDB_RIEGL_DEVICE_GEOMETRY.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Schema)));
  RDB_RIEGL_DEVICE_GEOMETRY.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Example)));

  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Name)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Title)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Description)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Schema)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Example)));

  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Name)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Title)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Description)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Schema)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Example)));

  RDB_RIEGL_DEVICES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Name)));
  RDB_RIEGL_DEVICES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Title)));
  RDB_RIEGL_DEVICES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Description)));
  RDB_RIEGL_DEVICES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Schema)));
  RDB_RIEGL_DEVICES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Example)));

  RDB_RIEGL_DMI_CONFIG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Name)));
  RDB_RIEGL_DMI_CONFIG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Title)));
  RDB_RIEGL_DMI_CONFIG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Description)));
  RDB_RIEGL_DMI_CONFIG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Schema)));
  RDB_RIEGL_DMI_CONFIG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Example)));

  RDB_RIEGL_DYNTRIG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Name)));
  RDB_RIEGL_DYNTRIG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Title)));
  RDB_RIEGL_DYNTRIG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Description)));
  RDB_RIEGL_DYNTRIG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Schema)));
  RDB_RIEGL_DYNTRIG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Example)));

  RDB_RIEGL_ECHO_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Name)));
  RDB_RIEGL_ECHO_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Title)));
  RDB_RIEGL_ECHO_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Description)));
  RDB_RIEGL_ECHO_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Schema)));
  RDB_RIEGL_ECHO_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Example)));

  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Name)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Title)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Description)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Schema)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Example)));

  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Name)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Title)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Description)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Schema)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Example)));

  RDB_RIEGL_GEO_TAG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Name)));
  RDB_RIEGL_GEO_TAG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Title)));
  RDB_RIEGL_GEO_TAG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Description)));
  RDB_RIEGL_GEO_TAG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Schema)));
  RDB_RIEGL_GEO_TAG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Example)));

  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Name)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Title)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Description)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Schema)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Example)));

  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Name)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Title)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Description)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Schema)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Example)));

  RDB_RIEGL_GNSS_PROCESSING_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Name)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Title)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Description)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Schema)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Example)));

  RDB_RIEGL_ITEM_NAMES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Name)));
  RDB_RIEGL_ITEM_NAMES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Title)));
  RDB_RIEGL_ITEM_NAMES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Description)));
  RDB_RIEGL_ITEM_NAMES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Schema)));
  RDB_RIEGL_ITEM_NAMES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Example)));

  RDB_RIEGL_LAG_ANGLE_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Name)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Title)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Description)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Schema)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Example)));

  RDB_RIEGL_LICENSES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Name)));
  RDB_RIEGL_LICENSES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Title)));
  RDB_RIEGL_LICENSES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Description)));
  RDB_RIEGL_LICENSES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Schema)));
  RDB_RIEGL_LICENSES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Example)));

  RDB_RIEGL_MTA_SETTINGS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Name)));
  RDB_RIEGL_MTA_SETTINGS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Title)));
  RDB_RIEGL_MTA_SETTINGS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Description)));
  RDB_RIEGL_MTA_SETTINGS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Schema)));
  RDB_RIEGL_MTA_SETTINGS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Example)));

  RDB_RIEGL_NEAR_RANGE_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Name)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Title)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Description)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Schema)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Example)));

  RDB_RIEGL_NOISE_ESTIMATES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Name)));
  RDB_RIEGL_NOISE_ESTIMATES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Title)));
  RDB_RIEGL_NOISE_ESTIMATES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Description)));
  RDB_RIEGL_NOISE_ESTIMATES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Schema)));
  RDB_RIEGL_NOISE_ESTIMATES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Example)));

  RDB_RIEGL_NOTCH_FILTER.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Name)));
  RDB_RIEGL_NOTCH_FILTER.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Title)));
  RDB_RIEGL_NOTCH_FILTER.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Description)));
  RDB_RIEGL_NOTCH_FILTER.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Schema)));
  RDB_RIEGL_NOTCH_FILTER.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Example)));

  RDB_RIEGL_PIXEL_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Name)));
  RDB_RIEGL_PIXEL_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Title)));
  RDB_RIEGL_PIXEL_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Description)));
  RDB_RIEGL_PIXEL_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Schema)));
  RDB_RIEGL_PIXEL_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Example)));

  RDB_RIEGL_PLANE_PATCH_MATCHING.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Name)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Title)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Description)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Schema)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Example)));

  RDB_RIEGL_PLANE_PATCH_STATISTICS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Name)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Title)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Description)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Schema)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Example)));

  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Name)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Title)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Description)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Schema)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Example)));

  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Name)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Title)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Description)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Schema)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Example)));

  RDB_RIEGL_POINTCLOUD_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Name)));
  RDB_RIEGL_POINTCLOUD_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Title)));
  RDB_RIEGL_POINTCLOUD_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Description)));
  RDB_RIEGL_POINTCLOUD_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Schema)));
  RDB_RIEGL_POINTCLOUD_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Example)));

  RDB_RIEGL_POSE_ESTIMATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Name)));
  RDB_RIEGL_POSE_ESTIMATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Title)));
  RDB_RIEGL_POSE_ESTIMATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Description)));
  RDB_RIEGL_POSE_ESTIMATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Schema)));
  RDB_RIEGL_POSE_ESTIMATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Example)));

  RDB_RIEGL_POSE_SENSORS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Name)));
  RDB_RIEGL_POSE_SENSORS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Title)));
  RDB_RIEGL_POSE_SENSORS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Description)));
  RDB_RIEGL_POSE_SENSORS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Schema)));
  RDB_RIEGL_POSE_SENSORS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Example)));

  RDB_RIEGL_PULSE_POSITION_MODULATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Name)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Title)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Description)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Schema)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Example)));

  RDB_RIEGL_RANGE_STATISTICS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Name)));
  RDB_RIEGL_RANGE_STATISTICS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Title)));
  RDB_RIEGL_RANGE_STATISTICS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Description)));
  RDB_RIEGL_RANGE_STATISTICS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Schema)));
  RDB_RIEGL_RANGE_STATISTICS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Example)));

  RDB_RIEGL_RECEIVER_INTERNALS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Name)));
  RDB_RIEGL_RECEIVER_INTERNALS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Title)));
  RDB_RIEGL_RECEIVER_INTERNALS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Description)));
  RDB_RIEGL_RECEIVER_INTERNALS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Schema)));
  RDB_RIEGL_RECEIVER_INTERNALS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Example)));

  RDB_RIEGL_REFLECTANCE_CALCULATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Name)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Title)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Description)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Schema)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Example)));

  RDB_RIEGL_REFLECTANCE_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Name)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Title)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Description)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Schema)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Example)));

  RDB_RIEGL_RILOC_PROCESSING_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Name)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Title)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Description)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Schema)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Example)));

  RDB_RIEGL_SCAN_PATTERN.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Name)));
  RDB_RIEGL_SCAN_PATTERN.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Title)));
  RDB_RIEGL_SCAN_PATTERN.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Description)));
  RDB_RIEGL_SCAN_PATTERN.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Schema)));
  RDB_RIEGL_SCAN_PATTERN.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Example)));

  RDB_RIEGL_SHOT_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Name)));
  RDB_RIEGL_SHOT_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Title)));
  RDB_RIEGL_SHOT_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Description)));
  RDB_RIEGL_SHOT_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Schema)));
  RDB_RIEGL_SHOT_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Example)));

  RDB_RIEGL_STORED_FILTERS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Name)));
  RDB_RIEGL_STORED_FILTERS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Title)));
  RDB_RIEGL_STORED_FILTERS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Description)));
  RDB_RIEGL_STORED_FILTERS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Schema)));
  RDB_RIEGL_STORED_FILTERS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Example)));

  RDB_RIEGL_SYSTEM_DESCRIPTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Name)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Title)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Description)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Schema)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Example)));

  RDB_RIEGL_TEMPERATURE_CALCULATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Name)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Title)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Description)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Schema)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Example)));

  RDB_RIEGL_TIME_BASE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Name)));
  RDB_RIEGL_TIME_BASE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Title)));
  RDB_RIEGL_TIME_BASE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Description)));
  RDB_RIEGL_TIME_BASE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Schema)));
  RDB_RIEGL_TIME_BASE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Example)));

  RDB_RIEGL_TRAJECTORY_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Name)));
  RDB_RIEGL_TRAJECTORY_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Title)));
  RDB_RIEGL_TRAJECTORY_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Description)));
  RDB_RIEGL_TRAJECTORY_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Schema)));
  RDB_RIEGL_TRAJECTORY_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Example)));

  RDB_RIEGL_TTIP_CONFIGURATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Name)));
  RDB_RIEGL_TTIP_CONFIGURATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Title)));
  RDB_RIEGL_TTIP_CONFIGURATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Description)));
  RDB_RIEGL_TTIP_CONFIGURATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Schema)));
  RDB_RIEGL_TTIP_CONFIGURATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Example)));

  RDB_RIEGL_VERTEX_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Name)));
  RDB_RIEGL_VERTEX_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Title)));
  RDB_RIEGL_VERTEX_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Description)));
  RDB_RIEGL_VERTEX_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Schema)));
  RDB_RIEGL_VERTEX_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Example)));

  RDB_RIEGL_VOXEL_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Name)));
  RDB_RIEGL_VOXEL_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Title)));
  RDB_RIEGL_VOXEL_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Description)));
  RDB_RIEGL_VOXEL_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Schema)));
  RDB_RIEGL_VOXEL_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Example)));

  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Name)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Title)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Description)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Schema)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Example)));

  RDB_RIEGL_WAVEFORM_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Name)));
  RDB_RIEGL_WAVEFORM_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Title)));
  RDB_RIEGL_WAVEFORM_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Description)));
  RDB_RIEGL_WAVEFORM_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Schema)));
  RDB_RIEGL_WAVEFORM_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Example)));

  RDB_RIEGL_WAVEFORM_SETTINGS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Name)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Title)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Description)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Schema)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Example)));

  RDB_RIEGL_WINDOW_ANALYSIS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Name)));
  RDB_RIEGL_WINDOW_ANALYSIS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Title)));
  RDB_RIEGL_WINDOW_ANALYSIS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Description)));
  RDB_RIEGL_WINDOW_ANALYSIS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Schema)));
  RDB_RIEGL_WINDOW_ANALYSIS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Example)));

  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Name)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Title)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Description)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Schema)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Example)));
end;

procedure FillMetadataArray;
var
  i : Integer;
begin
  SetLength(RDB_META_DATA_ITEMS, 56); i := -1;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ANGULAR_NOTCH_FILTER;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ATMOSPHERE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_BEAM_GEOMETRY;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_CONTROL_OBJECT_CATALOG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DETECTION_PROBABILITY;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE_GEOMETRY;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE_OUTPUT_LIMITS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DMI_CONFIG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DYNTRIG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ECHO_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_EXPONENTIAL_DECOMPOSITION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GAUSSIAN_DECOMPOSITION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GEO_TAG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GEOMETRIC_SCALE_FACTOR;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GEOREFERENCING_PARAMETERS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GNSS_PROCESSING_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ITEM_NAMES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_LAG_ANGLE_CORRECTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_LICENSES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_MTA_SETTINGS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_NEAR_RANGE_CORRECTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_NOISE_ESTIMATES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_NOTCH_FILTER;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PIXEL_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PLANE_PATCH_MATCHING;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PLANE_PATCH_STATISTICS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PLANE_SLOPE_CLASS_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POINT_ATTRIBUTE_GROUPS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POINTCLOUD_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POSE_ESTIMATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POSE_SENSORS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PULSE_POSITION_MODULATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_RANGE_STATISTICS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_RECEIVER_INTERNALS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_REFLECTANCE_CALCULATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_REFLECTANCE_CORRECTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_RILOC_PROCESSING_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_SCAN_PATTERN;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_SHOT_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_STORED_FILTERS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_SYSTEM_DESCRIPTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TEMPERATURE_CALCULATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TIME_BASE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TRAJECTORY_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TTIP_CONFIGURATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_VERTEX_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_VOXEL_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WAVEFORM_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WAVEFORM_SETTINGS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WINDOW_ANALYSIS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WINDOW_ECHO_CORRECTION;
end;

initialization

FixStringEncoding;
FillMetadataArray;

end.
