{*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *}
{*!
 *******************************************************************************
 *
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Description of RIEGL RDB 2 database meta data items.
 * \version 2015-10-27/AW: Initial version
 * \version 2015-11-25/AW: Item "Geo Tag" added
 * \version 2016-10-27/AW: Item "Voxel Information" added
 * \version 2016-11-17/AW: Item "Voxel Information" updated
 * \version 2016-12-12/AW: Item "Range Statistics" added
 * \version 2017-03-08/AW: Item "Plane Patch Statistics" added
 * \version 2017-04-05/AW: Items "Atmosphere" and "Geometric Scale Factor" added
 * \version 2017-08-22/AW: Items for waveform sample block and value files added
 * \version 2017-10-24/AW: Item "Gaussian Decomposition" added
 * \version 2017-11-13/AW: Item "riegl.scan_pattern" updated
 * \version 2017-11-21/AW: Item "riegl.trajectory_info" added
 * \version 2018-01-11/AW: Item "riegl.beam_geometry" added
 * \version 2018-01-15/AW: Item "riegl.reflectance_calculation" added
 * \version 2018-01-15/AW: Item "riegl.near_range_correction" added
 * \version 2018-01-15/AW: Item "riegl.device_geometry" added
 * \version 2018-02-13/AW: Item "riegl.notch_filter" added
 * \version 2018-03-08/AW: Item "riegl.window_echo_correction" added
 * \version 2018-03-15/AW: Item "riegl.pulse_position_modulation" added
 * \version 2018-05-24/AW: Item "riegl.pixel_info" added
 * \version 2018-06-08/AW: Item "riegl.shot_info" added
 * \version 2018-06-08/AW: Item "riegl.echo_info" added
 * \version 2018-06-14/AW: Item "riegl.mta_settings" added
 * \version 2018-06-14/AW: Item "riegl.receiver_internals" added
 * \version 2018-06-14/AW: Item "riegl.device_output_limits" added
 * \version 2018-06-26/AW: Schema: replace "number" with "integer" if applicable
 * \version 2018-07-09/AW: Item "riegl.pose_estimation" added
 * \version 2018-07-09/AW: Item "riegl.pose_sensors" added
 * \version 2018-09-20/AW: Item "riegl.pointcloud_info" added
 * \version 2018-11-08/AW: Item "riegl.scan_pattern" updated
 * \version 2018-11-13/AW: Item "riegl.receiver_internals" updated
 * \version 2019-03-06/AW: Item "riegl.receiver_internals" updated
 * \version 2019-03-21/AW: Item "riegl.device_geometry" updated
 * \version 2019-04-15/AW: Item "riegl.point_attribute_groups" added
 * \version 2019-04-30/AW: Item "riegl.waveform_settings" added
 * \version 2019-10-03/AW: Item "riegl.angular_notch_filter" added
 * \version 2019-10-03/AW: Item "riegl.noise_estimates" added
 * \version 2019-10-25/AW: Item "riegl.window_analysis" added
 * \version 2019-11-06/AW: Item "riegl.georeferencing_parameters" added
 * \version 2019-11-27/AW: Item "riegl.plane_patch_matching" added
 * \version 2019-12-13/AW: Items for tie-/control objects added
 * \version 2019-12-19/AW: Items for tie-/control objects added
 * \version 2020-02-04/AW: Item "riegl.detection_probability" added
 * \version 2020-02-04/AW: Item "riegl.licenses" added
 * \version 2020-04-27/AW: Item "riegl.waveform_info" updated (schema+example)
 * \version 2020-09-03/AW: Item "riegl.reflectance_correction" added
 * \version 2020-09-10/AW: Item "riegl.device_geometry_passive_channel" added
 * \version 2020-09-25/AW: Item "riegl.georeferencing_parameters" updated
 * \version 2020-09-25/AW: Item "riegl.trajectory_info" updated
 * \version 2020-09-29/AW: Item "riegl.temperature_calculation" added
 * \version 2020-10-23/AW: Item "riegl.exponential_decomposition" added (#3709)
 * \version 2020-11-30/AW: Item "riegl.notch_filter" updated (schema)
 * \version 2020-12-02/AW: Item "riegl.georeferencing_parameters" updated (schema)
 * \version 2021-02-02/AW: Item "riegl.plane_slope_class_info" added (rdbplanes/#7)
 * \version 2021-02-16/AW: Item "riegl.device_output_limits" updated (schema, #3811)
 * \version 2021-03-03/AW: Item "riegl.exponential_decomposition" updated (schema, #3822)
 * \version 2021-03-03/AW: Item "riegl.waveform_averaging_settings" added (#3821)
 * \version 2021-04-01/AW: Item "riegl.voxel_info" updated (schema, #3854)
 * \version 2021-04-16/AW: Item "riegl.voxel_info" updated (schema, #3866)
 * \version 2021-09-30/AW: Item "riegl.waveform_info" updated (schema+example, #4016)
 * \version 2021-10-04/AW: Improved spelling of the descriptions of some items
 * \version 2021-11-04/AW: Rename "riegl.record_names" to "riegl.item_names" (#4034)
 * \version 2022-03-11/AW: Item "riegl.devices" added (#4162)
 * \version 2022-03-14/AW: Item "riegl.stored_filters" added (#4164)
 * \version 2022-09-20/AW: Fix typos in schema of "riegl.georeferencing_parameters"
 * \version 2022-09-30/AW: Item "riegl.system_description" added (#4368)
 * \version 2022-10-10/AW: Correction of typos in the titles of some entries
 * \version 2022-10-20/AW: Item "riegl.stored_filters" updated (example, #4164)
 * \version 2023-01-19/AW: Item "riegl.ttip_configuration" added (#4449)
 * \version 2024-09-26/AW: Item "riegl.dyntrig" added (#5310)
 * \version 2025-03-21/AW: Item "riegl.dmi_config" added (#5571)
 * \version 2025-07-01/AW: Item "riegl.gnss_processing_info" added (#5777)
 * \version 2025-07-01/AW: Item "riegl.riloc_processing_info" added (#5777)
 * \version 2025-11-11/AW: Item "riegl.lag_angle_correction" added (#6068)
 *
 *******************************************************************************
 *}

unit riegl.rdb.default.metadata;

{$WRITEABLECONST ON} // see section "initialization"

interface

// Meta data items definition version
const
  RDB_META_DATA_ITEMS_VERSION = '1.1.57';
  RDB_META_DATA_ITEMS_DATE = '2025-11-11';

// Meta data item states
const
  RDB_STATUS_REQUIRED = 1; // mandatory item
  RDB_STATUS_OPTIONAL = 2; // optional item

// Container record for meta data item details
type
  TRDBPointcloudMetaDataItemInfo = record
    Name        : System.String;
    Title       : System.String;
    Description : System.String;
    Status      : System.Byte;
    Schema      : System.String;
    Example     : System.String;
  end;
  PRDBPointcloudMetaDataItemInfo = ^TRDBPointcloudMetaDataItemInfo;

// Angular notch filter parameters for window glass echoes
const
  RDB_RIEGL_ANGULAR_NOTCH_FILTER : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.angular_notch_filter';
    Title       : 'Angular Notch Filter';
    Description : 'Angular notch filter parameters for window glass echoes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["angle","range_mean","amplitude_mean"],"type":"object","d'
      + 'escription":"Angular notch filter parameters for window glass '
      + 'echoes","title":"Angular Notch Filter","properties":{"amplitude_mean":'
      + '{"type":"array","description":"Mean amplitude [dB]","items":{"type":"n'
      + 'umber"}},"range_mean":{"type":"array","description":"Mean range [m]","'
      + 'items":{"type":"number"}},"angle":{"type":"array","description":"Angle'
      + ' [deg]","items":{"type":"number"}}},"$schema":"http://json-schema.org/'
      + 'draft-04/schema#"}'
    );

    Example : (''
      + '{"amplitude_mean":[3.780913,3.780913,3.480913,3.120913,2.850913,2.7209'
      + '13,2.680913,2.610913,2.530913,2.570913,2.570913],"range_mean":[0.094,0'
      + '.094,0.09075,0.08675,0.0815,0.0775,0.074,0.071,0.068,0.0675,0.06475],"'
      + 'angle":[14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,22.0,23.0,24.0]}'
    );
  );

// Atmospheric parameters
const
  RDB_RIEGL_ATMOSPHERE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.atmosphere';
    Title       : 'Atmosphere';
    Description : 'Atmospheric parameters';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["temperature","pressure","rel_humidity","pressure_sl","am'
      + 'sl","group_velocity","attenuation","wavelength"],"type":"object","desc'
      + 'ription":"Atmospheric parameters","title":"Atmospheric Parameters","pr'
      + 'operties":{"pressure_sl":{"type":"number","description":"Atmospheric '
      + 'pressure at sea level '
      + '[mbar]"},"amsl":{"type":"number","description":"Height above mean sea '
      + 'level (AMSL) '
      + '[m]"},"attenuation":{"type":"number","description":"Atmospheric '
      + 'attenuation '
      + '[1/km]"},"group_velocity":{"type":"number","description":"Group '
      + 'velocity of laser beam '
      + '[m/s]"},"wavelength":{"type":"number","description":"Laser wavelength '
      + '[nm]"},"pressure":{"type":"number","description":"Pressure along '
      + 'measurment path '
      + '[mbar]"},"rel_humidity":{"type":"number","description":"Relative '
      + 'humidity along measurement path '
      + '[%]"},"temperature":{"type":"number","description":"Temperature along '
      + 'measurement path '
      + '[\u00b0C]"}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"pressure_sl":970,"amsl":0,"attenuation":0.028125,"group_velocity":29'
      + '9711000.0,"wavelength":1550,"pressure":970,"rel_humidity":63,"temperat'
      + 'ure":7}'
    );
  );

// Laser beam geometry details
const
  RDB_RIEGL_BEAM_GEOMETRY : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.beam_geometry';
    Title       : 'Beam Geometry';
    Description : 'Laser beam geometry details';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["beam_exit_diameter","beam_divergence"],"type":"object","'
      + 'description":"Laser beam geometry details","title":"Beam Geometry","pr'
      + 'operties":{"beam_divergence":{"type":"number","description":"Beam '
      + 'divergence in far field [rad]","minimum":0,"exclusiveMinimum":false},"'
      + 'beam_exit_diameter":{"type":"number","description":"Beam width at exit'
      + ' aperture [m]","minimum":0,"exclusiveMinimum":false}},"$schema":"http:'
      + '//json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"beam_divergence":0.0003,"beam_exit_diameter":0.0072}'
    );
  );

// List of control object type definitions
const
  RDB_RIEGL_CONTROL_OBJECT_CATALOG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.control_object_catalog';
    Title       : 'Control Object Catalog';
    Description : 'List of control object type definitions';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["types"],"type":"object","description":"List of control '
      + 'object type definitions","properties":{"types":{"type":"array","items"'
      + ':{"oneOf":[{"$ref":"#/definitions/rectangle"},{"$ref":"#/definitions/c'
      + 'heckerboard2x2"},{"$ref":"#/definitions/chevron"},{"$ref":"#/definitio'
      + 'ns/circular_disk"},{"$ref":"#/definitions/cylinder"},{"$ref":"#/defini'
      + 'tions/sphere"},{"$ref":"#/definitions/round_corner_cube_prism"}],"type'
      + '":"object"},"uniqueItems":true}},"title":"Control Object Catalog","def'
      + 'initions":{"round_corner_cube_prism":{"type":"object","description":"r'
      + 'ound corner cube prism","allOf":[{"$ref":"#/definitions/common"},{"req'
      + 'uired":["shape","diameter"],"type":"object","description":"round '
      + 'corner cube prism specific properties","properties":{"shape":{"type":"'
      + 'string","description":"shape identifier","enum":["round_corner_cube_pr'
      + 'ism"]},"diameter":{"type":"number","description":"diameter in meters",'
      + '"minimum":0,"exclusiveMinimum":true},"offset":{"type":"number","descri'
      + 'ption":"offset in meters, e.g. reflector constant (optional)"}}}]},"co'
      + 'mmon":{"required":["name","shape"],"type":"object","description":"comm'
      + 'on object properties","properties":{"name":{"type":"string","descripti'
      + 'on":"unique type identifier","minLength":3},"description":{"type":"str'
      + 'ing","description":"string describing the '
      + 'object"},"surface_type":{"type":"string","description":"surface '
      + 'material type","enum":["retro_reflective_foil","diffuse"]},"shape":{"t'
      + 'ype":"string","description":"shape identifier","enum":["rectangle","ch'
      + 'eckerboard2x2","chevron","circular_disk","cylinder","sphere","round_co'
      + 'rner_cube_prism"]}}},"sphere":{"type":"object","description":"sphere",'
      + '"allOf":[{"$ref":"#/definitions/common"},{"required":["shape","diamete'
      + 'r"],"type":"object","description":"sphere specific properties","proper'
      + 'ties":{"shape":{"type":"string","description":"shape identifier","enum'
      + '":["sphere"]},"diameter":{"type":"number","description":"diameter in m'
      + 'eters","minimum":0,"exclusiveMinimum":true}}}]},"checkerboard2x2":{"ty'
      + 'pe":"object","description":"checkerboard 2 by 2","allOf":[{"$ref":"#/d'
      + 'efinitions/common"},{"required":["shape","square_length"],"type":"obje'
      + 'ct","description":"checkerboard specific properties","properties":{"sh'
      + 'ape":{"type":"string","description":"shape identifier","enum":["checke'
      + 'rboard2x2"]},"square_length":{"type":"number","description":"length of'
      + ' a square of the checkerboard in meters","minimum":0,"exclusiveMinimum'
      + '":true}}}]},"circular_disk":{"type":"object","description":"circular d'
      + 'isk","allOf":[{"$ref":"#/definitions/common"},{"required":["shape","di'
      + 'ameter"],"type":"object","description":"circular disk specific propert'
      + 'ies","properties":{"shape":{"type":"string","description":"shape ident'
      + 'ifier","enum":["circular_disk"]},"diameter":{"type":"number","descript'
      + 'ion":"diameter in meters","minimum":0,"exclusiveMinimum":true},"offset'
      + '":{"type":"number","description":"offset in meters, e.g. reflector '
      + 'constant (optional)"}}}]},"chevron":{"type":"object","description":"ch'
      + 'evron","allOf":[{"$ref":"#/definitions/common"},{"required":["shape","'
      + 'outside_edge_length","thickness"],"type":"object","description":"chevr'
      + 'on specific properties","properties":{"shape":{"type":"string","descri'
      + 'ption":"shape identifier","enum":["chevron"]},"thickness":{"type":"num'
      + 'ber","description":"thickness in meters","minimum":0,"exclusiveMinimum'
      + '":true},"outside_edge_length":{"type":"number","description":"length '
      + 'of the two outer edges in meters","minimum":0,"exclusiveMinimum":true}'
      + '}}]},"cylinder":{"type":"object","description":"cylinder","allOf":[{"$'
      + 'ref":"#/definitions/common"},{"required":["shape","diameter","height"]'
      + ',"type":"object","description":"cylinder specific properties","propert'
      + 'ies":{"shape":{"type":"string","description":"shape identifier","enum"'
      + ':["cylinder"]},"diameter":{"type":"number","description":"diameter in '
      + 'meters","minimum":0,"exclusiveMinimum":true},"height":{"type":"number"'
      + ',"description":"height in meters","minimum":0,"exclusiveMinimum":true}'
      + '}}]},"rectangle":{"type":"object","description":"rectangle","allOf":[{'
      + '"$ref":"#/definitions/common"},{"required":["shape","length","width"],'
      + '"type":"object","description":"rectangle specific properties","propert'
      + 'ies":{"shape":{"type":"string","enum":["rectangle"]},"width":{"type":"'
      + 'number","description":"width in meters","minimum":0,"exclusiveMinimum"'
      + ':true},"length":{"type":"number","description":"length in meters","min'
      + 'imum":0,"exclusiveMinimum":true}}}]}},"$schema":"http://json-schema.or'
      + 'g/draft-04/schema#"}'
    );

    Example : (''
      + '{"types":[{"name":"Rectangle '
      + '60x30","length":0.6,"description":"Rectangle (60cm x '
      + '30cm)","width":0.3,"shape":"rectangle"},{"name":"Rectangle '
      + '80x40","length":0.8,"description":"Rectangle (80cm x '
      + '40cm)","width":0.4,"shape":"rectangle"},{"name":"Checkerboard2x2 '
      + '30","description":"Checkerboard (square length: 30cm)","shape":"checke'
      + 'rboard2x2","square_length":0.3},{"name":"Checkerboard2x2 '
      + '50","description":"Checkerboard (square length: '
      + '50cm)","shape":"checkerboard2x2","square_length":0.5},{"name":"Chevron'
      + ' 24''''/4''''","description":"Chevron (a=24''''; b=4'''')","thickness":0.1016,'
      + '"shape":"chevron","outside_edge_length":0.6096},{"name":"Circular Disk'
      + ' 50","description":" Circular Disk (diameter: 50cm)","diameter":0.5,"s'
      + 'urface_type":"diffuse","shape":"circular_disk"},{"name":"RIEGL flat '
      + 'reflector 50 mm","description":"flat circular reflector from '
      + 'retro-reflective foil","diameter":0.05,"surface_type":"retro_reflectiv'
      + 'e_foil","offset":0.0,"shape":"circular_disk"},{"name":"RIEGL flat '
      + 'reflector 100 mm","description":"flat circular reflector from '
      + 'retro-reflective foil","diameter":0.1,"surface_type":"retro_reflective'
      + '_foil","offset":0.0,"shape":"circular_disk"},{"name":"RIEGL flat '
      + 'reflector 150 mm","description":"flat circular reflector from '
      + 'retro-reflective foil","diameter":0.15,"surface_type":"retro_reflectiv'
      + 'e_foil","offset":0.0,"shape":"circular_disk"},{"name":"RIEGL '
      + 'cylindrical reflector 50 mm","description":"cylindrical reflector from'
      + ' retro-reflective foil","diameter":0.05,"surface_type":"retro_reflecti'
      + 've_foil","height":0.05,"shape":"cylinder"},{"name":"RIEGL cylindrical '
      + 'reflector 100 mm","description":"cylindrical reflector from '
      + 'retro-reflective foil","diameter":0.1,"surface_type":"retro_reflective'
      + '_foil","height":0.1,"shape":"cylinder"},{"name":"Sphere 200 '
      + 'mm","description":"Sphere (diameter: 200 '
      + 'mm)","diameter":0.2,"shape":"sphere"},{"name":"Corner Cube Prism 50 '
      + 'mm","description":"round corner cube prism","diameter":0.05,"shape":"r'
      + 'ound_corner_cube_prism","offset":0.0}],"comments":["This file contains'
      + ' a list of control object types (aka. ''catalog'').","Each type is '
      + 'described by an object,","which must contain at least the following '
      + 'parameters:","  - name: unique identifier of the type","  - shape: one'
      + ' of the following supported shapes:","      - rectangle","      - '
      + 'checkerboard2x2","      - chevron","      - circular_disk","      - '
      + 'cylinder","      - sphere","      - '
      + 'round_corner_cube_prism","Depending on ''shape'', the following '
      + 'parameters must/may be specified:","  - rectangle:","      - length: '
      + 'length in meters","      - width: width in meters","  - '
      + 'checkerboard2x2:","      - square_length: length of a square of the '
      + 'checkerboard in meters","  - circular_disk:","      - diameter: '
      + 'diameter in meters","      - offset: offset in meters, e.g. reflector '
      + 'constant (optional)","  - chevron:","      - outside_edge_length: '
      + 'length of the two outer edges in meters","      - thickness: thickness'
      + ' in meters","  - cylinder:","      - diameter: diameter in meters","'
      + '      - height: height in meters","  - sphere:","      - diameter: '
      + 'diameter in meters","  - round_corner_cube_prism:","      - diameter: '
      + 'diameter in meters","      - offset: offset in meters, e.g. reflector '
      + 'constant (optional)","Optional parameters:","    - description: string'
      + ' describing the object","    - surface_type: surface material type '
      + '(either ''retro_reflective_foil'' or ''diffuse'')"]}'
    );
  );

// Details about the control object reference file
const
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.control_object_reference_file';
    Title       : 'Control Object Reference file';
    Description : 'Details about the control object reference file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"De'
      + 'tails about the control object reference file","properties":{"referenc'
      + 'e_file":{"required":["file_uuid","file_path"],"type":"object","descrip'
      + 'tion":"Reference to a control object file","properties":{"file_uuid":{'
      + '"type":"string","description":"Control object file''s Universally '
      + 'Unique Identifier (RFC '
      + '4122)"},"file_path":{"type":"string","description":"Path of the '
      + 'control object file relative to referring file"}}}},"title":"Control '
      + 'Object Reference file","type":"object"}'
    );

    Example : (''
      + '{"reference_file":{"file_uuid":"810f5d57-eccf-49ed-b07a-0cdd109b4213",'
      + '"file_path":"../../../10_CONTROL_OBJECTS/ControlPoints.cpx"}}'
    );
  );

// Detection probability as a function of amplitude
const
  RDB_RIEGL_DETECTION_PROBABILITY : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.detection_probability';
    Title       : 'Detection Probability';
    Description : 'Detection probability as a function of amplitude';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["amplitude","detection_probability"],"type":"object","des'
      + 'cription":"Detection probability as a function of '
      + 'amplitude","title":"Detection Probability","properties":{"detection_pr'
      + 'obability":{"type":"array","description":"Detection probability [0..1]'
      + '","items":{"type":"number"}},"amplitude":{"type":"array","description"'
      + ':"Amplitude [dB]","items":{"type":"number"}}},"$schema":"http://json-s'
      + 'chema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"detection_probability":[0.0,0.5,0.8,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0]'
      + ',"amplitude":[0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0]}'
    );
  );

// Details about the device used to acquire the point cloud
const
  RDB_RIEGL_DEVICE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device';
    Title       : 'Device Information';
    Description : 'Details about the device used to acquire the point cloud';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["device_type","serial_number"],"type":"object","descripti'
      + 'on":"Details about the device used to acquire the point '
      + 'cloud","title":"Device Information","properties":{"channel_text":{"typ'
      + 'e":"string","description":"Optional channel description (e.g. ''Green '
      + 'Channel'' for multi-channel '
      + 'devices)"},"serial_number":{"type":"string","description":"Device '
      + 'serial number (e.g. '
      + 'S2221234)"},"device_build":{"type":"string","description":"Device '
      + 'build '
      + 'variant"},"channel_number":{"type":"integer","description":"Laser '
      + 'channel number (not defined or 0: single channel device)","minimum":0,'
      + '"exclusiveMinimum":false},"device_name":{"type":"string","description"'
      + ':"Optional device name (e.g. ''Scanner 1'' for multi-scanner '
      + 'systems)"},"device_type":{"type":"string","description":"Device type '
      + 'identifier (e.g. '
      + 'VZ-400i)"}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"channel_text":"","serial_number":"S2221234","device_build":"","chann'
      + 'el_number":0,"device_name":"Scanner 1","device_type":"VZ-400i"}'
    );
  );

// Scanner device geometry details
const
  RDB_RIEGL_DEVICE_GEOMETRY : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device_geometry';
    Title       : 'Device Geometry';
    Description : 'Scanner device geometry details';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["primary"],"type":"object","description":"Scanner device '
      + 'geometry details","title":"Device '
      + 'Geometry","properties":{"amu":{"type":"object","description":"Angle '
      + 'Measurement '
      + 'Unit","properties":{"lineCC":{"type":"number","description":"Line '
      + 'Circle Count (number of LSBs per full rotation about line axis)","mini'
      + 'mum":0,"exclusiveMinimum":false},"frameCC":{"type":"number","descripti'
      + 'on":"Frame Circle Count (number of LSBs per full rotation about frame '
      + 'axis)","minimum":0,"exclusiveMinimum":false}}},"secondary":{"required"'
      + ':["ID","content"],"type":"object","description":"Additional device '
      + 'geometry structure (optional)","properties":{"content":{"type":"array"'
      + ',"description":"Internal calibration values","items":{"type":"number"}'
      + '},"ID":{"maxItems":2,"type":"array","description":"Structure identifie'
      + 'r","minItems":2,"items":{"type":"integer"}}}},"primary":{"required":["'
      + 'ID","content"],"type":"object","description":"Primary device geometry '
      + 'structure (mandatory)","properties":{"content":{"type":"array","descri'
      + 'ption":"Internal calibration values","items":{"type":"number"}},"ID":{'
      + '"maxItems":2,"type":"array","description":"Structure identifier","minI'
      + 'tems":2,"items":{"type":"integer"}}}}},"$schema":"http://json-schema.o'
      + 'rg/draft-04/schema#"}'
    );

    Example : (''
      + '{"amu":{"lineCC":124000,"frameCC":124000},"secondary":{"content":[0],"'
      + 'ID":[91,0]},"primary":{"content":[0],"ID":[4,0]}}'
    );
  );

// Scanner passive channel device geometry details
const
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device_geometry_passive_channel';
    Title       : 'Device Geometry Passive Channel';
    Description : 'Scanner passive channel device geometry details';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["primary"],"type":"object","description":"Scanner passive'
      + ' channel device geometry details","title":"Device Geometry Passive Cha'
      + 'nnel","properties":{"primary":{"required":["ID","content"],"type":"obj'
      + 'ect","description":"Primary device geometry structure (mandatory)","pr'
      + 'operties":{"content":{"type":"array","description":"Internal '
      + 'calibration values","items":{"type":"number"}},"ID":{"maxItems":2,"typ'
      + 'e":"array","description":"Structure identifier","minItems":2,"items":{'
      + '"type":"integer"}}}}},"$schema":"http://json-schema.org/draft-04/schem'
      + 'a#"}'
    );

    Example : (''
      + '{"primary":{"content":[0],"ID":[143,0]}}'
    );
  );

// Limits of the measured values output by the device
const
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.device_output_limits';
    Title       : 'Device Output Limits';
    Description : 'Limits of the measured values output by the device';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Li'
      + 'mits of the measured values output by the device. The limits depend on'
      + ' the device type, measurement program and/or scan pattern.","propertie'
      + 's":{"amplitude_minimum":{"type":"number","description":"Minimum '
      + 'possible amplitude in '
      + 'dB."},"range_minimum":{"type":"number","description":"Minimum possible'
      + ' range in meters."},"reflectance_maximum":{"type":"number","descriptio'
      + 'n":"Maximum possible reflectance in '
      + 'dB."},"amplitude_maximum":{"type":"number","description":"Maximum '
      + 'possible amplitude in '
      + 'dB."},"reflectance_minimum":{"type":"number","description":"Minimum '
      + 'possible reflectance in dB."},"background_radiation_maximum":{"type":"'
      + 'number","description":"Maximum possible background radiation."},"backg'
      + 'round_radiation_minimum":{"type":"number","description":"Minimum '
      + 'possible background '
      + 'radiation."},"range_maximum":{"type":"number","description":"Maximum '
      + 'possible range in meters."},"mta_zone_count_maximum":{"type":"number",'
      + '"description":"Maximum number of MTA '
      + 'zones."},"deviation_minimum":{"type":"number","description":"Minimum '
      + 'possible pulse shape deviation."},"echo_count_maximum":{"type":"number'
      + '","description":"Maximum number of echoes a laser shot can '
      + 'have."},"deviation_maximum":{"type":"number","description":"Maximum '
      + 'possible pulse shape deviation."}},"title":"Device Output '
      + 'Limits","type":"object"}'
    );

    Example : (''
      + '{"background_radiation_minimum":0,"range_maximum":10000.0,"range_minim'
      + 'um":2.9,"deviation_minimum":-1,"reflectance_maximum":100.0,"amplitude_'
      + 'maximum":100.0,"mta_zone_count_maximum":7,"reflectance_minimum":-100.0'
      + ',"amplitude_minimum":0.0,"background_radiation_maximum":0,"deviation_m'
      + 'aximum":32767}'
    );
  );

// Details about the devices used to acquire the point cloud
const
  RDB_RIEGL_DEVICES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.devices';
    Title       : 'Devices Information';
    Description : 'Details about the devices used to acquire the point cloud';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"De'
      + 'tails about the devices used to acquire the point cloud (e.g. when '
      + 'merging point clouds of different devices)","items":{"required":["devi'
      + 'ce_type","serial_number"],"type":"object","properties":{"channel_text"'
      + ':{"type":"string","description":"Optional channel description (e.g. '
      + '''Green Channel'' for multi-channel '
      + 'devices)"},"serial_number":{"type":"string","description":"Device '
      + 'serial number (e.g. '
      + 'S2221234)"},"device_build":{"type":"string","description":"Device '
      + 'build '
      + 'variant"},"channel_number":{"type":"integer","description":"Laser '
      + 'channel number (not defined or 0: single channel device)","minimum":0,'
      + '"exclusiveMinimum":false},"device_name":{"type":"string","description"'
      + ':"Optional device name (e.g. ''Scanner 1'' for multi-scanner '
      + 'systems)"},"signed":{"type":"boolean","description":"Flag that is set '
      + 'when the original ''riegl.device'' entry in the source file was '
      + 'correctly '
      + 'signed."},"device_type":{"type":"string","description":"Device type '
      + 'identifier (e.g. VZ-400i)"}}},"title":"Devices '
      + 'Information","type":"array"}'
    );

    Example : (''
      + '[{"channel_text":"","serial_number":"S2221234","device_build":"","chan'
      + 'nel_number":0,"device_name":"Scanner 1","signed":false,"device_type":"'
      + 'VZ-400i"},{"channel_text":"","serial_number":"S2222680","device_build"'
      + ':"","channel_number":1,"device_name":"Scanner 2","signed":true,"device'
      + '_type":"VQ-1560i-DW"},{"channel_text":"","serial_number":"S2222680","d'
      + 'evice_build":"","channel_number":2,"device_name":"Scanner '
      + '3","signed":true,"device_type":"VQ-1560i-DW"}]'
    );
  );

// Distance measuring instrument configuration
const
  RDB_RIEGL_DMI_CONFIG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.dmi_config';
    Title       : 'DMI Configuration';
    Description : 'Distance measuring instrument configuration';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["dmi_count_dir","dmi_incr","dmi_min_time","dmi_max_time",'
      + '"dmi_dist_per_tick"],"type":"object","description":"Distance measuring'
      + ' instrument configuration","title":"DMI Configuration","properties":{"'
      + 'dmi_max_time":{"type":"integer","description":"Maximum time interval '
      + 'between trigger events, 0 means timeout is inactive [0.1 msec]","minim'
      + 'um":0,"exclusiveMinimum":false,"exclusiveMaximum":false,"maximum":6553'
      + '5},"dmi_min_time":{"type":"integer","description":"Minimum time '
      + 'interval between trigger events, 0 means rate limitation is inactive '
      + '[0.1 msec]","minimum":0,"exclusiveMinimum":false,"exclusiveMaximum":fa'
      + 'lse,"maximum":65535},"dmi_incr":{"type":"integer","description":"Incre'
      + 'ment in ticks, 0 means distance trigger is deactivated","minimum":0,"e'
      + 'xclusiveMinimum":false,"exclusiveMaximum":false,"maximum":2147483647},'
      + '"dmi_count_dir":{"type":"integer","description":"DMI count direction '
      + 'is inverted","minimum":0,"exclusiveMinimum":false,"exclusiveMaximum":f'
      + 'alse,"maximum":1},"dmi_dist_per_tick":{"type":"number","description":"'
      + 'Distance per tick, just informative '
      + '[m]"}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"dmi_max_time":100,"dmi_min_time":0,"dmi_incr":0,"dmi_count_dir":0,"d'
      + 'mi_dist_per_tick":0.00024399999529123306}'
    );
  );

// Dyntrig
const
  RDB_RIEGL_DYNTRIG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.dyntrig';
    Title       : 'Dyntrig';
    Description : 'Dyntrig';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Dy'
      + 'ntrig","properties":{"tab":{"maxItems":128,"type":"array","items":{"re'
      + 'quired":["thra1","del1","dec1","thra2","del2","dec2"],"type":"object",'
      + '"description":"...","properties":{"del1":{"type":"number","description'
      + '":"Length of constant post-trigger threshold elevation in units of '
      + 'm"},"del2":{"type":"number","description":"Length of constant '
      + 'pre-trigger threshold elevation in units of '
      + 'm"},"thra1":{"type":"number","description":"Post-trigger threshold in '
      + 'units of dB"},"thra2":{"type":"number","description":"Pre-trigger '
      + 'threshold in units of '
      + 'dB"},"dec1":{"type":"number","description":"Decay of post-trigger '
      + 'threshold after del1 in units of '
      + 'dB/m"},"dec2":{"type":"number","description":"Rise of pre-trigger '
      + 'threshold after del2 in units of dB/m"}}},"minItems":1,"description":"'
      + '..."},"scale":{"type":"number","description":"Scale in units of dB, '
      + 'for calculation of line: line number N=(amplitude-offset)/scale"},"pre'
      + '":{"required":["nc","a"],"type":"object","description":"Dyntrig pre va'
      + 'lues","properties":{"a":{"maxItems":2080,"type":"array","items":{"type'
      + '":"number"},"minItems":1,"description":"..."},"nc":{"type":"integer","'
      + 'description":"Number of entries","minimum":0,"maximum":255}}},"offset"'
      + ':{"type":"number","description":"Offset in units of dB, for '
      + 'calculation of line"},"post":{"required":["nc","a"],"type":"object","d'
      + 'escription":"Dyntrig post values","properties":{"a":{"maxItems":2080,"'
      + 'type":"array","items":{"type":"number"},"minItems":1,"description":"..'
      + '."},"nc":{"type":"integer","description":"Number of '
      + 'entries","minimum":0,"maximum":255}}}},"title":"Dyntrig"}'
    );

    Example : (''
      + '{"tab":[{"del1":0.0,"del2":0.0,"thra1":0.0,"thra2":0.0,"dec1":0.0,"dec'
      + '2":0.0}],"scale":1.0,"pre":{"a":[78,86,126,134,31],"nc":128},"offset":'
      + '0.0,"post":{"a":[78,86,126,134,31],"nc":128}}'
    );
  );

// Details about echo files
const
  RDB_RIEGL_ECHO_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.echo_info';
    Title       : 'Echo Information';
    Description : 'Details about echo files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["echo_file"],"type":"object","description":"Details about'
      + ' echo files","title":"Echo Information","properties":{"echo_file":{"re'
      + 'quired":["file_extension"],"type":"object","properties":{"file_uuid":{'
      + '"type":"string","description":"File''s Universally Unique Identifier '
      + '(RFC 4122)"},"file_extension":{"type":"string","description":"Echo '
      + 'file extension, without the leading '
      + 'dot"}}}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"echo_file":{"file_uuid":"26a03615-67c0-4bea-8fe8-c577378fe661","file'
      + '_extension":"owp"}}'
    );
  );

// Details for exponential decomposition of full waveform data
const
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.exponential_decomposition';
    Title       : 'Exponential Decomposition';
    Description : 'Details for exponential decomposition of full waveform data';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"Details for exponential decomposition '
      + 'of full waveform data","patternProperties":{"^[0-9]+$":{"$ref":"#/defi'
      + 'nitions/channel","description":"one field per channel, field name is '
      + 'channel index"}},"title":"Exponential Decomposition","definitions":{"c'
      + 'hannel":{"required":["delay","scale","parameter"],"type":"object","pro'
      + 'perties":{"delay":{"type":"number","description":"delay calibration in'
      + ' seconds"},"a_lin":{"type":"number","description":"relative linear '
      + 'amplitude range [0..1]","minimum":0,"exclusiveMinimum":false,"exclusiv'
      + 'eMaximum":false,"maximum":1},"scale":{"type":"number","description":"a'
      + 'mplitude calibration"},"parameter":{"required":["A","B","gamma","omega'
      + '"],"type":"object","description":"parameters of the syswave '
      + 'exponential '
      + 'sum","properties":{"gamma":{"type":"array","description":"decay in 1/s'
      + 'econd","items":{"type":"number"}},"B":{"type":"array","description":"i'
      + 'maginary part of amplitude factor in units of full-scale","items":{"ty'
      + 'pe":"number"}},"omega":{"type":"array","description":"angular '
      + 'frequency in '
      + 'Hz","items":{"type":"number"}},"A":{"type":"array","description":"real'
      + ' part of amplitude factor in units of full-scale","items":{"type":"num'
      + 'ber"}}}}}}},"$schema":"http://json-schema.org/draft-04/schema#","addit'
      + 'ionalProperties":false}'
    );

    Example : (''
      + '{"0":{"delay":3.783458418887631e-09,"a_lin":0.27,"scale":1.0,"paramete'
      + 'r":{"gamma":[-1094726528.0,-769562752.0,-848000064.0],"B":[-3.98130321'
      + '50268555,0.08622030913829803,-0.3152860999107361],"omega":[352020896.0'
      + ',3647927552.0,-1977987072.0],"A":[0.9772450923919678,0.335433512926101'
      + '7,-1.312678575515747]}},"1":{"delay":3.5e-09,"a_lin":0.9,"scale":1.0,"'
      + 'parameter":{"gamma":[-1094726528.0,-769562752.0,-848000064.0],"B":[-3.'
      + '9,0.0,-0.3],"omega":[352020896.0,3647927552.0,-1977987072.0],"A":[0.9,'
      + '0.3,-1.3]}}}'
    );
  );

// Details for Gaussian decomposition of full waveform data
const
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.gaussian_decomposition';
    Title       : 'Gaussian Decomposition';
    Description : 'Details for Gaussian decomposition of full waveform data';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["amplitude_lsb_low_power","amplitude_lsb_high_power","amp'
      + 'litude_db","range_offset_sec_low_power","range_offset_sec_high_power"]'
      + ',"type":"object","description":"riegl.gaussian_decomposition contains '
      + 'information relevant for extracting calibrated amplitudes and '
      + 'calibrated ranges from a Gaussian decomposition of full waveform data.'
      + ' This information is contained in a table with five columns. Two '
      + 'columns are to be used as input: amplitude_lsb_low_power and '
      + 'amplitude_lsb_high_power. The other three columns provide the outputs.'
      + ' Amplitude_db gives the calibrated amplitude in the optical regime in '
      + 'decibels. The range offset columns provide additive range offsets, '
      + 'given in units of seconds, for each channel.","title":"Gaussian Decomp'
      + 'osition","properties":{"range_offset_sec_low_power":{"type":"array","i'
      + 'tems":{"type":"number"}},"amplitude_lsb_high_power":{"type":"array","i'
      + 'tems":{"type":"number"}},"amplitude_lsb_low_power":{"type":"array","it'
      + 'ems":{"type":"number"}},"range_offset_sec_high_power":{"type":"array",'
      + '"items":{"type":"number"}},"amplitude_db":{"type":"array","items":{"ty'
      + 'pe":"number"}}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"range_offset_sec_low_power":[],"amplitude_lsb_high_power":[],"amplit'
      + 'ude_lsb_low_power":[],"range_offset_sec_high_power":[],"amplitude_db":'
      + '[]}'
    );
  );

// Point cloud georeferencing information
const
  RDB_RIEGL_GEO_TAG : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.geo_tag';
    Title       : 'Geo Tag';
    Description : 'Point cloud georeferencing information';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Po'
      + 'int cloud georeferencing information","properties":{"crs":{"type":"obj'
      + 'ect","description":"Global Coordinate Reference System. Please note '
      + 'that only 3D Cartesian Coordinate Systems are allowed.","properties":{'
      + '"name":{"type":"string","description":"Coordinate reference system '
      + 'name"},"wkt":{"type":"string","description":"\"Well-Known Text\" '
      + 'string, OGC WKT dialect (see http://www.opengeospatial.org/standards/w'
      + 'kt-crs)"},"epsg":{"type":"integer","description":"EPSG code","minimum"'
      + ':0}}},"pose":{"maxItems":4,"type":"array","description":"Coordinate '
      + 'Transformation Matrix to transform from File Coordinate System to '
      + 'Global Coordinate Reference System. 4x4 matrix stored as two '
      + 'dimensional array, row major order.","minItems":4,"items":{"maxItems":'
      + '4,"type":"array","description":"rows","minItems":4,"items":{"type":"nu'
      + 'mber","description":"columns"}}}},"title":"Geo Tag","type":"object"}'
    );

    Example : (''
      + '{"crs":{"name":"WGS84 Geocentric","wkt":"GEOCCS[\"WGS84 Geocentric\",D'
      + 'ATUM[\"WGS84\",SPHEROID[\"WGS84\",6378137.000,298.257223563,AUTHORITY['
      + '\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\"'
      + ',0.0000000000000000,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"Meter\",1.000'
      + '00000000000000000,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",OTHER],AXIS'
      + '[\"Y\",EAST],AXIS[\"Z\",NORTH],AUTHORITY[\"EPSG\",\"4978\"]]","epsg":4'
      + '978},"pose":[[-0.269827776749716,-0.723017716139738,0.635954678449952,'
      + '4063882.500831],[0.962908599449764,-0.20260517250352,0.178208229833847'
      + ',1138787.607461],[0.0,0.660451759194338,0.7508684796801,4766084.550196'
      + '],[0.0,0.0,0.0,1.0]]}'
    );
  );

// Geometric scale factor applied to point coordinates
const
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.geometric_scale_factor';
    Title       : 'Geometric Scale Factor';
    Description : 'Geometric scale factor applied to point coordinates';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Ge'
      + 'ometric scale factor applied to point '
      + 'coordinates","exclusiveMinimum":true,"minimum":0,"type":"number"}'
    );

    Example : (''
      + '1.0'
    );
  );

// Parameters used for georeferencing of the point cloud
const
  RDB_RIEGL_GEOREFERENCING_PARAMETERS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.georeferencing_parameters';
    Title       : 'Georeferencing Parameters';
    Description : 'Parameters used for georeferencing of the point cloud';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Pa'
      + 'rameters used for georeferencing of the point cloud","properties":{"so'
      + 'cs_to_body_matrix":{"maxItems":4,"type":"array","description":"Coordin'
      + 'ate Transformation Matrix to transform from Scanner''s Own Coordinate '
      + 'System to Body Coordinate System. 4x4 matrix stored as two dimensional'
      + ' array, row major order.","minItems":4,"items":{"maxItems":4,"type":"a'
      + 'rray","description":"rows","minItems":4,"items":{"type":"number","desc'
      + 'ription":"columns"}}},"body_coordinate_system_type":{"type":"string","'
      + 'description":"BODY coordinate frame (NED: North-East-Down, ENU: '
      + 'East-North-Up), default: NED","enum":["NED","ENU"]},"trajectory_offset'
      + 's":{"type":"object","description":"Correction offsets applied to the '
      + 'trajectory '
      + 'data","properties":{"version":{"type":"integer","description":"Meaning'
      + ' of offset values and how to apply them; version 0: '
      + 'Rz(yaw+offset_yaw)*Ry(pitch+offset_pitch)*Rx(roll+offset_roll), '
      + 'version 1: Rz(yaw)*Ry(pitch)*Rx(roll) * Rz(offset_yaw)*Ry(offset_pitch'
      + ')*Rx(offset_roll)"},"offset_yaw":{"type":"number","description":"[deg]'
      + '"},"offset_time":{"type":"number","description":"[s]"},"offset_north":'
      + '{"type":"number","description":"[m]"},"offset_roll":{"type":"number","'
      + 'description":"[deg]"},"offset_east":{"type":"number","description":"[m'
      + ']"},"offset_pitch":{"type":"number","description":"[deg]"},"offset_hei'
      + 'ght":{"type":"number","description":"[m]"}}},"socs_to_rocs_matrix":{"m'
      + 'axItems":4,"type":"array","description":"Coordinate Transformation '
      + 'Matrix to transform from Scanner''s Own Coordinate System to Record '
      + 'Coordinate System. 4x4 matrix stored as two dimensional array, row '
      + 'major order.","minItems":4,"items":{"maxItems":4,"type":"array","descr'
      + 'iption":"rows","minItems":4,"items":{"type":"number","description":"co'
      + 'lumns"}}},"trajectory_file":{"required":["file_extension"],"type":"obj'
      + 'ect","description":"Trajectory data used for georeferencing of the '
      + 'point cloud","properties":{"file_uuid":{"type":"string","description":'
      + '"File''s Universally Unique Identifier (RFC '
      + '4122)"},"file_extension":{"type":"string","description":"Trajectory '
      + 'file extension, without the leading dot"}}}},"title":"Georeferencing '
      + 'Parameters","type":"object"}'
    );

    Example : (''
      + '{"socs_to_body_matrix":[[-0.269827776749716,-0.723017716139738,0.63595'
      + '4678449952,0.0],[0.962908599449764,-0.20260517250352,0.178208229833847'
      + ',0.0],[0.0,0.660451759194338,0.7508684796801,0.0],[0.0,0.0,0.0,1.0]],"'
      + 'body_coordinate_system_type":"NED","trajectory_offsets":{"version":0,"'
      + 'offset_yaw":-0.45,"offset_time":18.007,"offset_north":0.07,"offset_rol'
      + 'l":0.03,"offset_east":0.15,"offset_pitch":0.01,"offset_height":-0.2},"'
      + 'trajectory_file":{"file_uuid":"93a03615-66c0-4bea-8ff8-c577378fe660","'
      + 'file_extension":"pofx"}}'
    );
  );

// Details about GNSS processing
const
  RDB_RIEGL_GNSS_PROCESSING_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.gnss_processing_info';
    Title       : 'GNSS Processing Information';
    Description : 'Details about GNSS processing';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"De'
      + 'tails about GNSS processing","properties":{"base_stations":{"type":"ar'
      + 'ray","description":"List of GNSS base stations","items":{"required":["'
      + 'latitude","longitude","altitude"],"type":"object","description":"GNSS '
      + 'base station details","properties":{"longitude":{"type":"number","desc'
      + 'ription":"Longitude '
      + '[deg]"},"altitude":{"type":"number","description":"Altitude '
      + '[m]"},"latitude":{"type":"number","description":"Latitude '
      + '[deg]"}}}}},"title":"GNSS Processing Information","type":"object"}'
    );

    Example : (''
      + '{"base_stations":[{"longitude":15.663389822,"altitude":379.80041503906'
      + '25,"latitude":48.658391162}]}'
    );
  );

// Map of item names
const
  RDB_RIEGL_ITEM_NAMES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.item_names';
    Title       : 'Item Names';
    Description : 'Map of item names';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"Map of item names","title":"Item Names'
      + '","patternProperties":{"^-?[0-9]+$":{"type":"string","description":"On'
      + 'e field per item, field name is item id, field value is item name"}},"'
      + '$schema":"http://json-schema.org/draft-04/schema#","additionalProperti'
      + 'es":false}'
    );

    Example : (''
      + '{"47":"Name of item with id 47","-1":"Name of item with id '
      + '-1","1":"Name of item with id 1","2":"Name of item with id 2"}'
    );
  );

// Lag angle depended range and reflectance correction
const
  RDB_RIEGL_LAG_ANGLE_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.lag_angle_correction';
    Title       : 'Lag Angle Correction';
    Description : 'Lag angle depended range and reflectance correction';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["ranges_m","range_correction_m","reflectance_correction_d'
      + 'b"],"type":"object","description":"Lag angle depended range and '
      + 'reflectance correction","title":"Lag Angle Correction","properties":{"'
      + 'reflectance_correction_db":{"type":"array","description":"Reflectance '
      + 'correction [db] as a function of the range and for applied scanrate","'
      + 'items":{"type":"number"}},"ranges_m":{"type":"array","description":"Ra'
      + 'nge [m]","items":{"type":"number"}},"range_correction_m":{"type":"arra'
      + 'y","description":"Range correction [m] as a function of the range and '
      + 'for applied scanrate, which defines the lag angle","items":{"type":"nu'
      + 'mber"}}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"reflectance_correction_db":[0.0,0.0,0.16,0.46,1.18,2.97,2.97],"range'
      + 's_m":[0.0,4.795,31.964,63.928,95.892,127.856,10000.0],"range_correctio'
      + 'n_m":[0.0,0.0,0.0004,0.0023,0.0039,0.0053,0.0053]}'
    );
  );

// License keys for software features
const
  RDB_RIEGL_LICENSES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.licenses';
    Title       : 'Software License Keys';
    Description : 'License keys for software features';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"License keys for software '
      + 'features","title":"Software License '
      + 'Keys","patternProperties":{"^.*$":{"type":"array","description":"Each '
      + 'field of the object represents a feature and holds a list of license '
      + 'keys, where the field name is the feature '
      + 'name.","minItems":1,"items":{"type":"string","description":"License '
      + 'key (example: ''46AE032A - 39882AC4 - 9EC0A184 - 6F163D73'')"}}},"$schem'
      + 'a":"http://json-schema.org/draft-04/schema#","additionalProperties":fa'
      + 'lse}'
    );

    Example : (''
      + '{"Full Waveform Analysis Topography":["0FD5FF07 - 011A1255 - 9F76CACA '
      + '- 8D2ED557"],"MTA resolution":["468E020A - 39A922E4 - B681A184 - '
      + '673E3D72"],"Georeferencing":["46AE032A - 39882AC4 - 9EC0A184 - '
      + '6F163D73"],"Full Waveform Analysis Topography with GPU '
      + 'support":["8AB44126 - 23B92250 - 16E2689F - 34EF7E7B"]}'
    );
  );

// Parameters for MTA processing
const
  RDB_RIEGL_MTA_SETTINGS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.mta_settings';
    Title       : 'MTA Settings';
    Description : 'Parameters for MTA processing';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Pa'
      + 'rameters for MTA processing","properties":{"zone_width":{"type":"numbe'
      + 'r","description":"Width of a MTA zone in meter.","minimum":0},"zone_co'
      + 'unt":{"type":"integer","description":"Maximum number of MTA zones.","m'
      + 'inimum":0,"maximum":255},"modulation_depth":{"type":"number","descript'
      + 'ion":"Depth of pulse position modulation in '
      + 'meter.","minimum":0}},"title":"MTA Settings","type":"object"}'
    );

    Example : (''
      + '{"zone_width":149.896225,"zone_count":23,"modulation_depth":9.368514}'
    );
  );

// Lookup table for range correction based on raw range
const
  RDB_RIEGL_NEAR_RANGE_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.near_range_correction';
    Title       : 'Near Range Correction Table';
    Description : 'Lookup table for range correction based on raw range';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["delta","content"],"type":"object","description":"Lookup '
      + 'table for range correction based on raw range","title":"Near Range '
      + 'Correction '
      + 'Table","properties":{"delta":{"type":"number","description":"Delta '
      + 'between table entries [m], first entry is at range = 0 m"},"content":{'
      + '"maxItems":2000,"type":"array","description":"Correction value [m] to '
      + 'be added to the raw range","minItems":1,"items":{"type":"number"}}},"$'
      + 'schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"delta":0.512,"content":[0.0]}'
    );
  );

// Standard deviation for range and amplitude as a function of amplitude
const
  RDB_RIEGL_NOISE_ESTIMATES : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.noise_estimates';
    Title       : 'Noise Estimates';
    Description : 'Standard deviation for range and amplitude as a function of amplitude';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["amplitude","range_sigma","amplitude_sigma"],"type":"obje'
      + 'ct","description":"Standard deviation for range and amplitude as a '
      + 'function of amplitude","title":"Noise Estimates","properties":{"range_'
      + 'sigma":{"type":"array","description":"Sigma range [m]","items":{"type"'
      + ':"number"}},"amplitude_sigma":{"type":"array","description":"Sigma '
      + 'amplitude [dB]","items":{"type":"number"}},"amplitude":{"type":"array"'
      + ',"description":"Amplitude [dB]","items":{"type":"number"}}},"$schema":'
      + '"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"range_sigma":[0.065,0.056,0.046,0.038,0.032,0.027,0.024,0.021,0.018,'
      + '0.016,0.014],"amplitude_sigma":[0.988,0.988,0.875,0.774,0.686,0.608,0.'
      + '54,0.482,0.432,0.39,0.354],"amplitude":[0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.'
      + '0,8.0,9.0,10.0]}'
    );
  );

// Notch filter parameters for window glass echoes
const
  RDB_RIEGL_NOTCH_FILTER : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.notch_filter';
    Title       : 'Notch Filter';
    Description : 'Notch filter parameters for window glass echoes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["range_minimum","range_maximum","amplitude_maximum"],"typ'
      + 'e":"object","description":"Notch filter parameters for window glass '
      + 'echoes","title":"Notch Filter","properties":{"range_maximum":{"type":"'
      + 'number","description":"Maximum range '
      + '[m]"},"range_minimum":{"type":"number","description":"Minimum range '
      + '[m]"},"amplitude_maximum":{"type":"number","description":"Maximum '
      + 'amplitude [dB]","minimum":0}},"$schema":"http://json-schema.org/draft-'
      + '04/schema#"}'
    );

    Example : (''
      + '{"range_maximum":0.2,"range_minimum":-0.5,"amplitude_maximum":18.0}'
    );
  );

// Details about the pixels contained in the file
const
  RDB_RIEGL_PIXEL_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pixel_info';
    Title       : 'Pixel Information';
    Description : 'Details about the pixels contained in the file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["size"],"type":"object","description":"Details about the '
      + 'pixels contained in the file","properties":{"size_llcs":{"$ref":"#/def'
      + 'initions/pixel_size","description":"Size of pixels in a locally '
      + 'levelled cartesian coordinate system (xy). This is only used for '
      + 'pixels based on a map projection."},"size":{"$ref":"#/definitions/pixe'
      + 'l_size","description":"Size of pixels in file coordinate '
      + 'system."}},"title":"Pixel Information","definitions":{"pixel_size":{"m'
      + 'axItems":2,"type":"array","description":"Size of '
      + 'pixels.","minItems":2,"items":{"type":"number","description":"Length '
      + 'of pixel edge [m].","minimum":0}}},"$schema":"http://json-schema.org/d'
      + 'raft-04/schema#"}'
    );

    Example : (''
      + '{"size_llcs":[0.5156575252891171,0.5130835356683303],"size":[0.5971642'
      + '834779395,0.5971642834779395]}'
    );
  );

// Details about the plane patch matching process
const
  RDB_RIEGL_PLANE_PATCH_MATCHING : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.plane_patch_matching';
    Title       : 'Plane Patch Matching';
    Description : 'Details about the plane patch matching process';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["plane_patch_file_one","plane_patch_file_two"],"type":"ob'
      + 'ject","description":"Details about the plane patch matching process","'
      + 'properties":{"plane_patch_file_two":{"$ref":"#/definitions/file_refere'
      + 'nce","description":"Reference to the plane patch file two"},"plane_pat'
      + 'ch_file_one":{"$ref":"#/definitions/file_reference","description":"Ref'
      + 'erence to the plane patch file one"}},"title":"Plane Patch Matching","'
      + 'definitions":{"file_reference":{"required":["file_uuid","file_path"],"'
      + 'type":"object","description":"Reference to a plane patch '
      + 'file","properties":{"file_uuid":{"type":"string","description":"Plane '
      + 'patch file''s Universally Unique Identifier (RFC '
      + '4122)"},"file_path":{"type":"string","description":"Path of the plane '
      + 'patch file relative to the match '
      + 'file"}}}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"plane_patch_file_two":{"file_uuid":"fa47d509-a64e-49ce-8b14-ff3130fb'
      + 'efa9","file_path":"project.ptch"},"plane_patch_file_one":{"file_uuid":'
      + '"810f5d57-eccf-49ed-b07a-0cdd109b4213","file_path":"Record009_Line001/'
      + '191025_121410_Scanner_1.ptch"}}'
    );
  );

// Statistics about plane patches found by plane patch extractor
const
  RDB_RIEGL_PLANE_PATCH_STATISTICS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.plane_patch_statistics';
    Title       : 'Plane Patch Statistics';
    Description : 'Statistics about plane patches found by plane patch extractor';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"St'
      + 'atistics about plane patches found by plane patch extractor","properti'
      + 'es":{"total_area":{"type":"number","description":"sum of all plane '
      + 'patch areas [m\u00b2]"},"total_horizontal_area":{"type":"number","desc'
      + 'ription":"sum of all plane patch areas projected to horizontal plane '
      + '[m\u00b2]"}},"title":"Plane Patch Statistics","type":"object"}'
    );

    Example : (''
      + '{"total_area":14007.965,"total_horizontal_area":13954.601}'
    );
  );

// Settings and classes for plane slope classification
const
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.plane_slope_class_info';
    Title       : 'Plane Slope Class Info';
    Description : 'Settings and classes for plane slope classification';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["settings","classes"],"type":"object","description":"Sett'
      + 'ings and classes for plane slope classification","properties":{"classe'
      + 's":{"type":"object","description":"Class definition table","additional'
      + 'Properties":false,"patternProperties":{"^[0-9]+$":{"type":"string","de'
      + 'scription":"one field per class, field name is class number, field '
      + 'value is class name"}}},"settings":{"oneOf":[{"$ref":"#/definitions/me'
      + 'thod-1"},{"$ref":"#/definitions/method-2"}],"type":"object","descripti'
      + 'on":"Classification settings, details see documentation of '
      + 'rdbplanes"}},"title":"Plane Slope Class Info","definitions":{"method-2'
      + '":{"required":["plane_classification_method","sloping_plane_classes_mi'
      + 'nimum_angle","sloping_plane_classes_maximum_angle"],"type":"object","d'
      + 'escription":"Classification method 2","properties":{"plane_classificat'
      + 'ion_method":{"type":"integer","description":"method ID (=2)","minimum"'
      + ':2,"maximum":2},"sloping_plane_classes_maximum_angle":{"type":"number"'
      + ',"description":"maximum inclination angle of sloping plane patches [de'
      + 'g]","minimum":-360.0,"maximum":360.0},"sloping_plane_classes_minimum_a'
      + 'ngle":{"type":"number","description":"minimum inclination angle of '
      + 'sloping plane patches [deg]","minimum":-360.0,"maximum":360.0}}},"meth'
      + 'od-1":{"required":["plane_classification_method","maximum_inclination_'
      + 'angle_horizontal"],"type":"object","description":"Classification '
      + 'method 1","properties":{"plane_classification_method":{"type":"integer'
      + '","description":"method ID (=1)","minimum":1,"maximum":1},"maximum_inc'
      + 'lination_angle_horizontal":{"type":"number","description":"maximum '
      + 'inclination angle of horizontal plane patches [deg]","minimum":-360.0,'
      + '"maximum":360.0}}}},"$schema":"http://json-schema.org/draft-04/schema#'
      + '"}'
    );

    Example : (''
      + '{"classes":{"10":"sloping, pointing down and east","12":"sloping, '
      + 'pointing down and north","1":"horizontal, pointing up","4":"sloping, '
      + 'pointing up and north","14":"horizontal, pointing down","7":"vertical,'
      + ' pointing south","5":"sloping, pointing up and west","13":"sloping, '
      + 'pointing down and west","6":"vertical, pointing east","9":"vertical, '
      + 'pointing west","8":"vertical, pointing north","3":"sloping, pointing '
      + 'up and south","11":"sloping, pointing down and south","2":"sloping, '
      + 'pointing up and east"},"settings":{"plane_classification_method":2,"sl'
      + 'oping_plane_classes_maximum_angle":70.0,"sloping_plane_classes_minimum'
      + '_angle":10.0}}'
    );
  );

// Grouping and sorting of point attributes for visualization purposes
const
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.point_attribute_groups';
    Title       : 'Point Attribute Groups';
    Description : 'Grouping and sorting of point attributes for visualization purposes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"Grouping and sorting of point '
      + 'attributes for visualization purposes","title":"Point Attribute Groups'
      + '","patternProperties":{"^.*$":{"type":"array","description":"Each '
      + 'field of the object represents a point attribute group and holds a '
      + 'list of point attributes, where the field name is the group '
      + 'name.","minItems":1,"items":{"type":"string","description":"Point '
      + 'attribute full name or name pattern (perl regular expression syntax)"}'
      + '}},"$schema":"http://json-schema.org/draft-04/schema#","additionalProp'
      + 'erties":false}'
    );

    Example : (''
      + '{"Time":["riegl.timestamp"],"Secondary '
      + 'Attributes":["riegl.mirror_facet","riegl.waveform_available"],"Primary'
      + ' Attributes":["riegl.reflectance","riegl.amplitude","riegl.deviation"]'
      + ',"Other Attributes":["riegl.selected","riegl.visible"],"Coordinates/Ve'
      + 'ctors":["riegl.xyz","riegl.range","riegl.theta","riegl.phi"]}'
    );
  );

// Details about point cloud files
const
  RDB_RIEGL_POINTCLOUD_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pointcloud_info';
    Title       : 'Point Cloud Information';
    Description : 'Details about point cloud files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"De'
      + 'tails about point cloud files","properties":{"field_of_application":{"'
      + 'type":"string","description":"Field of application","enum":["unknown",'
      + '"SLS","TLS","KLS","MLS","ULS","ALS","BLS","ILS"]},"comments":{"type":"'
      + 'string","description":"Comments"},"project":{"type":"string","descript'
      + 'ion":"Project name"}},"title":"Point Cloud '
      + 'Information","type":"object"}'
    );

    Example : (''
      + '{"field_of_application":"ALS","comments":"Line 3","project":"Campaign '
      + '4"}'
    );
  );

// Estimated position and orientation information
const
  RDB_RIEGL_POSE_ESTIMATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pose_estimation';
    Title       : 'Pose Estimation';
    Description : 'Estimated position and orientation information';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["orientation"],"type":"object","description":"Estimated '
      + 'position and orientation information as measured by GNSS, IMU or '
      + 'inclination sensors","title":"Pose Estimation","properties":{"barometr'
      + 'ic_height_amsl":{"type":"number","description":"Altitude determined '
      + 'based on the atmospheric pressure according to the standard atmosphere'
      + ' laws [m]."},"position":{"required":["coordinate_1","coordinate_2","co'
      + 'ordinate_3","horizontal_accuracy","vertical_accuracy","crs"],"type":"o'
      + 'bject","description":"Position coordinates and position accuracy '
      + 'values as measured by GNSS in the specified Coordinate Reference '
      + 'System (CRS)","properties":{"crs":{"required":["epsg"],"type":"object"'
      + ',"description":"Global Coordinate Reference System","properties":{"wkt'
      + '":{"type":"string","description":"\"Well-Known Text\" string, OGC WKT '
      + 'dialect (see http://www.opengeospatial.org/standards/wkt-crs)"},"epsg"'
      + ':{"type":"integer","description":"EPSG code","minimum":0}}},"vertical_'
      + 'accuracy":{"type":"number","description":"Vertical accuracy [m]","mini'
      + 'mum":0,"exclusiveMinimum":true},"coordinate_3":{"type":"number","descr'
      + 'iption":"Coordinate 3 as defined by axis 3 of the specified CRS (e.g.,'
      + ' Z, Altitude)"},"horizontal_accuracy":{"type":"number","description":"'
      + 'Horizontal accuracy [m]","minimum":0,"exclusiveMinimum":true},"coordin'
      + 'ate_1":{"type":"number","description":"Coordinate 1 as defined by axis'
      + ' 1 of the specified CRS (e.g., X, '
      + 'Latitude)"},"coordinate_2":{"type":"number","description":"Coordinate '
      + '2 as defined by axis 2 of the specified CRS (e.g., Y, Longitude)"}}},"'
      + 'orientation":{"required":["roll","pitch","yaw","roll_accuracy","pitch_'
      + 'accuracy","yaw_accuracy"],"type":"object","description":"Orientation '
      + 'values and orientation accuracies, measured with IMU or inclination '
      + 'sensors.","properties":{"roll":{"type":"number","description":"Roll '
      + 'angle about scanner X-axis [deg]","minimum":-360,"maximum":360},"pitch'
      + '":{"type":"number","description":"Pitch angle about scanner Y-axis [de'
      + 'g]","minimum":-360,"maximum":360},"pitch_accuracy":{"type":"number","d'
      + 'escription":"Pitch angle accuracy [deg]","minimum":0,"exclusiveMinimum'
      + '":true},"roll_accuracy":{"type":"number","description":"Roll angle '
      + 'accuracy [deg]","minimum":0,"exclusiveMinimum":true},"yaw_accuracy":{"'
      + 'type":"number","description":"Yaw angle accuracy [deg]","minimum":0,"e'
      + 'xclusiveMinimum":true},"yaw":{"type":"number","description":"Yaw angle'
      + ' about scanner Z-axis [deg]","minimum":-360,"maximum":360}}}},"$schema'
      + '":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"barometric_height_amsl":386.7457796227932,"position":{"crs":{"wkt":"'
      + 'GEOGCS[\"WGS84 / Geographic\",DATUM[\"WGS84\",SPHEROID[\"WGS84\",63781'
      + '37.000,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",'
      + '\"6326\"]],PRIMEM[\"Greenwich\",0.0000000000000000,AUTHORITY[\"EPSG\",'
      + '\"8901\"]],UNIT[\"Degree\",0.01745329251994329547,AUTHORITY[\"EPSG\",\'
      + '"9102\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY['
      + '\"EPSG\",\"4979\"]]","epsg":4979},"vertical_accuracy":1.33149993419647'
      + '22,"coordinate_3":362.7124938964844,"horizontal_accuracy":0.8106999993'
      + '32428,"coordinate_1":48.655799473,"coordinate_2":15.645033406},"orient'
      + 'ation":{"roll":3.14743073066123,"pitch":1.509153024827064,"pitch_accur'
      + 'acy":0.009433783936875745,"roll_accuracy":0.009433783936875745,"yaw_ac'
      + 'curacy":1.0094337839368757,"yaw":101.87293630292045}}'
    );
  );

// Details on position and orientation sensors
const
  RDB_RIEGL_POSE_SENSORS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pose_sensors';
    Title       : 'Pose Sensors';
    Description : 'Details on position and orientation sensors';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["gyroscope","accelerometer","magnetic_field_sensor"],"typ'
      + 'e":"object","description":"Details on position and orientation sensors'
      + '","properties":{"gyroscope":{"required":["unit","x_axis","y_axis","z_a'
      + 'xis","offset","origin","relative_nonlinearity"],"type":"object","descr'
      + 'iption":"Gyroscope details","properties":{"relative_nonlinearity":{"$r'
      + 'ef":"#/definitions/vector","description":"Relative nonlinearity, dimen'
      + 'sionless"},"offset":{"$ref":"#/definitions/vector","description":"Valu'
      + 'e to be subtracted from raw measurement values"},"y_axis":{"$ref":"#/d'
      + 'efinitions/vector","description":"Sensitive Y axis of sensor at frame '
      + 'angle = '
      + '0"},"z_axis":{"$ref":"#/definitions/vector","description":"Sensitive Z'
      + ' axis of sensor at frame angle = '
      + '0"},"origin":{"$ref":"#/definitions/vector","description":"Sensor '
      + 'origin in SOCS [m] at frame angle = '
      + '0"},"x_axis":{"$ref":"#/definitions/vector","description":"Sensitive X'
      + ' axis of sensor at frame angle = '
      + '0"},"unit":{"type":"number","description":"Unit of raw data and '
      + 'calibration values, 1 LSB in rad/s","minimum":0,"exclusiveMinimum":tru'
      + 'e}}},"magnetic_field_sensor":{"required":["unit","x_axis","y_axis","z_'
      + 'axis","offset","fixed","relative_nonlinearity"],"type":"object","descr'
      + 'iption":"Magnetic Field Sensor details","properties":{"relative_nonlin'
      + 'earity":{"$ref":"#/definitions/vector","description":"Relative '
      + 'nonlinearity, dimensionless"},"offset":{"$ref":"#/definitions/vector",'
      + '"description":"Value to be subtracted from raw measurement values"},"y'
      + '_axis":{"$ref":"#/definitions/vector","description":"Sensitive Y axis '
      + 'of sensor at frame angle = '
      + '0"},"z_axis":{"$ref":"#/definitions/vector","description":"Sensitive Z'
      + ' axis of sensor at frame angle = '
      + '0"},"x_axis":{"$ref":"#/definitions/vector","description":"Sensitive X'
      + ' axis of sensor at frame angle = '
      + '0"},"fixed":{"$ref":"#/definitions/vector","description":"Distortion '
      + 'of magnetic field caused by non-rotating scanner '
      + 'part"},"unit":{"type":"number","description":"Unit of raw data and '
      + 'calibration values, 1 LSB in nT","minimum":0,"exclusiveMinimum":true}}'
      + '},"accelerometer":{"required":["unit","x_axis","y_axis","z_axis","offs'
      + 'et","origin","relative_nonlinearity"],"type":"object","description":"A'
      + 'ccelerometer details","properties":{"relative_nonlinearity":{"$ref":"#'
      + '/definitions/vector","description":"Relative nonlinearity, dimensionle'
      + 'ss"},"offset":{"$ref":"#/definitions/vector","description":"Value to '
      + 'be subtracted from raw measurement values"},"y_axis":{"$ref":"#/defini'
      + 'tions/vector","description":"Sensitive Y axis of sensor at frame angle'
      + ' = '
      + '0"},"z_axis":{"$ref":"#/definitions/vector","description":"Sensitive Z'
      + ' axis of sensor at frame angle = '
      + '0"},"origin":{"$ref":"#/definitions/vector","description":"Sensor '
      + 'origin in SOCS [m] at frame angle = '
      + '0"},"x_axis":{"$ref":"#/definitions/vector","description":"Sensitive X'
      + ' axis of sensor at frame angle = '
      + '0"},"unit":{"type":"number","description":"Unit of raw data and '
      + 'calibration values, 1 LSB in 9.81 '
      + 'm/s\u00b2","minimum":0,"exclusiveMinimum":true}}}},"title":"Pose Senso'
      + 'rs","definitions":{"vector":{"maxItems":3,"type":"array","items":{"typ'
      + 'e":"number","description":"Index 0=X, 1=Y, 2=Z component"},"minItems":'
      + '3}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"gyroscope":{"relative_nonlinearity":[2.888176311444113e-07,1.0627416'
      + '4579645e-07,-1.7186295080634935e-39],"offset":[-50.92609786987305,146.'
      + '15643310546875,62.4327278137207],"y_axis":[-0.440765917301178,-0.78973'
      + '99663925171,119.5894775390625],"z_axis":[0.555869996547699,119.2213516'
      + '2353516,0.467585027217865],"origin":[0.026900000870227814,-0.039999999'
      + '10593033,-0.08950000256299973],"x_axis":[-121.195556640625,0.821971416'
      + '4733887,0.2313031703233719],"unit":0.00014544410805683583},"magnetic_f'
      + 'ield_sensor":{"relative_nonlinearity":[0.0,0.0,0.0],"offset":[-23812.0'
      + '52734375,5606.57666015625,2493.28125],"y_axis":[0.00027888521435670555'
      + ',-0.011427424848079681,-5.204829722060822e-05],"z_axis":[0.00041987866'
      + '279669106,7.876977906562388e-05,0.011407104320824146],"x_axis":[-0.011'
      + '162743903696537,-2.315962774446234e-05,0.00016818844596855342],"fixed"'
      + ':[-1576.010498046875,1596.081787109375,0.0],"unit":91.74311828613281},'
      + '"accelerometer":{"relative_nonlinearity":[0.0,0.0,0.0],"offset":[-733.'
      + '3636474609375,58.969032287597656,1060.2550048828125],"y_axis":[-7.0272'
      + '88913726807,-44.12333679199219,14952.3701171875],"z_axis":[1.639882206'
      + '916809,15166.744140625,-116.99742889404297],"origin":[0.02690000087022'
      + '7814,-0.03999999910593033,-0.08950000256299973],"x_axis":[-15008.12304'
      + '6875,56.956390380859375,-60.5175666809082],"unit":6.666666740784422e-0'
      + '5}}'
    );
  );

// Laser pulse position modulation used for MTA resolution
const
  RDB_RIEGL_PULSE_POSITION_MODULATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.pulse_position_modulation';
    Title       : 'Pulse Position Modulation';
    Description : 'Laser pulse position modulation used for MTA resolution';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["length","num_mod_ampl","pulse_interval"],"type":"object"'
      + ',"description":"Laser pulse position modulation used for MTA '
      + 'resolution","title":"Pulse Position Modulation","properties":{"pulse_i'
      + 'nterval":{"type":"array","description":"Explicit table of the pulse '
      + 'position modulation used for MTA resolution. Table gives times between'
      + ' successive laser pulses in seconds.","items":{"type":"number","minimu'
      + 'm":0}},"length":{"type":"integer","description":"Length of code","mini'
      + 'mum":0,"maximum":255},"phase_step":{"type":"integer","description":"St'
      + 'ep width in phase of modulation code from line to line","minimum":0,"m'
      + 'aximum":255},"num_mod_ampl":{"type":"integer","description":"Number of'
      + ' different modulation amplitudes (2: binary modulation)","minimum":0,"'
      + 'maximum":255},"code_phase_mode":{"type":"integer","description":"0: no'
      + ' synchronization, 1: toggle between 2 phases, 2: increment with phase_'
      + 'increment","minimum":0,"maximum":255}},"$schema":"http://json-schema.o'
      + 'rg/draft-04/schema#"}'
    );

    Example : (''
      + '{"pulse_interval":[2.759375e-06,2.759375e-06,2.759375e-06,2.759375e-06'
      + ',2.821875e-06,2.759375e-06,2.759375e-06,2.821875e-06,2.759375e-06,2.82'
      + '1875e-06,2.821875e-06,2.759375e-06,2.759375e-06,2.821875e-06,2.821875e'
      + '-06,2.821875e-06,2.821875e-06,2.821875e-06,2.759375e-06,2.759375e-06,2'
      + '.759375e-06,2.821875e-06,2.821875e-06,2.759375e-06,2.821875e-06,2.8218'
      + '75e-06,2.821875e-06,2.759375e-06,2.821875e-06,2.759375e-06,2.821875e-0'
      + '6],"length":31,"phase_step":5,"num_mod_ampl":2,"code_phase_mode":2}'
    );
  );

// Statistics about target distance wrt. SOCS origin
const
  RDB_RIEGL_RANGE_STATISTICS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.range_statistics';
    Title       : 'Range Statistics';
    Description : 'Statistics about target distance wrt. SOCS origin';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["minimum","average","maximum","std_dev"],"type":"object",'
      + '"description":"Statistics about target distance wrt. SOCS '
      + 'origin","title":"Range Statistics","properties":{"std_dev":{"type":"nu'
      + 'mber","description":"Standard '
      + 'deviation"},"minimum":{"type":"number","description":"Minimum '
      + 'value"},"maximum":{"type":"number","description":"Maximum '
      + 'value"},"average":{"type":"number","description":"Average '
      + 'value"}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"std_dev":24.349,"minimum":0.919,"maximum":574.35,"average":15.49738}'
    );
  );

// Receiver Internals
const
  RDB_RIEGL_RECEIVER_INTERNALS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.receiver_internals';
    Title       : 'Receiver Internals';
    Description : 'Receiver Internals';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"Receiver '
      + 'Internals","properties":{"nt":{"type":"integer","description":"Number '
      + 'of traces","minimum":0,"maximum":255},"tbl":{"type":"array","items":{"'
      + '$ref":"#/definitions/fp_table"},"minItems":1,"description":"various '
      + 'internal data"},"si":{"type":"number","description":"Start index (hw_s'
      + 'tart)","minimum":0,"maximum":255},"t":{"type":"object","additionalProp'
      + 'erties":false,"patternProperties":{"^[0-9]+$":{"$ref":"#/definitions/f'
      + 'p","description":"one field per channel, field name is channel '
      + 'index"}}},"sr":{"type":"number","description":"Sample rate [Hz]","mini'
      + 'mum":0,"exclusiveMinimum":true},"a":{"maxItems":256,"type":"array","it'
      + 'ems":{"type":"number"},"minItems":1,"description":"Amplitude '
      + '[dB]"},"mw":{"type":"number","description":"Maximum weight","minimum":'
      + '0,"maximum":4095,"exclusiveMinimum":true},"ns":{"type":"integer","desc'
      + 'ription":"Number of samples","minimum":0,"maximum":4095},"ex":{"type":'
      + '"object","description":"DEPRECATED, use '
      + '''riegl.exponential_decomposition'' instead"}},"title":"Receiver Interna'
      + 'ls","definitions":{"fp_table_row":{"maxItems":2048,"type":"array","ite'
      + 'ms":{"type":"number"},"minItems":1},"fp_table":{"required":["ch","tc",'
      + '"nx","ny","tv"],"type":"object","properties":{"tv":{"maxItems":2048,"t'
      + 'ype":"array","items":{"oneOf":[{"$ref":"#/definitions/fp_table_row"},{'
      + '"type":"number"}]},"minItems":1},"ch":{"type":"integer","min":0,"max":'
      + '255,"description":"channel number"},"ny":{"type":"integer","min":1,"ma'
      + 'x":2048,"description":"number of y entries"},"tc":{"type":"integer","m'
      + 'in":0,"max":255,"description":"table data type '
      + 'code"},"nx":{"type":"integer","min":1,"max":2048,"description":"number'
      + ' of x entries"}},"desription":"scanner internal data"},"fp":{"required'
      + '":["s","w"],"type":"object","description":"Fingerprint values","proper'
      + 'ties":{"s":{"maxItems":256,"type":"array","items":{"maxItems":4096,"ty'
      + 'pe":"array","items":{"type":"number"},"minItems":1},"minItems":1},"w":'
      + '{"maxItems":256,"type":"array","items":{"maxItems":5,"type":"array","i'
      + 'tems":{"type":"number"},"minItems":5},"minItems":1}}}},"$schema":"http'
      + '://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"nt":128,"tbl":[{"tv":[[1,2,3,4,5],[1.1,2.2,3.3,4.4,5.5]],"ch":0,"ny"'
      + ':2,"tc":1,"nx":5}],"si":48,"t":{"0":{"s":[[1.23,4.56],[7.89,0.12]],"w"'
      + ':[[78,86,126,134,31],[78,86,126,134,31]]},"1":{"s":[[1.23,4.56],[7.89,'
      + '0.12]],"w":[[78,86,126,134,31],[78,86,126,134,31]]}},"sr":7959997000.0'
      + ',"a":[-1.55],"mw":31,"ns":400}'
    );
  );

// Lookup table for reflectance calculation based on amplitude and range
const
  RDB_RIEGL_REFLECTANCE_CALCULATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.reflectance_calculation';
    Title       : 'Reflectance Calculation Table';
    Description : 'Lookup table for reflectance calculation based on amplitude and range';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["delta","content"],"type":"object","description":"Lookup '
      + 'table for reflectance calculation based on amplitude and '
      + 'range","title":"Reflectance Calculation '
      + 'Table","properties":{"delta":{"type":"number","description":"Delta '
      + 'between table entries [m], first entry is at range = 0 m"},"content":{'
      + '"maxItems":2000,"type":"array","description":"Correction value [dB] to'
      + ' be added to the amplitude","minItems":1,"items":{"type":"number"}}},"'
      + '$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"delta":0.150918,"content":[-33.01]}'
    );
  );

// Range-dependent and scan-angle-dependent correction of reflectance reading
const
  RDB_RIEGL_REFLECTANCE_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.reflectance_correction';
    Title       : 'Near-Range Reflectance Correction';
    Description : 'Range-dependent and scan-angle-dependent correction of reflectance reading';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["ranges_m","line_angles_deg","reflectance_correction_db"]'
      + ',"type":"object","description":"Range-dependent and '
      + 'scan-angle-dependent correction of reflectance '
      + 'reading","title":"Near-range reflectance correction","properties":{"re'
      + 'flectance_correction_db":{"type":"array","description":"Near range '
      + 'reflectance correction in dB as a function of range over '
      + 'angle","items":{"type":"array","description":"rows (each array '
      + 'corresponds to a '
      + 'range)","items":{"type":"number","description":"columns (each value '
      + 'corresponds to an '
      + 'angle)"}}},"ranges_m":{"type":"array","description":"Range [m]","items'
      + '":{"type":"number"}},"line_angles_deg":{"type":"array","description":"'
      + 'Angle [deg]","items":{"type":"number"}}},"$schema":"http://json-schema'
      + '.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"reflectance_correction_db":[[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.'
      + '01],[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01],[0.8,0.7,0.6,0.5,0.4,0'
      + '.3,0.2,0.1,0.05,0.01],[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01]],"ra'
      + 'nges_m":[0.0,1.0,2.0,3.0],"line_angles_deg":[0.0,0.5,1.0,1.5,1.0,2.0,2'
      + '.5,3.0,3.5,4.0]}'
    );
  );

// Details about RiLOC processing
const
  RDB_RIEGL_RILOC_PROCESSING_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.riloc_processing_info';
    Title       : 'RiLOC Processing Information';
    Description : 'Details about RiLOC processing';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["trajectory","optimizer","georeferencing"],"type":"object'
      + '","description":"Details about RiLOC processing","title":"RiLOC '
      + 'Processing Information","properties":{"georeferencing":{"type":"object'
      + '","description":"Internal georeferencing parameters.","properties":{}}'
      + ',"trajectory":{"type":"object","description":"Trajectory information '
      + 'and statistics.","properties":{}},"planes":{"type":"object","descripti'
      + 'on":"Information on plane correspondences and used extraction/matching'
      + ' templates.","properties":{}},"optimizer":{"type":"object","descriptio'
      + 'n":"Optimization result information and statistics.","properties":{}}}'
      + ',"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"georeferencing":{},"trajectory":{},"planes":{},"optimizer":{}}'
    );
  );

// Scan pattern description
const
  RDB_RIEGL_SCAN_PATTERN : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.scan_pattern';
    Title       : 'Scan Pattern';
    Description : 'Scan pattern description';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Sc'
      + 'an pattern description","properties":{"rectangular":{"required":["phi_'
      + 'start","phi_stop","phi_increment","theta_start","theta_stop","theta_in'
      + 'crement"],"type":"object","description":"Rectangular Field Of View '
      + 'Scan '
      + 'Pattern","properties":{"phi_stop":{"type":"number","description":"Stop'
      + ' phi angle in SOCS [deg]","minimum":0.0,"maximum":720.0},"program":{"$'
      + 'ref":"#/definitions/program"},"phi_start":{"type":"number","descriptio'
      + 'n":"Start phi angle in SOCS [deg]","minimum":0.0,"maximum":360.0},"the'
      + 'ta_start":{"type":"number","description":"Start theta angle in SOCS [d'
      + 'eg]","minimum":0.0,"maximum":180.0},"phi_increment":{"type":"number","'
      + 'description":"Increment of phi angle in SOCS [deg]","minimum":0.0,"max'
      + 'imum":90.0},"theta_increment":{"type":"number","description":"Incremen'
      + 't of theta angle in SOCS [deg]","minimum":0.0,"maximum":90.0},"theta_s'
      + 'top":{"type":"number","description":"Stop theta angle in SOCS [deg]","'
      + 'minimum":0.0,"maximum":180.0}}},"segments":{"required":["list"],"type"'
      + ':"object","description":"Segmented Line Scan Pattern","properties":{"l'
      + 'ist":{"type":"array","items":{"required":["start","stop","increment"],'
      + '"type":"object","description":"Line Scan '
      + 'Segment","properties":{"start":{"type":"number","description":"Start '
      + 'angle in SOCS [deg]","minimum":0.0,"maximum":360.0},"stop":{"type":"nu'
      + 'mber","description":"Stop angle in SOCS [deg]","minimum":0.0,"maximum"'
      + ':720.0},"increment":{"type":"number","description":"Increment of angle'
      + ' in SOCS [deg]","minimum":0.0,"maximum":90.0}}}},"program":{"$ref":"#/'
      + 'definitions/program"}}},"line":{"required":["start","stop","increment"'
      + '],"type":"object","description":"Line Scan '
      + 'Pattern","properties":{"start":{"type":"number","description":"Start '
      + 'angle in SOCS [deg]","minimum":0.0,"maximum":360.0},"stop":{"type":"nu'
      + 'mber","description":"Stop angle in SOCS [deg]","minimum":0.0,"maximum"'
      + ':720.0},"program":{"$ref":"#/definitions/program"},"increment":{"type"'
      + ':"number","description":"Increment of angle in SOCS '
      + '[deg]","minimum":0.0,"maximum":90.0}}}},"title":"Scan Pattern","defini'
      + 'tions":{"program":{"required":["name"],"type":"object","description":"'
      + 'Measurement '
      + 'program","properties":{"name":{"type":"string","description":"Name of '
      + 'measurement '
      + 'program"},"laser_prr":{"type":"number","description":"Laser Pulse '
      + 'Repetition Rate [Hz]","minimum":0,"exclusiveMinimum":false}}}}}'
    );

    Example : (''
      + '{"rectangular":{"phi_stop":270.0,"program":{"name":"High Speed","laser'
      + '_prr":100000.0},"phi_start":45.0,"theta_start":30.0,"phi_increment":0.'
      + '04,"theta_increment":0.04,"theta_stop":130.0}}'
    );
  );

// Details about laser shot files
const
  RDB_RIEGL_SHOT_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.shot_info';
    Title       : 'Shot Information';
    Description : 'Details about laser shot files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"De'
      + 'tails about laser shot files","properties":{"shot_file":{"required":["'
      + 'file_extension"],"type":"object","properties":{"file_uuid":{"type":"st'
      + 'ring","description":"File''s Universally Unique Identifier (RFC '
      + '4122)"},"file_extension":{"type":"string","description":"Shot file '
      + 'extension, without the leading dot"}}}},"title":"Shot '
      + 'Information","type":"object"}'
    );

    Example : (''
      + '{"shot_file":{"file_uuid":"26a00815-67c0-4bff-8fe8-c577378fe663","file'
      + '_extension":"sodx"}}'
    );
  );

// Point filters applied in addition to the application-defined filters
const
  RDB_RIEGL_STORED_FILTERS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.stored_filters';
    Title       : 'Stored Filters';
    Description : 'Point filters applied in addition to the application-defined filters';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["activated","filters"],"type":"object","description":"Poi'
      + 'nt filters applied in addition to the application-defined '
      + 'filters","title":"Stored '
      + 'filters","properties":{"filters":{"type":"array","description":"List '
      + 'of point filters","items":{"required":["activated","title","descriptio'
      + 'n","filter"],"type":"object","description":"Point filter definition","'
      + 'properties":{"description":{"type":"string","description":"A brief '
      + 'description of the filter (e.g. for display in a '
      + 'tooltip)"},"activated":{"type":"boolean","description":"Apply (''true'')'
      + ' or ignore (''false'') this '
      + 'filter"},"filter":{"type":"string","description":"The RDB filter '
      + 'string to apply (e.g. when reading points or index), details see '
      + 'documentation of function '
      + 'select()"},"title":{"type":"string","description":"A short filter '
      + 'title (e.g. for display in a selection '
      + 'list)"}}}},"activated":{"type":"boolean","description":"Apply (''true'')'
      + ' or ignore (''false'') all '
      + 'filters"}},"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"filters":[{"description":"Ignore points with uncertain MTA zone '
      + 'assignment","activated":false,"filter":"riegl.mta_uncertain_point == '
      + '0","title":"Ignore uncertain points from MTA '
      + 'resolution"},{"description":"Ignore points with an echo signal '
      + 'amplitude below the dynamic '
      + 'trigger","activated":false,"filter":"riegl.dyntrig_uncertain_point == '
      + '0","title":"Ignore points below dynamic trigger '
      + 'level"},{"description":"Ignore points that are outside the outer AABB '
      + 'in BOCS","activated":false,"filter":"riegl.point_outside_aabb_bocs == '
      + '0","title":"Ignore points outside outer AABB"},{"description":"Ignore '
      + 'points that are inside the inner AABB in '
      + 'BOCS","activated":false,"filter":"riegl.point_inside_aabb_bocs == '
      + '0","title":"Ignore points inside inner AABB"}],"activated":true}'
    );
  );

// Details of major system components like lidar sensors, cameras and navigation devices
const
  RDB_RIEGL_SYSTEM_DESCRIPTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.system_description';
    Title       : 'System Description';
    Description : 'Details of major system components like lidar sensors, cameras and navigation devices';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["$class","version","author","timestamp","system"],"type":'
      + '"object","description":"Details of major system components like lidar '
      + 'sensors, cameras and navigation devices","title":"System Description",'
      + '"properties":{"version":{"type":"string","description":"Document '
      + 'format version"},"$class":{"type":"string","description":"Object class'
      + ' name","enum":["Document"]},"author":{"type":"string","description":"N'
      + 'ame of the author that created the '
      + 'document"},"system":{"type":"object","description":"The actual system '
      + 'description, details see documentation of RIEGL System '
      + 'Description"},"timestamp":{"type":"string","description":"Date and '
      + 'time of creation (e.g. 2019-06-19T13:32:10+02:00)"}},"$schema":"http:/'
      + '/json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"version":"1.2.1","$class":"Document","author":"RIEGL LMS GmbH, '
      + 'Austria","system":{"details":"see documentation of RIEGL System '
      + 'Description"},"timestamp":"2022-09-30T11:56:26+00:00"}'
    );
  );

// Conversion of background radiation raw values to temperatures in °C
const
  RDB_RIEGL_TEMPERATURE_CALCULATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.temperature_calculation';
    Title       : 'Temperature Calculation Table';
    Description : 'Conversion of background radiation raw values to temperatures in °C';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"Conversion of background radiation raw'
      + ' values to temperatures in \u00b0C","properties":{"InGaAs_Si_Differenc'
      + 'e":{"$ref":"#/definitions/conversion_table","description":"Conversion '
      + 'table for InGaAs - Si difference"},"Si":{"$ref":"#/definitions/convers'
      + 'ion_table","description":"Conversion table for Si channel"},"InGaAs":{'
      + '"$ref":"#/definitions/conversion_table","description":"Conversion '
      + 'table for InGaAs channel"}},"title":"Temperature Calculation Table","d'
      + 'efinitions":{"conversion_table":{"required":["value","temperature"],"t'
      + 'ype":"object","properties":{"value":{"type":"array","description":"LSB'
      + ' [1]","items":{"type":"number"}},"temperature":{"type":"array","descri'
      + 'ption":"Temperature [\u00b0C]","items":{"type":"number"}}}}},"$schema"'
      + ':"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"InGaAs_Si_Difference":{"value":[1000.0,1100.090029602954,1200.044251'
      + '83874,1300.1342814416948,1400.0885036774805,1500.0427259132668,1600.13'
      + '27555162209,1700.0869777520065,1800.0411999877924],"temperature":[1749'
      + '.977111117893,1749.977111117893,1749.977111117893,1749.977111117893,17'
      + '49.977111117893,1749.977111117893,1744.7813348796044,1681.997131260109'
      + '2,1622.3944822534868]},"Si":{"value":[0.0,64.00097659230323,128.001953'
      + '1846065,192.0029297769097,256.0039063692129,320.00488296151616,384.005'
      + '8595538194,448.0068361461226,512.0078127384259],"temperature":[546.300'
      + '048828125,548.8164051212026,551.3143938500972,554.0144257850053,556.60'
      + '4252334815,559.2124464488079,561.8022729986177,564.4104671126105,567.0'
      + '002936624203]},"InGaAs":{"value":[0.0,64.00097659230323,128.0019531846'
      + '065,192.0029297769097,256.0039063692129,320.00488296151616,384.0058595'
      + '538194,448.0068361461226,512.0078127384259],"temperature":[307.2219672'
      + '2535614,309.1153478247277,311.1188086915047,313.10025350480055,315.213'
      + '7946389828,317.2172555057597,319.2207163725366,321.2021611858325,323.3'
      + '157023200148]}}'
    );
  );

// Base of timestamps (epoch)
const
  RDB_RIEGL_TIME_BASE : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.time_base';
    Title       : 'Time Base';
    Description : 'Base of timestamps (epoch)';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["epoch","source"],"type":"object","description":"Base of '
      + 'timestamps (epoch)","title":"Time '
      + 'Base","properties":{"system":{"type":"string","description":"Time '
      + 'system (time standard)","enum":["unknown","UTC","GPS"]},"epoch":{"type'
      + '":"string","description":"Date and time of timestamp ''0'' as proposed '
      + 'by RFC 3339 (e.g. 2015-10-27T00:00:00+01:00)."},"source":{"type":"stri'
      + 'ng","description":"Timestamp source","enum":["unknown","RTC","GNSS"]}}'
      + ',"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"system":"UTC","epoch":"2015-10-27T00:00:00+00:00","source":"GNSS"}'
    );
  );

// Details about position+orientation files
const
  RDB_RIEGL_TRAJECTORY_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.trajectory_info';
    Title       : 'Trajectory Information';
    Description : 'Details about position+orientation files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["time_interval","navigation_frame"],"type":"object","desc'
      + 'ription":"Details about position+orientation '
      + 'files","title":"Trajectory Information","properties":{"field_of_applic'
      + 'ation":{"type":"string","description":"Field of application","enum":["'
      + 'unknown","SLS","TLS","KLS","MLS","ULS","ALS","BLS","ILS"]},"navigation'
      + '_frame":{"type":"string","description":"Navigation frame (NED: '
      + 'North-East-Down, ENU: East-North-Up)","enum":["unknown","NED","ENU"]},'
      + '"software":{"type":"string","description":"Software that calculated '
      + 'the trajectory (this may be the same or different software than the '
      + 'one that created the '
      + 'file)"},"project":{"type":"string","description":"Project '
      + 'name"},"settings":{"type":"string","description":"Settings used to '
      + 'calculate the trajectory (descriptive '
      + 'text)"},"location":{"type":"string","description":"Project location, '
      + 'e.g. '
      + 'city/state/country"},"company":{"type":"string","description":"Company'
      + ' name"},"time_interval":{"required":["minimum","average","maximum","st'
      + 'd_dev"],"type":"object","description":"Time interval statistics","prop'
      + 'erties":{"std_dev":{"type":"number","description":"Standard deviation '
      + 'of intervals [s]"},"minimum":{"type":"number","description":"Minimum '
      + 'time interval [s]"},"maximum":{"type":"number","description":"Maximum '
      + 'time interval [s]"},"average":{"type":"number","description":"Average '
      + 'time interval '
      + '[s]"}}},"device":{"type":"string","description":"Navigation device, '
      + 'e.g. name/type/serial"}},"$schema":"http://json-schema.org/draft-04/sc'
      + 'hema#"}'
    );

    Example : (''
      + '{"field_of_application":"MLS","navigation_frame":"NED","software":"Nav'
      + 'igation Software XYZ","project":"Campaign '
      + '3","settings":"default","location":"Horn","company":"RIEGL LMS","time_'
      + 'interval":{"std_dev":5.51e-07,"minimum":0.00500032,"maximum":0.0050048'
      + '83,"average":0.00500053},"device":"IMU Model 12/1, Serial# 12345"}'
    );
  );

// Trigger-Timestamping-Unit/IP configuration
const
  RDB_RIEGL_TTIP_CONFIGURATION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.ttip_configuration';
    Title       : 'TTIP Configuration';
    Description : 'Trigger-Timestamping-Unit/IP configuration';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["ttip_version","num_channel","ext_channel","ext_signal","'
      + 'ext_delay","ext_subdivider","ext_bitmask","dmi_incr","dmi_min_time","d'
      + 'mi_max_time","dmi_dist_per_tick","channel","output_descr","input_descr'
      + '","output_usage","input_usage","out_polarity","out_duration","out_inte'
      + 'rval","out_delay","out_num_pulses","in_polarity","in_min_duration","in'
      + '_max_duration","in_max_delay"],"type":"object","description":"Trigger-'
      + 'Timestamping-Unit/IP configuration","title":"TTIP Configuration","prop'
      + 'erties":{"out_delay":{"type":"integer","description":"output pulse '
      + 'initial delay after start [0.1 msec]","minimum":0},"ext_bitmask":{"typ'
      + 'e":"integer","description":"defines which of the internal pulse '
      + 'generators are to be '
      + 'started","minimum":0},"ext_signal":{"type":"integer","description":"0 '
      + '.. use input signal, 1 .. use output signal of channel","minimum":0},"'
      + 'out_interval":{"type":"integer","description":"output pulse interval '
      + '[0.1 msec]","minimum":0},"out_num_pulses":{"type":"integer","descripti'
      + 'on":"number of output pulses to be generated, 0 .. infinite","minimum"'
      + ':0},"dmi_dist_per_tick":{"type":"number","description":"dmi, distance '
      + 'per tick, just informative '
      + '[m]"},"dmi_min_time":{"type":"integer","description":"dmi, minimum '
      + 'time interval between trigger events [0.1 msec]","minimum":0},"ext_sub'
      + 'divider":{"type":"integer","description":"reduces the frequency, '
      + 'default 1","minimum":0},"in_min_duration":{"type":"integer","descripti'
      + 'on":"input signals with smaller pulse durations are ignored [0.1 '
      + 'msec]","minimum":0},"out_polarity":{"type":"integer","description":"0 '
      + '.. positive edge, 1 .. negative edge","minimum":0},"in_max_delay":{"ty'
      + 'pe":"integer","description":"maximum delay to output pulse before fake'
      + ' event is generated [0.1 msec], zero indicates that no fake events are'
      + ' generated","minimum":0},"dmi_max_time":{"type":"integer","description'
      + '":"dmi, maximum time interval between trigger events [0.1 msec]","mini'
      + 'mum":0},"ttip_version":{"type":"integer","description":"following main'
      + '.sub.ss.sss","minimum":0},"in_max_duration":{"type":"integer","descrip'
      + 'tion":"stops measurement of pulse duration of input signal [0.1 msec]"'
      + ',"minimum":0},"out_duration":{"type":"integer","description":"output '
      + 'pulse duration [0.1 '
      + 'msec]","minimum":0},"dmi_incr":{"type":"integer","description":"dmi, '
      + 'increment in ticks"},"ext_channel":{"type":"integer","description":"ID'
      + ' of channel used as external trigger input, 32 indicates none","minimu'
      + 'm":0},"input_descr":{"type":"string","description":"descriptive '
      + 'string"},"output_descr":{"type":"string","description":"descriptive '
      + 'string"},"in_polarity":{"type":"integer","description":"0 .. positive '
      + 'edge, 1 .. negative '
      + 'edge","minimum":0},"channel":{"type":"integer","description":"ID of '
      + 'input/output channel","minimum":0},"output_usage":{"type":"integer","d'
      + 'escription":"0 .. no output, 1 .. output derived from internal clock, '
      + '2 .. output derived from dmi, 3 .. output derived from external '
      + 'signal, 4 .. output static low, 5 .. output static '
      + 'high","minimum":0},"input_usage":{"type":"integer","description":"0 ..'
      + ' deactivated, 1 .. just detecting and timestamping","minimum":0},"ext_'
      + 'delay":{"type":"integer","description":"external trigger, time delay '
      + '[0.1 msec]","minimum":0},"num_channel":{"type":"integer","description"'
      + ':"number of input/output channels","minimum":0}},"$schema":"http://jso'
      + 'n-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"out_delay":0,"ext_bitmask":0,"ext_signal":0,"out_interval":10000,"ou'
      + 't_num_pulses":1,"dmi_dist_per_tick":0.0,"dmi_min_time":0,"ext_subdivid'
      + 'er":1,"in_min_duration":0,"out_polarity":0,"in_max_delay":9990,"dmi_ma'
      + 'x_time":0,"ttip_version":1,"in_max_duration":10000,"out_duration":300,'
      + '"dmi_incr":0,"ext_channel":32,"input_descr":"Port 1 - '
      + 'Exposure","output_descr":"Port 1 - Trigger","in_polarity":0,"channel":'
      + '0,"output_usage":1,"input_usage":1,"ext_delay":0,"num_channel":9}'
    );
  );

// Details about vertex file
const
  RDB_RIEGL_VERTEX_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.vertex_info';
    Title       : 'Vertex Information';
    Description : 'Details about vertex file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"De'
      + 'tails about vertex file","properties":{"vertex_file":{"required":["fil'
      + 'e_extension"],"type":"object","properties":{"file_uuid":{"type":"strin'
      + 'g","description":"File''s Universally Unique Identifier (RFC '
      + '4122)"},"file_extension":{"type":"string","description":"Vertex file '
      + 'extension, without the leading dot"}}}},"title":"Vertex '
      + 'Information","type":"object"}'
    );

    Example : (''
      + '{"vertex_file":{"file_uuid":"51534d95-d71f-4f36-ae1a-3e63a21fd1c7","fi'
      + 'le_extension":"vtx"}}'
    );
  );

// Details about the voxels contained in the file
const
  RDB_RIEGL_VOXEL_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.voxel_info';
    Title       : 'Voxel Information';
    Description : 'Details about the voxels contained in the file';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"type":"object","description":"Details about the voxels contained in '
      + 'the file","title":"Voxel Information","definitions":{"voxel_size_cubic'
      + '":{"$ref":"#/definitions/edge_length","type":"number"},"voxel_origin_e'
      + 'num":{"description":"Defines whether the voxel''s center or a corner is'
      + ' placed on CRS origin <tt>(0/0/0)</tt>.","enum":["center","corner"],"d'
      + 'efault":"corner"},"edge_length":{"type":"number","description":"Length'
      + ' of voxel edge [m].","minimum":0,"exclusiveMinimum":true},"voxel_size"'
      + ':{"maxItems":3,"type":"array","items":{"$ref":"#/definitions/edge_leng'
      + 'th"},"minItems":3,"description":"Size of '
      + 'voxels."},"voxel_type":{"description":"Whether a point in a voxel '
      + 'represents its center or its centroid. If type is <tt>index</tt> there'
      + ' is no point but only an integer voxel index.","enum":["center","centr'
      + 'oid","index"],"default":"centroid"},"shape_thresholds":{"required":["p'
      + 'lane","line"],"type":"object","description":"Thresholds used to '
      + 'compute the voxel''s shape_id '
      + 'value.","properties":{"plane":{"type":"number","description":"If the '
      + 'smallest eigenvalue is smaller than the median eigenvalue * '
      + 'plane_threshold, the voxel is considered a plane.","minimum":0,"exclus'
      + 'iveMinimum":true,"exclusiveMaximum":true,"maximum":1},"line":{"type":"'
      + 'number","description":"If the biggest eigenvalue is bigger than the '
      + 'median eigenvalue * line_threshold, the voxel is considered a line.","'
      + 'minimum":1,"exclusiveMinimum":true}}},"voxel_origin_point":{"maxItems"'
      + ':3,"type":"array","description":"Origin point for all voxel indices in'
      + ' voxel CRS.","minItems":3,"items":{"type":"number"}}},"oneOf":[{"requi'
      + 'red":["size","voxel_origin","voxel_type"],"additionalProperties":false'
      + ',"properties":{"voxel_origin":{"$ref":"#/definitions/voxel_origin_enum'
      + '"},"voxel_type":{"$ref":"#/definitions/voxel_type"},"size":{"oneOf":[{'
      + '"$ref":"#/definitions/voxel_size"},{"$ref":"#/definitions/voxel_size_c'
      + 'ubic"}],"description":"Size of voxels in file coordinate system."},"sh'
      + 'ape_thresholds":{"$ref":"#/definitions/shape_thresholds"}}},{"required'
      + '":["reference_point","size_llcs","size","voxel_origin","voxel_type"],"'
      + 'additionalProperties":false,"properties":{"voxel_origin":{"oneOf":[{"$'
      + 'ref":"#/definitions/voxel_origin_enum"},{"$ref":"#/definitions/voxel_o'
      + 'rigin_point","description":"The base point of the voxel grid. Used '
      + 'together with <tt>voxel_size</tt> and <tt>voxel_index</tt> to compute '
      + 'actual point coordinates."}]},"voxel_type":{"$ref":"#/definitions/voxe'
      + 'l_type"},"size_llcs":{"$ref":"#/definitions/voxel_size","description":'
      + '"Size of voxels in a locally levelled cartesian coordinate system '
      + '(xyz). This is only used for voxels based on a map projection."},"size'
      + '":{"$ref":"#/definitions/voxel_size","description":"Size of voxels in '
      + 'file coordinate system."},"reference_point":{"maxItems":2,"type":"arra'
      + 'y","items":{"type":"number","minimum":-180,"maximum":180},"minItems":2'
      + ',"description":"Point in WGS84 geodetic decimal degree (EPSG:4326) '
      + 'that was used to compute the projection distortion parameters. The '
      + 'coefficient order is latitude, longitude. Only voxels with '
      + 'corresponding geo_tag, voxel_size and reference_point can be reliably '
      + 'processed together. This entry is available for voxel files in '
      + 'projected CRS only."},"shape_thresholds":{"$ref":"#/definitions/shape_'
      + 'thresholds"}}}],"$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"voxel_origin":"corner","voxel_type":"centroid","size_llcs":[0.515657'
      + '5252891171,0.5130835356683303,0.5143705304787237],"size":[0.5971642834'
      + '779395,0.5971642834779395,0.5143705304787237],"reference_point":[48,16'
      + '],"shape_thresholds":{"plane":0.16,"line":6}}'
    );
  );

// Settings for waveform averaging
const
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.waveform_averaging_settings';
    Title       : 'Waveform Averaging Settings';
    Description : 'Settings for waveform averaging';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["num_shots","mta_zone"],"type":"object","description":"Se'
      + 'ttings for waveform averaging","title":"Waveform Averaging Settings","'
      + 'properties":{"mta_zone":{"type":"integer","description":"Fixed MTA '
      + 'zone for averaging.","minimum":1},"trim":{"type":"number","description'
      + '":"Percentage for robust averaging.","minimum":0,"maximum":0.5,"defaul'
      + 't":0},"num_shots":{"type":"integer","description":"Number of '
      + 'consecutive shots to be used for averaging.","minimum":1}},"$schema":"'
      + 'http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"mta_zone":1,"trim":0.05,"num_shots":7}'
    );
  );

// Details about waveform files
const
  RDB_RIEGL_WAVEFORM_INFO : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.waveform_info';
    Title       : 'Waveform Information';
    Description : 'Details about waveform files';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["sample_block_file","sample_data_files"],"type":"object",'
      + '"description":"Details about waveform files","properties":{"sample_dat'
      + 'a_files":{"type":"array","items":{"required":["channel","channel_name"'
      + ',"sample_interval","sample_bits","laser_wavelength","delta_st","file_e'
      + 'xtension"],"type":"object","properties":{"channel":{"type":"integer","'
      + 'description":"Sample block channel number (255 = invalid)","minimum":0'
      + ',"exclusiveMinimum":false,"exclusiveMaximum":false,"maximum":255},"cha'
      + 'nnel_name":{"type":"string","description":"Sample block channel '
      + 'name"},"sample_bits":{"type":"integer","description":"Bitwidth of '
      + 'samples (e.g. 10 bit, 12 bit)","minimum":0,"exclusiveMinimum":false,"e'
      + 'xclusiveMaximum":false,"maximum":32},"sample_interval":{"type":"number'
      + '","description":"Sampling interval in seconds","minimum":0,"exclusiveM'
      + 'inimum":false},"laser_wavelength":{"type":"number","description":"Lase'
      + 'r wavelength in meters (0 = unknown)","minimum":0,"exclusiveMinimum":f'
      + 'alse},"file_extension":{"type":"string","description":"Sample data '
      + 'file extension, without the leading '
      + 'dot"},"file_uuid":{"type":"string","description":"File''s Universally '
      + 'Unique Identifier (RFC 4122)"},"delta_st":{"type":"number","descriptio'
      + 'n":"reserved"}}}},"range_offset_m":{"type":"number","description":"Cal'
      + 'ibrated device specific range offset for waveform analysis by system '
      + 'response fitting in meters."},"range_offset_waveform_samples_m":{"type'
      + '":"number","description":"Calibrated device specific range offset for '
      + 'waveform samples in meters."},"sample_block_file":{"required":["file_e'
      + 'xtension"],"type":"object","properties":{"file_uuid":{"type":"string",'
      + '"description":"File''s Universally Unique Identifier (RFC '
      + '4122)"},"file_extension":{"type":"string","description":"Sample block '
      + 'file extension, without the leading dot"}}}},"title":"Waveform '
      + 'Information","$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"sample_data_files":[{"channel":0,"channel_name":"high_power","sample'
      + '_bits":12,"sample_interval":1.00503e-09,"laser_wavelength":0,"delta_st'
      + '":0,"file_extension":"sp0","file_uuid":"da084413-e3e8-4655-a122-071de8'
      + '490d8e"},{"channel":1,"channel_name":"low_power","sample_bits":12,"sam'
      + 'ple_interval":1.00503e-09,"laser_wavelength":0,"delta_st":0,"file_exte'
      + 'nsion":"sp1","file_uuid":"93585b5e-5ea9-43a1-947b-e7ba3be642d2"},{"cha'
      + 'nnel":5,"channel_name":"wwf","sample_bits":12,"sample_interval":1.0050'
      + '3e-09,"laser_wavelength":0,"delta_st":0,"file_extension":"sp5","file_u'
      + 'uid":"9d2298c4-1036-464f-b5cb-1cf8e517f3a0"}],"range_offset_m":3.1415,'
      + '"range_offset_waveform_samples_m ":7.283,"sample_block_file":{"file_uu'
      + 'id":"93a03615-66c0-4bea-8ff8-c577378fe660","file_extension":"sbx"}}'
    );
  );

// Scanner settings for waveform output
const
  RDB_RIEGL_WAVEFORM_SETTINGS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.waveform_settings';
    Title       : 'Waveform Settings';
    Description : 'Scanner settings for waveform output';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"$schema":"http://json-schema.org/draft-04/schema#","description":"Sc'
      + 'anner settings for waveform output","items":{"required":["sbl_name","e'
      + 'nabled","channel_idx_mask"],"type":"object","properties":{"pass_rng_le'
      + 'ss":{"type":"number","description":"Threshold for range less than '
      + '[m]"},"pass_dev_less":{"type":"integer","description":"Threshold for '
      + 'deviation less than '
      + '[1]"},"sbl_name":{"type":"string","description":"Name of sample block,'
      + ' e.g.: wfm, '
      + 'wwf"},"logic_expression":{"type":"string","description":"Logic '
      + 'expression of smart waveforms '
      + 'filter"},"enabled":{"type":"boolean","description":"Waveform output '
      + 'enabled"},"pass_rng_greater":{"type":"number","description":"Threshold'
      + ' for range greater than '
      + '[m]"},"pass_dev_greater":{"type":"integer","description":"Threshold '
      + 'for deviation greater than '
      + '[1]"},"pass_ampl_greater":{"type":"number","description":"Threshold '
      + 'for amplitude greater than '
      + '[dB]"},"smart_enabled":{"type":"boolean","description":"Smart waveform'
      + ' output '
      + 'enabled"},"channel_idx_mask":{"type":"integer","description":"Bit mask'
      + ' for channels which belong to sbl_name: Channel 0 = Bit0, Channel 1 = '
      + 'Bit1, ..."},"pass_ampl_less":{"type":"number","description":"Threshold'
      + ' for amplitude less than [dB]"}}},"title":"Waveform '
      + 'Settings","type":"array"}'
    );

    Example : (''
      + '[{"pass_rng_less":13.11,"sbl_name":"wfm","enabled":true,"pass_rng_grea'
      + 'ter":9.27,"pass_ampl_greater":1.0,"smart_enabled":true,"channel_idx_ma'
      + 'sk":11,"pass_ampl_less":5.0},{"sbl_name":"wwf","enabled":false,"channe'
      + 'l_idx_mask":32}]'
    );
  );

// Window analysis data estimated from scandata and resulting filter parameters
const
  RDB_RIEGL_WINDOW_ANALYSIS : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.window_analysis';
    Title       : 'Window Analysis';
    Description : 'Window analysis data estimated from scandata and resulting filter parameters';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["result","filter","settings"],"type":"object","descriptio'
      + 'n":"Window analysis data estimated from scandata and resulting filter '
      + 'parameters","title":"Window Analysis","properties":{"result":{"require'
      + 'd":["angle","range_mean","range_sigma","amplitude_mean","amplitude_sig'
      + 'ma","amplitude_offset"],"type":"object","properties":{"range_sigma":{"'
      + 'type":"array","items":{"type":"number"},"description":"[m]"},"amplitud'
      + 'e_sigma":{"type":"array","items":{"type":"number"},"description":"[dB]'
      + '"},"range_mean":{"type":"array","items":{"type":"number"},"description'
      + '":"[m]"},"amplitude_offset":{"type":"array","items":{"type":"number"},'
      + '"description":"[dB]"},"amplitude_mean":{"type":"array","items":{"type"'
      + ':"number"},"description":"[dB]"},"timestamp":{"type":"array","items":{'
      + '"type":"number"},"description":"[s]"},"angle":{"type":"array","items":'
      + '{"type":"number"},"description":"[deg]"}}},"filter":{"required":["angl'
      + 'e","range_min","range_max","amplitude_max"],"type":"object","propertie'
      + 's":{"amplitude_max":{"type":"array","items":{"type":"number"},"descrip'
      + 'tion":"[dB]"},"range_min":{"type":"array","items":{"type":"number"},"d'
      + 'escription":"[m]"},"angle":{"type":"array","items":{"type":"number"},"'
      + 'description":"[deg]"},"range_max":{"type":"array","items":{"type":"num'
      + 'ber"},"description":"[m]"}}},"settings":{"required":["range","amplitud'
      + 'e"],"type":"object","properties":{"range":{"required":["sigma_factor",'
      + '"additive_value"],"type":"object","properties":{"sigma_factor":{"type"'
      + ':"number"},"additive_value":{"type":"number"}}},"amplitude":{"required'
      + '":["sigma_factor","additive_value"],"type":"object","properties":{"sig'
      + 'ma_factor":{"type":"number"},"additive_value":{"type":"number"}}}}}},"'
      + '$schema":"http://json-schema.org/draft-04/schema#"}'
    );

    Example : (''
      + '{"result":{"range_sigma":[0.01869652,0.02151435,0.01747969,0.01918765,'
      + '0.01945776,0.01934862,0.01955329,0.02225589,0.02229977,0.01899122,0.02'
      + '009433],"amplitude_sigma":[0.4272844,0.4298479,0.4236816,0.4283583,0.4'
      + '362353,0.4315141,0.4373984,0.4472798,0.4346001,0.4345487,0.4540681],"r'
      + 'ange_mean":[0.1105621,0.1079564,0.1087088,0.1067261,0.1054582,0.109041'
      + '2,0.102871,0.1019044,0.1051523,0.1058445,0.1031261],"amplitude_offset"'
      + ':[1.9,1.9],"amplitude_mean":[5.347396,5.263155,5.224655,5.179926,5.097'
      + '782,5.116479,5.051756,4.983473,5.007885,5.002441,4.982],"timestamp":[4'
      + '08.4441,411.4443],"angle":[14.9,15.0,15.1,15.2,15.3,15.4,15.5,15.6,15.'
      + '7,15.8,15.9]},"filter":{"amplitude_max":[8.04,8.01,7.99,7.96,7.93,7.9,'
      + '7.88,7.85,7.83,7.8,7.78],"range_min":[-0.208,-0.21,-0.212,-0.214,-0.21'
      + '6,-0.218,-0.219,-0.221,-0.223,-0.225,-0.227],"angle":[14.9,15.0,15.1,1'
      + '5.2,15.3,15.4,15.5,15.6,15.7,15.8,15.9],"range_max":[0.424,0.425,0.426'
      + ',0.427,0.428,0.428,0.429,0.43,0.431,0.431,0.432]},"settings":{"range":'
      + '{"sigma_factor":8,"additive_value":0.1},"amplitude":{"sigma_factor":4,'
      + '"additive_value":1.0}}}'
    );
  );

// Correction parameters for window glass echoes
const
  RDB_RIEGL_WINDOW_ECHO_CORRECTION : TRDBPointcloudMetaDataItemInfo = (
    Name        : 'riegl.window_echo_correction';
    Title       : 'Window Echo Correction';
    Description : 'Correction parameters for window glass echoes';
    Status      : RDB_STATUS_OPTIONAL;

    Schema : (''
      + '{"required":["amplitude","range","slices"],"type":"object","descriptio'
      + 'n":"Correction parameters for window glass echoes","title":"Window '
      + 'Echo Correction","properties":{"range":{"required":["minimum","maximum'
      + '","entries"],"type":"object","description":"Range axis of correction '
      + 'table","properties":{"entries":{"type":"integer","description":"Number'
      + ' of range entries","minimum":1},"minimum":{"type":"number","descriptio'
      + 'n":"Minimum range in m","minimum":-2.0,"maximum":2.0},"maximum":{"type'
      + '":"number","description":"Maximum range in m","minimum":-2.0,"maximum"'
      + ':2.0}}},"slices":{"type":"array","items":{"required":["amplitude","tab'
      + 'le"],"type":"object","description":"Window echo correction parameter '
      + 'slice","properties":{"table":{"type":"array","description":"Correction'
      + ' table (dimension defined by the ''amplitude'' and ''range'' '
      + 'objects)","minItems":1,"items":{"type":"array","description":"Table '
      + 'row (= amplitude axis)","minItems":1,"items":{"maxItems":3,"type":"arr'
      + 'ay","description":"Table column (= range '
      + 'axis)","minItems":3,"items":{"type":"number","description":"Table cell'
      + ' (item 0: amplitude in dB, 1: range in m, 2: '
      + 'flags)"}}}},"amplitude":{"type":"number","description":"Window echo '
      + 'amplitude of slice in dB"}}}},"amplitude":{"required":["minimum","maxi'
      + 'mum","entries"],"type":"object","description":"Amplitude axis of '
      + 'correction '
      + 'table","properties":{"entries":{"type":"integer","description":"Number'
      + ' of amplitude entries","minimum":1},"minimum":{"type":"number","descri'
      + 'ption":"Minimum amplitude in '
      + 'dB","minimum":0.0},"maximum":{"type":"number","description":"Maximum '
      + 'amplitude in dB","minimum":0.0}}}},"$schema":"http://json-schema.org/d'
      + 'raft-04/schema#"}'
    );

    Example : (''
      + '{"range":{"entries":128,"minimum":-1.5060822940732335,"maximum":1.5060'
      + '822940732335},"slices":[{"table":[[[6.23,0.3535,1]],[[5.54,0.72375,1]]'
      + '],"amplitude":1.5},{"table":[[[6.23,0.3535,1]],[[5.54,0.72375,1]]],"am'
      + 'plitude":2.0}],"amplitude":{"entries":128,"minimum":2,"maximum":20}}'
    );
  );

// Table of all meta data item details records
const
  RDB_META_DATA_ITEMS : array of PRDBPointcloudMetaDataItemInfo = nil; // filled during initialization

implementation

procedure FixStringEncoding;
begin
  // As the unit (.pas file) doesn't contain a BOM, we need to convert all strings
  // from UTF-8 to "native" encoding at runtime (tested on Delphi 7 and Delphi XE5)

  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Name)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Title)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Description)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Schema)));
  RDB_RIEGL_ANGULAR_NOTCH_FILTER.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ANGULAR_NOTCH_FILTER.Example)));

  RDB_RIEGL_ATMOSPHERE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Name)));
  RDB_RIEGL_ATMOSPHERE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Title)));
  RDB_RIEGL_ATMOSPHERE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Description)));
  RDB_RIEGL_ATMOSPHERE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Schema)));
  RDB_RIEGL_ATMOSPHERE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ATMOSPHERE.Example)));

  RDB_RIEGL_BEAM_GEOMETRY.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Name)));
  RDB_RIEGL_BEAM_GEOMETRY.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Title)));
  RDB_RIEGL_BEAM_GEOMETRY.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Description)));
  RDB_RIEGL_BEAM_GEOMETRY.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Schema)));
  RDB_RIEGL_BEAM_GEOMETRY.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_BEAM_GEOMETRY.Example)));

  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Name)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Title)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Description)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Schema)));
  RDB_RIEGL_CONTROL_OBJECT_CATALOG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_CATALOG.Example)));

  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Name)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Title)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Description)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Schema)));
  RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE.Example)));

  RDB_RIEGL_DETECTION_PROBABILITY.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Name)));
  RDB_RIEGL_DETECTION_PROBABILITY.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Title)));
  RDB_RIEGL_DETECTION_PROBABILITY.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Description)));
  RDB_RIEGL_DETECTION_PROBABILITY.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Schema)));
  RDB_RIEGL_DETECTION_PROBABILITY.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DETECTION_PROBABILITY.Example)));

  RDB_RIEGL_DEVICE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Name)));
  RDB_RIEGL_DEVICE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Title)));
  RDB_RIEGL_DEVICE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Description)));
  RDB_RIEGL_DEVICE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Schema)));
  RDB_RIEGL_DEVICE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE.Example)));

  RDB_RIEGL_DEVICE_GEOMETRY.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Name)));
  RDB_RIEGL_DEVICE_GEOMETRY.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Title)));
  RDB_RIEGL_DEVICE_GEOMETRY.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Description)));
  RDB_RIEGL_DEVICE_GEOMETRY.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Schema)));
  RDB_RIEGL_DEVICE_GEOMETRY.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY.Example)));

  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Name)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Title)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Description)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Schema)));
  RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL.Example)));

  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Name)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Title)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Description)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Schema)));
  RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICE_OUTPUT_LIMITS.Example)));

  RDB_RIEGL_DEVICES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Name)));
  RDB_RIEGL_DEVICES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Title)));
  RDB_RIEGL_DEVICES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Description)));
  RDB_RIEGL_DEVICES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Schema)));
  RDB_RIEGL_DEVICES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DEVICES.Example)));

  RDB_RIEGL_DMI_CONFIG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Name)));
  RDB_RIEGL_DMI_CONFIG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Title)));
  RDB_RIEGL_DMI_CONFIG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Description)));
  RDB_RIEGL_DMI_CONFIG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Schema)));
  RDB_RIEGL_DMI_CONFIG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DMI_CONFIG.Example)));

  RDB_RIEGL_DYNTRIG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Name)));
  RDB_RIEGL_DYNTRIG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Title)));
  RDB_RIEGL_DYNTRIG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Description)));
  RDB_RIEGL_DYNTRIG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Schema)));
  RDB_RIEGL_DYNTRIG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_DYNTRIG.Example)));

  RDB_RIEGL_ECHO_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Name)));
  RDB_RIEGL_ECHO_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Title)));
  RDB_RIEGL_ECHO_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Description)));
  RDB_RIEGL_ECHO_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Schema)));
  RDB_RIEGL_ECHO_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ECHO_INFO.Example)));

  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Name)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Title)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Description)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Schema)));
  RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_EXPONENTIAL_DECOMPOSITION.Example)));

  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Name)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Title)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Description)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Schema)));
  RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GAUSSIAN_DECOMPOSITION.Example)));

  RDB_RIEGL_GEO_TAG.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Name)));
  RDB_RIEGL_GEO_TAG.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Title)));
  RDB_RIEGL_GEO_TAG.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Description)));
  RDB_RIEGL_GEO_TAG.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Schema)));
  RDB_RIEGL_GEO_TAG.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEO_TAG.Example)));

  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Name)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Title)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Description)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Schema)));
  RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOMETRIC_SCALE_FACTOR.Example)));

  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Name)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Title)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Description)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Schema)));
  RDB_RIEGL_GEOREFERENCING_PARAMETERS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GEOREFERENCING_PARAMETERS.Example)));

  RDB_RIEGL_GNSS_PROCESSING_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Name)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Title)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Description)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Schema)));
  RDB_RIEGL_GNSS_PROCESSING_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_GNSS_PROCESSING_INFO.Example)));

  RDB_RIEGL_ITEM_NAMES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Name)));
  RDB_RIEGL_ITEM_NAMES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Title)));
  RDB_RIEGL_ITEM_NAMES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Description)));
  RDB_RIEGL_ITEM_NAMES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Schema)));
  RDB_RIEGL_ITEM_NAMES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_ITEM_NAMES.Example)));

  RDB_RIEGL_LAG_ANGLE_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Name)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Title)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Description)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Schema)));
  RDB_RIEGL_LAG_ANGLE_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LAG_ANGLE_CORRECTION.Example)));

  RDB_RIEGL_LICENSES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Name)));
  RDB_RIEGL_LICENSES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Title)));
  RDB_RIEGL_LICENSES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Description)));
  RDB_RIEGL_LICENSES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Schema)));
  RDB_RIEGL_LICENSES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_LICENSES.Example)));

  RDB_RIEGL_MTA_SETTINGS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Name)));
  RDB_RIEGL_MTA_SETTINGS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Title)));
  RDB_RIEGL_MTA_SETTINGS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Description)));
  RDB_RIEGL_MTA_SETTINGS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Schema)));
  RDB_RIEGL_MTA_SETTINGS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_MTA_SETTINGS.Example)));

  RDB_RIEGL_NEAR_RANGE_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Name)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Title)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Description)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Schema)));
  RDB_RIEGL_NEAR_RANGE_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NEAR_RANGE_CORRECTION.Example)));

  RDB_RIEGL_NOISE_ESTIMATES.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Name)));
  RDB_RIEGL_NOISE_ESTIMATES.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Title)));
  RDB_RIEGL_NOISE_ESTIMATES.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Description)));
  RDB_RIEGL_NOISE_ESTIMATES.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Schema)));
  RDB_RIEGL_NOISE_ESTIMATES.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOISE_ESTIMATES.Example)));

  RDB_RIEGL_NOTCH_FILTER.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Name)));
  RDB_RIEGL_NOTCH_FILTER.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Title)));
  RDB_RIEGL_NOTCH_FILTER.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Description)));
  RDB_RIEGL_NOTCH_FILTER.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Schema)));
  RDB_RIEGL_NOTCH_FILTER.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_NOTCH_FILTER.Example)));

  RDB_RIEGL_PIXEL_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Name)));
  RDB_RIEGL_PIXEL_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Title)));
  RDB_RIEGL_PIXEL_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Description)));
  RDB_RIEGL_PIXEL_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Schema)));
  RDB_RIEGL_PIXEL_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PIXEL_INFO.Example)));

  RDB_RIEGL_PLANE_PATCH_MATCHING.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Name)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Title)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Description)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Schema)));
  RDB_RIEGL_PLANE_PATCH_MATCHING.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_MATCHING.Example)));

  RDB_RIEGL_PLANE_PATCH_STATISTICS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Name)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Title)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Description)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Schema)));
  RDB_RIEGL_PLANE_PATCH_STATISTICS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_PATCH_STATISTICS.Example)));

  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Name)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Title)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Description)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Schema)));
  RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PLANE_SLOPE_CLASS_INFO.Example)));

  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Name)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Title)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Description)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Schema)));
  RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINT_ATTRIBUTE_GROUPS.Example)));

  RDB_RIEGL_POINTCLOUD_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Name)));
  RDB_RIEGL_POINTCLOUD_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Title)));
  RDB_RIEGL_POINTCLOUD_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Description)));
  RDB_RIEGL_POINTCLOUD_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Schema)));
  RDB_RIEGL_POINTCLOUD_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POINTCLOUD_INFO.Example)));

  RDB_RIEGL_POSE_ESTIMATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Name)));
  RDB_RIEGL_POSE_ESTIMATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Title)));
  RDB_RIEGL_POSE_ESTIMATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Description)));
  RDB_RIEGL_POSE_ESTIMATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Schema)));
  RDB_RIEGL_POSE_ESTIMATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_ESTIMATION.Example)));

  RDB_RIEGL_POSE_SENSORS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Name)));
  RDB_RIEGL_POSE_SENSORS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Title)));
  RDB_RIEGL_POSE_SENSORS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Description)));
  RDB_RIEGL_POSE_SENSORS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Schema)));
  RDB_RIEGL_POSE_SENSORS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_POSE_SENSORS.Example)));

  RDB_RIEGL_PULSE_POSITION_MODULATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Name)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Title)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Description)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Schema)));
  RDB_RIEGL_PULSE_POSITION_MODULATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_PULSE_POSITION_MODULATION.Example)));

  RDB_RIEGL_RANGE_STATISTICS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Name)));
  RDB_RIEGL_RANGE_STATISTICS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Title)));
  RDB_RIEGL_RANGE_STATISTICS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Description)));
  RDB_RIEGL_RANGE_STATISTICS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Schema)));
  RDB_RIEGL_RANGE_STATISTICS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RANGE_STATISTICS.Example)));

  RDB_RIEGL_RECEIVER_INTERNALS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Name)));
  RDB_RIEGL_RECEIVER_INTERNALS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Title)));
  RDB_RIEGL_RECEIVER_INTERNALS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Description)));
  RDB_RIEGL_RECEIVER_INTERNALS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Schema)));
  RDB_RIEGL_RECEIVER_INTERNALS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RECEIVER_INTERNALS.Example)));

  RDB_RIEGL_REFLECTANCE_CALCULATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Name)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Title)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Description)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Schema)));
  RDB_RIEGL_REFLECTANCE_CALCULATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CALCULATION.Example)));

  RDB_RIEGL_REFLECTANCE_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Name)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Title)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Description)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Schema)));
  RDB_RIEGL_REFLECTANCE_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_REFLECTANCE_CORRECTION.Example)));

  RDB_RIEGL_RILOC_PROCESSING_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Name)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Title)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Description)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Schema)));
  RDB_RIEGL_RILOC_PROCESSING_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_RILOC_PROCESSING_INFO.Example)));

  RDB_RIEGL_SCAN_PATTERN.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Name)));
  RDB_RIEGL_SCAN_PATTERN.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Title)));
  RDB_RIEGL_SCAN_PATTERN.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Description)));
  RDB_RIEGL_SCAN_PATTERN.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Schema)));
  RDB_RIEGL_SCAN_PATTERN.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SCAN_PATTERN.Example)));

  RDB_RIEGL_SHOT_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Name)));
  RDB_RIEGL_SHOT_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Title)));
  RDB_RIEGL_SHOT_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Description)));
  RDB_RIEGL_SHOT_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Schema)));
  RDB_RIEGL_SHOT_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SHOT_INFO.Example)));

  RDB_RIEGL_STORED_FILTERS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Name)));
  RDB_RIEGL_STORED_FILTERS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Title)));
  RDB_RIEGL_STORED_FILTERS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Description)));
  RDB_RIEGL_STORED_FILTERS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Schema)));
  RDB_RIEGL_STORED_FILTERS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_STORED_FILTERS.Example)));

  RDB_RIEGL_SYSTEM_DESCRIPTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Name)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Title)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Description)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Schema)));
  RDB_RIEGL_SYSTEM_DESCRIPTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_SYSTEM_DESCRIPTION.Example)));

  RDB_RIEGL_TEMPERATURE_CALCULATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Name)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Title)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Description)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Schema)));
  RDB_RIEGL_TEMPERATURE_CALCULATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TEMPERATURE_CALCULATION.Example)));

  RDB_RIEGL_TIME_BASE.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Name)));
  RDB_RIEGL_TIME_BASE.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Title)));
  RDB_RIEGL_TIME_BASE.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Description)));
  RDB_RIEGL_TIME_BASE.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Schema)));
  RDB_RIEGL_TIME_BASE.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TIME_BASE.Example)));

  RDB_RIEGL_TRAJECTORY_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Name)));
  RDB_RIEGL_TRAJECTORY_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Title)));
  RDB_RIEGL_TRAJECTORY_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Description)));
  RDB_RIEGL_TRAJECTORY_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Schema)));
  RDB_RIEGL_TRAJECTORY_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TRAJECTORY_INFO.Example)));

  RDB_RIEGL_TTIP_CONFIGURATION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Name)));
  RDB_RIEGL_TTIP_CONFIGURATION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Title)));
  RDB_RIEGL_TTIP_CONFIGURATION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Description)));
  RDB_RIEGL_TTIP_CONFIGURATION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Schema)));
  RDB_RIEGL_TTIP_CONFIGURATION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_TTIP_CONFIGURATION.Example)));

  RDB_RIEGL_VERTEX_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Name)));
  RDB_RIEGL_VERTEX_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Title)));
  RDB_RIEGL_VERTEX_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Description)));
  RDB_RIEGL_VERTEX_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Schema)));
  RDB_RIEGL_VERTEX_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VERTEX_INFO.Example)));

  RDB_RIEGL_VOXEL_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Name)));
  RDB_RIEGL_VOXEL_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Title)));
  RDB_RIEGL_VOXEL_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Description)));
  RDB_RIEGL_VOXEL_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Schema)));
  RDB_RIEGL_VOXEL_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_VOXEL_INFO.Example)));

  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Name)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Title)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Description)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Schema)));
  RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS.Example)));

  RDB_RIEGL_WAVEFORM_INFO.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Name)));
  RDB_RIEGL_WAVEFORM_INFO.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Title)));
  RDB_RIEGL_WAVEFORM_INFO.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Description)));
  RDB_RIEGL_WAVEFORM_INFO.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Schema)));
  RDB_RIEGL_WAVEFORM_INFO.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_INFO.Example)));

  RDB_RIEGL_WAVEFORM_SETTINGS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Name)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Title)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Description)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Schema)));
  RDB_RIEGL_WAVEFORM_SETTINGS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WAVEFORM_SETTINGS.Example)));

  RDB_RIEGL_WINDOW_ANALYSIS.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Name)));
  RDB_RIEGL_WINDOW_ANALYSIS.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Title)));
  RDB_RIEGL_WINDOW_ANALYSIS.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Description)));
  RDB_RIEGL_WINDOW_ANALYSIS.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Schema)));
  RDB_RIEGL_WINDOW_ANALYSIS.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ANALYSIS.Example)));

  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Name        := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Name)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Title       := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Title)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Description := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Description)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Schema      := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Schema)));
  RDB_RIEGL_WINDOW_ECHO_CORRECTION.Example     := String(UTF8ToAnsi(AnsiString(RDB_RIEGL_WINDOW_ECHO_CORRECTION.Example)));
end;

procedure FillMetadataArray;
var
  i : Integer;
begin
  SetLength(RDB_META_DATA_ITEMS, 56); i := -1;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ANGULAR_NOTCH_FILTER;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ATMOSPHERE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_BEAM_GEOMETRY;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_CONTROL_OBJECT_CATALOG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DETECTION_PROBABILITY;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE_GEOMETRY;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICE_OUTPUT_LIMITS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DEVICES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DMI_CONFIG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_DYNTRIG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ECHO_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_EXPONENTIAL_DECOMPOSITION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GAUSSIAN_DECOMPOSITION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GEO_TAG;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GEOMETRIC_SCALE_FACTOR;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GEOREFERENCING_PARAMETERS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_GNSS_PROCESSING_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_ITEM_NAMES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_LAG_ANGLE_CORRECTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_LICENSES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_MTA_SETTINGS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_NEAR_RANGE_CORRECTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_NOISE_ESTIMATES;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_NOTCH_FILTER;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PIXEL_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PLANE_PATCH_MATCHING;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PLANE_PATCH_STATISTICS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PLANE_SLOPE_CLASS_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POINT_ATTRIBUTE_GROUPS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POINTCLOUD_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POSE_ESTIMATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_POSE_SENSORS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_PULSE_POSITION_MODULATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_RANGE_STATISTICS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_RECEIVER_INTERNALS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_REFLECTANCE_CALCULATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_REFLECTANCE_CORRECTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_RILOC_PROCESSING_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_SCAN_PATTERN;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_SHOT_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_STORED_FILTERS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_SYSTEM_DESCRIPTION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TEMPERATURE_CALCULATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TIME_BASE;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TRAJECTORY_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_TTIP_CONFIGURATION;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_VERTEX_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_VOXEL_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WAVEFORM_INFO;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WAVEFORM_SETTINGS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WINDOW_ANALYSIS;
  Inc(i); RDB_META_DATA_ITEMS[i] := @RDB_RIEGL_WINDOW_ECHO_CORRECTION;
end;

initialization

FixStringEncoding;
FillMetadataArray;

end.
