/*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    library.hpp
 * \author  RIEGL LMS GmbH, Austria
 * \brief   RDB library management tools
 * \version 2020-04-08/AW: Initial version
 *
 * NOTE: Unless otherwise specified, the functions defined herein are only
 * available in "run-time linking" mode (i.e. when the RDB_RUNTIME_LINKING
 * option/macro is defined). In this mode, the library is not automatically
 * loaded on application startup and must be manually loaded by calling the
 * function riegl::rdb::library::load(). To use this mode on Linux, you must
 * link the library "libdl" to your application.
 *
 *******************************************************************************
 */

#ifndef RIEGL_RDB_LIBRARY_HPP
#define RIEGL_RDB_LIBRARY_HPP

//---< INCLUDES >---------------------------------------------------------------

#include <string>
#include "riegl/rdb.hpp"

//---< FUNCTIONS >--------------------------------------------------------------

namespace riegl {
namespace rdb {
namespace library {
#ifdef RDB_RUNTIME_LINKING

//______________________________________________________________________________
/*!
 * \brief Load library and resolve functions
 *
 * Call this function before using any of the other library functions.
 * If no filename is given, then the default library filename is used.
 * If the library is already loaded, this function does nothing. To load
 * a different library, unload the current library first.
 *
 * Throws an exception if the library was not loaded successfully.
 */
void load(const std::string &filename = "");

//______________________________________________________________________________
/*!
 * \brief Free library
 *
 * Optionally call this function to free the library. Subsequent
 * calls to other library functions will crash the application.
 * If the library is not loaded, this function does nothing.
 *
 * Throws an exception if the library was not freed successfully.
 */
void free();

#endif // RDB_RUNTIME_LINKING
}}} // namespace riegl::rdb::library

#endif // RIEGL_RDB_LIBRARY_HPP
