/*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    library.cpp
 * \author  RIEGL LMS GmbH, Austria
 * \brief   RDB library management tools
 * \version 2020-04-08/AW: Initial version
 *
 *******************************************************************************
 */

//---< INCLUDES >---------------------------------------------------------------

#include <stdexcept>

#include "riegl/rdb/library.c"
#include "riegl/rdb/library.hpp"

//---< FUNCTIONS >--------------------------------------------------------------

namespace riegl {
namespace rdb {
namespace library {
#ifdef RDB_RUNTIME_LINKING

void load(const std::string &fn)
{
    if (const RDBString message = rdb_library_load(fn.empty() ? 0 : fn.c_str()))
    {
        throw std::runtime_error(message);
    }
}

void free()
{
    if (const RDBString message = rdb_library_free())
    {
        throw std::runtime_error(message);
    }
}

#endif // RDB_RUNTIME_LINKING
}}} // namespace riegl::rdb::library
