/*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \author RIEGL LMS GmbH, Austria
 * \brief  Description of RIEGL RDB 2 database file contents
 *
 *  NOTE: All information in this file is preliminary, since the
 *        definition of the database schemas is not yet complete.
 *
 *******************************************************************************
 */

#ifndef RDB_6DC7FF98_C890_4397_90B3_45A2547A201F
#define RDB_6DC7FF98_C890_4397_90B3_45A2547A201F

#include <vector>
#include <string>
#include <cstdlib>
#include <cstdint>

namespace riegl {
namespace rdb {
namespace pointcloud {

// File schema version
const std::string RDB_SCHEMA_VERSION = "ffc879de";
const std::string RDB_SCHEMA_DATE = "2025-04-18";

// Schema for ".avg.fwa" files
const std::string RDB_SCHEMA_RIEGL_AVG_FWA(
    "{\"metadata\":[],\"extension\":\"avg.fwa\",\"identifier\":\"avg.fwa\",\"attribute"
    "s\":[\"riegl.id*\",\"riegl.amplitude\",\"riegl.gain\",\"riegl.raw_range\",\"rieg"
    "l.wfm_echo_time_offset\",\"riegl.wfm_sbl_id\",\"riegl.deviation?\",\"riegl.p"
    "ulse_width?\"]}"
);

// Schema for ".avg.sbx" files
const std::string RDB_SCHEMA_RIEGL_AVG_SBX(
    "{\"metadata\":[],\"extension\":\"avg.sbx\",\"identifier\":\"avg.sbx\",\"attribute"
    "s\":[\"riegl.id*\",\"riegl.wfm_sbl_channel\",\"riegl.wfm_sbl_mean\",\"riegl.wf"
    "m_sbl_std_dev\",\"riegl.wfm_sbl_time_offset\",\"riegl.wfm_sda_first\",\"rieg"
    "l.wfm_sda_count\"]}"
);

// Schema for ".avg.sidx" files
const std::string RDB_SCHEMA_RIEGL_AVG_SIDX(
    "{\"metadata\":[\"riegl.shot_info\",\"riegl.waveform_info\",\"riegl.echo_info?"
    "\",\"riegl.waveform_averaging_settings\"],\"extension\":\"avg.sidx\",\"identif"
    "ier\":\"avg.sidx\",\"attributes\":[\"riegl.id\",\"riegl.shot_timestamp_hr*\",\"r"
    "iegl.wfm_sbl_first\",\"riegl.wfm_sbl_count\",\"riegl.echo_first?\",\"riegl.e"
    "cho_count?\"]}"
);

// Schema for ".avg.sp{C}" files
const std::string RDB_SCHEMA_RIEGL_AVG_SPC(
    "{\"metadata\":[],\"extension\":\"avg.sp{C}\",\"identifier\":\"avg.sp{C}\",\"attri"
    "butes\":[\"riegl.id*\",\"riegl.wfm_sample_value\"]}"
);

// Schema for ".bsx" files
const std::string RDB_SCHEMA_RIEGL_BSX(
    "{\"metadata\":[\"riegl.time_base\"],\"extension\":\"bsx\",\"identifier\":\"bsx\",\""
    "attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.accelerometer_bi"
    "as\",\"riegl.accelerometer_scale\",\"riegl.gyroscope_bias\",\"riegl.gyroscop"
    "e_scale\"]}"
);

// Schema for ".cpx" files
const std::string RDB_SCHEMA_RIEGL_CPX(
    "{\"metadata\":[\"riegl.geo_tag\",\"riegl.control_object_catalog\",\"riegl.ite"
    "m_names\",\"riegl.imported_files\"],\"extension\":\"cpx\",\"identifier\":\"cpx\","
    "\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.xyz_accuracies\",\"riegl.co"
    "ntrol_object_type\",\"riegl.zenith_vector\",\"riegl.used_for_adjustment\",\""
    "riegl.acquisition_date?\",\"riegl.cp_surface_inclination_angle\",\"riegl.c"
    "p_surface_inclination_tolerance_angle\",\"riegl.cp_surface_northing_angl"
    "e?\",\"riegl.cp_surface_northing_tolerance_angle?\",\"riegl.cp_search_radi"
    "us?\",\"riegl.cp_maximum_distance?\",\"riegl.import_line_number\"]}"
);

// Schema for ".cyl" files
const std::string RDB_SCHEMA_RIEGL_CYL(
    "{\"metadata\":[\"riegl.geo_tag\"],\"extension\":\"cyl\",\"identifier\":\"cyl\",\"at"
    "tributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.cylinder_axis_direction\",\"ri"
    "egl.cylinder_radius\",\"riegl.cylinder_height\",\"riegl.cylinder_radius_co"
    "nfidence\",\"riegl.cylinder_direction_confidence\",\"riegl.std_dev\"]}"
);

// Schema for ".dmix" files
const std::string RDB_SCHEMA_RIEGL_DMIX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.dmi_config\",\"riegl.time_base\"],\"ex"
    "tension\":\"dmix\",\"identifier\":\"dmix\",\"attributes\":[\"riegl.id\",\"riegl.dm"
    "i_count\",\"riegl.dmi_path_length_raw\",\"riegl.pof_timestamp*\"]}"
);

// Schema for ".doix" files
const std::string RDB_SCHEMA_RIEGL_DOIX(
    "{\"metadata\":[],\"extension\":\"doix\",\"identifier\":\"doix\",\"attributes\":[\"r"
    "iegl.id\",\"riegl.shot_origin\",\"riegl.shot_direction*\",\"riegl.scan_line_"
    "index\",\"riegl.shot_index_line\"]}"
);

// Schema for ".eifx" files
const std::string RDB_SCHEMA_RIEGL_EIFX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.time_base\",\"riegl.ttip_configurati"
    "on?\"],\"extension\":\"eifx\",\"identifier\":\"eifx\",\"attributes\":[\"riegl.id\","
    "\"riegl.event_timestamp*\",\"riegl.event_index?\",\"riegl.event_pulse_width"
    "?\",\"riegl.event_fake_pulse?\",\"riegl.raw_line_angle?\",\"riegl.raw_frame_"
    "angle?\"]}"
);

// Schema for ".epfx" files
const std::string RDB_SCHEMA_RIEGL_EPFX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.time_base\",\"riegl."
    "ttip_configuration?\"],\"extension\":\"epfx\",\"identifier\":\"epfx\",\"attribut"
    "es\":[\"riegl.id\",\"riegl.event_timestamp*\",\"riegl.event_index?\",\"riegl.e"
    "vent_pulse_width?\",\"riegl.event_fake_pulse?\",\"riegl.raw_line_angle?\",\""
    "riegl.raw_frame_angle?\",\"riegl.xyz\",\"riegl.model_cs_axis_x\",\"riegl.mod"
    "el_cs_axis_y\",\"riegl.model_cs_axis_z\"]}"
);

// Schema for ".fwa" files
const std::string RDB_SCHEMA_RIEGL_FWA(
    "{\"metadata\":[],\"extension\":\"fwa\",\"identifier\":\"fwa\",\"attributes\":[\"rie"
    "gl.id*\",\"riegl.amplitude\",\"riegl.gain\",\"riegl.raw_range\",\"riegl.wfm_ec"
    "ho_time_offset\",\"riegl.wfm_sbl_id\",\"riegl.deviation?\",\"riegl.pulse_wid"
    "th?\",\"riegl.extinction?\",\"riegl.svb_amplitude_volumetric?\",\"riegl.svb_"
    "attenuation_volumetric?\",\"riegl.svb_target_attenuation_coefficient_vol"
    "umetric?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\",\"riegl.svb_path_len"
    "gth?\"]}"
);

// Schema for ".imux" files
const std::string RDB_SCHEMA_RIEGL_IMUX(
    "{\"metadata\":[\"riegl.device\",\"riegl.time_base\",\"riegl.riloc_sensor_info"
    "rmation\",\"riegl.rxp_json_parameter_1\"],\"extension\":\"imux\",\"identifier\""
    ":\"imux\",\"attributes\":[\"riegl.id\",\"riegl.timestamp*\",\"riegl.temperature"
    "\",\"riegl.accelerometer\",\"riegl.gyroscope\",\"riegl.accelerometer_raw\",\"r"
    "iegl.gyroscope_raw\",\"riegl.magnetic_field_sensor_raw\",\"riegl.frame_ang"
    "le_coarse\",\"riegl.line_angle_coarse\",\"riegl.frame_scan_active\",\"riegl."
    "data_acquisition_active\",\"riegl.barometric_height_amsl\"]}"
);

// Schema for ".llhx" files
const std::string RDB_SCHEMA_RIEGL_LLHX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.time_base\"],\"exten"
    "sion\":\"llhx\",\"identifier\":\"llhx\",\"attributes\":[\"riegl.pof_latitude\",\"r"
    "iegl.pof_longitude\",\"riegl.pof_height\",\"riegl.pof_timestamp*\",\"riegl.p"
    "of_accuracy_north\",\"riegl.pof_accuracy_east\",\"riegl.pof_accuracy_down\""
    ",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_age_of_"
    "corrections\",\"riegl.pof_baseline_length\",\"riegl.pof_solution_gnss\",\"ri"
    "egl.pof_satellites_gnss\",\"riegl.id\"]}"
);

// Schema for ".llhx" files
const std::string RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.time_base\"],\"exten"
    "sion\":\"llhx\",\"identifier\":\"trajectory.llhx\",\"attributes\":[\"riegl.id\",\""
    "riegl.pof_timestamp*\",\"riegl.pof_latitude\",\"riegl.pof_longitude\",\"rieg"
    "l.pof_height\",\"riegl.pof_accuracy_north\",\"riegl.pof_accuracy_east\",\"ri"
    "egl.pof_accuracy_down\",\"riegl.pof_accuracy_north_east?\",\"riegl.pof_acc"
    "uracy_east_down?\",\"riegl.pof_accuracy_down_north?\",\"riegl.pof_velocity"
    "_ned?\",\"riegl.pof_velocity_accuracy_north?\",\"riegl.pof_velocity_accura"
    "cy_east?\",\"riegl.pof_velocity_accuracy_down?\",\"riegl.pof_velocity_accu"
    "racy_north_east?\",\"riegl.pof_velocity_accuracy_east_down?\",\"riegl.pof_"
    "velocity_accuracy_down_north?\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"rieg"
    "l.pof_vdop\",\"riegl.pof_age_of_corrections?\",\"riegl.pof_baseline_length"
    "?\",\"riegl.pof_solution_gnss\",\"riegl.pof_satellites_gnss\",\"riegl.pof_pa"
    "th_length?\"]}"
);

// Schema for ".mpx" files
const std::string RDB_SCHEMA_RIEGL_MPX(
    "{\"metadata\":[\"riegl.geo_tag\",\"riegl.pixel_info\",\"riegl.time_base?\"],\"e"
    "xtension\":\"mpx\",\"identifier\":\"mpx\",\"attributes\":[\"riegl.id\",\"riegl.xy_"
    "map*\",\"riegl.amplitude\",\"riegl.reflectance\",\"riegl.deviation\",\"riegl.t"
    "imestamp_min?\",\"riegl.timestamp_max?\",\"riegl.point_count\",\"riegl.point"
    "_count_grid_cell\",\"riegl.pixel_linear_sums?\",\"riegl.pixel_square_sums?"
    "\",\"riegl.height_min\",\"riegl.height_max\",\"riegl.height_mean\",\"riegl.hei"
    "ght_center\",\"riegl.surface_normal\",\"riegl.pca_thickness\",\"riegl.std_de"
    "v\",\"riegl.voxel_count\"]}"
);

// Schema for ".mtch" files
const std::string RDB_SCHEMA_RIEGL_MTCH(
    "{\"metadata\":[\"riegl.plane_patch_matching\"],\"extension\":\"mtch\",\"identif"
    "ier\":\"mtch\",\"attributes\":[\"riegl.xyz*\",\"riegl.plane_references\",\"riegl"
    ".plane_patch_distance\",\"riegl.plane_patch_lateral_distance\",\"riegl.pla"
    "ne_patch_link_vector\",\"riegl.id\"]}"
);

// Schema for ".mvx" files
const std::string RDB_SCHEMA_RIEGL_MVX(
    "{\"metadata\":[\"riegl.geo_tag\",\"riegl.time_base?\",\"riegl.voxel_info\"],\"e"
    "xtension\":\"mvx\",\"identifier\":\"mvx\",\"attributes\":[\"riegl.id\",\"riegl.xyz"
    "_map*\",\"riegl.amplitude\",\"riegl.reflectance\",\"riegl.deviation\",\"riegl."
    "timestamp_min?\",\"riegl.timestamp_max?\",\"riegl.point_count\",\"riegl.shap"
    "e_id\",\"riegl.covariances?\",\"riegl.pca_axis_min\",\"riegl.pca_axis_max\",\""
    "riegl.pca_extents\",\"riegl.std_dev\",\"riegl.voxel_collapsed\"]}"
);

// Schema for ".obsx" files
const std::string RDB_SCHEMA_RIEGL_OBSX(
    "{\"metadata\":[\"riegl.geo_tag\",\"riegl.plane_slope_class_info?\",\"riegl.po"
    "intcloud_info\",\"riegl.sda1_source_files\"],\"extension\":\"obsx\",\"identifi"
    "er\":\"obsx\",\"attributes\":[\"riegl.xyz\",\"riegl.surface_normal\",\"riegl.pla"
    "ne_slope_class?\",\"riegl.id*\",\"riegl.sda1_plane_patch_one\",\"riegl.sda1_"
    "plane_patch_two\",\"riegl.sda1_source_file_one\",\"riegl.sda1_source_file_"
    "two\"]}"
);

// Schema for ".ocyl" files
const std::string RDB_SCHEMA_RIEGL_OCYL(
    "{\"metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"r"
    "iegl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base"
    "\"],\"extension\":\"ocyl\",\"identifier\":\"ocyl\",\"attributes\":[\"riegl.id\",\"ri"
    "egl.xyz*\",\"riegl.cylinder_axis_direction\",\"riegl.cylinder_radius\",\"rie"
    "gl.cylinder_height\",\"riegl.cylinder_radius_confidence\",\"riegl.cylinder"
    "_direction_confidence\",\"riegl.model_fit_quality?\",\"riegl.std_dev\",\"rie"
    "gl.xyz_socs\",\"riegl.direction\",\"riegl.mirror_facet\",\"riegl.timestamp\"]"
    "}"
);

// Schema for ".opefx" files
const std::string RDB_SCHEMA_RIEGL_OPEFX(
    "{\"metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"r"
    "iegl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base"
    "\",\"riegl.item_names\",\"riegl.control_object_reference_file\"],\"extension"
    "\":\"opefx\",\"identifier\":\"opefx\",\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\""
    "riegl.xyz_accuracies?\",\"riegl.surface_normal\",\"riegl.plane_up\",\"riegl."
    "point_count\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.plane_height\","
    "\"riegl.plane_confidence_normal\",\"riegl.model_fit_quality?\",\"riegl.used"
    "_for_adjustment\",\"riegl.xyz_socs\",\"riegl.timestamp\",\"riegl.mirror_face"
    "t\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.platform_drpy_ROCS_NED\",\"riegl"
    ".platform_xyz_ROCS_ENU\",\"riegl.platform_dxyz_ROCS_ENU\",\"riegl.sda.shif"
    "t_vector\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\"riegl.raw_line_an"
    "gle\",\"riegl.reference_object_id\"]}"
);

// Schema for ".opp" files
const std::string RDB_SCHEMA_RIEGL_OPP(
    "{\"metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"r"
    "iegl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base"
    "\",\"riegl.item_names\",\"riegl.control_object_reference_file\"],\"extension"
    "\":\"opp\",\"identifier\":\"opp\",\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"rieg"
    "l.xyz_accuracies?\",\"riegl.surface_normal\",\"riegl.plane_up\",\"riegl.poin"
    "t_count\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.plane_height\",\"rie"
    "gl.plane_confidence_normal\",\"riegl.model_fit_quality?\",\"riegl.used_for"
    "_adjustment\",\"riegl.xyz_socs\",\"riegl.timestamp\",\"riegl.mirror_facet\",\""
    "riegl.platform_rpy_ROCS_NED\",\"riegl.platform_drpy_ROCS_NED\",\"riegl.pla"
    "tform_xyz_ROCS_ENU\",\"riegl.platform_dxyz_ROCS_ENU\",\"riegl.sda.shift_ve"
    "ctor\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\"riegl.raw_line_angle\""
    ",\"riegl.reference_object_id\"]}"
);

// Schema for ".opx" files
const std::string RDB_SCHEMA_RIEGL_OPX(
    "{\"metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"r"
    "iegl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base"
    "\",\"riegl.control_object_catalog\",\"riegl.item_names\",\"riegl.control_obj"
    "ect_reference_file\"],\"extension\":\"opx\",\"identifier\":\"opx\",\"attributes\""
    ":[\"riegl.id\",\"riegl.xyz*\",\"riegl.control_object_type\",\"riegl.model_cs_"
    "axis_x?\",\"riegl.model_cs_axis_y?\",\"riegl.model_cs_axis_z?\",\"riegl.mode"
    "l_fit_quality?\",\"riegl.obs_confidence_xy?\",\"riegl.obs_confidence_z?\",\""
    "riegl.obs_signal_confidence_rot?\",\"riegl.obs_confidence_range?\",\"riegl"
    ".obs_confidence_theta?\",\"riegl.obs_confidence_phi?\",\"riegl.point_count"
    "?\",\"riegl.used_for_adjustment\",\"riegl.xyz_socs\",\"riegl.timestamp\",\"rie"
    "gl.mirror_facet\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.platform_drpy_RO"
    "CS_NED\",\"riegl.platform_xyz_ROCS_ENU\",\"riegl.platform_dxyz_ROCS_ENU\",\""
    "riegl.sda.shift_vector\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\"rie"
    "gl.raw_line_angle\",\"riegl.reference_object_id\"]}"
);

// Schema for ".owp" files
const std::string RDB_SCHEMA_RIEGL_OWP(
    "{\"metadata\":[],\"extension\":\"owp\",\"identifier\":\"owp\",\"attributes\":[\"rie"
    "gl.id*\",\"riegl.raw_range\",\"riegl.amplitude\",\"riegl.deviation\",\"riegl.g"
    "ain\"]}"
);

// Schema for ".pefx" files
const std::string RDB_SCHEMA_RIEGL_PEFX(
    "{\"metadata\":[\"riegl.geo_tag\",\"riegl.vertex_info\",\"riegl.item_names\",\"r"
    "iegl.imported_files\"],\"extension\":\"pefx\",\"identifier\":\"pefx\",\"attribut"
    "es\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.xyz_accuracies?\",\"riegl.surface_no"
    "rmal\",\"riegl.plane_up\",\"riegl.std_dev\",\"riegl.plane_confidence_normal\""
    ",\"riegl.plane_width\",\"riegl.plane_height\",\"riegl.vertex_first\",\"riegl."
    "vertex_count\",\"riegl.used_for_adjustment\",\"riegl.acquisition_date?\",\"r"
    "iegl.import_line_number\",\"riegl.import_line_count\"]}"
);

// Schema for ".pofx" files
const std::string RDB_SCHEMA_RIEGL_PROJECT_POFX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.time_base\",\"riegl."
    "trajectory_info\"],\"extension\":\"pofx\",\"identifier\":\"project.pofx\",\"attr"
    "ibutes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\",\"riegl"
    ".pof_longitude\",\"riegl.pof_height\",\"riegl.pof_roll\",\"riegl.pof_pitch\","
    "\"riegl.pof_yaw\",\"riegl.pof_velocity_ned?\",\"riegl.pof_path_length?\"]}"
);

// Schema for ".pofx" files
const std::string RDB_SCHEMA_RIEGL_SCAN_POFX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.time_base\",\"riegl.geo_tag\",\"riegl."
    "trajectory_info\"],\"extension\":\"pofx\",\"identifier\":\"scan.pofx\",\"attribu"
    "tes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\",\"riegl.po"
    "f_longitude\",\"riegl.pof_height\",\"riegl.pof_roll\",\"riegl.pof_pitch\",\"ri"
    "egl.pof_yaw\",\"riegl.pof_path_length?\",\"riegl.pof_xyz\",\"riegl.pof_roll_"
    "ned\",\"riegl.pof_pitch_ned\",\"riegl.pof_yaw_ned\"]}"
);

// Schema for ".poqx" files
const std::string RDB_SCHEMA_RIEGL_PROJECT_POQX(
    "{\"metadata\":[\"riegl.time_base\",\"riegl.trajectory_info\"],\"extension\":\"p"
    "oqx\",\"identifier\":\"project.poqx\",\"attributes\":[\"riegl.id\",\"riegl.pof_t"
    "imestamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_accuracy_east\",\"riegl"
    ".pof_accuracy_down\",\"riegl.pof_accuracy_north_east?\",\"riegl.pof_accura"
    "cy_east_down?\",\"riegl.pof_accuracy_down_north?\",\"riegl.pof_velocity_ac"
    "curacy_north?\",\"riegl.pof_velocity_accuracy_east?\",\"riegl.pof_velocity"
    "_accuracy_down?\",\"riegl.pof_velocity_accuracy_north_east?\",\"riegl.pof_"
    "velocity_accuracy_east_down?\",\"riegl.pof_velocity_accuracy_down_north?"
    "\",\"riegl.pof_accuracy_roll\",\"riegl.pof_accuracy_pitch\",\"riegl.pof_accu"
    "racy_yaw\",\"riegl.pof_path_length?\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\""
    "riegl.pof_vdop\",\"riegl.pof_satellites_gnss?\",\"riegl.pof_satellites_gps"
    "?\",\"riegl.pof_satellites_glonass?\",\"riegl.pof_satellites_beidou?\",\"rie"
    "gl.pof_satellites_galileo?\",\"riegl.pof_satellites_qzss?\",\"riegl.pof_so"
    "lution_gnss\",\"riegl.pof_baseline_length?\"]}"
);

// Schema for ".poqx" files
const std::string RDB_SCHEMA_RIEGL_SCAN_POQX(
    "{\"metadata\":[\"riegl.time_base\",\"riegl.trajectory_info\"],\"extension\":\"p"
    "oqx\",\"identifier\":\"scan.poqx\",\"attributes\":[\"riegl.id\",\"riegl.pof_time"
    "stamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_accuracy_east\",\"riegl.po"
    "f_accuracy_down\",\"riegl.pof_accuracy_north_east?\",\"riegl.pof_accuracy_"
    "east_down?\",\"riegl.pof_accuracy_down_north?\",\"riegl.pof_velocity_accur"
    "acy_north?\",\"riegl.pof_velocity_accuracy_east?\",\"riegl.pof_velocity_ac"
    "curacy_down?\",\"riegl.pof_velocity_accuracy_north_east?\",\"riegl.pof_vel"
    "ocity_accuracy_east_down?\",\"riegl.pof_velocity_accuracy_down_north?\",\""
    "riegl.pof_accuracy_roll\",\"riegl.pof_accuracy_pitch\",\"riegl.pof_accurac"
    "y_yaw\",\"riegl.pof_path_length?\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"rie"
    "gl.pof_vdop\",\"riegl.pof_satellites_gnss?\",\"riegl.pof_satellites_gps?\","
    "\"riegl.pof_satellites_glonass?\",\"riegl.pof_satellites_beidou?\",\"riegl."
    "pof_satellites_galileo?\",\"riegl.pof_satellites_qzss?\",\"riegl.pof_solut"
    "ion_gnss\",\"riegl.pof_baseline_length?\"]}"
);

// Schema for ".ppx" files
const std::string RDB_SCHEMA_RIEGL_PPX(
    "{\"metadata\":[\"riegl.device\",\"riegl.time_base\"],\"extension\":\"ppx\",\"iden"
    "tifier\":\"ppx\",\"attributes\":[\"riegl.id\",\"riegl.pps_timestamp_intern*\",\""
    "riegl.pps_timestamp_extern\"]}"
);

// Schema for ".ptch" files
const std::string RDB_SCHEMA_RIEGL_PROJECT_PTCH(
    "{\"metadata\":[\"riegl.device\",\"riegl.geo_tag?\",\"riegl.scan_pattern?\",\"ri"
    "egl.time_base?\",\"riegl.plane_patch_statistics?\"],\"extension\":\"ptch\",\"i"
    "dentifier\":\"project.ptch\",\"attributes\":[\"riegl.xyz*\",\"riegl.surface_no"
    "rmal\",\"riegl.plane_up\",\"riegl.reflectance?\",\"riegl.point_count\",\"riegl"
    ".std_dev\",\"riegl.plane_width\",\"riegl.plane_height\",\"riegl.plane_count\""
    ",\"riegl.covariances\",\"riegl.id\"]}"
);

// Schema for ".ptch" files
const std::string RDB_SCHEMA_RIEGL_SCAN_PTCH(
    "{\"metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"r"
    "iegl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base"
    "\",\"riegl.plane_patch_statistics?\",\"riegl.plane_slope_class_info?\"],\"ex"
    "tension\":\"ptch\",\"identifier\":\"scan.ptch\",\"attributes\":[\"riegl.xyz*\",\"r"
    "iegl.xyz_socs\",\"riegl.direction?\",\"riegl.direction_medium?\",\"riegl.dir"
    "ection_coarse?\",\"riegl.surface_normal\",\"riegl.plane_up\",\"riegl.timesta"
    "mp\",\"riegl.reflectance?\",\"riegl.point_count\",\"riegl.std_dev\",\"riegl.pl"
    "ane_width\",\"riegl.plane_height\",\"riegl.plane_count\",\"riegl.mirror_face"
    "t\",\"riegl.covariances\",\"riegl.id\",\"riegl.plane_slope_class?\",\"riegl.pl"
    "ane_occupancy\",\"riegl.plane_confidence_normal\",\"riegl.plane_cog_link\","
    "\"riegl.match_count\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.platform_xyz_"
    "ROCS_ENU\",\"riegl.platform_drpy_ROCS_NED\",\"riegl.platform_dxyz_ROCS_ENU"
    "\",\"riegl.sda.shift_vector\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\""
    "riegl.raw_line_angle\"]}"
);

// Schema for ".ptch" files
const std::string RDB_SCHEMA_RIEGL_SCANPOS_PTCH(
    "{\"metadata\":[\"riegl.device\",\"riegl.geo_tag?\",\"riegl.scan_pattern?\",\"ri"
    "egl.time_base?\",\"riegl.plane_patch_statistics?\"],\"extension\":\"ptch\",\"i"
    "dentifier\":\"scanpos.ptch\",\"attributes\":[\"riegl.xyz*\",\"riegl.surface_no"
    "rmal\",\"riegl.plane_up\",\"riegl.reflectance?\",\"riegl.point_count\",\"riegl"
    ".std_dev\",\"riegl.plane_width\",\"riegl.plane_height\",\"riegl.plane_count\""
    ",\"riegl.covariances\",\"riegl.id\"]}"
);

// Schema for ".rdbx" files
const std::string RDB_SCHEMA_RIEGL_RDBX(
    "{\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl.device_ge"
    "ometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"riegl.exponent"
    "ial_decomposition?\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters\","
    "\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl.noise_esti"
    "mates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\",\"riegl.poi"
    "ntcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.range_statist"
    "ics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calculation?\",\"ri"
    "egl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.time_base\",\"r"
    "iegl.waveform_settings?\",\"riegl.window_analysis?\",\"riegl.window_echo_c"
    "orrection?\"],\"extension\":\"rdbx\",\"identifier\":\"rdbx\",\"attributes\":[\"rie"
    "gl.id\",\"riegl.timestamp\",\"riegl.xyz*\",\"riegl.xyz_socs\",\"riegl.directio"
    "n_medium?\",\"riegl.direction?\",\"riegl.amplitude\",\"riegl.reflectance?\",\""
    "riegl.deviation?\",\"riegl.pulse_width?\",\"riegl.target_index\",\"riegl.tar"
    "get_count\",\"riegl.mirror_facet?\",\"riegl.scan_segment?\",\"riegl.mta_unce"
    "rtain_point?\",\"riegl.mta_zone?\",\"riegl.window_echo_impact_corrected?\","
    "\"riegl.dyntrig_uncertain_point?\",\"riegl.rgba?\",\"riegl.class?\",\"riegl.s"
    "tart_of_scan_line?\",\"riegl.end_of_scan_line?\",\"riegl.source_indicator?"
    "\",\"riegl.fwa?\",\"riegl.waveform_available?\",\"riegl.wfm_sbl_id?\",\"riegl."
    "wfm_echo_time_offset?\",\"riegl.scan_angle\",\"riegl.scan_direction\",\"rieg"
    "l.source_index?\",\"riegl.scan_line_index?\",\"riegl.shot_index_line?\",\"ri"
    "egl.hydro_refraction_corrected?\",\"riegl.hydro_intersection_point?\",\"ri"
    "egl.hydro_intersection_normal?\",\"riegl.extinction?\",\"riegl.svb_amplitu"
    "de_volumetric?\",\"riegl.svb_reflectance_volumetric?\",\"riegl.svb_reflect"
    "ance_bottom_uncorrected?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\",\"ri"
    "egl.svb_path_length?\"]}"
);

// Schema for ".rmvx" files
const std::string RDB_SCHEMA_RIEGL_RMVX(
    "{\"metadata\":[\"riegl.geo_tag\",\"riegl.voxel_info\",\"riegl.time_base?\"],\"e"
    "xtension\":\"rmvx\",\"identifier\":\"rmvx\",\"attributes\":[\"riegl.id\",\"riegl.v"
    "oxel_index*\",\"riegl.amplitude\",\"riegl.reflectance\",\"riegl.deviation\",\""
    "riegl.direction_medium\",\"riegl.point_count\",\"riegl.voxel_linear_sums\","
    "\"riegl.voxel_square_sums\",\"riegl.timestamp_min?\",\"riegl.timestamp_max?"
    "\"]}"
);

// Schema for ".rt.llhx" files
const std::string RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX(
    "{\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.time_base\"],\"exten"
    "sion\":\"rt.llhx\",\"identifier\":\"trajectory.rt.llhx\",\"attributes\":[\"riegl"
    ".id\",\"riegl.pof_latitude\",\"riegl.pof_longitude\",\"riegl.pof_height\",\"ri"
    "egl.pof_timestamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_accuracy_eas"
    "t\",\"riegl.pof_accuracy_down\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"riegl."
    "pof_vdop\",\"riegl.pof_age_of_corrections\",\"riegl.pof_baseline_length\",\""
    "riegl.pof_solution_gnss\",\"riegl.pof_satellites_gnss\",\"riegl.pof_course"
    "?\",\"riegl.pof_xyz_ned_velocity?\"]}"
);

// Schema for ".s10x" files
const std::string RDB_SCHEMA_RIEGL_S10X(
    "{\"metadata\":[\"riegl.time_base\",\"riegl.device?\",\"riegl.pose_sensors\"],\""
    "extension\":\"s10x\",\"identifier\":\"s10x\",\"attributes\":[\"riegl.id\",\"riegl."
    "timestamp*\",\"riegl.frame_angle_coarse\",\"riegl.gyroscope_raw\",\"riegl.ac"
    "celerometer_raw\",\"riegl.magnetic_field_sensor_raw\",\"riegl.gyroscope\",\""
    "riegl.accelerometer\",\"riegl.magnetic_field_sensor\",\"riegl.barometric_h"
    "eight_amsl\",\"riegl.temperature\",\"riegl.line_scan_active\",\"riegl.frame_"
    "scan_active\",\"riegl.data_acquisition_active\"]}"
);

// Schema for ".sbx" files
const std::string RDB_SCHEMA_RIEGL_SBX(
    "{\"metadata\":[],\"extension\":\"sbx\",\"identifier\":\"sbx\",\"attributes\":[\"rie"
    "gl.id*\",\"riegl.wfm_sbl_channel\",\"riegl.wfm_sbl_mean\",\"riegl.wfm_sbl_st"
    "d_dev\",\"riegl.wfm_sbl_time_offset\",\"riegl.wfm_sda_first\",\"riegl.wfm_sd"
    "a_count\"]}"
);

// Schema for ".sdcx" files
const std::string RDB_SCHEMA_RIEGL_SDCX(
    "{\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl.device_ge"
    "ometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"riegl.exponent"
    "ial_decomposition?\",\"riegl.mta_settings?\",\"riegl.near_range_correction"
    "?\",\"riegl.noise_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch"
    "_filter?\",\"riegl.pointcloud_info?\",\"riegl.pulse_position_modulation?\","
    "\"riegl.range_statistics?\",\"riegl.receiver_internals?\",\"riegl.reflectan"
    "ce_calculation?\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\","
    "\"riegl.time_base\",\"riegl.window_analysis?\",\"riegl.window_echo_correcti"
    "on?\"],\"extension\":\"sdcx\",\"identifier\":\"sdcx\",\"attributes\":[\"riegl.id\","
    "\"riegl.timestamp*\",\"riegl.xyz\",\"riegl.amplitude\",\"riegl.reflectance?\","
    "\"riegl.deviation?\",\"riegl.pulse_width?\",\"riegl.target_index\",\"riegl.ta"
    "rget_count\",\"riegl.mirror_facet?\",\"riegl.scan_segment?\",\"riegl.mta_unc"
    "ertain_point?\",\"riegl.mta_zone?\",\"riegl.window_echo_impact_corrected?\""
    ",\"riegl.dyntrig_uncertain_point?\",\"riegl.class?\",\"riegl.start_of_scan_"
    "line?\",\"riegl.end_of_scan_line?\",\"riegl.source_indicator?\",\"riegl.fwa?"
    "\",\"riegl.waveform_available?\",\"riegl.wfm_sbl_id?\",\"riegl.wfm_echo_time"
    "_offset?\",\"riegl.extinction?\",\"riegl.svb_amplitude_volumetric?\",\"riegl"
    ".svb_surface?\",\"riegl.svb_bottom?\",\"riegl.svb_path_length?\"]}"
);

// Schema for ".sidx" files
const std::string RDB_SCHEMA_RIEGL_SIDX(
    "{\"metadata\":[\"riegl.shot_info\",\"riegl.echo_info\"],\"extension\":\"sidx\",\""
    "identifier\":\"sidx\",\"attributes\":[\"riegl.id\",\"riegl.shot_timestamp_hr*\""
    ",\"riegl.echo_first\",\"riegl.echo_count\"]}"
);

// Schema for ".sodx" files
const std::string RDB_SCHEMA_RIEGL_SODX(
    "{\"metadata\":[\"riegl.atmosphere\",\"riegl.device\",\"riegl.device_geometry\""
    ",\"riegl.device_output_limits\",\"riegl.beam_geometry\",\"riegl.near_range_"
    "correction?\",\"riegl.window_echo_correction?\",\"riegl.receiver_internals"
    "?\",\"riegl.gaussian_decomposition?\",\"riegl.exponential_decomposition?\","
    "\"riegl.mta_settings?\",\"riegl.pulse_position_modulation?\",\"riegl.notch_"
    "filter?\",\"riegl.reflectance_calculation?\",\"riegl.scan_pattern\",\"riegl."
    "time_base\",\"riegl.waveform_info?\",\"riegl.echo_info?\"],\"extension\":\"sod"
    "x\",\"identifier\":\"sodx\",\"attributes\":[\"riegl.id\",\"riegl.shot_timestamp_"
    "hr*\",\"riegl.mirror_facet\",\"riegl.scan_segment\",\"riegl.start_of_scan_li"
    "ne\",\"riegl.line_angle_coarse\",\"riegl.shot_origin\",\"riegl.shot_biaxial_"
    "shift?\",\"riegl.shot_direction\",\"riegl.shot_direction_levelled?\",\"riegl"
    ".wfm_sbl_first?\",\"riegl.wfm_sbl_count?\",\"riegl.echo_first?\",\"riegl.ech"
    "o_count?\"]}"
);

// Schema for ".sp{C}" files
const std::string RDB_SCHEMA_RIEGL_SPC(
    "{\"metadata\":[],\"extension\":\"sp{C}\",\"identifier\":\"sp{C}\",\"attributes\":["
    "\"riegl.id*\",\"riegl.wfm_sample_value\"]}"
);

// Schema for ".vtx" files
const std::string RDB_SCHEMA_RIEGL_VTX(
    "{\"metadata\":[\"riegl.geo_tag\"],\"extension\":\"vtx\",\"identifier\":\"vtx\",\"at"
    "tributes\":[\"riegl.id*\",\"riegl.xyz\",\"riegl.xyz_accuracies?\"]}"
);

// Schema for ".vxls" files
const std::string RDB_SCHEMA_RIEGL_VXLS(
    "{\"metadata\":[\"riegl.voxel_info\",\"riegl.geo_tag?\"],\"extension\":\"vxls\",\""
    "identifier\":\"vxls\",\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.covari"
    "ances\",\"riegl.pca_axis_max\",\"riegl.pca_axis_min\",\"riegl.pca_extents\",\""
    "riegl.point_count\",\"riegl.reflectance\",\"riegl.shape_id\",\"riegl.voxel_c"
    "ollapsed\",\"riegl.std_dev?\"]}"
);

// Schema for ".wdcx" files
const std::string RDB_SCHEMA_RIEGL_WDCX(
    "{\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl.device_ge"
    "ometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"riegl.exponent"
    "ial_decomposition?\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters\","
    "\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl.noise_esti"
    "mates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\",\"riegl.poi"
    "ntcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.range_statist"
    "ics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calculation?\",\"ri"
    "egl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.time_base\",\"r"
    "iegl.waveform_settings?\",\"riegl.window_analysis?\",\"riegl.window_echo_c"
    "orrection?\"],\"extension\":\"wdcx\",\"identifier\":\"wdcx\",\"attributes\":[\"rie"
    "gl.id\",\"riegl.timestamp\",\"riegl.xyz*\",\"riegl.xyz_socs\",\"riegl.directio"
    "n_medium?\",\"riegl.direction?\",\"riegl.amplitude\",\"riegl.reflectance?\",\""
    "riegl.deviation?\",\"riegl.pulse_width?\",\"riegl.target_index\",\"riegl.tar"
    "get_count\",\"riegl.mirror_facet?\",\"riegl.scan_segment?\",\"riegl.mta_unce"
    "rtain_point?\",\"riegl.mta_zone?\",\"riegl.window_echo_impact_corrected?\","
    "\"riegl.dyntrig_uncertain_point?\",\"riegl.rgba?\",\"riegl.class?\",\"riegl.s"
    "tart_of_scan_line?\",\"riegl.end_of_scan_line?\",\"riegl.source_indicator?"
    "\",\"riegl.fwa?\",\"riegl.waveform_available?\",\"riegl.wfm_sbl_id?\",\"riegl."
    "wfm_echo_time_offset?\",\"riegl.scan_angle\",\"riegl.scan_direction\",\"rieg"
    "l.source_index?\",\"riegl.scan_line_index?\",\"riegl.shot_index_line?\",\"ri"
    "egl.hydro_refraction_corrected?\",\"riegl.hydro_intersection_point?\",\"ri"
    "egl.hydro_intersection_normal?\",\"riegl.extinction?\",\"riegl.svb_amplitu"
    "de_volumetric?\",\"riegl.svb_reflectance_volumetric?\",\"riegl.svb_reflect"
    "ance_bottom_uncorrected?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\",\"ri"
    "egl.svb_path_length?\"]}"
);

// Schema for ".wex" files
const std::string RDB_SCHEMA_RIEGL_WEX(
    "{\"metadata\":[\"riegl.device\",\"riegl.notch_filter\",\"riegl.window_analysi"
    "s\"],\"extension\":\"wex\",\"identifier\":\"wex\",\"attributes\":[\"riegl.id\",\"rie"
    "gl.timestamp*\",\"riegl.wex_filter_valid\",\"riegl.wex_point_count\",\"riegl"
    ".wex_amplitude\",\"riegl.wex_amplitude_std_dev\",\"riegl.wex_amplitude_min"
    "\",\"riegl.wex_amplitude_max\",\"riegl.wex_amplitude_offset\",\"riegl.wex_de"
    "viation\",\"riegl.wex_deviation_std_dev\",\"riegl.wex_deviation_min\",\"rieg"
    "l.wex_deviation_max\",\"riegl.wex_range\",\"riegl.wex_range_std_dev\",\"rieg"
    "l.wex_range_min\",\"riegl.wex_range_max\",\"riegl.wex_filter_range_min\",\"r"
    "iegl.wex_filter_range_max\",\"riegl.wex_filter_amplitude_max\"]}"
);

// Table of all RDB file schema strings
const std::string RDB_SCHEMA_ARRAY[] = {
    RDB_SCHEMA_RIEGL_AVG_FWA,
    RDB_SCHEMA_RIEGL_AVG_SBX,
    RDB_SCHEMA_RIEGL_AVG_SIDX,
    RDB_SCHEMA_RIEGL_AVG_SPC,
    RDB_SCHEMA_RIEGL_BSX,
    RDB_SCHEMA_RIEGL_CPX,
    RDB_SCHEMA_RIEGL_CYL,
    RDB_SCHEMA_RIEGL_DMIX,
    RDB_SCHEMA_RIEGL_DOIX,
    RDB_SCHEMA_RIEGL_EIFX,
    RDB_SCHEMA_RIEGL_EPFX,
    RDB_SCHEMA_RIEGL_FWA,
    RDB_SCHEMA_RIEGL_IMUX,
    RDB_SCHEMA_RIEGL_LLHX,
    RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX,
    RDB_SCHEMA_RIEGL_MPX,
    RDB_SCHEMA_RIEGL_MTCH,
    RDB_SCHEMA_RIEGL_MVX,
    RDB_SCHEMA_RIEGL_OBSX,
    RDB_SCHEMA_RIEGL_OCYL,
    RDB_SCHEMA_RIEGL_OPEFX,
    RDB_SCHEMA_RIEGL_OPP,
    RDB_SCHEMA_RIEGL_OPX,
    RDB_SCHEMA_RIEGL_OWP,
    RDB_SCHEMA_RIEGL_PEFX,
    RDB_SCHEMA_RIEGL_PROJECT_POFX,
    RDB_SCHEMA_RIEGL_SCAN_POFX,
    RDB_SCHEMA_RIEGL_PROJECT_POQX,
    RDB_SCHEMA_RIEGL_SCAN_POQX,
    RDB_SCHEMA_RIEGL_PPX,
    RDB_SCHEMA_RIEGL_PROJECT_PTCH,
    RDB_SCHEMA_RIEGL_SCAN_PTCH,
    RDB_SCHEMA_RIEGL_SCANPOS_PTCH,
    RDB_SCHEMA_RIEGL_RDBX,
    RDB_SCHEMA_RIEGL_RMVX,
    RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX,
    RDB_SCHEMA_RIEGL_S10X,
    RDB_SCHEMA_RIEGL_SBX,
    RDB_SCHEMA_RIEGL_SDCX,
    RDB_SCHEMA_RIEGL_SIDX,
    RDB_SCHEMA_RIEGL_SODX,
    RDB_SCHEMA_RIEGL_SPC,
    RDB_SCHEMA_RIEGL_VTX,
    RDB_SCHEMA_RIEGL_VXLS,
    RDB_SCHEMA_RIEGL_WDCX,
    RDB_SCHEMA_RIEGL_WEX
};
const std::size_t RDB_SCHEMA_COUNT(
    sizeof(RDB_SCHEMA_ARRAY) / sizeof(RDB_SCHEMA_ARRAY[0])
);
const std::vector<std::string> RDB_SCHEMA_VECTOR(
    RDB_SCHEMA_ARRAY, RDB_SCHEMA_ARRAY + RDB_SCHEMA_COUNT
);

}}} // namespace riegl::rdb::pointcloud

#endif // RDB_6DC7FF98_C890_4397_90B3_45A2547A201F
