{*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *}
{*!
 *******************************************************************************
 *
 * \author RIEGL LMS GmbH, Austria
 * \brief  Description of RIEGL RDB 2 database file contents
 *
 *  NOTE: All information in this file is preliminary, since the
 *        definition of the database schemas is not yet complete.
 *
 *******************************************************************************
 *}

unit riegl.rdb.default.schema;

{$WRITEABLECONST ON} // see section "initialization"

interface

// File schema version
const
  RDB_SCHEMA_VERSION = 'ffc879de';
  RDB_SCHEMA_DATE = '2025-04-18';

// Schema for ".avg.fwa" files
const
  RDB_SCHEMA_RIEGL_AVG_FWA : System.String = (''
    + '{"metadata":[],"extension":"avg.fwa","attributes":["riegl.id*","riegl.'
    + 'amplitude","riegl.gain","riegl.raw_range","riegl.wfm_echo_time_offset"'
    + ',"riegl.wfm_sbl_id","riegl.deviation?","riegl.pulse_width?"],"identifi'
    + 'er":"avg.fwa"}'
  );

// Schema for ".avg.sbx" files
const
  RDB_SCHEMA_RIEGL_AVG_SBX : System.String = (''
    + '{"metadata":[],"extension":"avg.sbx","attributes":["riegl.id*","riegl.'
    + 'wfm_sbl_channel","riegl.wfm_sbl_mean","riegl.wfm_sbl_std_dev","riegl.w'
    + 'fm_sbl_time_offset","riegl.wfm_sda_first","riegl.wfm_sda_count"],"iden'
    + 'tifier":"avg.sbx"}'
  );

// Schema for ".avg.sidx" files
const
  RDB_SCHEMA_RIEGL_AVG_SIDX : System.String = (''
    + '{"metadata":["riegl.shot_info","riegl.waveform_info","riegl.echo_info?'
    + '","riegl.waveform_averaging_settings"],"extension":"avg.sidx","attribu'
    + 'tes":["riegl.id","riegl.shot_timestamp_hr*","riegl.wfm_sbl_first","rie'
    + 'gl.wfm_sbl_count","riegl.echo_first?","riegl.echo_count?"],"identifier'
    + '":"avg.sidx"}'
  );

// Schema for ".avg.sp{C}" files
const
  RDB_SCHEMA_RIEGL_AVG_SPC : System.String = (''
    + '{"metadata":[],"extension":"avg.sp{C}","attributes":["riegl.id*","rieg'
    + 'l.wfm_sample_value"],"identifier":"avg.sp{C}"}'
  );

// Schema for ".bsx" files
const
  RDB_SCHEMA_RIEGL_BSX : System.String = (''
    + '{"metadata":["riegl.time_base"],"extension":"bsx","attributes":["riegl'
    + '.id","riegl.pof_timestamp*","riegl.accelerometer_bias","riegl.accelero'
    + 'meter_scale","riegl.gyroscope_bias","riegl.gyroscope_scale"],"identifi'
    + 'er":"bsx"}'
  );

// Schema for ".cpx" files
const
  RDB_SCHEMA_RIEGL_CPX : System.String = (''
    + '{"metadata":["riegl.geo_tag","riegl.control_object_catalog","riegl.ite'
    + 'm_names","riegl.imported_files"],"extension":"cpx","attributes":["rieg'
    + 'l.id","riegl.xyz*","riegl.xyz_accuracies","riegl.control_object_type",'
    + '"riegl.zenith_vector","riegl.used_for_adjustment","riegl.acquisition_d'
    + 'ate?","riegl.cp_surface_inclination_angle","riegl.cp_surface_inclinati'
    + 'on_tolerance_angle","riegl.cp_surface_northing_angle?","riegl.cp_surfa'
    + 'ce_northing_tolerance_angle?","riegl.cp_search_radius?","riegl.cp_maxi'
    + 'mum_distance?","riegl.import_line_number"],"identifier":"cpx"}'
  );

// Schema for ".cyl" files
const
  RDB_SCHEMA_RIEGL_CYL : System.String = (''
    + '{"metadata":["riegl.geo_tag"],"extension":"cyl","attributes":["riegl.i'
    + 'd","riegl.xyz*","riegl.cylinder_axis_direction","riegl.cylinder_radius'
    + '","riegl.cylinder_height","riegl.cylinder_radius_confidence","riegl.cy'
    + 'linder_direction_confidence","riegl.std_dev"],"identifier":"cyl"}'
  );

// Schema for ".dmix" files
const
  RDB_SCHEMA_RIEGL_DMIX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.dmi_config","riegl.time_base"],"ex'
    + 'tension":"dmix","attributes":["riegl.id","riegl.dmi_count","riegl.dmi_'
    + 'path_length_raw","riegl.pof_timestamp*"],"identifier":"dmix"}'
  );

// Schema for ".doix" files
const
  RDB_SCHEMA_RIEGL_DOIX : System.String = (''
    + '{"metadata":[],"extension":"doix","attributes":["riegl.id","riegl.shot'
    + '_origin","riegl.shot_direction*","riegl.scan_line_index","riegl.shot_i'
    + 'ndex_line"],"identifier":"doix"}'
  );

// Schema for ".eifx" files
const
  RDB_SCHEMA_RIEGL_EIFX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.time_base","riegl.ttip_configurati'
    + 'on?"],"extension":"eifx","attributes":["riegl.id","riegl.event_timesta'
    + 'mp*","riegl.event_index?","riegl.event_pulse_width?","riegl.event_fake'
    + '_pulse?","riegl.raw_line_angle?","riegl.raw_frame_angle?"],"identifier'
    + '":"eifx"}'
  );

// Schema for ".epfx" files
const
  RDB_SCHEMA_RIEGL_EPFX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.geo_tag","riegl.time_base","riegl.'
    + 'ttip_configuration?"],"extension":"epfx","attributes":["riegl.id","rie'
    + 'gl.event_timestamp*","riegl.event_index?","riegl.event_pulse_width?","'
    + 'riegl.event_fake_pulse?","riegl.raw_line_angle?","riegl.raw_frame_angl'
    + 'e?","riegl.xyz","riegl.model_cs_axis_x","riegl.model_cs_axis_y","riegl'
    + '.model_cs_axis_z"],"identifier":"epfx"}'
  );

// Schema for ".fwa" files
const
  RDB_SCHEMA_RIEGL_FWA : System.String = (''
    + '{"metadata":[],"extension":"fwa","attributes":["riegl.id*","riegl.ampl'
    + 'itude","riegl.gain","riegl.raw_range","riegl.wfm_echo_time_offset","ri'
    + 'egl.wfm_sbl_id","riegl.deviation?","riegl.pulse_width?","riegl.extinct'
    + 'ion?","riegl.svb_amplitude_volumetric?","riegl.svb_attenuation_volumet'
    + 'ric?","riegl.svb_target_attenuation_coefficient_volumetric?","riegl.sv'
    + 'b_surface?","riegl.svb_bottom?","riegl.svb_path_length?"],"identifier"'
    + ':"fwa"}'
  );

// Schema for ".imux" files
const
  RDB_SCHEMA_RIEGL_IMUX : System.String = (''
    + '{"metadata":["riegl.device","riegl.time_base","riegl.riloc_sensor_info'
    + 'rmation","riegl.rxp_json_parameter_1"],"extension":"imux","attributes"'
    + ':["riegl.id","riegl.timestamp*","riegl.temperature","riegl.acceleromet'
    + 'er","riegl.gyroscope","riegl.accelerometer_raw","riegl.gyroscope_raw",'
    + '"riegl.magnetic_field_sensor_raw","riegl.frame_angle_coarse","riegl.li'
    + 'ne_angle_coarse","riegl.frame_scan_active","riegl.data_acquisition_act'
    + 'ive","riegl.barometric_height_amsl"],"identifier":"imux"}'
  );

// Schema for ".llhx" files
const
  RDB_SCHEMA_RIEGL_LLHX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.geo_tag","riegl.time_base"],"exten'
    + 'sion":"llhx","attributes":["riegl.pof_latitude","riegl.pof_longitude",'
    + '"riegl.pof_height","riegl.pof_timestamp*","riegl.pof_accuracy_north","'
    + 'riegl.pof_accuracy_east","riegl.pof_accuracy_down","riegl.pof_pdop","r'
    + 'iegl.pof_hdop","riegl.pof_vdop","riegl.pof_age_of_corrections","riegl.'
    + 'pof_baseline_length","riegl.pof_solution_gnss","riegl.pof_satellites_g'
    + 'nss","riegl.id"],"identifier":"llhx"}'
  );

// Schema for ".llhx" files
const
  RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.geo_tag","riegl.time_base"],"exten'
    + 'sion":"llhx","attributes":["riegl.id","riegl.pof_timestamp*","riegl.po'
    + 'f_latitude","riegl.pof_longitude","riegl.pof_height","riegl.pof_accura'
    + 'cy_north","riegl.pof_accuracy_east","riegl.pof_accuracy_down","riegl.p'
    + 'of_accuracy_north_east?","riegl.pof_accuracy_east_down?","riegl.pof_ac'
    + 'curacy_down_north?","riegl.pof_velocity_ned?","riegl.pof_velocity_accu'
    + 'racy_north?","riegl.pof_velocity_accuracy_east?","riegl.pof_velocity_a'
    + 'ccuracy_down?","riegl.pof_velocity_accuracy_north_east?","riegl.pof_ve'
    + 'locity_accuracy_east_down?","riegl.pof_velocity_accuracy_down_north?",'
    + '"riegl.pof_pdop","riegl.pof_hdop","riegl.pof_vdop","riegl.pof_age_of_c'
    + 'orrections?","riegl.pof_baseline_length?","riegl.pof_solution_gnss","r'
    + 'iegl.pof_satellites_gnss","riegl.pof_path_length?"],"identifier":"traj'
    + 'ectory.llhx"}'
  );

// Schema for ".mpx" files
const
  RDB_SCHEMA_RIEGL_MPX : System.String = (''
    + '{"metadata":["riegl.geo_tag","riegl.pixel_info","riegl.time_base?"],"e'
    + 'xtension":"mpx","attributes":["riegl.id","riegl.xy_map*","riegl.amplit'
    + 'ude","riegl.reflectance","riegl.deviation","riegl.timestamp_min?","rie'
    + 'gl.timestamp_max?","riegl.point_count","riegl.point_count_grid_cell","'
    + 'riegl.pixel_linear_sums?","riegl.pixel_square_sums?","riegl.height_min'
    + '","riegl.height_max","riegl.height_mean","riegl.height_center","riegl.'
    + 'surface_normal","riegl.pca_thickness","riegl.std_dev","riegl.voxel_cou'
    + 'nt"],"identifier":"mpx"}'
  );

// Schema for ".mtch" files
const
  RDB_SCHEMA_RIEGL_MTCH : System.String = (''
    + '{"metadata":["riegl.plane_patch_matching"],"extension":"mtch","attribu'
    + 'tes":["riegl.xyz*","riegl.plane_references","riegl.plane_patch_distanc'
    + 'e","riegl.plane_patch_lateral_distance","riegl.plane_patch_link_vector'
    + '","riegl.id"],"identifier":"mtch"}'
  );

// Schema for ".mvx" files
const
  RDB_SCHEMA_RIEGL_MVX : System.String = (''
    + '{"metadata":["riegl.geo_tag","riegl.time_base?","riegl.voxel_info"],"e'
    + 'xtension":"mvx","attributes":["riegl.id","riegl.xyz_map*","riegl.ampli'
    + 'tude","riegl.reflectance","riegl.deviation","riegl.timestamp_min?","ri'
    + 'egl.timestamp_max?","riegl.point_count","riegl.shape_id","riegl.covari'
    + 'ances?","riegl.pca_axis_min","riegl.pca_axis_max","riegl.pca_extents",'
    + '"riegl.std_dev","riegl.voxel_collapsed"],"identifier":"mvx"}'
  );

// Schema for ".obsx" files
const
  RDB_SCHEMA_RIEGL_OBSX : System.String = (''
    + '{"metadata":["riegl.geo_tag","riegl.plane_slope_class_info?","riegl.po'
    + 'intcloud_info","riegl.sda1_source_files"],"extension":"obsx","attribut'
    + 'es":["riegl.xyz","riegl.surface_normal","riegl.plane_slope_class?","ri'
    + 'egl.id*","riegl.sda1_plane_patch_one","riegl.sda1_plane_patch_two","ri'
    + 'egl.sda1_source_file_one","riegl.sda1_source_file_two"],"identifier":"'
    + 'obsx"}'
  );

// Schema for ".ocyl" files
const
  RDB_SCHEMA_RIEGL_OCYL : System.String = (''
    + '{"metadata":["riegl.device","riegl.device_geometry","riegl.geo_tag","r'
    + 'iegl.georeferencing_parameters","riegl.scan_pattern?","riegl.time_base'
    + '"],"extension":"ocyl","attributes":["riegl.id","riegl.xyz*","riegl.cyl'
    + 'inder_axis_direction","riegl.cylinder_radius","riegl.cylinder_height",'
    + '"riegl.cylinder_radius_confidence","riegl.cylinder_direction_confidenc'
    + 'e","riegl.model_fit_quality?","riegl.std_dev","riegl.xyz_socs","riegl.'
    + 'direction","riegl.mirror_facet","riegl.timestamp"],"identifier":"ocyl"'
    + '}'
  );

// Schema for ".opefx" files
const
  RDB_SCHEMA_RIEGL_OPEFX : System.String = (''
    + '{"metadata":["riegl.device","riegl.device_geometry","riegl.geo_tag","r'
    + 'iegl.georeferencing_parameters","riegl.scan_pattern?","riegl.time_base'
    + '","riegl.item_names","riegl.control_object_reference_file"],"extension'
    + '":"opefx","attributes":["riegl.id","riegl.xyz*","riegl.xyz_accuracies?'
    + '","riegl.surface_normal","riegl.plane_up","riegl.point_count","riegl.s'
    + 'td_dev","riegl.plane_width","riegl.plane_height","riegl.plane_confiden'
    + 'ce_normal","riegl.model_fit_quality?","riegl.used_for_adjustment","rie'
    + 'gl.xyz_socs","riegl.timestamp","riegl.mirror_facet","riegl.platform_rp'
    + 'y_ROCS_NED","riegl.platform_drpy_ROCS_NED","riegl.platform_xyz_ROCS_EN'
    + 'U","riegl.platform_dxyz_ROCS_ENU","riegl.sda.shift_vector","riegl.raw_'
    + 'range","riegl.raw_frame_angle","riegl.raw_line_angle","riegl.reference'
    + '_object_id"],"identifier":"opefx"}'
  );

// Schema for ".opp" files
const
  RDB_SCHEMA_RIEGL_OPP : System.String = (''
    + '{"metadata":["riegl.device","riegl.device_geometry","riegl.geo_tag","r'
    + 'iegl.georeferencing_parameters","riegl.scan_pattern?","riegl.time_base'
    + '","riegl.item_names","riegl.control_object_reference_file"],"extension'
    + '":"opp","attributes":["riegl.id","riegl.xyz*","riegl.xyz_accuracies?",'
    + '"riegl.surface_normal","riegl.plane_up","riegl.point_count","riegl.std'
    + '_dev","riegl.plane_width","riegl.plane_height","riegl.plane_confidence'
    + '_normal","riegl.model_fit_quality?","riegl.used_for_adjustment","riegl'
    + '.xyz_socs","riegl.timestamp","riegl.mirror_facet","riegl.platform_rpy_'
    + 'ROCS_NED","riegl.platform_drpy_ROCS_NED","riegl.platform_xyz_ROCS_ENU"'
    + ',"riegl.platform_dxyz_ROCS_ENU","riegl.sda.shift_vector","riegl.raw_ra'
    + 'nge","riegl.raw_frame_angle","riegl.raw_line_angle","riegl.reference_o'
    + 'bject_id"],"identifier":"opp"}'
  );

// Schema for ".opx" files
const
  RDB_SCHEMA_RIEGL_OPX : System.String = (''
    + '{"metadata":["riegl.device","riegl.device_geometry","riegl.geo_tag","r'
    + 'iegl.georeferencing_parameters","riegl.scan_pattern?","riegl.time_base'
    + '","riegl.control_object_catalog","riegl.item_names","riegl.control_obj'
    + 'ect_reference_file"],"extension":"opx","attributes":["riegl.id","riegl'
    + '.xyz*","riegl.control_object_type","riegl.model_cs_axis_x?","riegl.mod'
    + 'el_cs_axis_y?","riegl.model_cs_axis_z?","riegl.model_fit_quality?","ri'
    + 'egl.obs_confidence_xy?","riegl.obs_confidence_z?","riegl.obs_signal_co'
    + 'nfidence_rot?","riegl.obs_confidence_range?","riegl.obs_confidence_the'
    + 'ta?","riegl.obs_confidence_phi?","riegl.point_count?","riegl.used_for_'
    + 'adjustment","riegl.xyz_socs","riegl.timestamp","riegl.mirror_facet","r'
    + 'iegl.platform_rpy_ROCS_NED","riegl.platform_drpy_ROCS_NED","riegl.plat'
    + 'form_xyz_ROCS_ENU","riegl.platform_dxyz_ROCS_ENU","riegl.sda.shift_vec'
    + 'tor","riegl.raw_range","riegl.raw_frame_angle","riegl.raw_line_angle",'
    + '"riegl.reference_object_id"],"identifier":"opx"}'
  );

// Schema for ".owp" files
const
  RDB_SCHEMA_RIEGL_OWP : System.String = (''
    + '{"metadata":[],"extension":"owp","attributes":["riegl.id*","riegl.raw_'
    + 'range","riegl.amplitude","riegl.deviation","riegl.gain"],"identifier":'
    + '"owp"}'
  );

// Schema for ".pefx" files
const
  RDB_SCHEMA_RIEGL_PEFX : System.String = (''
    + '{"metadata":["riegl.geo_tag","riegl.vertex_info","riegl.item_names","r'
    + 'iegl.imported_files"],"extension":"pefx","attributes":["riegl.id","rie'
    + 'gl.xyz*","riegl.xyz_accuracies?","riegl.surface_normal","riegl.plane_u'
    + 'p","riegl.std_dev","riegl.plane_confidence_normal","riegl.plane_width"'
    + ',"riegl.plane_height","riegl.vertex_first","riegl.vertex_count","riegl'
    + '.used_for_adjustment","riegl.acquisition_date?","riegl.import_line_num'
    + 'ber","riegl.import_line_count"],"identifier":"pefx"}'
  );

// Schema for ".pofx" files
const
  RDB_SCHEMA_RIEGL_PROJECT_POFX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.geo_tag","riegl.time_base","riegl.'
    + 'trajectory_info"],"extension":"pofx","attributes":["riegl.id","riegl.p'
    + 'of_timestamp*","riegl.pof_latitude","riegl.pof_longitude","riegl.pof_h'
    + 'eight","riegl.pof_roll","riegl.pof_pitch","riegl.pof_yaw","riegl.pof_v'
    + 'elocity_ned?","riegl.pof_path_length?"],"identifier":"project.pofx"}'
  );

// Schema for ".pofx" files
const
  RDB_SCHEMA_RIEGL_SCAN_POFX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.time_base","riegl.geo_tag","riegl.'
    + 'trajectory_info"],"extension":"pofx","attributes":["riegl.id","riegl.p'
    + 'of_timestamp*","riegl.pof_latitude","riegl.pof_longitude","riegl.pof_h'
    + 'eight","riegl.pof_roll","riegl.pof_pitch","riegl.pof_yaw","riegl.pof_p'
    + 'ath_length?","riegl.pof_xyz","riegl.pof_roll_ned","riegl.pof_pitch_ned'
    + '","riegl.pof_yaw_ned"],"identifier":"scan.pofx"}'
  );

// Schema for ".poqx" files
const
  RDB_SCHEMA_RIEGL_PROJECT_POQX : System.String = (''
    + '{"metadata":["riegl.time_base","riegl.trajectory_info"],"extension":"p'
    + 'oqx","attributes":["riegl.id","riegl.pof_timestamp*","riegl.pof_accura'
    + 'cy_north","riegl.pof_accuracy_east","riegl.pof_accuracy_down","riegl.p'
    + 'of_accuracy_north_east?","riegl.pof_accuracy_east_down?","riegl.pof_ac'
    + 'curacy_down_north?","riegl.pof_velocity_accuracy_north?","riegl.pof_ve'
    + 'locity_accuracy_east?","riegl.pof_velocity_accuracy_down?","riegl.pof_'
    + 'velocity_accuracy_north_east?","riegl.pof_velocity_accuracy_east_down?'
    + '","riegl.pof_velocity_accuracy_down_north?","riegl.pof_accuracy_roll",'
    + '"riegl.pof_accuracy_pitch","riegl.pof_accuracy_yaw","riegl.pof_path_le'
    + 'ngth?","riegl.pof_pdop","riegl.pof_hdop","riegl.pof_vdop","riegl.pof_s'
    + 'atellites_gnss?","riegl.pof_satellites_gps?","riegl.pof_satellites_glo'
    + 'nass?","riegl.pof_satellites_beidou?","riegl.pof_satellites_galileo?",'
    + '"riegl.pof_satellites_qzss?","riegl.pof_solution_gnss","riegl.pof_base'
    + 'line_length?"],"identifier":"project.poqx"}'
  );

// Schema for ".poqx" files
const
  RDB_SCHEMA_RIEGL_SCAN_POQX : System.String = (''
    + '{"metadata":["riegl.time_base","riegl.trajectory_info"],"extension":"p'
    + 'oqx","attributes":["riegl.id","riegl.pof_timestamp*","riegl.pof_accura'
    + 'cy_north","riegl.pof_accuracy_east","riegl.pof_accuracy_down","riegl.p'
    + 'of_accuracy_north_east?","riegl.pof_accuracy_east_down?","riegl.pof_ac'
    + 'curacy_down_north?","riegl.pof_velocity_accuracy_north?","riegl.pof_ve'
    + 'locity_accuracy_east?","riegl.pof_velocity_accuracy_down?","riegl.pof_'
    + 'velocity_accuracy_north_east?","riegl.pof_velocity_accuracy_east_down?'
    + '","riegl.pof_velocity_accuracy_down_north?","riegl.pof_accuracy_roll",'
    + '"riegl.pof_accuracy_pitch","riegl.pof_accuracy_yaw","riegl.pof_path_le'
    + 'ngth?","riegl.pof_pdop","riegl.pof_hdop","riegl.pof_vdop","riegl.pof_s'
    + 'atellites_gnss?","riegl.pof_satellites_gps?","riegl.pof_satellites_glo'
    + 'nass?","riegl.pof_satellites_beidou?","riegl.pof_satellites_galileo?",'
    + '"riegl.pof_satellites_qzss?","riegl.pof_solution_gnss","riegl.pof_base'
    + 'line_length?"],"identifier":"scan.poqx"}'
  );

// Schema for ".ppx" files
const
  RDB_SCHEMA_RIEGL_PPX : System.String = (''
    + '{"metadata":["riegl.device","riegl.time_base"],"extension":"ppx","attr'
    + 'ibutes":["riegl.id","riegl.pps_timestamp_intern*","riegl.pps_timestamp'
    + '_extern"],"identifier":"ppx"}'
  );

// Schema for ".ptch" files
const
  RDB_SCHEMA_RIEGL_PROJECT_PTCH : System.String = (''
    + '{"metadata":["riegl.device","riegl.geo_tag?","riegl.scan_pattern?","ri'
    + 'egl.time_base?","riegl.plane_patch_statistics?"],"extension":"ptch","a'
    + 'ttributes":["riegl.xyz*","riegl.surface_normal","riegl.plane_up","rieg'
    + 'l.reflectance?","riegl.point_count","riegl.std_dev","riegl.plane_width'
    + '","riegl.plane_height","riegl.plane_count","riegl.covariances","riegl.'
    + 'id"],"identifier":"project.ptch"}'
  );

// Schema for ".ptch" files
const
  RDB_SCHEMA_RIEGL_SCAN_PTCH : System.String = (''
    + '{"metadata":["riegl.device","riegl.device_geometry","riegl.geo_tag","r'
    + 'iegl.georeferencing_parameters","riegl.scan_pattern?","riegl.time_base'
    + '","riegl.plane_patch_statistics?","riegl.plane_slope_class_info?"],"ex'
    + 'tension":"ptch","attributes":["riegl.xyz*","riegl.xyz_socs","riegl.dir'
    + 'ection?","riegl.direction_medium?","riegl.direction_coarse?","riegl.su'
    + 'rface_normal","riegl.plane_up","riegl.timestamp","riegl.reflectance?",'
    + '"riegl.point_count","riegl.std_dev","riegl.plane_width","riegl.plane_h'
    + 'eight","riegl.plane_count","riegl.mirror_facet","riegl.covariances","r'
    + 'iegl.id","riegl.plane_slope_class?","riegl.plane_occupancy","riegl.pla'
    + 'ne_confidence_normal","riegl.plane_cog_link","riegl.match_count","rieg'
    + 'l.platform_rpy_ROCS_NED","riegl.platform_xyz_ROCS_ENU","riegl.platform'
    + '_drpy_ROCS_NED","riegl.platform_dxyz_ROCS_ENU","riegl.sda.shift_vector'
    + '","riegl.raw_range","riegl.raw_frame_angle","riegl.raw_line_angle"],"i'
    + 'dentifier":"scan.ptch"}'
  );

// Schema for ".ptch" files
const
  RDB_SCHEMA_RIEGL_SCANPOS_PTCH : System.String = (''
    + '{"metadata":["riegl.device","riegl.geo_tag?","riegl.scan_pattern?","ri'
    + 'egl.time_base?","riegl.plane_patch_statistics?"],"extension":"ptch","a'
    + 'ttributes":["riegl.xyz*","riegl.surface_normal","riegl.plane_up","rieg'
    + 'l.reflectance?","riegl.point_count","riegl.std_dev","riegl.plane_width'
    + '","riegl.plane_height","riegl.plane_count","riegl.covariances","riegl.'
    + 'id"],"identifier":"scanpos.ptch"}'
  );

// Schema for ".rdbx" files
const
  RDB_SCHEMA_RIEGL_RDBX : System.String = (''
    + '{"metadata":["riegl.atmosphere","riegl.beam_geometry","riegl.device_ge'
    + 'ometry","riegl.device","riegl.gaussian_decomposition?","riegl.exponent'
    + 'ial_decomposition?","riegl.geo_tag","riegl.georeferencing_parameters",'
    + '"riegl.mta_settings?","riegl.near_range_correction?","riegl.noise_esti'
    + 'mates?","riegl.angular_notch_filter?","riegl.notch_filter?","riegl.poi'
    + 'ntcloud_info?","riegl.pulse_position_modulation?","riegl.range_statist'
    + 'ics?","riegl.receiver_internals?","riegl.reflectance_calculation?","ri'
    + 'egl.reflectance_correction?","riegl.scan_pattern","riegl.time_base","r'
    + 'iegl.waveform_settings?","riegl.window_analysis?","riegl.window_echo_c'
    + 'orrection?"],"extension":"rdbx","attributes":["riegl.id","riegl.timest'
    + 'amp","riegl.xyz*","riegl.xyz_socs","riegl.direction_medium?","riegl.di'
    + 'rection?","riegl.amplitude","riegl.reflectance?","riegl.deviation?","r'
    + 'iegl.pulse_width?","riegl.target_index","riegl.target_count","riegl.mi'
    + 'rror_facet?","riegl.scan_segment?","riegl.mta_uncertain_point?","riegl'
    + '.mta_zone?","riegl.window_echo_impact_corrected?","riegl.dyntrig_uncer'
    + 'tain_point?","riegl.rgba?","riegl.class?","riegl.start_of_scan_line?",'
    + '"riegl.end_of_scan_line?","riegl.source_indicator?","riegl.fwa?","rieg'
    + 'l.waveform_available?","riegl.wfm_sbl_id?","riegl.wfm_echo_time_offset'
    + '?","riegl.scan_angle","riegl.scan_direction","riegl.source_index?","ri'
    + 'egl.scan_line_index?","riegl.shot_index_line?","riegl.hydro_refraction'
    + '_corrected?","riegl.hydro_intersection_point?","riegl.hydro_intersecti'
    + 'on_normal?","riegl.extinction?","riegl.svb_amplitude_volumetric?","rie'
    + 'gl.svb_reflectance_volumetric?","riegl.svb_reflectance_bottom_uncorrec'
    + 'ted?","riegl.svb_surface?","riegl.svb_bottom?","riegl.svb_path_length?'
    + '"],"identifier":"rdbx"}'
  );

// Schema for ".rmvx" files
const
  RDB_SCHEMA_RIEGL_RMVX : System.String = (''
    + '{"metadata":["riegl.geo_tag","riegl.voxel_info","riegl.time_base?"],"e'
    + 'xtension":"rmvx","attributes":["riegl.id","riegl.voxel_index*","riegl.'
    + 'amplitude","riegl.reflectance","riegl.deviation","riegl.direction_medi'
    + 'um","riegl.point_count","riegl.voxel_linear_sums","riegl.voxel_square_'
    + 'sums","riegl.timestamp_min?","riegl.timestamp_max?"],"identifier":"rmv'
    + 'x"}'
  );

// Schema for ".rt.llhx" files
const
  RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX : System.String = (''
    + '{"metadata":["riegl.device?","riegl.geo_tag","riegl.time_base"],"exten'
    + 'sion":"rt.llhx","attributes":["riegl.id","riegl.pof_latitude","riegl.p'
    + 'of_longitude","riegl.pof_height","riegl.pof_timestamp*","riegl.pof_acc'
    + 'uracy_north","riegl.pof_accuracy_east","riegl.pof_accuracy_down","rieg'
    + 'l.pof_pdop","riegl.pof_hdop","riegl.pof_vdop","riegl.pof_age_of_correc'
    + 'tions","riegl.pof_baseline_length","riegl.pof_solution_gnss","riegl.po'
    + 'f_satellites_gnss","riegl.pof_course?","riegl.pof_xyz_ned_velocity?"],'
    + '"identifier":"trajectory.rt.llhx"}'
  );

// Schema for ".s10x" files
const
  RDB_SCHEMA_RIEGL_S10X : System.String = (''
    + '{"metadata":["riegl.time_base","riegl.device?","riegl.pose_sensors"],"'
    + 'extension":"s10x","attributes":["riegl.id","riegl.timestamp*","riegl.f'
    + 'rame_angle_coarse","riegl.gyroscope_raw","riegl.accelerometer_raw","ri'
    + 'egl.magnetic_field_sensor_raw","riegl.gyroscope","riegl.accelerometer"'
    + ',"riegl.magnetic_field_sensor","riegl.barometric_height_amsl","riegl.t'
    + 'emperature","riegl.line_scan_active","riegl.frame_scan_active","riegl.'
    + 'data_acquisition_active"],"identifier":"s10x"}'
  );

// Schema for ".sbx" files
const
  RDB_SCHEMA_RIEGL_SBX : System.String = (''
    + '{"metadata":[],"extension":"sbx","attributes":["riegl.id*","riegl.wfm_'
    + 'sbl_channel","riegl.wfm_sbl_mean","riegl.wfm_sbl_std_dev","riegl.wfm_s'
    + 'bl_time_offset","riegl.wfm_sda_first","riegl.wfm_sda_count"],"identifi'
    + 'er":"sbx"}'
  );

// Schema for ".sdcx" files
const
  RDB_SCHEMA_RIEGL_SDCX : System.String = (''
    + '{"metadata":["riegl.atmosphere","riegl.beam_geometry","riegl.device_ge'
    + 'ometry","riegl.device","riegl.gaussian_decomposition?","riegl.exponent'
    + 'ial_decomposition?","riegl.mta_settings?","riegl.near_range_correction'
    + '?","riegl.noise_estimates?","riegl.angular_notch_filter?","riegl.notch'
    + '_filter?","riegl.pointcloud_info?","riegl.pulse_position_modulation?",'
    + '"riegl.range_statistics?","riegl.receiver_internals?","riegl.reflectan'
    + 'ce_calculation?","riegl.reflectance_correction?","riegl.scan_pattern",'
    + '"riegl.time_base","riegl.window_analysis?","riegl.window_echo_correcti'
    + 'on?"],"extension":"sdcx","attributes":["riegl.id","riegl.timestamp*","'
    + 'riegl.xyz","riegl.amplitude","riegl.reflectance?","riegl.deviation?","'
    + 'riegl.pulse_width?","riegl.target_index","riegl.target_count","riegl.m'
    + 'irror_facet?","riegl.scan_segment?","riegl.mta_uncertain_point?","rieg'
    + 'l.mta_zone?","riegl.window_echo_impact_corrected?","riegl.dyntrig_unce'
    + 'rtain_point?","riegl.class?","riegl.start_of_scan_line?","riegl.end_of'
    + '_scan_line?","riegl.source_indicator?","riegl.fwa?","riegl.waveform_av'
    + 'ailable?","riegl.wfm_sbl_id?","riegl.wfm_echo_time_offset?","riegl.ext'
    + 'inction?","riegl.svb_amplitude_volumetric?","riegl.svb_surface?","rieg'
    + 'l.svb_bottom?","riegl.svb_path_length?"],"identifier":"sdcx"}'
  );

// Schema for ".sidx" files
const
  RDB_SCHEMA_RIEGL_SIDX : System.String = (''
    + '{"metadata":["riegl.shot_info","riegl.echo_info"],"extension":"sidx","'
    + 'attributes":["riegl.id","riegl.shot_timestamp_hr*","riegl.echo_first",'
    + '"riegl.echo_count"],"identifier":"sidx"}'
  );

// Schema for ".sodx" files
const
  RDB_SCHEMA_RIEGL_SODX : System.String = (''
    + '{"metadata":["riegl.atmosphere","riegl.device","riegl.device_geometry"'
    + ',"riegl.device_output_limits","riegl.beam_geometry","riegl.near_range_'
    + 'correction?","riegl.window_echo_correction?","riegl.receiver_internals'
    + '?","riegl.gaussian_decomposition?","riegl.exponential_decomposition?",'
    + '"riegl.mta_settings?","riegl.pulse_position_modulation?","riegl.notch_'
    + 'filter?","riegl.reflectance_calculation?","riegl.scan_pattern","riegl.'
    + 'time_base","riegl.waveform_info?","riegl.echo_info?"],"extension":"sod'
    + 'x","attributes":["riegl.id","riegl.shot_timestamp_hr*","riegl.mirror_f'
    + 'acet","riegl.scan_segment","riegl.start_of_scan_line","riegl.line_angl'
    + 'e_coarse","riegl.shot_origin","riegl.shot_biaxial_shift?","riegl.shot_'
    + 'direction","riegl.shot_direction_levelled?","riegl.wfm_sbl_first?","ri'
    + 'egl.wfm_sbl_count?","riegl.echo_first?","riegl.echo_count?"],"identifi'
    + 'er":"sodx"}'
  );

// Schema for ".sp{C}" files
const
  RDB_SCHEMA_RIEGL_SPC : System.String = (''
    + '{"metadata":[],"extension":"sp{C}","attributes":["riegl.id*","riegl.wf'
    + 'm_sample_value"],"identifier":"sp{C}"}'
  );

// Schema for ".vtx" files
const
  RDB_SCHEMA_RIEGL_VTX : System.String = (''
    + '{"metadata":["riegl.geo_tag"],"extension":"vtx","attributes":["riegl.i'
    + 'd*","riegl.xyz","riegl.xyz_accuracies?"],"identifier":"vtx"}'
  );

// Schema for ".vxls" files
const
  RDB_SCHEMA_RIEGL_VXLS : System.String = (''
    + '{"metadata":["riegl.voxel_info","riegl.geo_tag?"],"extension":"vxls","'
    + 'attributes":["riegl.id","riegl.xyz*","riegl.covariances","riegl.pca_ax'
    + 'is_max","riegl.pca_axis_min","riegl.pca_extents","riegl.point_count","'
    + 'riegl.reflectance","riegl.shape_id","riegl.voxel_collapsed","riegl.std'
    + '_dev?"],"identifier":"vxls"}'
  );

// Schema for ".wdcx" files
const
  RDB_SCHEMA_RIEGL_WDCX : System.String = (''
    + '{"metadata":["riegl.atmosphere","riegl.beam_geometry","riegl.device_ge'
    + 'ometry","riegl.device","riegl.gaussian_decomposition?","riegl.exponent'
    + 'ial_decomposition?","riegl.geo_tag","riegl.georeferencing_parameters",'
    + '"riegl.mta_settings?","riegl.near_range_correction?","riegl.noise_esti'
    + 'mates?","riegl.angular_notch_filter?","riegl.notch_filter?","riegl.poi'
    + 'ntcloud_info?","riegl.pulse_position_modulation?","riegl.range_statist'
    + 'ics?","riegl.receiver_internals?","riegl.reflectance_calculation?","ri'
    + 'egl.reflectance_correction?","riegl.scan_pattern","riegl.time_base","r'
    + 'iegl.waveform_settings?","riegl.window_analysis?","riegl.window_echo_c'
    + 'orrection?"],"extension":"wdcx","attributes":["riegl.id","riegl.timest'
    + 'amp","riegl.xyz*","riegl.xyz_socs","riegl.direction_medium?","riegl.di'
    + 'rection?","riegl.amplitude","riegl.reflectance?","riegl.deviation?","r'
    + 'iegl.pulse_width?","riegl.target_index","riegl.target_count","riegl.mi'
    + 'rror_facet?","riegl.scan_segment?","riegl.mta_uncertain_point?","riegl'
    + '.mta_zone?","riegl.window_echo_impact_corrected?","riegl.dyntrig_uncer'
    + 'tain_point?","riegl.rgba?","riegl.class?","riegl.start_of_scan_line?",'
    + '"riegl.end_of_scan_line?","riegl.source_indicator?","riegl.fwa?","rieg'
    + 'l.waveform_available?","riegl.wfm_sbl_id?","riegl.wfm_echo_time_offset'
    + '?","riegl.scan_angle","riegl.scan_direction","riegl.source_index?","ri'
    + 'egl.scan_line_index?","riegl.shot_index_line?","riegl.hydro_refraction'
    + '_corrected?","riegl.hydro_intersection_point?","riegl.hydro_intersecti'
    + 'on_normal?","riegl.extinction?","riegl.svb_amplitude_volumetric?","rie'
    + 'gl.svb_reflectance_volumetric?","riegl.svb_reflectance_bottom_uncorrec'
    + 'ted?","riegl.svb_surface?","riegl.svb_bottom?","riegl.svb_path_length?'
    + '"],"identifier":"wdcx"}'
  );

// Schema for ".wex" files
const
  RDB_SCHEMA_RIEGL_WEX : System.String = (''
    + '{"metadata":["riegl.device","riegl.notch_filter","riegl.window_analysi'
    + 's"],"extension":"wex","attributes":["riegl.id","riegl.timestamp*","rie'
    + 'gl.wex_filter_valid","riegl.wex_point_count","riegl.wex_amplitude","ri'
    + 'egl.wex_amplitude_std_dev","riegl.wex_amplitude_min","riegl.wex_amplit'
    + 'ude_max","riegl.wex_amplitude_offset","riegl.wex_deviation","riegl.wex'
    + '_deviation_std_dev","riegl.wex_deviation_min","riegl.wex_deviation_max'
    + '","riegl.wex_range","riegl.wex_range_std_dev","riegl.wex_range_min","r'
    + 'iegl.wex_range_max","riegl.wex_filter_range_min","riegl.wex_filter_ran'
    + 'ge_max","riegl.wex_filter_amplitude_max"],"identifier":"wex"}'
  );

// Table of all RDB file schema strings
const
  RDB_SCHEMA_ARRAY : array of System.String = nil; // filled during initialization

implementation

procedure FixStringEncoding;
begin
  // As the unit (.pas file) doesn't contain a BOM, we need to convert all strings
  // from UTF-8 to "native" encoding at runtime (tested on Delphi 7 and Delphi XE5)

  RDB_SCHEMA_RIEGL_AVG_FWA := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_AVG_FWA)));
  RDB_SCHEMA_RIEGL_AVG_SBX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_AVG_SBX)));
  RDB_SCHEMA_RIEGL_AVG_SIDX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_AVG_SIDX)));
  RDB_SCHEMA_RIEGL_AVG_SPC := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_AVG_SPC)));
  RDB_SCHEMA_RIEGL_BSX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_BSX)));
  RDB_SCHEMA_RIEGL_CPX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_CPX)));
  RDB_SCHEMA_RIEGL_CYL := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_CYL)));
  RDB_SCHEMA_RIEGL_DMIX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_DMIX)));
  RDB_SCHEMA_RIEGL_DOIX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_DOIX)));
  RDB_SCHEMA_RIEGL_EIFX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_EIFX)));
  RDB_SCHEMA_RIEGL_EPFX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_EPFX)));
  RDB_SCHEMA_RIEGL_FWA := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_FWA)));
  RDB_SCHEMA_RIEGL_IMUX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_IMUX)));
  RDB_SCHEMA_RIEGL_LLHX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_LLHX)));
  RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX)));
  RDB_SCHEMA_RIEGL_MPX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_MPX)));
  RDB_SCHEMA_RIEGL_MTCH := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_MTCH)));
  RDB_SCHEMA_RIEGL_MVX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_MVX)));
  RDB_SCHEMA_RIEGL_OBSX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_OBSX)));
  RDB_SCHEMA_RIEGL_OCYL := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_OCYL)));
  RDB_SCHEMA_RIEGL_OPEFX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_OPEFX)));
  RDB_SCHEMA_RIEGL_OPP := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_OPP)));
  RDB_SCHEMA_RIEGL_OPX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_OPX)));
  RDB_SCHEMA_RIEGL_OWP := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_OWP)));
  RDB_SCHEMA_RIEGL_PEFX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_PEFX)));
  RDB_SCHEMA_RIEGL_PROJECT_POFX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_PROJECT_POFX)));
  RDB_SCHEMA_RIEGL_SCAN_POFX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SCAN_POFX)));
  RDB_SCHEMA_RIEGL_PROJECT_POQX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_PROJECT_POQX)));
  RDB_SCHEMA_RIEGL_SCAN_POQX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SCAN_POQX)));
  RDB_SCHEMA_RIEGL_PPX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_PPX)));
  RDB_SCHEMA_RIEGL_PROJECT_PTCH := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_PROJECT_PTCH)));
  RDB_SCHEMA_RIEGL_SCAN_PTCH := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SCAN_PTCH)));
  RDB_SCHEMA_RIEGL_SCANPOS_PTCH := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SCANPOS_PTCH)));
  RDB_SCHEMA_RIEGL_RDBX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_RDBX)));
  RDB_SCHEMA_RIEGL_RMVX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_RMVX)));
  RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX)));
  RDB_SCHEMA_RIEGL_S10X := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_S10X)));
  RDB_SCHEMA_RIEGL_SBX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SBX)));
  RDB_SCHEMA_RIEGL_SDCX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SDCX)));
  RDB_SCHEMA_RIEGL_SIDX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SIDX)));
  RDB_SCHEMA_RIEGL_SODX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SODX)));
  RDB_SCHEMA_RIEGL_SPC := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_SPC)));
  RDB_SCHEMA_RIEGL_VTX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_VTX)));
  RDB_SCHEMA_RIEGL_VXLS := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_VXLS)));
  RDB_SCHEMA_RIEGL_WDCX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_WDCX)));
  RDB_SCHEMA_RIEGL_WEX := String(UTF8ToAnsi(AnsiString(RDB_SCHEMA_RIEGL_WEX)));
end;

procedure FillSchemaArray;
var
  i : Integer;
begin
  SetLength(RDB_SCHEMA_ARRAY, 46); i := -1;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_AVG_FWA;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_AVG_SBX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_AVG_SIDX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_AVG_SPC;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_BSX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_CPX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_CYL;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_DMIX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_DOIX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_EIFX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_EPFX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_FWA;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_IMUX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_LLHX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_MPX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_MTCH;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_MVX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_OBSX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_OCYL;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_OPEFX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_OPP;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_OPX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_OWP;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_PEFX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_PROJECT_POFX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SCAN_POFX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_PROJECT_POQX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SCAN_POQX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_PPX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_PROJECT_PTCH;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SCAN_PTCH;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SCANPOS_PTCH;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_RDBX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_RMVX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_S10X;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SBX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SDCX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SIDX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SODX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_SPC;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_VTX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_VXLS;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_WDCX;
  Inc(i); RDB_SCHEMA_ARRAY[i] := RDB_SCHEMA_RIEGL_WEX;
end;

initialization

FixStringEncoding;
FillSchemaArray;

end.
