/*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Description of RIEGL RDB 2 database meta data items.
 * \version 2015-10-27/AW: Initial version
 * \version 2015-11-25/AW: Item "Geo Tag" added
 * \version 2016-10-27/AW: Item "Voxel Information" added
 * \version 2016-11-17/AW: Item "Voxel Information" updated
 * \version 2016-12-12/AW: Item "Range Statistics" added
 * \version 2017-03-08/AW: Item "Plane Patch Statistics" added
 * \version 2017-04-05/AW: Items "Atmosphere" and "Geometric Scale Factor" added
 * \version 2017-08-22/AW: Items for waveform sample block and value files added
 * \version 2017-10-24/AW: Item "Gaussian Decomposition" added
 * \version 2017-11-13/AW: Item "riegl.scan_pattern" updated
 * \version 2017-11-21/AW: Item "riegl.trajectory_info" added
 * \version 2018-01-11/AW: Item "riegl.beam_geometry" added
 * \version 2018-01-15/AW: Item "riegl.reflectance_calculation" added
 * \version 2018-01-15/AW: Item "riegl.near_range_correction" added
 * \version 2018-01-15/AW: Item "riegl.device_geometry" added
 * \version 2018-02-13/AW: Item "riegl.notch_filter" added
 * \version 2018-03-08/AW: Item "riegl.window_echo_correction" added
 * \version 2018-03-15/AW: Item "riegl.pulse_position_modulation" added
 * \version 2018-05-24/AW: Item "riegl.pixel_info" added
 * \version 2018-06-08/AW: Item "riegl.shot_info" added
 * \version 2018-06-08/AW: Item "riegl.echo_info" added
 * \version 2018-06-14/AW: Item "riegl.mta_settings" added
 * \version 2018-06-14/AW: Item "riegl.receiver_internals" added
 * \version 2018-06-14/AW: Item "riegl.device_output_limits" added
 * \version 2018-06-26/AW: Schema: replace "number" with "integer" if applicable
 * \version 2018-07-09/AW: Item "riegl.pose_estimation" added
 * \version 2018-07-09/AW: Item "riegl.pose_sensors" added
 * \version 2018-09-20/AW: Item "riegl.pointcloud_info" added
 * \version 2018-11-08/AW: Item "riegl.scan_pattern" updated
 * \version 2018-11-13/AW: Item "riegl.receiver_internals" updated
 * \version 2019-03-06/AW: Item "riegl.receiver_internals" updated
 * \version 2019-03-21/AW: Item "riegl.device_geometry" updated
 * \version 2019-04-15/AW: Item "riegl.point_attribute_groups" added
 * \version 2019-04-30/AW: Item "riegl.waveform_settings" added
 * \version 2019-10-03/AW: Item "riegl.angular_notch_filter" added
 * \version 2019-10-03/AW: Item "riegl.noise_estimates" added
 * \version 2019-10-25/AW: Item "riegl.window_analysis" added
 * \version 2019-11-06/AW: Item "riegl.georeferencing_parameters" added
 * \version 2019-11-27/AW: Item "riegl.plane_patch_matching" added
 * \version 2019-12-13/AW: Items for tie-/control objects added
 * \version 2019-12-19/AW: Items for tie-/control objects added
 * \version 2020-02-04/AW: Item "riegl.detection_probability" added
 * \version 2020-02-04/AW: Item "riegl.licenses" added
 * \version 2020-04-27/AW: Item "riegl.waveform_info" updated (schema+example)
 * \version 2020-09-03/AW: Item "riegl.reflectance_correction" added
 * \version 2020-09-10/AW: Item "riegl.device_geometry_passive_channel" added
 * \version 2020-09-25/AW: Item "riegl.georeferencing_parameters" updated
 * \version 2020-09-25/AW: Item "riegl.trajectory_info" updated
 * \version 2020-09-29/AW: Item "riegl.temperature_calculation" added
 * \version 2020-10-23/AW: Item "riegl.exponential_decomposition" added (#3709)
 * \version 2020-11-30/AW: Item "riegl.notch_filter" updated (schema)
 * \version 2020-12-02/AW: Item "riegl.georeferencing_parameters" updated (schema)
 * \version 2021-02-02/AW: Item "riegl.plane_slope_class_info" added (rdbplanes/#7)
 * \version 2021-02-16/AW: Item "riegl.device_output_limits" updated (schema, #3811)
 * \version 2021-03-03/AW: Item "riegl.exponential_decomposition" updated (schema, #3822)
 * \version 2021-03-03/AW: Item "riegl.waveform_averaging_settings" added (#3821)
 * \version 2021-04-01/AW: Item "riegl.voxel_info" updated (schema, #3854)
 * \version 2021-04-16/AW: Item "riegl.voxel_info" updated (schema, #3866)
 * \version 2021-09-30/AW: Item "riegl.waveform_info" updated (schema+example, #4016)
 * \version 2021-10-04/AW: Improved spelling of the descriptions of some items
 * \version 2021-11-04/AW: Rename "riegl.record_names" to "riegl.item_names" (#4034)
 * \version 2022-03-11/AW: Item "riegl.devices" added (#4162)
 * \version 2022-03-14/AW: Item "riegl.stored_filters" added (#4164)
 * \version 2022-09-20/AW: Fix typos in schema of "riegl.georeferencing_parameters"
 * \version 2022-09-30/AW: Item "riegl.system_description" added (#4368)
 * \version 2022-10-10/AW: Correction of typos in the titles of some entries
 * \version 2022-10-20/AW: Item "riegl.stored_filters" updated (example, #4164)
 * \version 2023-01-19/AW: Item "riegl.ttip_configuration" added (#4449)
 * \version 2024-09-26/AW: Item "riegl.dyntrig" added (#5310)
 * \version 2025-03-21/AW: Item "riegl.dmi_config" added (#5571)
 * \version 2025-07-01/AW: Item "riegl.gnss_processing_info" added (#5777)
 * \version 2025-07-01/AW: Item "riegl.riloc_processing_info" added (#5777)
 * \version 2025-11-11/AW: Item "riegl.lag_angle_correction" added (#6068)
 *
 *******************************************************************************
 */

#ifndef RDB_81EBCB65_FE94_471E_8D25_2B4D71CC91B1
#define RDB_81EBCB65_FE94_471E_8D25_2B4D71CC91B1

// Meta data item definition version
const char* const RDB_META_DATA_ITEMS_VERSION = "1.1.57";
const char* const RDB_META_DATA_ITEMS_DATE = "2025-11-11";

// Meta data item states
const unsigned char RDB_STATUS_REQUIRED = 1; // mandatory item
const unsigned char RDB_STATUS_OPTIONAL = 2; // optional item

// Container record for meta data item details
typedef struct MetaDataItemInfo
{
    const char*   name;
    const char*   title;
    const char*   description;
    unsigned char status;
    const char*   schema;
    const char*   example;
} MetaDataItemInfo;

// Angular notch filter parameters for window glass echoes
const MetaDataItemInfo RDB_RIEGL_ANGULAR_NOTCH_FILTER = {
    /* name        */ "riegl.angular_notch_filter",
    /* title       */ "Angular Notch Filter",
    /* description */ "Angular notch filter parameters for window glass echoes",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"range_mean\":{\"type\":\"array\",\"description\":\"Mean range "
    "[m]\",\"items\":{\"type\":\"number\"}},\"angle\":{\"type\":\"array\",\"description\":"
    "\"Angle [deg]\",\"items\":{\"type\":\"number\"}},\"amplitude_mean\":{\"type\":\"arr"
    "ay\",\"description\":\"Mean amplitude "
    "[dB]\",\"items\":{\"type\":\"number\"}}},\"title\":\"Angular Notch Filter\",\"$sch"
    "ema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"descri"
    "ption\":\"Angular notch filter parameters for window glass "
    "echoes\",\"required\":[\"angle\",\"range_mean\",\"amplitude_mean\"]}"
    ,
    /* example: */
    "{\"range_mean\":[0.094,0.094,0.09075,0.08675,0.0815,0.0775,0.074,0.071,0"
    ".068,0.0675,0.06475],\"angle\":[14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,"
    "22.0,23.0,24.0],\"amplitude_mean\":[3.780913,3.780913,3.480913,3.120913,"
    "2.850913,2.720913,2.680913,2.610913,2.530913,2.570913,2.570913]}"
};

// Atmospheric parameters
const MetaDataItemInfo RDB_RIEGL_ATMOSPHERE = {
    /* name        */ "riegl.atmosphere",
    /* title       */ "Atmosphere",
    /* description */ "Atmospheric parameters",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"wavelength\":{\"type\":\"number\",\"description\":\"Laser "
    "wavelength [nm]\"},\"pressure\":{\"type\":\"number\",\"description\":\"Pressure "
    "along measurment path "
    "[mbar]\"},\"temperature\":{\"type\":\"number\",\"description\":\"Temperature "
    "along measurement path "
    "[\\u00b0C]\"},\"attenuation\":{\"type\":\"number\",\"description\":\"Atmospheric "
    "attenuation "
    "[1/km]\"},\"group_velocity\":{\"type\":\"number\",\"description\":\"Group "
    "velocity of laser beam "
    "[m/s]\"},\"rel_humidity\":{\"type\":\"number\",\"description\":\"Relative "
    "humidity along measurement path "
    "[%]\"},\"amsl\":{\"type\":\"number\",\"description\":\"Height above mean sea "
    "level (AMSL) "
    "[m]\"},\"pressure_sl\":{\"type\":\"number\",\"description\":\"Atmospheric "
    "pressure at sea level [mbar]\"}},\"title\":\"Atmospheric Parameters\",\"$sch"
    "ema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"descri"
    "ption\":\"Atmospheric parameters\",\"required\":[\"temperature\",\"pressure\",\""
    "rel_humidity\",\"pressure_sl\",\"amsl\",\"group_velocity\",\"attenuation\",\"wav"
    "elength\"]}"
    ,
    /* example: */
    "{\"wavelength\":1550,\"pressure\":970,\"temperature\":7,\"attenuation\":0.0281"
    "25,\"group_velocity\":299711000.0,\"rel_humidity\":63,\"amsl\":0,\"pressure_s"
    "l\":970}"
};

// Laser beam geometry details
const MetaDataItemInfo RDB_RIEGL_BEAM_GEOMETRY = {
    /* name        */ "riegl.beam_geometry",
    /* title       */ "Beam Geometry",
    /* description */ "Laser beam geometry details",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"beam_exit_diameter\":{\"minimum\":0,\"type\":\"number\",\"desc"
    "ription\":\"Beam width at exit aperture [m]\",\"exclusiveMinimum\":false},\""
    "beam_divergence\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Beam "
    "divergence in far field "
    "[rad]\",\"exclusiveMinimum\":false}},\"title\":\"Beam Geometry\",\"$schema\":\"h"
    "ttp://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":"
    "\"Laser beam geometry "
    "details\",\"required\":[\"beam_exit_diameter\",\"beam_divergence\"]}"
    ,
    /* example: */
    "{\"beam_exit_diameter\":0.0072,\"beam_divergence\":0.0003}"
};

// List of control object type definitions
const MetaDataItemInfo RDB_RIEGL_CONTROL_OBJECT_CATALOG = {
    /* name        */ "riegl.control_object_catalog",
    /* title       */ "Control Object Catalog",
    /* description */ "List of control object type definitions",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"types\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"oneOf"
    "\":[{\"$ref\":\"#/definitions/rectangle\"},{\"$ref\":\"#/definitions/checkerbo"
    "ard2x2\"},{\"$ref\":\"#/definitions/chevron\"},{\"$ref\":\"#/definitions/circu"
    "lar_disk\"},{\"$ref\":\"#/definitions/cylinder\"},{\"$ref\":\"#/definitions/sp"
    "here\"},{\"$ref\":\"#/definitions/round_corner_cube_prism\"}]},\"uniqueItems"
    "\":true}},\"required\":[\"types\"],\"title\":\"Control Object Catalog\",\"$schem"
    "a\":\"http://json-schema.org/draft-04/schema#\",\"definitions\":{\"circular_"
    "disk\":{\"allOf\":[{\"$ref\":\"#/definitions/common\"},{\"properties\":{\"offset"
    "\":{\"type\":\"number\",\"description\":\"offset in meters, e.g. reflector "
    "constant (optional)\"},\"diameter\":{\"minimum\":0,\"type\":\"number\",\"descrip"
    "tion\":\"diameter in meters\",\"exclusiveMinimum\":true},\"shape\":{\"enum\":[\""
    "circular_disk\"],\"type\":\"string\",\"description\":\"shape "
    "identifier\"}},\"type\":\"object\",\"description\":\"circular disk specific pr"
    "operties\",\"required\":[\"shape\",\"diameter\"]}],\"type\":\"object\",\"descripti"
    "on\":\"circular disk\"},\"cylinder\":{\"allOf\":[{\"$ref\":\"#/definitions/commo"
    "n\"},{\"properties\":{\"diameter\":{\"minimum\":0,\"type\":\"number\",\"descriptio"
    "n\":\"diameter in meters\",\"exclusiveMinimum\":true},\"height\":{\"minimum\":0"
    ",\"type\":\"number\",\"description\":\"height in meters\",\"exclusiveMinimum\":t"
    "rue},\"shape\":{\"enum\":[\"cylinder\"],\"type\":\"string\",\"description\":\"shape"
    " identifier\"}},\"type\":\"object\",\"description\":\"cylinder specific proper"
    "ties\",\"required\":[\"shape\",\"diameter\",\"height\"]}],\"type\":\"object\",\"desc"
    "ription\":\"cylinder\"},\"rectangle\":{\"allOf\":[{\"$ref\":\"#/definitions/comm"
    "on\"},{\"properties\":{\"width\":{\"minimum\":0,\"type\":\"number\",\"description\""
    ":\"width in meters\",\"exclusiveMinimum\":true},\"length\":{\"minimum\":0,\"typ"
    "e\":\"number\",\"description\":\"length in meters\",\"exclusiveMinimum\":true},"
    "\"shape\":{\"enum\":[\"rectangle\"],\"type\":\"string\"}},\"type\":\"object\",\"descr"
    "iption\":\"rectangle specific properties\",\"required\":[\"shape\",\"length\",\""
    "width\"]}],\"type\":\"object\",\"description\":\"rectangle\"},\"round_corner_cub"
    "e_prism\":{\"allOf\":[{\"$ref\":\"#/definitions/common\"},{\"properties\":{\"off"
    "set\":{\"type\":\"number\",\"description\":\"offset in meters, e.g. reflector "
    "constant (optional)\"},\"diameter\":{\"minimum\":0,\"type\":\"number\",\"descrip"
    "tion\":\"diameter in meters\",\"exclusiveMinimum\":true},\"shape\":{\"enum\":[\""
    "round_corner_cube_prism\"],\"type\":\"string\",\"description\":\"shape "
    "identifier\"}},\"type\":\"object\",\"description\":\"round corner cube prism "
    "specific properties\",\"required\":[\"shape\",\"diameter\"]}],\"type\":\"object\""
    ",\"description\":\"round corner cube prism\"},\"sphere\":{\"allOf\":[{\"$ref\":\""
    "#/definitions/common\"},{\"properties\":{\"diameter\":{\"minimum\":0,\"type\":\""
    "number\",\"description\":\"diameter in meters\",\"exclusiveMinimum\":true},\"s"
    "hape\":{\"enum\":[\"sphere\"],\"type\":\"string\",\"description\":\"shape "
    "identifier\"}},\"type\":\"object\",\"description\":\"sphere specific propertie"
    "s\",\"required\":[\"shape\",\"diameter\"]}],\"type\":\"object\",\"description\":\"sp"
    "here\"},\"common\":{\"properties\":{\"name\":{\"type\":\"string\",\"description\":\""
    "unique type identifier\",\"minLength\":3},\"description\":{\"type\":\"string\","
    "\"description\":\"string describing the object\"},\"surface_type\":{\"enum\":["
    "\"retro_reflective_foil\",\"diffuse\"],\"type\":\"string\",\"description\":\"surf"
    "ace material type\"},\"shape\":{\"enum\":[\"rectangle\",\"checkerboard2x2\",\"ch"
    "evron\",\"circular_disk\",\"cylinder\",\"sphere\",\"round_corner_cube_prism\"],"
    "\"type\":\"string\",\"description\":\"shape "
    "identifier\"}},\"type\":\"object\",\"description\":\"common object properties\""
    ",\"required\":[\"name\",\"shape\"]},\"checkerboard2x2\":{\"allOf\":[{\"$ref\":\"#/d"
    "efinitions/common\"},{\"properties\":{\"square_length\":{\"minimum\":0,\"type\""
    ":\"number\",\"description\":\"length of a square of the checkerboard in met"
    "ers\",\"exclusiveMinimum\":true},\"shape\":{\"enum\":[\"checkerboard2x2\"],\"typ"
    "e\":\"string\",\"description\":\"shape "
    "identifier\"}},\"type\":\"object\",\"description\":\"checkerboard specific pro"
    "perties\",\"required\":[\"shape\",\"square_length\"]}],\"type\":\"object\",\"descr"
    "iption\":\"checkerboard 2 by 2\"},\"chevron\":{\"allOf\":[{\"$ref\":\"#/definiti"
    "ons/common\"},{\"properties\":{\"thickness\":{\"minimum\":0,\"type\":\"number\",\""
    "description\":\"thickness in meters\",\"exclusiveMinimum\":true},\"outside_e"
    "dge_length\":{\"minimum\":0,\"type\":\"number\",\"description\":\"length of the "
    "two outer edges in meters\",\"exclusiveMinimum\":true},\"shape\":{\"enum\":[\""
    "chevron\"],\"type\":\"string\",\"description\":\"shape "
    "identifier\"}},\"type\":\"object\",\"description\":\"chevron specific properti"
    "es\",\"required\":[\"shape\",\"outside_edge_length\",\"thickness\"]}],\"type\":\"o"
    "bject\",\"description\":\"chevron\"}},\"description\":\"List of control object"
    " type definitions\",\"type\":\"object\"}"
    ,
    /* example: */
    "{\"types\":[{\"length\":0.6,\"name\":\"Rectangle "
    "60x30\",\"description\":\"Rectangle (60cm x 30cm)\",\"width\":0.3,\"shape\":\"re"
    "ctangle\"},{\"length\":0.8,\"name\":\"Rectangle "
    "80x40\",\"description\":\"Rectangle (80cm x "
    "40cm)\",\"width\":0.4,\"shape\":\"rectangle\"},{\"name\":\"Checkerboard2x2 "
    "30\",\"description\":\"Checkerboard (square length: 30cm)\",\"square_length\""
    ":0.3,\"shape\":\"checkerboard2x2\"},{\"name\":\"Checkerboard2x2 "
    "50\",\"description\":\"Checkerboard (square length: 50cm)\",\"square_length\""
    ":0.5,\"shape\":\"checkerboard2x2\"},{\"outside_edge_length\":0.6096,\"name\":\""
    "Chevron 24''/4''\",\"thickness\":0.1016,\"description\":\"Chevron (a=24''; "
    "b=4'')\",\"shape\":\"chevron\"},{\"diameter\":0.5,\"name\":\"Circular Disk "
    "50\",\"description\":\" Circular Disk (diameter: 50cm)\",\"surface_type\":\"di"
    "ffuse\",\"shape\":\"circular_disk\"},{\"name\":\"RIEGL flat reflector 50 "
    "mm\",\"description\":\"flat circular reflector from retro-reflective foil\""
    ",\"offset\":0.0,\"diameter\":0.05,\"surface_type\":\"retro_reflective_foil\",\""
    "shape\":\"circular_disk\"},{\"name\":\"RIEGL flat reflector 100 "
    "mm\",\"description\":\"flat circular reflector from retro-reflective foil\""
    ",\"offset\":0.0,\"diameter\":0.1,\"surface_type\":\"retro_reflective_foil\",\"s"
    "hape\":\"circular_disk\"},{\"name\":\"RIEGL flat reflector 150 "
    "mm\",\"description\":\"flat circular reflector from retro-reflective foil\""
    ",\"offset\":0.0,\"diameter\":0.15,\"surface_type\":\"retro_reflective_foil\",\""
    "shape\":\"circular_disk\"},{\"name\":\"RIEGL cylindrical reflector 50 "
    "mm\",\"description\":\"cylindrical reflector from retro-reflective foil\",\""
    "diameter\":0.05,\"height\":0.05,\"surface_type\":\"retro_reflective_foil\",\"s"
    "hape\":\"cylinder\"},{\"name\":\"RIEGL cylindrical reflector 100 "
    "mm\",\"description\":\"cylindrical reflector from retro-reflective foil\",\""
    "diameter\":0.1,\"height\":0.1,\"surface_type\":\"retro_reflective_foil\",\"sha"
    "pe\":\"cylinder\"},{\"diameter\":0.2,\"name\":\"Sphere 200 "
    "mm\",\"description\":\"Sphere (diameter: 200 "
    "mm)\",\"shape\":\"sphere\"},{\"diameter\":0.05,\"name\":\"Corner Cube Prism 50 "
    "mm\",\"offset\":0.0,\"description\":\"round corner cube "
    "prism\",\"shape\":\"round_corner_cube_prism\"}],\"comments\":[\"This file "
    "contains a list of control object types (aka. 'catalog').\",\"Each type "
    "is described by an object,\",\"which must contain at least the following"
    " parameters:\",\"  - name: unique identifier of the type\",\"  - shape: "
    "one of the following supported shapes:\",\"      - rectangle\",\"      - "
    "checkerboard2x2\",\"      - chevron\",\"      - circular_disk\",\"      - "
    "cylinder\",\"      - sphere\",\"      - "
    "round_corner_cube_prism\",\"Depending on 'shape', the following "
    "parameters must/may be specified:\",\"  - rectangle:\",\"      - length: "
    "length in meters\",\"      - width: width in meters\",\"  - "
    "checkerboard2x2:\",\"      - square_length: length of a square of the "
    "checkerboard in meters\",\"  - circular_disk:\",\"      - diameter: "
    "diameter in meters\",\"      - offset: offset in meters, e.g. reflector "
    "constant (optional)\",\"  - chevron:\",\"      - outside_edge_length: "
    "length of the two outer edges in meters\",\"      - thickness: thickness"
    " in meters\",\"  - cylinder:\",\"      - diameter: diameter in meters\",\""
    "      - height: height in meters\",\"  - sphere:\",\"      - diameter: "
    "diameter in meters\",\"  - round_corner_cube_prism:\",\"      - diameter: "
    "diameter in meters\",\"      - offset: offset in meters, e.g. reflector "
    "constant (optional)\",\"Optional parameters:\",\"    - description: string"
    " describing the object\",\"    - surface_type: surface material type "
    "(either 'retro_reflective_foil' or 'diffuse')\"]}"
};

// Details about the control object reference file
const MetaDataItemInfo RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE = {
    /* name        */ "riegl.control_object_reference_file",
    /* title       */ "Control Object Reference file",
    /* description */ "Details about the control object reference file",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"reference_file\":{\"properties\":{\"file_path\":{\"type\":\"st"
    "ring\",\"description\":\"Path of the control object file relative to "
    "referring file\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"Control "
    "object file's Universally Unique Identifier (RFC "
    "4122)\"}},\"type\":\"object\",\"description\":\"Reference to a control object "
    "file\",\"required\":[\"file_uuid\",\"file_path\"]}},\"$schema\":\"http://json-sc"
    "hema.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Details "
    "about the control object reference file\",\"title\":\"Control Object "
    "Reference file\"}"
    ,
    /* example: */
    "{\"reference_file\":{\"file_path\":\"../../../10_CONTROL_OBJECTS/ControlPoi"
    "nts.cpx\",\"file_uuid\":\"810f5d57-eccf-49ed-b07a-0cdd109b4213\"}}"
};

// Detection probability as a function of amplitude
const MetaDataItemInfo RDB_RIEGL_DETECTION_PROBABILITY = {
    /* name        */ "riegl.detection_probability",
    /* title       */ "Detection Probability",
    /* description */ "Detection probability as a function of amplitude",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"amplitude\":{\"type\":\"array\",\"description\":\"Amplitude [d"
    "B]\",\"items\":{\"type\":\"number\"}},\"detection_probability\":{\"type\":\"array\""
    ",\"description\":\"Detection probability "
    "[0..1]\",\"items\":{\"type\":\"number\"}}},\"title\":\"Detection Probability\",\"$"
    "schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"des"
    "cription\":\"Detection probability as a function of "
    "amplitude\",\"required\":[\"amplitude\",\"detection_probability\"]}"
    ,
    /* example: */
    "{\"amplitude\":[0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0],\"detection"
    "_probability\":[0.0,0.5,0.8,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0]}"
};

// Details about the device used to acquire the point cloud
const MetaDataItemInfo RDB_RIEGL_DEVICE = {
    /* name        */ "riegl.device",
    /* title       */ "Device Information",
    /* description */ "Details about the device used to acquire the point cloud",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"channel_number\":{\"minimum\":0,\"type\":\"integer\",\"descrip"
    "tion\":\"Laser channel number (not defined or 0: single channel device)\""
    ",\"exclusiveMinimum\":false},\"device_build\":{\"type\":\"string\",\"descriptio"
    "n\":\"Device build "
    "variant\"},\"device_name\":{\"type\":\"string\",\"description\":\"Optional "
    "device name (e.g. 'Scanner 1' for multi-scanner "
    "systems)\"},\"serial_number\":{\"type\":\"string\",\"description\":\"Device "
    "serial number (e.g. "
    "S2221234)\"},\"device_type\":{\"type\":\"string\",\"description\":\"Device type "
    "identifier (e.g. "
    "VZ-400i)\"},\"channel_text\":{\"type\":\"string\",\"description\":\"Optional "
    "channel description (e.g. 'Green Channel' for multi-channel "
    "devices)\"}},\"title\":\"Device Information\",\"$schema\":\"http://json-schema"
    ".org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Details about "
    "the device used to acquire the point "
    "cloud\",\"required\":[\"device_type\",\"serial_number\"]}"
    ,
    /* example: */
    "{\"channel_number\":0,\"device_build\":\"\",\"device_name\":\"Scanner 1\",\"seria"
    "l_number\":\"S2221234\",\"device_type\":\"VZ-400i\",\"channel_text\":\"\"}"
};

// Scanner device geometry details
const MetaDataItemInfo RDB_RIEGL_DEVICE_GEOMETRY = {
    /* name        */ "riegl.device_geometry",
    /* title       */ "Device Geometry",
    /* description */ "Scanner device geometry details",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"secondary\":{\"properties\":{\"ID\":{\"minItems\":2,\"type\":\"a"
    "rray\",\"description\":\"Structure identifier\",\"items\":{\"type\":\"integer\"},"
    "\"maxItems\":2},\"content\":{\"type\":\"array\",\"description\":\"Internal "
    "calibration values\",\"items\":{\"type\":\"number\"}}},\"type\":\"object\",\"descr"
    "iption\":\"Additional device geometry structure (optional)\",\"required\":["
    "\"ID\",\"content\"]},\"primary\":{\"properties\":{\"ID\":{\"minItems\":2,\"type\":\"a"
    "rray\",\"description\":\"Structure identifier\",\"items\":{\"type\":\"integer\"},"
    "\"maxItems\":2},\"content\":{\"type\":\"array\",\"description\":\"Internal "
    "calibration values\",\"items\":{\"type\":\"number\"}}},\"type\":\"object\",\"descr"
    "iption\":\"Primary device geometry structure (mandatory)\",\"required\":[\"I"
    "D\",\"content\"]},\"amu\":{\"properties\":{\"frameCC\":{\"minimum\":0,\"type\":\"num"
    "ber\",\"description\":\"Frame Circle Count (number of LSBs per full "
    "rotation about frame axis)\",\"exclusiveMinimum\":false},\"lineCC\":{\"minim"
    "um\":0,\"type\":\"number\",\"description\":\"Line Circle Count (number of LSBs"
    " per full rotation about line "
    "axis)\",\"exclusiveMinimum\":false}},\"type\":\"object\",\"description\":\"Angle"
    " Measurement Unit\"}},\"title\":\"Device Geometry\",\"$schema\":\"http://json-"
    "schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Scanner "
    "device geometry details\",\"required\":[\"primary\"]}"
    ,
    /* example: */
    "{\"secondary\":{\"ID\":[91,0],\"content\":[0]},\"primary\":{\"ID\":[4,0],\"conten"
    "t\":[0]},\"amu\":{\"frameCC\":124000,\"lineCC\":124000}}"
};

// Scanner passive channel device geometry details
const MetaDataItemInfo RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL = {
    /* name        */ "riegl.device_geometry_passive_channel",
    /* title       */ "Device Geometry Passive Channel",
    /* description */ "Scanner passive channel device geometry details",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"primary\":{\"properties\":{\"ID\":{\"minItems\":2,\"type\":\"arr"
    "ay\",\"description\":\"Structure identifier\",\"items\":{\"type\":\"integer\"},\"m"
    "axItems\":2},\"content\":{\"type\":\"array\",\"description\":\"Internal "
    "calibration values\",\"items\":{\"type\":\"number\"}}},\"type\":\"object\",\"descr"
    "iption\":\"Primary device geometry structure "
    "(mandatory)\",\"required\":[\"ID\",\"content\"]}},\"title\":\"Device Geometry "
    "Passive Channel\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\""
    "type\":\"object\",\"description\":\"Scanner passive channel device geometry "
    "details\",\"required\":[\"primary\"]}"
    ,
    /* example: */
    "{\"primary\":{\"ID\":[143,0],\"content\":[0]}}"
};

// Limits of the measured values output by the device
const MetaDataItemInfo RDB_RIEGL_DEVICE_OUTPUT_LIMITS = {
    /* name        */ "riegl.device_output_limits",
    /* title       */ "Device Output Limits",
    /* description */ "Limits of the measured values output by the device",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"deviation_minimum\":{\"type\":\"number\",\"description\":\"Min"
    "imum possible pulse shape "
    "deviation.\"},\"range_minimum\":{\"type\":\"number\",\"description\":\"Minimum "
    "possible range in "
    "meters.\"},\"range_maximum\":{\"type\":\"number\",\"description\":\"Maximum "
    "possible range in meters.\"},\"reflectance_minimum\":{\"type\":\"number\",\"de"
    "scription\":\"Minimum possible reflectance in "
    "dB.\"},\"echo_count_maximum\":{\"type\":\"number\",\"description\":\"Maximum "
    "number of echoes a laser shot can "
    "have.\"},\"deviation_maximum\":{\"type\":\"number\",\"description\":\"Maximum "
    "possible pulse shape deviation.\"},\"amplitude_maximum\":{\"type\":\"number\""
    ",\"description\":\"Maximum possible amplitude in "
    "dB.\"},\"amplitude_minimum\":{\"type\":\"number\",\"description\":\"Minimum "
    "possible amplitude in dB.\"},\"background_radiation_minimum\":{\"type\":\"nu"
    "mber\",\"description\":\"Minimum possible background radiation.\"},\"backgro"
    "und_radiation_maximum\":{\"type\":\"number\",\"description\":\"Maximum "
    "possible background radiation.\"},\"mta_zone_count_maximum\":{\"type\":\"num"
    "ber\",\"description\":\"Maximum number of MTA "
    "zones.\"},\"reflectance_maximum\":{\"type\":\"number\",\"description\":\"Maximum"
    " possible reflectance in dB.\"}},\"$schema\":\"http://json-schema.org/draf"
    "t-04/schema#\",\"type\":\"object\",\"description\":\"Limits of the measured "
    "values output by the device. The limits depend on the device type, "
    "measurement program and/or scan pattern.\",\"title\":\"Device Output "
    "Limits\"}"
    ,
    /* example: */
    "{\"background_radiation_minimum\":0,\"mta_zone_count_maximum\":7,\"deviatio"
    "n_minimum\":-1,\"amplitude_maximum\":100.0,\"amplitude_minimum\":0.0,\"range"
    "_maximum\":10000.0,\"deviation_maximum\":32767,\"range_minimum\":2.9,\"backg"
    "round_radiation_maximum\":0,\"reflectance_minimum\":-100.0,\"reflectance_m"
    "aximum\":100.0}"
};

// Details about the devices used to acquire the point cloud
const MetaDataItemInfo RDB_RIEGL_DEVICES = {
    /* name        */ "riegl.devices",
    /* title       */ "Devices Information",
    /* description */ "Details about the devices used to acquire the point cloud",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"array\",\"d"
    "escription\":\"Details about the devices used to acquire the point cloud"
    " (e.g. when merging point clouds of different devices)\",\"items\":{\"prop"
    "erties\":{\"channel_number\":{\"minimum\":0,\"type\":\"integer\",\"description\":"
    "\"Laser channel number (not defined or 0: single channel device)\",\"excl"
    "usiveMinimum\":false},\"device_build\":{\"type\":\"string\",\"description\":\"De"
    "vice build "
    "variant\"},\"device_name\":{\"type\":\"string\",\"description\":\"Optional "
    "device name (e.g. 'Scanner 1' for multi-scanner "
    "systems)\"},\"serial_number\":{\"type\":\"string\",\"description\":\"Device "
    "serial number (e.g. "
    "S2221234)\"},\"device_type\":{\"type\":\"string\",\"description\":\"Device type "
    "identifier (e.g. "
    "VZ-400i)\"},\"signed\":{\"type\":\"boolean\",\"description\":\"Flag that is set "
    "when the original 'riegl.device' entry in the source file was "
    "correctly "
    "signed.\"},\"channel_text\":{\"type\":\"string\",\"description\":\"Optional "
    "channel description (e.g. 'Green Channel' for multi-channel devices)\"}"
    "},\"type\":\"object\",\"required\":[\"device_type\",\"serial_number\"]},\"title\":"
    "\"Devices Information\"}"
    ,
    /* example: */
    "[{\"channel_number\":0,\"device_build\":\"\",\"device_name\":\"Scanner 1\",\"seri"
    "al_number\":\"S2221234\",\"device_type\":\"VZ-400i\",\"signed\":false,\"channel_"
    "text\":\"\"},{\"channel_number\":1,\"device_build\":\"\",\"device_name\":\"Scanner"
    " 2\",\"serial_number\":\"S2222680\",\"device_type\":\"VQ-1560i-DW\",\"signed\":tr"
    "ue,\"channel_text\":\"\"},{\"channel_number\":2,\"device_build\":\"\",\"device_na"
    "me\":\"Scanner 3\",\"serial_number\":\"S2222680\",\"device_type\":\"VQ-1560i-DW\""
    ",\"signed\":true,\"channel_text\":\"\"}]"
};

// Distance measuring instrument configuration
const MetaDataItemInfo RDB_RIEGL_DMI_CONFIG = {
    /* name        */ "riegl.dmi_config",
    /* title       */ "DMI Configuration",
    /* description */ "Distance measuring instrument configuration",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"dmi_max_time\":{\"exclusiveMaximum\":false,\"exclusiveMini"
    "mum\":false,\"minimum\":0,\"type\":\"integer\",\"description\":\"Maximum time "
    "interval between trigger events, 0 means timeout is inactive [0.1 msec"
    "]\",\"maximum\":65535},\"dmi_dist_per_tick\":{\"type\":\"number\",\"description\""
    ":\"Distance per tick, just informative [m]\"},\"dmi_count_dir\":{\"exclusiv"
    "eMaximum\":false,\"exclusiveMinimum\":false,\"minimum\":0,\"type\":\"integer\","
    "\"description\":\"DMI count direction is inverted\",\"maximum\":1},\"dmi_min_"
    "time\":{\"exclusiveMaximum\":false,\"exclusiveMinimum\":false,\"minimum\":0,\""
    "type\":\"integer\",\"description\":\"Minimum time interval between trigger "
    "events, 0 means rate limitation is inactive [0.1 msec]\",\"maximum\":6553"
    "5},\"dmi_incr\":{\"exclusiveMaximum\":false,\"exclusiveMinimum\":false,\"mini"
    "mum\":0,\"type\":\"integer\",\"description\":\"Increment in ticks, 0 means "
    "distance trigger is deactivated\",\"maximum\":2147483647}},\"title\":\"DMI C"
    "onfiguration\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"typ"
    "e\":\"object\",\"description\":\"Distance measuring instrument configuration"
    "\",\"required\":[\"dmi_count_dir\",\"dmi_incr\",\"dmi_min_time\",\"dmi_max_time\""
    ",\"dmi_dist_per_tick\"]}"
    ,
    /* example: */
    "{\"dmi_max_time\":100,\"dmi_dist_per_tick\":0.00024399999529123306,\"dmi_co"
    "unt_dir\":0,\"dmi_min_time\":0,\"dmi_incr\":0}"
};

// Dyntrig
const MetaDataItemInfo RDB_RIEGL_DYNTRIG = {
    /* name        */ "riegl.dyntrig",
    /* title       */ "Dyntrig",
    /* description */ "Dyntrig",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"offset\":{\"type\":\"number\",\"description\":\"Offset in "
    "units of dB, for calculation of line\"},\"post\":{\"properties\":{\"a\":{\"min"
    "Items\":1,\"type\":\"array\",\"description\":\"...\",\"items\":{\"type\":\"number\"},"
    "\"maxItems\":2080},\"nc\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"Num"
    "ber of entries\",\"maximum\":255}},\"type\":\"object\",\"description\":\"Dyntrig"
    " post values\",\"required\":[\"nc\",\"a\"]},\"tab\":{\"minItems\":1,\"type\":\"array"
    "\",\"description\":\"...\",\"items\":{\"properties\":{\"dec1\":{\"type\":\"number\",\""
    "description\":\"Decay of post-trigger threshold after del1 in units of "
    "dB/m\"},\"del2\":{\"type\":\"number\",\"description\":\"Length of constant "
    "pre-trigger threshold elevation in units of "
    "m\"},\"thra1\":{\"type\":\"number\",\"description\":\"Post-trigger threshold in "
    "units of dB\"},\"thra2\":{\"type\":\"number\",\"description\":\"Pre-trigger "
    "threshold in units of "
    "dB\"},\"del1\":{\"type\":\"number\",\"description\":\"Length of constant "
    "post-trigger threshold elevation in units of "
    "m\"},\"dec2\":{\"type\":\"number\",\"description\":\"Rise of pre-trigger "
    "threshold after del2 in units of dB/m\"}},\"type\":\"object\",\"description\""
    ":\"...\",\"required\":[\"thra1\",\"del1\",\"dec1\",\"thra2\",\"del2\",\"dec2\"]},\"maxI"
    "tems\":128},\"pre\":{\"properties\":{\"a\":{\"minItems\":1,\"type\":\"array\",\"desc"
    "ription\":\"...\",\"items\":{\"type\":\"number\"},\"maxItems\":2080},\"nc\":{\"minim"
    "um\":0,\"type\":\"integer\",\"description\":\"Number of "
    "entries\",\"maximum\":255}},\"type\":\"object\",\"description\":\"Dyntrig pre va"
    "lues\",\"required\":[\"nc\",\"a\"]},\"scale\":{\"type\":\"number\",\"description\":\"S"
    "cale in units of dB, for calculation of line: line number N=(amplitude"
    "-offset)/scale\"}},\"$schema\":\"http://json-schema.org/draft-04/schema#\","
    "\"description\":\"Dyntrig\",\"title\":\"Dyntrig\"}"
    ,
    /* example: */
    "{\"offset\":0.0,\"post\":{\"a\":[78,86,126,134,31],\"nc\":128},\"tab\":[{\"dec1\":"
    "0.0,\"del2\":0.0,\"thra1\":0.0,\"thra2\":0.0,\"del1\":0.0,\"dec2\":0.0}],\"pre\":{"
    "\"a\":[78,86,126,134,31],\"nc\":128},\"scale\":1.0}"
};

// Details about echo files
const MetaDataItemInfo RDB_RIEGL_ECHO_INFO = {
    /* name        */ "riegl.echo_info",
    /* title       */ "Echo Information",
    /* description */ "Details about echo files",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"echo_file\":{\"properties\":{\"file_extension\":{\"type\":\"st"
    "ring\",\"description\":\"Echo file extension, without the leading "
    "dot\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"File's Universally "
    "Unique Identifier (RFC "
    "4122)\"}},\"type\":\"object\",\"required\":[\"file_extension\"]}},\"title\":\"Echo"
    " Information\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"typ"
    "e\":\"object\",\"description\":\"Details about echo "
    "files\",\"required\":[\"echo_file\"]}"
    ,
    /* example: */
    "{\"echo_file\":{\"file_extension\":\"owp\",\"file_uuid\":\"26a03615-67c0-4bea-8"
    "fe8-c577378fe661\"}}"
};

// Details for exponential decomposition of full waveform data
const MetaDataItemInfo RDB_RIEGL_EXPONENTIAL_DECOMPOSITION = {
    /* name        */ "riegl.exponential_decomposition",
    /* title       */ "Exponential Decomposition",
    /* description */ "Details for exponential decomposition of full waveform data",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"additionalProperties\":false,\"title\":\"Exponential Decomposition\",\"$sc"
    "hema\":\"http://json-schema.org/draft-04/schema#\",\"definitions\":{\"channe"
    "l\":{\"properties\":{\"delay\":{\"type\":\"number\",\"description\":\"delay "
    "calibration in seconds\"},\"a_lin\":{\"exclusiveMaximum\":false,\"exclusiveM"
    "inimum\":false,\"minimum\":0,\"type\":\"number\",\"description\":\"relative "
    "linear amplitude range "
    "[0..1]\",\"maximum\":1},\"scale\":{\"type\":\"number\",\"description\":\"amplitude"
    " calibration\"},\"parameter\":{\"properties\":{\"B\":{\"type\":\"array\",\"descrip"
    "tion\":\"imaginary part of amplitude factor in units of full-scale\",\"ite"
    "ms\":{\"type\":\"number\"}},\"A\":{\"type\":\"array\",\"description\":\"real part of"
    " amplitude factor in units of full-scale\",\"items\":{\"type\":\"number\"}},\""
    "gamma\":{\"type\":\"array\",\"description\":\"decay in 1/second\",\"items\":{\"typ"
    "e\":\"number\"}},\"omega\":{\"type\":\"array\",\"description\":\"angular frequency"
    " in Hz\",\"items\":{\"type\":\"number\"}}},\"type\":\"object\",\"description\":\"par"
    "ameters of the syswave exponential sum\",\"required\":[\"A\",\"B\",\"gamma\",\"o"
    "mega\"]}},\"type\":\"object\",\"required\":[\"delay\",\"scale\",\"parameter\"]}},\"d"
    "escription\":\"Details for exponential decomposition of full waveform da"
    "ta\",\"patternProperties\":{\"^[0-9]+$\":{\"$ref\":\"#/definitions/channel\",\"d"
    "escription\":\"one field per channel, field name is channel "
    "index\"}},\"type\":\"object\"}"
    ,
    /* example: */
    "{\"0\":{\"delay\":3.783458418887631e-09,\"a_lin\":0.27,\"scale\":1.0,\"paramete"
    "r\":{\"B\":[-3.9813032150268555,0.08622030913829803,-0.3152860999107361],"
    "\"A\":[0.9772450923919678,0.3354335129261017,-1.312678575515747],\"gamma\""
    ":[-1094726528.0,-769562752.0,-848000064.0],\"omega\":[352020896.0,364792"
    "7552.0,-1977987072.0]}},\"1\":{\"delay\":3.5e-09,\"a_lin\":0.9,\"scale\":1.0,\""
    "parameter\":{\"B\":[-3.9,0.0,-0.3],\"A\":[0.9,0.3,-1.3],\"gamma\":[-109472652"
    "8.0,-769562752.0,-848000064.0],\"omega\":[352020896.0,3647927552.0,-1977"
    "987072.0]}}}"
};

// Details for Gaussian decomposition of full waveform data
const MetaDataItemInfo RDB_RIEGL_GAUSSIAN_DECOMPOSITION = {
    /* name        */ "riegl.gaussian_decomposition",
    /* title       */ "Gaussian Decomposition",
    /* description */ "Details for Gaussian decomposition of full waveform data",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"range_offset_sec_high_power\":{\"type\":\"array\",\"items\":{"
    "\"type\":\"number\"}},\"amplitude_lsb_high_power\":{\"type\":\"array\",\"items\":{"
    "\"type\":\"number\"}},\"range_offset_sec_low_power\":{\"type\":\"array\",\"items\""
    ":{\"type\":\"number\"}},\"amplitude_lsb_low_power\":{\"type\":\"array\",\"items\":"
    "{\"type\":\"number\"}},\"amplitude_db\":{\"type\":\"array\",\"items\":{\"type\":\"num"
    "ber\"}}},\"title\":\"Gaussian Decomposition\",\"$schema\":\"http://json-schema"
    ".org/draft-04/schema#\",\"type\":\"object\",\"description\":\"riegl.gaussian_d"
    "ecomposition contains information relevant for extracting calibrated "
    "amplitudes and calibrated ranges from a Gaussian decomposition of full"
    " waveform data. This information is contained in a table with five "
    "columns. Two columns are to be used as input: amplitude_lsb_low_power "
    "and amplitude_lsb_high_power. The other three columns provide the "
    "outputs. Amplitude_db gives the calibrated amplitude in the optical "
    "regime in decibels. The range offset columns provide additive range "
    "offsets, given in units of seconds, for each channel.\",\"required\":[\"am"
    "plitude_lsb_low_power\",\"amplitude_lsb_high_power\",\"amplitude_db\",\"rang"
    "e_offset_sec_low_power\",\"range_offset_sec_high_power\"]}"
    ,
    /* example: */
    "{\"range_offset_sec_high_power\":[],\"amplitude_lsb_high_power\":[],\"range"
    "_offset_sec_low_power\":[],\"amplitude_lsb_low_power\":[],\"amplitude_db\":"
    "[]}"
};

// Point cloud georeferencing information
const MetaDataItemInfo RDB_RIEGL_GEO_TAG = {
    /* name        */ "riegl.geo_tag",
    /* title       */ "Geo Tag",
    /* description */ "Point cloud georeferencing information",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"crs\":{\"properties\":{\"name\":{\"type\":\"string\",\"descripti"
    "on\":\"Coordinate reference system "
    "name\"},\"wkt\":{\"type\":\"string\",\"description\":\"\\\"Well-Known Text\\\" "
    "string, OGC WKT dialect (see http://www.opengeospatial.org/standards/w"
    "kt-crs)\"},\"epsg\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"EPSG "
    "code\"}},\"type\":\"object\",\"description\":\"Global Coordinate Reference "
    "System. Please note that only 3D Cartesian Coordinate Systems are allo"
    "wed.\"},\"pose\":{\"maxItems\":4,\"type\":\"array\",\"description\":\"Coordinate "
    "Transformation Matrix to transform from File Coordinate System to "
    "Global Coordinate Reference System. 4x4 matrix stored as two "
    "dimensional array, row major order.\",\"items\":{\"maxItems\":4,\"type\":\"arr"
    "ay\",\"description\":\"rows\",\"items\":{\"type\":\"number\",\"description\":\"colum"
    "ns\"},\"minItems\":4},\"minItems\":4}},\"$schema\":\"http://json-schema.org/dr"
    "aft-04/schema#\",\"type\":\"object\",\"description\":\"Point cloud "
    "georeferencing information\",\"title\":\"Geo Tag\"}"
    ,
    /* example: */
    "{\"crs\":{\"name\":\"WGS84 Geocentric\",\"wkt\":\"GEOCCS[\\\"WGS84 Geocentric\\\",D"
    "ATUM[\\\"WGS84\\\",SPHEROID[\\\"WGS84\\\",6378137.000,298.257223563,AUTHORITY["
    "\\\"EPSG\\\",\\\"7030\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6326\\\"]],PRIMEM[\\\"Greenwich\\\""
    ",0.0000000000000000,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"Meter\\\",1.000"
    "00000000000000000,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"X\\\",OTHER],AXIS"
    "[\\\"Y\\\",EAST],AXIS[\\\"Z\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"4978\\\"]]\",\"epsg\":4"
    "978},\"pose\":[[-0.269827776749716,-0.723017716139738,0.635954678449952,"
    "4063882.500831],[0.962908599449764,-0.20260517250352,0.178208229833847"
    ",1138787.607461],[0.0,0.660451759194338,0.7508684796801,4766084.550196"
    "],[0.0,0.0,0.0,1.0]]}"
};

// Geometric scale factor applied to point coordinates
const MetaDataItemInfo RDB_RIEGL_GEOMETRIC_SCALE_FACTOR = {
    /* name        */ "riegl.geometric_scale_factor",
    /* title       */ "Geometric Scale Factor",
    /* description */ "Geometric scale factor applied to point coordinates",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"number\",\""
    "description\":\"Geometric scale factor applied to point "
    "coordinates\",\"exclusiveMinimum\":true,\"minimum\":0}"
    ,
    /* example: */
    "1.0"
};

// Parameters used for georeferencing of the point cloud
const MetaDataItemInfo RDB_RIEGL_GEOREFERENCING_PARAMETERS = {
    /* name        */ "riegl.georeferencing_parameters",
    /* title       */ "Georeferencing Parameters",
    /* description */ "Parameters used for georeferencing of the point cloud",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"trajectory_offsets\":{\"properties\":{\"offset_yaw\":{\"type"
    "\":\"number\",\"description\":\"[deg]\"},\"offset_roll\":{\"type\":\"number\",\"desc"
    "ription\":\"[deg]\"},\"offset_pitch\":{\"type\":\"number\",\"description\":\"[deg]"
    "\"},\"offset_east\":{\"type\":\"number\",\"description\":\"[m]\"},\"offset_height\""
    ":{\"type\":\"number\",\"description\":\"[m]\"},\"offset_time\":{\"type\":\"number\","
    "\"description\":\"[s]\"},\"version\":{\"type\":\"integer\",\"description\":\"Meanin"
    "g of offset values and how to apply them; version 0: "
    "Rz(yaw+offset_yaw)*Ry(pitch+offset_pitch)*Rx(roll+offset_roll), "
    "version 1: Rz(yaw)*Ry(pitch)*Rx(roll) * Rz(offset_yaw)*Ry(offset_pitch"
    ")*Rx(offset_roll)\"},\"offset_north\":{\"type\":\"number\",\"description\":\"[m]"
    "\"}},\"type\":\"object\",\"description\":\"Correction offsets applied to the "
    "trajectory data\"},\"socs_to_body_matrix\":{\"maxItems\":4,\"type\":\"array\",\""
    "description\":\"Coordinate Transformation Matrix to transform from "
    "Scanner's Own Coordinate System to Body Coordinate System. 4x4 matrix "
    "stored as two dimensional array, row major order.\",\"items\":{\"maxItems\""
    ":4,\"type\":\"array\",\"description\":\"rows\",\"items\":{\"type\":\"number\",\"descr"
    "iption\":\"columns\"},\"minItems\":4},\"minItems\":4},\"socs_to_rocs_matrix\":{"
    "\"maxItems\":4,\"type\":\"array\",\"description\":\"Coordinate Transformation "
    "Matrix to transform from Scanner's Own Coordinate System to Record "
    "Coordinate System. 4x4 matrix stored as two dimensional array, row "
    "major order.\",\"items\":{\"maxItems\":4,\"type\":\"array\",\"description\":\"rows"
    "\",\"items\":{\"type\":\"number\",\"description\":\"columns\"},\"minItems\":4},\"min"
    "Items\":4},\"body_coordinate_system_type\":{\"enum\":[\"NED\",\"ENU\"],\"type\":\""
    "string\",\"description\":\"BODY coordinate frame (NED: North-East-Down, "
    "ENU: East-North-Up), default: NED\"},\"trajectory_file\":{\"properties\":{\""
    "file_extension\":{\"type\":\"string\",\"description\":\"Trajectory file "
    "extension, without the leading "
    "dot\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"File's Universally "
    "Unique Identifier (RFC "
    "4122)\"}},\"type\":\"object\",\"description\":\"Trajectory data used for "
    "georeferencing of the point cloud\",\"required\":[\"file_extension\"]}},\"$s"
    "chema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"desc"
    "ription\":\"Parameters used for georeferencing of the point "
    "cloud\",\"title\":\"Georeferencing Parameters\"}"
    ,
    /* example: */
    "{\"trajectory_offsets\":{\"offset_yaw\":-0.45,\"offset_roll\":0.03,\"offset_p"
    "itch\":0.01,\"offset_east\":0.15,\"offset_height\":-0.2,\"offset_time\":18.00"
    "7,\"version\":0,\"offset_north\":0.07},\"socs_to_body_matrix\":[[-0.26982777"
    "6749716,-0.723017716139738,0.635954678449952,0.0],[0.962908599449764,-"
    "0.20260517250352,0.178208229833847,0.0],[0.0,0.660451759194338,0.75086"
    "84796801,0.0],[0.0,0.0,0.0,1.0]],\"body_coordinate_system_type\":\"NED\",\""
    "trajectory_file\":{\"file_extension\":\"pofx\",\"file_uuid\":\"93a03615-66c0-4"
    "bea-8ff8-c577378fe660\"}}"
};

// Details about GNSS processing
const MetaDataItemInfo RDB_RIEGL_GNSS_PROCESSING_INFO = {
    /* name        */ "riegl.gnss_processing_info",
    /* title       */ "GNSS Processing Information",
    /* description */ "Details about GNSS processing",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"base_stations\":{\"type\":\"array\",\"description\":\"List of "
    "GNSS base stations\",\"items\":{\"properties\":{\"latitude\":{\"type\":\"number\""
    ",\"description\":\"Latitude "
    "[deg]\"},\"longitude\":{\"type\":\"number\",\"description\":\"Longitude "
    "[deg]\"},\"altitude\":{\"type\":\"number\",\"description\":\"Altitude "
    "[m]\"}},\"type\":\"object\",\"description\":\"GNSS base station details\",\"requ"
    "ired\":[\"latitude\",\"longitude\",\"altitude\"]}}},\"$schema\":\"http://json-sc"
    "hema.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Details "
    "about GNSS processing\",\"title\":\"GNSS Processing Information\"}"
    ,
    /* example: */
    "{\"base_stations\":[{\"latitude\":48.658391162,\"longitude\":15.663389822,\"a"
    "ltitude\":379.8004150390625}]}"
};

// Map of item names
const MetaDataItemInfo RDB_RIEGL_ITEM_NAMES = {
    /* name        */ "riegl.item_names",
    /* title       */ "Item Names",
    /* description */ "Map of item names",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"additionalProperties\":false,\"title\":\"Item Names\",\"$schema\":\"http://j"
    "son-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Map of"
    " item names\",\"patternProperties\":{\"^-?[0-9]+$\":{\"type\":\"string\",\"descr"
    "iption\":\"One field per item, field name is item id, field value is "
    "item name\"}}}"
    ,
    /* example: */
    "{\"2\":\"Name of item with id 2\",\"-1\":\"Name of item with id "
    "-1\",\"47\":\"Name of item with id 47\",\"1\":\"Name of item with id 1\"}"
};

// Lag angle depended range and reflectance correction
const MetaDataItemInfo RDB_RIEGL_LAG_ANGLE_CORRECTION = {
    /* name        */ "riegl.lag_angle_correction",
    /* title       */ "Lag Angle Correction",
    /* description */ "Lag angle depended range and reflectance correction",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"range_correction_m\":{\"type\":\"array\",\"description\":\"Ran"
    "ge correction [m] as a function of the range and for applied scanrate,"
    " which defines the lag angle\",\"items\":{\"type\":\"number\"}},\"reflectance_"
    "correction_db\":{\"type\":\"array\",\"description\":\"Reflectance correction "
    "[db] as a function of the range and for applied scanrate\",\"items\":{\"ty"
    "pe\":\"number\"}},\"ranges_m\":{\"type\":\"array\",\"description\":\"Range "
    "[m]\",\"items\":{\"type\":\"number\"}}},\"title\":\"Lag Angle Correction\",\"$sche"
    "ma\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"descrip"
    "tion\":\"Lag angle depended range and reflectance correction\",\"required\""
    ":[\"ranges_m\",\"range_correction_m\",\"reflectance_correction_db\"]}"
    ,
    /* example: */
    "{\"range_correction_m\":[0.0,0.0,0.0004,0.0023,0.0039,0.0053,0.0053],\"re"
    "flectance_correction_db\":[0.0,0.0,0.16,0.46,1.18,2.97,2.97],\"ranges_m\""
    ":[0.0,4.795,31.964,63.928,95.892,127.856,10000.0]}"
};

// License keys for software features
const MetaDataItemInfo RDB_RIEGL_LICENSES = {
    /* name        */ "riegl.licenses",
    /* title       */ "Software License Keys",
    /* description */ "License keys for software features",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"additionalProperties\":false,\"title\":\"Software License Keys\",\"$schema"
    "\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"descripti"
    "on\":\"License keys for software features\",\"patternProperties\":{\"^.*$\":{"
    "\"minItems\":1,\"type\":\"array\",\"description\":\"Each field of the object "
    "represents a feature and holds a list of license keys, where the field"
    " name is the feature "
    "name.\",\"items\":{\"type\":\"string\",\"description\":\"License key (example: "
    "'46AE032A - 39882AC4 - 9EC0A184 - 6F163D73')\"}}}}"
    ,
    /* example: */
    "{\"Full Waveform Analysis Topography\":[\"0FD5FF07 - 011A1255 - 9F76CACA "
    "- 8D2ED557\"],\"MTA resolution\":[\"468E020A - 39A922E4 - B681A184 - "
    "673E3D72\"],\"Full Waveform Analysis Topography with GPU "
    "support\":[\"8AB44126 - 23B92250 - 16E2689F - "
    "34EF7E7B\"],\"Georeferencing\":[\"46AE032A - 39882AC4 - 9EC0A184 - "
    "6F163D73\"]}"
};

// Parameters for MTA processing
const MetaDataItemInfo RDB_RIEGL_MTA_SETTINGS = {
    /* name        */ "riegl.mta_settings",
    /* title       */ "MTA Settings",
    /* description */ "Parameters for MTA processing",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"modulation_depth\":{\"minimum\":0,\"type\":\"number\",\"descri"
    "ption\":\"Depth of pulse position modulation in meter.\"},\"zone_width\":{\""
    "minimum\":0,\"type\":\"number\",\"description\":\"Width of a MTA zone in meter"
    ".\"},\"zone_count\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"Maximum "
    "number of MTA zones.\",\"maximum\":255}},\"$schema\":\"http://json-schema.or"
    "g/draft-04/schema#\",\"type\":\"object\",\"description\":\"Parameters for MTA "
    "processing\",\"title\":\"MTA Settings\"}"
    ,
    /* example: */
    "{\"modulation_depth\":9.368514,\"zone_width\":149.896225,\"zone_count\":23}"
};

// Lookup table for range correction based on raw range
const MetaDataItemInfo RDB_RIEGL_NEAR_RANGE_CORRECTION = {
    /* name        */ "riegl.near_range_correction",
    /* title       */ "Near Range Correction Table",
    /* description */ "Lookup table for range correction based on raw range",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"delta\":{\"type\":\"number\",\"description\":\"Delta between "
    "table entries [m], first entry is at range = 0 "
    "m\"},\"content\":{\"minItems\":1,\"type\":\"array\",\"description\":\"Correction "
    "value [m] to be added to the raw "
    "range\",\"items\":{\"type\":\"number\"},\"maxItems\":2000}},\"title\":\"Near Range"
    " Correction Table\",\"$schema\":\"http://json-schema.org/draft-04/schema#\""
    ",\"type\":\"object\",\"description\":\"Lookup table for range correction "
    "based on raw range\",\"required\":[\"delta\",\"content\"]}"
    ,
    /* example: */
    "{\"delta\":0.512,\"content\":[0.0]}"
};

// Standard deviation for range and amplitude as a function of amplitude
const MetaDataItemInfo RDB_RIEGL_NOISE_ESTIMATES = {
    /* name        */ "riegl.noise_estimates",
    /* title       */ "Noise Estimates",
    /* description */ "Standard deviation for range and amplitude as a function of amplitude",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"amplitude\":{\"type\":\"array\",\"description\":\"Amplitude [d"
    "B]\",\"items\":{\"type\":\"number\"}},\"range_sigma\":{\"type\":\"array\",\"descript"
    "ion\":\"Sigma range [m]\",\"items\":{\"type\":\"number\"}},\"amplitude_sigma\":{\""
    "type\":\"array\",\"description\":\"Sigma amplitude "
    "[dB]\",\"items\":{\"type\":\"number\"}}},\"title\":\"Noise Estimates\",\"$schema\":"
    "\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"description"
    "\":\"Standard deviation for range and amplitude as a function of "
    "amplitude\",\"required\":[\"amplitude\",\"range_sigma\",\"amplitude_sigma\"]}"
    ,
    /* example: */
    "{\"amplitude\":[0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0],\"range_sig"
    "ma\":[0.065,0.056,0.046,0.038,0.032,0.027,0.024,0.021,0.018,0.016,0.014"
    "],\"amplitude_sigma\":[0.988,0.988,0.875,0.774,0.686,0.608,0.54,0.482,0."
    "432,0.39,0.354]}"
};

// Notch filter parameters for window glass echoes
const MetaDataItemInfo RDB_RIEGL_NOTCH_FILTER = {
    /* name        */ "riegl.notch_filter",
    /* title       */ "Notch Filter",
    /* description */ "Notch filter parameters for window glass echoes",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"amplitude_maximum\":{\"minimum\":0,\"type\":\"number\",\"descr"
    "iption\":\"Maximum amplitude "
    "[dB]\"},\"range_minimum\":{\"type\":\"number\",\"description\":\"Minimum range "
    "[m]\"},\"range_maximum\":{\"type\":\"number\",\"description\":\"Maximum range "
    "[m]\"}},\"title\":\"Notch Filter\",\"$schema\":\"http://json-schema.org/draft-"
    "04/schema#\",\"type\":\"object\",\"description\":\"Notch filter parameters for"
    " window glass echoes\",\"required\":[\"range_minimum\",\"range_maximum\",\"amp"
    "litude_maximum\"]}"
    ,
    /* example: */
    "{\"amplitude_maximum\":18.0,\"range_minimum\":-0.5,\"range_maximum\":0.2}"
};

// Details about the pixels contained in the file
const MetaDataItemInfo RDB_RIEGL_PIXEL_INFO = {
    /* name        */ "riegl.pixel_info",
    /* title       */ "Pixel Information",
    /* description */ "Details about the pixels contained in the file",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"size_llcs\":{\"$ref\":\"#/definitions/pixel_size\",\"descrip"
    "tion\":\"Size of pixels in a locally levelled cartesian coordinate "
    "system (xy). This is only used for pixels based on a map projection.\"}"
    ",\"size\":{\"$ref\":\"#/definitions/pixel_size\",\"description\":\"Size of "
    "pixels in file coordinate "
    "system.\"}},\"required\":[\"size\"],\"title\":\"Pixel Information\",\"$schema\":\""
    "http://json-schema.org/draft-04/schema#\",\"definitions\":{\"pixel_size\":{"
    "\"maxItems\":2,\"type\":\"array\",\"description\":\"Size of "
    "pixels.\",\"items\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Length of"
    " pixel edge [m].\"},\"minItems\":2}},\"description\":\"Details about the "
    "pixels contained in the file\",\"type\":\"object\"}"
    ,
    /* example: */
    "{\"size_llcs\":[0.5156575252891171,0.5130835356683303],\"size\":[0.5971642"
    "834779395,0.5971642834779395]}"
};

// Details about the plane patch matching process
const MetaDataItemInfo RDB_RIEGL_PLANE_PATCH_MATCHING = {
    /* name        */ "riegl.plane_patch_matching",
    /* title       */ "Plane Patch Matching",
    /* description */ "Details about the plane patch matching process",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"plane_patch_file_two\":{\"$ref\":\"#/definitions/file_refe"
    "rence\",\"description\":\"Reference to the plane patch file two\"},\"plane_p"
    "atch_file_one\":{\"$ref\":\"#/definitions/file_reference\",\"description\":\"R"
    "eference to the plane patch file one\"}},\"required\":[\"plane_patch_file_"
    "one\",\"plane_patch_file_two\"],\"title\":\"Plane Patch Matching\",\"$schema\":"
    "\"http://json-schema.org/draft-04/schema#\",\"definitions\":{\"file_referen"
    "ce\":{\"properties\":{\"file_path\":{\"type\":\"string\",\"description\":\"Path of"
    " the plane patch file relative to the match "
    "file\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"Plane patch file's "
    "Universally Unique Identifier (RFC "
    "4122)\"}},\"type\":\"object\",\"description\":\"Reference to a plane patch "
    "file\",\"required\":[\"file_uuid\",\"file_path\"]}},\"description\":\"Details "
    "about the plane patch matching process\",\"type\":\"object\"}"
    ,
    /* example: */
    "{\"plane_patch_file_two\":{\"file_path\":\"project.ptch\",\"file_uuid\":\"fa47d"
    "509-a64e-49ce-8b14-ff3130fbefa9\"},\"plane_patch_file_one\":{\"file_path\":"
    "\"Record009_Line001/191025_121410_Scanner_1.ptch\",\"file_uuid\":\"810f5d57"
    "-eccf-49ed-b07a-0cdd109b4213\"}}"
};

// Statistics about plane patches found by plane patch extractor
const MetaDataItemInfo RDB_RIEGL_PLANE_PATCH_STATISTICS = {
    /* name        */ "riegl.plane_patch_statistics",
    /* title       */ "Plane Patch Statistics",
    /* description */ "Statistics about plane patches found by plane patch extractor",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"total_area\":{\"type\":\"number\",\"description\":\"sum of all"
    " plane patch areas [m\\u00b2]\"},\"total_horizontal_area\":{\"type\":\"number"
    "\",\"description\":\"sum of all plane patch areas projected to horizontal "
    "plane [m\\u00b2]\"}},\"$schema\":\"http://json-schema.org/draft-04/schema#\""
    ",\"type\":\"object\",\"description\":\"Statistics about plane patches found "
    "by plane patch extractor\",\"title\":\"Plane Patch Statistics\"}"
    ,
    /* example: */
    "{\"total_area\":14007.965,\"total_horizontal_area\":13954.601}"
};

// Settings and classes for plane slope classification
const MetaDataItemInfo RDB_RIEGL_PLANE_SLOPE_CLASS_INFO = {
    /* name        */ "riegl.plane_slope_class_info",
    /* title       */ "Plane Slope Class Info",
    /* description */ "Settings and classes for plane slope classification",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"settings\":{\"type\":\"object\",\"description\":\"Classificati"
    "on settings, details see documentation of rdbplanes\",\"oneOf\":[{\"$ref\":"
    "\"#/definitions/method-1\"},{\"$ref\":\"#/definitions/method-2\"}]},\"classes"
    "\":{\"type\":\"object\",\"description\":\"Class definition table\",\"patternProp"
    "erties\":{\"^[0-9]+$\":{\"type\":\"string\",\"description\":\"one field per "
    "class, field name is class number, field value is class name\"}},\"addit"
    "ionalProperties\":false}},\"required\":[\"settings\",\"classes\"],\"title\":\"Pl"
    "ane Slope Class Info\",\"$schema\":\"http://json-schema.org/draft-04/schem"
    "a#\",\"type\":\"object\",\"description\":\"Settings and classes for plane "
    "slope classification\",\"definitions\":{\"method-1\":{\"properties\":{\"maximu"
    "m_inclination_angle_horizontal\":{\"minimum\":-360.0,\"type\":\"number\",\"des"
    "cription\":\"maximum inclination angle of horizontal plane patches [deg]"
    "\",\"maximum\":360.0},\"plane_classification_method\":{\"minimum\":1,\"type\":\""
    "integer\",\"description\":\"method ID "
    "(=1)\",\"maximum\":1}},\"type\":\"object\",\"description\":\"Classification "
    "method 1\",\"required\":[\"plane_classification_method\",\"maximum_inclinati"
    "on_angle_horizontal\"]},\"method-2\":{\"properties\":{\"sloping_plane_classe"
    "s_minimum_angle\":{\"minimum\":-360.0,\"type\":\"number\",\"description\":\"mini"
    "mum inclination angle of sloping plane patches [deg]\",\"maximum\":360.0}"
    ",\"plane_classification_method\":{\"minimum\":2,\"type\":\"integer\",\"descript"
    "ion\":\"method ID (=2)\",\"maximum\":2},\"sloping_plane_classes_maximum_angl"
    "e\":{\"minimum\":-360.0,\"type\":\"number\",\"description\":\"maximum "
    "inclination angle of sloping plane patches "
    "[deg]\",\"maximum\":360.0}},\"type\":\"object\",\"description\":\"Classification"
    " method 2\",\"required\":[\"plane_classification_method\",\"sloping_plane_cl"
    "asses_minimum_angle\",\"sloping_plane_classes_maximum_angle\"]}}}"
    ,
    /* example: */
    "{\"settings\":{\"sloping_plane_classes_minimum_angle\":10.0,\"plane_classif"
    "ication_method\":2,\"sloping_plane_classes_maximum_angle\":70.0},\"classes"
    "\":{\"6\":\"vertical, pointing east\",\"10\":\"sloping, pointing down and "
    "east\",\"3\":\"sloping, pointing up and south\",\"7\":\"vertical, pointing "
    "south\",\"8\":\"vertical, pointing north\",\"12\":\"sloping, pointing down and"
    " north\",\"13\":\"sloping, pointing down and west\",\"4\":\"sloping, pointing "
    "up and north\",\"11\":\"sloping, pointing down and "
    "south\",\"14\":\"horizontal, pointing down\",\"9\":\"vertical, pointing "
    "west\",\"2\":\"sloping, pointing up and east\",\"5\":\"sloping, pointing up "
    "and west\",\"1\":\"horizontal, pointing up\"}}"
};

// Grouping and sorting of point attributes for visualization purposes
const MetaDataItemInfo RDB_RIEGL_POINT_ATTRIBUTE_GROUPS = {
    /* name        */ "riegl.point_attribute_groups",
    /* title       */ "Point Attribute Groups",
    /* description */ "Grouping and sorting of point attributes for visualization purposes",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"additionalProperties\":false,\"title\":\"Point Attribute Groups\",\"$schem"
    "a\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"descript"
    "ion\":\"Grouping and sorting of point attributes for visualization purpo"
    "ses\",\"patternProperties\":{\"^.*$\":{\"minItems\":1,\"type\":\"array\",\"descrip"
    "tion\":\"Each field of the object represents a point attribute group and"
    " holds a list of point attributes, where the field name is the group "
    "name.\",\"items\":{\"type\":\"string\",\"description\":\"Point attribute full "
    "name or name pattern (perl regular expression syntax)\"}}}}"
    ,
    /* example: */
    "{\"Coordinates/Vectors\":[\"riegl.xyz\",\"riegl.range\",\"riegl.theta\",\"riegl"
    ".phi\"],\"Primary Attributes\":[\"riegl.reflectance\",\"riegl.amplitude\",\"ri"
    "egl.deviation\"],\"Time\":[\"riegl.timestamp\"],\"Other "
    "Attributes\":[\"riegl.selected\",\"riegl.visible\"],\"Secondary "
    "Attributes\":[\"riegl.mirror_facet\",\"riegl.waveform_available\"]}"
};

// Details about point cloud files
const MetaDataItemInfo RDB_RIEGL_POINTCLOUD_INFO = {
    /* name        */ "riegl.pointcloud_info",
    /* title       */ "Point Cloud Information",
    /* description */ "Details about point cloud files",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"project\":{\"type\":\"string\",\"description\":\"Project name\""
    "},\"field_of_application\":{\"enum\":[\"unknown\",\"SLS\",\"TLS\",\"KLS\",\"MLS\",\"U"
    "LS\",\"ALS\",\"BLS\",\"ILS\"],\"type\":\"string\",\"description\":\"Field of applica"
    "tion\"},\"comments\":{\"type\":\"string\",\"description\":\"Comments\"}},\"$schema"
    "\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"descripti"
    "on\":\"Details about point cloud files\",\"title\":\"Point Cloud "
    "Information\"}"
    ,
    /* example: */
    "{\"project\":\"Campaign 4\",\"field_of_application\":\"ALS\",\"comments\":\"Line "
    "3\"}"
};

// Estimated position and orientation information
const MetaDataItemInfo RDB_RIEGL_POSE_ESTIMATION = {
    /* name        */ "riegl.pose_estimation",
    /* title       */ "Pose Estimation",
    /* description */ "Estimated position and orientation information",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"barometric_height_amsl\":{\"type\":\"number\",\"description\""
    ":\"Altitude determined based on the atmospheric pressure according to "
    "the standard atmosphere laws [m].\"},\"position\":{\"properties\":{\"horizon"
    "tal_accuracy\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Horizontal "
    "accuracy [m]\",\"exclusiveMinimum\":true},\"vertical_accuracy\":{\"minimum\":"
    "0,\"type\":\"number\",\"description\":\"Vertical accuracy [m]\",\"exclusiveMini"
    "mum\":true},\"coordinate_2\":{\"type\":\"number\",\"description\":\"Coordinate 2"
    " as defined by axis 2 of the specified CRS (e.g., Y, Longitude)\"},\"crs"
    "\":{\"properties\":{\"wkt\":{\"type\":\"string\",\"description\":\"\\\"Well-Known "
    "Text\\\" string, OGC WKT dialect (see http://www.opengeospatial.org/stan"
    "dards/wkt-crs)\"},\"epsg\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"E"
    "PSG code\"}},\"type\":\"object\",\"description\":\"Global Coordinate Reference"
    " System\",\"required\":[\"epsg\"]},\"coordinate_3\":{\"type\":\"number\",\"descrip"
    "tion\":\"Coordinate 3 as defined by axis 3 of the specified CRS (e.g., "
    "Z, "
    "Altitude)\"},\"coordinate_1\":{\"type\":\"number\",\"description\":\"Coordinate "
    "1 as defined by axis 1 of the specified CRS (e.g., X, "
    "Latitude)\"}},\"type\":\"object\",\"description\":\"Position coordinates and "
    "position accuracy values as measured by GNSS in the specified "
    "Coordinate Reference System (CRS)\",\"required\":[\"coordinate_1\",\"coordin"
    "ate_2\",\"coordinate_3\",\"horizontal_accuracy\",\"vertical_accuracy\",\"crs\"]"
    "},\"orientation\":{\"properties\":{\"roll\":{\"minimum\":-360,\"type\":\"number\","
    "\"description\":\"Roll angle about scanner X-axis [deg]\",\"maximum\":360},\""
    "roll_accuracy\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Roll angle "
    "accuracy [deg]\",\"exclusiveMinimum\":true},\"pitch_accuracy\":{\"minimum\":0"
    ",\"type\":\"number\",\"description\":\"Pitch angle accuracy [deg]\",\"exclusive"
    "Minimum\":true},\"pitch\":{\"minimum\":-360,\"type\":\"number\",\"description\":\""
    "Pitch angle about scanner Y-axis [deg]\",\"maximum\":360},\"yaw\":{\"minimum"
    "\":-360,\"type\":\"number\",\"description\":\"Yaw angle about scanner Z-axis ["
    "deg]\",\"maximum\":360},\"yaw_accuracy\":{\"minimum\":0,\"type\":\"number\",\"desc"
    "ription\":\"Yaw angle accuracy [deg]\",\"exclusiveMinimum\":true}},\"type\":\""
    "object\",\"description\":\"Orientation values and orientation accuracies, "
    "measured with IMU or inclination sensors.\",\"required\":[\"roll\",\"pitch\","
    "\"yaw\",\"roll_accuracy\",\"pitch_accuracy\",\"yaw_accuracy\"]}},\"title\":\"Pose"
    " Estimation\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type"
    "\":\"object\",\"description\":\"Estimated position and orientation "
    "information as measured by GNSS, IMU or inclination "
    "sensors\",\"required\":[\"orientation\"]}"
    ,
    /* example: */
    "{\"barometric_height_amsl\":386.7457796227932,\"position\":{\"horizontal_ac"
    "curacy\":0.810699999332428,\"vertical_accuracy\":1.3314999341964722,\"coor"
    "dinate_2\":15.645033406,\"crs\":{\"wkt\":\"GEOGCS[\\\"WGS84 / Geographic\\\",DAT"
    "UM[\\\"WGS84\\\",SPHEROID[\\\"WGS84\\\",6378137.000,298.257223563,AUTHORITY[\\\""
    "EPSG\\\",\\\"7030\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6326\\\"]],PRIMEM[\\\"Greenwich\\\",0"
    ".0000000000000000,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"Degree\\\",0.0174"
    "5329251994329547,AUTHORITY[\\\"EPSG\\\",\\\"9102\\\"]],AXIS[\\\"Latitude\\\",NORTH"
    "],AXIS[\\\"Longitude\\\",EAST],AUTHORITY[\\\"EPSG\\\",\\\"4979\\\"]]\",\"epsg\":4979}"
    ",\"coordinate_3\":362.7124938964844,\"coordinate_1\":48.655799473},\"orient"
    "ation\":{\"roll\":3.14743073066123,\"roll_accuracy\":0.009433783936875745,\""
    "pitch_accuracy\":0.009433783936875745,\"pitch\":1.509153024827064,\"yaw\":1"
    "01.87293630292045,\"yaw_accuracy\":1.0094337839368757}}"
};

// Details on position and orientation sensors
const MetaDataItemInfo RDB_RIEGL_POSE_SENSORS = {
    /* name        */ "riegl.pose_sensors",
    /* title       */ "Pose Sensors",
    /* description */ "Details on position and orientation sensors",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"accelerometer\":{\"properties\":{\"x_axis\":{\"$ref\":\"#/defi"
    "nitions/vector\",\"description\":\"Sensitive X axis of sensor at frame "
    "angle = 0\"},\"unit\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Unit of"
    " raw data and calibration values, 1 LSB in 9.81 m/s\\u00b2\",\"exclusiveM"
    "inimum\":true},\"y_axis\":{\"$ref\":\"#/definitions/vector\",\"description\":\"S"
    "ensitive Y axis of sensor at frame angle = 0\"},\"relative_nonlinearity\""
    ":{\"$ref\":\"#/definitions/vector\",\"description\":\"Relative nonlinearity, "
    "dimensionless\"},\"z_axis\":{\"$ref\":\"#/definitions/vector\",\"description\":"
    "\"Sensitive Z axis of sensor at frame angle = "
    "0\"},\"offset\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Value to be"
    " subtracted from raw measurement "
    "values\"},\"origin\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Sensor"
    " origin in SOCS [m] at frame angle = "
    "0\"}},\"type\":\"object\",\"description\":\"Accelerometer details\",\"required\":"
    "[\"unit\",\"x_axis\",\"y_axis\",\"z_axis\",\"offset\",\"origin\",\"relative_nonline"
    "arity\"]},\"gyroscope\":{\"properties\":{\"x_axis\":{\"$ref\":\"#/definitions/ve"
    "ctor\",\"description\":\"Sensitive X axis of sensor at frame angle = "
    "0\"},\"unit\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Unit of raw "
    "data and calibration values, 1 LSB in rad/s\",\"exclusiveMinimum\":true},"
    "\"y_axis\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Sensitive Y "
    "axis of sensor at frame angle = 0\"},\"relative_nonlinearity\":{\"$ref\":\"#"
    "/definitions/vector\",\"description\":\"Relative nonlinearity, dimensionle"
    "ss\"},\"z_axis\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Sensitive "
    "Z axis of sensor at frame angle = "
    "0\"},\"offset\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Value to be"
    " subtracted from raw measurement "
    "values\"},\"origin\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Sensor"
    " origin in SOCS [m] at frame angle = "
    "0\"}},\"type\":\"object\",\"description\":\"Gyroscope details\",\"required\":[\"un"
    "it\",\"x_axis\",\"y_axis\",\"z_axis\",\"offset\",\"origin\",\"relative_nonlinearit"
    "y\"]},\"magnetic_field_sensor\":{\"properties\":{\"x_axis\":{\"$ref\":\"#/defini"
    "tions/vector\",\"description\":\"Sensitive X axis of sensor at frame angle"
    " = 0\"},\"unit\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Unit of raw "
    "data and calibration values, 1 LSB in nT\",\"exclusiveMinimum\":true},\"y_"
    "axis\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Sensitive Y axis "
    "of sensor at frame angle = 0\"},\"relative_nonlinearity\":{\"$ref\":\"#/defi"
    "nitions/vector\",\"description\":\"Relative nonlinearity, dimensionless\"},"
    "\"z_axis\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Sensitive Z "
    "axis of sensor at frame angle = "
    "0\"},\"offset\":{\"$ref\":\"#/definitions/vector\",\"description\":\"Value to be"
    " subtracted from raw measurement values\"},\"fixed\":{\"$ref\":\"#/definitio"
    "ns/vector\",\"description\":\"Distortion of magnetic field caused by "
    "non-rotating scanner part\"}},\"type\":\"object\",\"description\":\"Magnetic "
    "Field Sensor details\",\"required\":[\"unit\",\"x_axis\",\"y_axis\",\"z_axis\",\"o"
    "ffset\",\"fixed\",\"relative_nonlinearity\"]}},\"required\":[\"gyroscope\",\"acc"
    "elerometer\",\"magnetic_field_sensor\"],\"title\":\"Pose Sensors\",\"$schema\":"
    "\"http://json-schema.org/draft-04/schema#\",\"definitions\":{\"vector\":{\"mi"
    "nItems\":3,\"type\":\"array\",\"items\":{\"type\":\"number\",\"description\":\"Index"
    " 0=X, 1=Y, 2=Z component\"},\"maxItems\":3}},\"description\":\"Details on "
    "position and orientation sensors\",\"type\":\"object\"}"
    ,
    /* example: */
    "{\"accelerometer\":{\"x_axis\":[-15008.123046875,56.956390380859375,-60.51"
    "75666809082],\"unit\":6.666666740784422e-05,\"y_axis\":[-7.027288913726807"
    ",-44.12333679199219,14952.3701171875],\"relative_nonlinearity\":[0.0,0.0"
    ",0.0],\"z_axis\":[1.639882206916809,15166.744140625,-116.99742889404297]"
    ",\"offset\":[-733.3636474609375,58.969032287597656,1060.2550048828125],\""
    "origin\":[0.026900000870227814,-0.03999999910593033,-0.0895000025629997"
    "3]},\"gyroscope\":{\"x_axis\":[-121.195556640625,0.8219714164733887,0.2313"
    "031703233719],\"unit\":0.00014544410805683583,\"y_axis\":[-0.4407659173011"
    "78,-0.7897399663925171,119.5894775390625],\"relative_nonlinearity\":[2.8"
    "88176311444113e-07,1.06274164579645e-07,-1.7186295080634935e-39],\"z_ax"
    "is\":[0.555869996547699,119.22135162353516,0.467585027217865],\"offset\":"
    "[-50.92609786987305,146.15643310546875,62.4327278137207],\"origin\":[0.0"
    "26900000870227814,-0.03999999910593033,-0.08950000256299973]},\"magneti"
    "c_field_sensor\":{\"x_axis\":[-0.011162743903696537,-2.315962774446234e-0"
    "5,0.00016818844596855342],\"unit\":91.74311828613281,\"y_axis\":[0.0002788"
    "8521435670555,-0.011427424848079681,-5.204829722060822e-05],\"relative_"
    "nonlinearity\":[0.0,0.0,0.0],\"z_axis\":[0.00041987866279669106,7.8769779"
    "06562388e-05,0.011407104320824146],\"offset\":[-23812.052734375,5606.576"
    "66015625,2493.28125],\"fixed\":[-1576.010498046875,1596.081787109375,0.0"
    "]}}"
};

// Laser pulse position modulation used for MTA resolution
const MetaDataItemInfo RDB_RIEGL_PULSE_POSITION_MODULATION = {
    /* name        */ "riegl.pulse_position_modulation",
    /* title       */ "Pulse Position Modulation",
    /* description */ "Laser pulse position modulation used for MTA resolution",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"pulse_interval\":{\"type\":\"array\",\"description\":\"Explici"
    "t table of the pulse position modulation used for MTA resolution. "
    "Table gives times between successive laser pulses in seconds.\",\"items\""
    ":{\"minimum\":0,\"type\":\"number\"}},\"num_mod_ampl\":{\"minimum\":0,\"type\":\"in"
    "teger\",\"description\":\"Number of different modulation amplitudes (2: "
    "binary modulation)\",\"maximum\":255},\"code_phase_mode\":{\"minimum\":0,\"typ"
    "e\":\"integer\",\"description\":\"0: no synchronization, 1: toggle between 2"
    " phases, 2: increment with phase_increment\",\"maximum\":255},\"phase_step"
    "\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"Step width in phase of "
    "modulation code from line to line\",\"maximum\":255},\"length\":{\"minimum\":"
    "0,\"type\":\"integer\",\"description\":\"Length of "
    "code\",\"maximum\":255}},\"title\":\"Pulse Position Modulation\",\"$schema\":\"h"
    "ttp://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":"
    "\"Laser pulse position modulation used for MTA "
    "resolution\",\"required\":[\"length\",\"num_mod_ampl\",\"pulse_interval\"]}"
    ,
    /* example: */
    "{\"pulse_interval\":[2.759375e-06,2.759375e-06,2.759375e-06,2.759375e-06"
    ",2.821875e-06,2.759375e-06,2.759375e-06,2.821875e-06,2.759375e-06,2.82"
    "1875e-06,2.821875e-06,2.759375e-06,2.759375e-06,2.821875e-06,2.821875e"
    "-06,2.821875e-06,2.821875e-06,2.821875e-06,2.759375e-06,2.759375e-06,2"
    ".759375e-06,2.821875e-06,2.821875e-06,2.759375e-06,2.821875e-06,2.8218"
    "75e-06,2.821875e-06,2.759375e-06,2.821875e-06,2.759375e-06,2.821875e-0"
    "6],\"num_mod_ampl\":2,\"code_phase_mode\":2,\"phase_step\":5,\"length\":31}"
};

// Statistics about target distance wrt. SOCS origin
const MetaDataItemInfo RDB_RIEGL_RANGE_STATISTICS = {
    /* name        */ "riegl.range_statistics",
    /* title       */ "Range Statistics",
    /* description */ "Statistics about target distance wrt. SOCS origin",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"minimum\":{\"type\":\"number\",\"description\":\"Minimum "
    "value\"},\"maximum\":{\"type\":\"number\",\"description\":\"Maximum "
    "value\"},\"std_dev\":{\"type\":\"number\",\"description\":\"Standard "
    "deviation\"},\"average\":{\"type\":\"number\",\"description\":\"Average "
    "value\"}},\"title\":\"Range Statistics\",\"$schema\":\"http://json-schema.org/"
    "draft-04/schema#\",\"type\":\"object\",\"description\":\"Statistics about "
    "target distance wrt. SOCS "
    "origin\",\"required\":[\"minimum\",\"average\",\"maximum\",\"std_dev\"]}"
    ,
    /* example: */
    "{\"minimum\":0.919,\"maximum\":574.35,\"std_dev\":24.349,\"average\":15.49738}"
};

// Receiver Internals
const MetaDataItemInfo RDB_RIEGL_RECEIVER_INTERNALS = {
    /* name        */ "riegl.receiver_internals",
    /* title       */ "Receiver Internals",
    /* description */ "Receiver Internals",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"sr\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Sample"
    " rate [Hz]\",\"exclusiveMinimum\":true},\"ex\":{\"type\":\"object\",\"descriptio"
    "n\":\"DEPRECATED, use 'riegl.exponential_decomposition' "
    "instead\"},\"nt\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"Number of "
    "traces\",\"maximum\":255},\"si\":{\"minimum\":0,\"type\":\"number\",\"description\""
    ":\"Start index (hw_start)\",\"maximum\":255},\"a\":{\"minItems\":1,\"type\":\"arr"
    "ay\",\"description\":\"Amplitude [dB]\",\"items\":{\"type\":\"number\"},\"maxItems"
    "\":256},\"t\":{\"type\":\"object\",\"additionalProperties\":false,\"patternPrope"
    "rties\":{\"^[0-9]+$\":{\"$ref\":\"#/definitions/fp\",\"description\":\"one field"
    " per channel, field name is channel "
    "index\"}}},\"mw\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Maximum wei"
    "ght\",\"maximum\":4095,\"exclusiveMinimum\":true},\"ns\":{\"minimum\":0,\"type\":"
    "\"integer\",\"description\":\"Number of samples\",\"maximum\":4095},\"tbl\":{\"mi"
    "nItems\":1,\"type\":\"array\",\"description\":\"various internal "
    "data\",\"items\":{\"$ref\":\"#/definitions/fp_table\"}}},\"title\":\"Receiver In"
    "ternals\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"definiti"
    "ons\":{\"fp_table\":{\"properties\":{\"nx\":{\"type\":\"integer\",\"description\":\""
    "number of x entries\",\"max\":2048,\"min\":1},\"tv\":{\"minItems\":1,\"type\":\"ar"
    "ray\",\"maxItems\":2048,\"items\":{\"oneOf\":[{\"$ref\":\"#/definitions/fp_table"
    "_row\"},{\"type\":\"number\"}]}},\"tc\":{\"type\":\"integer\",\"description\":\"tabl"
    "e data type "
    "code\",\"max\":255,\"min\":0},\"ch\":{\"type\":\"integer\",\"description\":\"channel"
    " number\",\"max\":255,\"min\":0},\"ny\":{\"type\":\"integer\",\"description\":\"numb"
    "er of y entries\",\"max\":2048,\"min\":1}},\"type\":\"object\",\"required\":[\"ch\""
    ",\"tc\",\"nx\",\"ny\",\"tv\"],\"desription\":\"scanner internal data\"},\"fp\":{\"pro"
    "perties\":{\"s\":{\"minItems\":1,\"type\":\"array\",\"items\":{\"minItems\":1,\"type"
    "\":\"array\",\"items\":{\"type\":\"number\"},\"maxItems\":4096},\"maxItems\":256},\""
    "w\":{\"minItems\":1,\"type\":\"array\",\"items\":{\"minItems\":5,\"type\":\"array\",\""
    "items\":{\"type\":\"number\"},\"maxItems\":5},\"maxItems\":256}},\"type\":\"object"
    "\",\"description\":\"Fingerprint values\",\"required\":[\"s\",\"w\"]},\"fp_table_r"
    "ow\":{\"minItems\":1,\"type\":\"array\",\"maxItems\":2048,\"items\":{\"type\":\"numb"
    "er\"}}},\"description\":\"Receiver Internals\",\"type\":\"object\"}"
    ,
    /* example: */
    "{\"sr\":7959997000.0,\"nt\":128,\"si\":48,\"a\":[-1.55],\"t\":{\"0\":{\"s\":[[1.23,4"
    ".56],[7.89,0.12]],\"w\":[[78,86,126,134,31],[78,86,126,134,31]]},\"1\":{\"s"
    "\":[[1.23,4.56],[7.89,0.12]],\"w\":[[78,86,126,134,31],[78,86,126,134,31]"
    "]}},\"mw\":31,\"ns\":400,\"tbl\":[{\"nx\":5,\"tv\":[[1,2,3,4,5],[1.1,2.2,3.3,4.4"
    ",5.5]],\"tc\":1,\"ch\":0,\"ny\":2}]}"
};

// Lookup table for reflectance calculation based on amplitude and range
const MetaDataItemInfo RDB_RIEGL_REFLECTANCE_CALCULATION = {
    /* name        */ "riegl.reflectance_calculation",
    /* title       */ "Reflectance Calculation Table",
    /* description */ "Lookup table for reflectance calculation based on amplitude and range",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"delta\":{\"type\":\"number\",\"description\":\"Delta between "
    "table entries [m], first entry is at range = 0 "
    "m\"},\"content\":{\"minItems\":1,\"type\":\"array\",\"description\":\"Correction "
    "value [dB] to be added to the amplitude\",\"items\":{\"type\":\"number\"},\"ma"
    "xItems\":2000}},\"title\":\"Reflectance Calculation Table\",\"$schema\":\"http"
    "://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Lo"
    "okup table for reflectance calculation based on amplitude and "
    "range\",\"required\":[\"delta\",\"content\"]}"
    ,
    /* example: */
    "{\"delta\":0.150918,\"content\":[-33.01]}"
};

// Range-dependent and scan-angle-dependent correction of reflectance reading
const MetaDataItemInfo RDB_RIEGL_REFLECTANCE_CORRECTION = {
    /* name        */ "riegl.reflectance_correction",
    /* title       */ "Near-Range Reflectance Correction",
    /* description */ "Range-dependent and scan-angle-dependent correction of reflectance reading",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"line_angles_deg\":{\"type\":\"array\",\"description\":\"Angle "
    "[deg]\",\"items\":{\"type\":\"number\"}},\"reflectance_correction_db\":{\"type\":"
    "\"array\",\"description\":\"Near range reflectance correction in dB as a "
    "function of range over "
    "angle\",\"items\":{\"type\":\"array\",\"description\":\"rows (each array "
    "corresponds to a "
    "range)\",\"items\":{\"type\":\"number\",\"description\":\"columns (each value "
    "corresponds to an "
    "angle)\"}}},\"ranges_m\":{\"type\":\"array\",\"description\":\"Range "
    "[m]\",\"items\":{\"type\":\"number\"}}},\"title\":\"Near-range reflectance corre"
    "ction\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"obj"
    "ect\",\"description\":\"Range-dependent and scan-angle-dependent "
    "correction of reflectance reading\",\"required\":[\"ranges_m\",\"line_angles"
    "_deg\",\"reflectance_correction_db\"]}"
    ,
    /* example: */
    "{\"line_angles_deg\":[0.0,0.5,1.0,1.5,1.0,2.0,2.5,3.0,3.5,4.0],\"reflecta"
    "nce_correction_db\":[[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01],[0.8,0"
    ".7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01],[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1"
    ",0.05,0.01],[0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.01]],\"ranges_m\":[0"
    ".0,1.0,2.0,3.0]}"
};

// Details about RiLOC processing
const MetaDataItemInfo RDB_RIEGL_RILOC_PROCESSING_INFO = {
    /* name        */ "riegl.riloc_processing_info",
    /* title       */ "RiLOC Processing Information",
    /* description */ "Details about RiLOC processing",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"planes\":{\"properties\":{},\"type\":\"object\",\"description\""
    ":\"Information on plane correspondences and used extraction/matching te"
    "mplates.\"},\"georeferencing\":{\"properties\":{},\"type\":\"object\",\"descript"
    "ion\":\"Internal georeferencing parameters.\"},\"optimizer\":{\"properties\":"
    "{},\"type\":\"object\",\"description\":\"Optimization result information and "
    "statistics.\"},\"trajectory\":{\"properties\":{},\"type\":\"object\",\"descripti"
    "on\":\"Trajectory information and statistics.\"}},\"title\":\"RiLOC "
    "Processing Information\",\"$schema\":\"http://json-schema.org/draft-04/sch"
    "ema#\",\"type\":\"object\",\"description\":\"Details about RiLOC "
    "processing\",\"required\":[\"trajectory\",\"optimizer\",\"georeferencing\"]}"
    ,
    /* example: */
    "{\"planes\":{},\"georeferencing\":{},\"optimizer\":{},\"trajectory\":{}}"
};

// Scan pattern description
const MetaDataItemInfo RDB_RIEGL_SCAN_PATTERN = {
    /* name        */ "riegl.scan_pattern",
    /* title       */ "Scan Pattern",
    /* description */ "Scan pattern description",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"line\":{\"properties\":{\"program\":{\"$ref\":\"#/definitions/"
    "program\"},\"stop\":{\"minimum\":0.0,\"type\":\"number\",\"description\":\"Stop "
    "angle in SOCS [deg]\",\"maximum\":720.0},\"increment\":{\"minimum\":0.0,\"type"
    "\":\"number\",\"description\":\"Increment of angle in SOCS [deg]\",\"maximum\":"
    "90.0},\"start\":{\"minimum\":0.0,\"type\":\"number\",\"description\":\"Start "
    "angle in SOCS "
    "[deg]\",\"maximum\":360.0}},\"type\":\"object\",\"description\":\"Line Scan Patt"
    "ern\",\"required\":[\"start\",\"stop\",\"increment\"]},\"rectangular\":{\"properti"
    "es\":{\"program\":{\"$ref\":\"#/definitions/program\"},\"phi_stop\":{\"minimum\":"
    "0.0,\"type\":\"number\",\"description\":\"Stop phi angle in SOCS [deg]\",\"maxi"
    "mum\":720.0},\"phi_start\":{\"minimum\":0.0,\"type\":\"number\",\"description\":\""
    "Start phi angle in SOCS [deg]\",\"maximum\":360.0},\"theta_stop\":{\"minimum"
    "\":0.0,\"type\":\"number\",\"description\":\"Stop theta angle in SOCS [deg]\",\""
    "maximum\":180.0},\"theta_start\":{\"minimum\":0.0,\"type\":\"number\",\"descript"
    "ion\":\"Start theta angle in SOCS [deg]\",\"maximum\":180.0},\"phi_increment"
    "\":{\"minimum\":0.0,\"type\":\"number\",\"description\":\"Increment of phi angle"
    " in SOCS [deg]\",\"maximum\":90.0},\"theta_increment\":{\"minimum\":0.0,\"type"
    "\":\"number\",\"description\":\"Increment of theta angle in SOCS "
    "[deg]\",\"maximum\":90.0}},\"type\":\"object\",\"description\":\"Rectangular "
    "Field Of View Scan Pattern\",\"required\":[\"phi_start\",\"phi_stop\",\"phi_in"
    "crement\",\"theta_start\",\"theta_stop\",\"theta_increment\"]},\"segments\":{\"p"
    "roperties\":{\"list\":{\"type\":\"array\",\"items\":{\"properties\":{\"stop\":{\"min"
    "imum\":0.0,\"type\":\"number\",\"description\":\"Stop angle in SOCS [deg]\",\"ma"
    "ximum\":720.0},\"increment\":{\"minimum\":0.0,\"type\":\"number\",\"description\""
    ":\"Increment of angle in SOCS [deg]\",\"maximum\":90.0},\"start\":{\"minimum\""
    ":0.0,\"type\":\"number\",\"description\":\"Start angle in SOCS "
    "[deg]\",\"maximum\":360.0}},\"type\":\"object\",\"description\":\"Line Scan Segm"
    "ent\",\"required\":[\"start\",\"stop\",\"increment\"]}},\"program\":{\"$ref\":\"#/de"
    "finitions/program\"}},\"type\":\"object\",\"description\":\"Segmented Line "
    "Scan Pattern\",\"required\":[\"list\"]}},\"$schema\":\"http://json-schema.org/"
    "draft-04/schema#\",\"definitions\":{\"program\":{\"properties\":{\"name\":{\"typ"
    "e\":\"string\",\"description\":\"Name of measurement program\"},\"laser_prr\":{"
    "\"minimum\":0,\"type\":\"number\",\"description\":\"Laser Pulse Repetition Rate"
    " [Hz]\",\"exclusiveMinimum\":false}},\"type\":\"object\",\"description\":\"Measu"
    "rement program\",\"required\":[\"name\"]}},\"description\":\"Scan pattern "
    "description\",\"title\":\"Scan Pattern\"}"
    ,
    /* example: */
    "{\"rectangular\":{\"program\":{\"name\":\"High Speed\",\"laser_prr\":100000.0},\""
    "phi_stop\":270.0,\"phi_start\":45.0,\"theta_stop\":130.0,\"theta_start\":30.0"
    ",\"phi_increment\":0.04,\"theta_increment\":0.04}}"
};

// Details about laser shot files
const MetaDataItemInfo RDB_RIEGL_SHOT_INFO = {
    /* name        */ "riegl.shot_info",
    /* title       */ "Shot Information",
    /* description */ "Details about laser shot files",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"shot_file\":{\"properties\":{\"file_extension\":{\"type\":\"st"
    "ring\",\"description\":\"Shot file extension, without the leading "
    "dot\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"File's Universally "
    "Unique Identifier (RFC 4122)\"}},\"type\":\"object\",\"required\":[\"file_exte"
    "nsion\"]}},\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\""
    "object\",\"description\":\"Details about laser shot files\",\"title\":\"Shot "
    "Information\"}"
    ,
    /* example: */
    "{\"shot_file\":{\"file_extension\":\"sodx\",\"file_uuid\":\"26a00815-67c0-4bff-"
    "8fe8-c577378fe663\"}}"
};

// Point filters applied in addition to the application-defined filters
const MetaDataItemInfo RDB_RIEGL_STORED_FILTERS = {
    /* name        */ "riegl.stored_filters",
    /* title       */ "Stored Filters",
    /* description */ "Point filters applied in addition to the application-defined filters",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"activated\":{\"type\":\"boolean\",\"description\":\"Apply "
    "('true') or ignore ('false') all "
    "filters\"},\"filters\":{\"type\":\"array\",\"description\":\"List of point filte"
    "rs\",\"items\":{\"properties\":{\"activated\":{\"type\":\"boolean\",\"description\""
    ":\"Apply ('true') or ignore ('false') this "
    "filter\"},\"description\":{\"type\":\"string\",\"description\":\"A brief "
    "description of the filter (e.g. for display in a "
    "tooltip)\"},\"filter\":{\"type\":\"string\",\"description\":\"The RDB filter "
    "string to apply (e.g. when reading points or index), details see "
    "documentation of function "
    "select()\"},\"title\":{\"type\":\"string\",\"description\":\"A short filter "
    "title (e.g. for display in a selection "
    "list)\"}},\"type\":\"object\",\"description\":\"Point filter definition\",\"requ"
    "ired\":[\"activated\",\"title\",\"description\",\"filter\"]}}},\"title\":\"Stored "
    "filters\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"o"
    "bject\",\"description\":\"Point filters applied in addition to the "
    "application-defined filters\",\"required\":[\"activated\",\"filters\"]}"
    ,
    /* example: */
    "{\"activated\":true,\"filters\":[{\"activated\":false,\"description\":\"Ignore "
    "points with uncertain MTA zone "
    "assignment\",\"filter\":\"riegl.mta_uncertain_point == 0\",\"title\":\"Ignore "
    "uncertain points from MTA "
    "resolution\"},{\"activated\":false,\"description\":\"Ignore points with an "
    "echo signal amplitude below the dynamic "
    "trigger\",\"filter\":\"riegl.dyntrig_uncertain_point == 0\",\"title\":\"Ignore"
    " points below dynamic trigger "
    "level\"},{\"activated\":false,\"description\":\"Ignore points that are "
    "outside the outer AABB in "
    "BOCS\",\"filter\":\"riegl.point_outside_aabb_bocs == 0\",\"title\":\"Ignore "
    "points outside outer AABB\"},{\"activated\":false,\"description\":\"Ignore "
    "points that are inside the inner AABB in "
    "BOCS\",\"filter\":\"riegl.point_inside_aabb_bocs == 0\",\"title\":\"Ignore "
    "points inside inner AABB\"}]}"
};

// Details of major system components like lidar sensors, cameras and navigation devices
const MetaDataItemInfo RDB_RIEGL_SYSTEM_DESCRIPTION = {
    /* name        */ "riegl.system_description",
    /* title       */ "System Description",
    /* description */ "Details of major system components like lidar sensors, cameras and navigation devices",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"system\":{\"type\":\"object\",\"description\":\"The actual "
    "system description, details see documentation of RIEGL System "
    "Description\"},\"version\":{\"type\":\"string\",\"description\":\"Document "
    "format version\"},\"timestamp\":{\"type\":\"string\",\"description\":\"Date and "
    "time of creation (e.g. 2019-06-19T13:32:10+02:00)\"},\"author\":{\"type\":\""
    "string\",\"description\":\"Name of the author that created the document\"},"
    "\"$class\":{\"enum\":[\"Document\"],\"type\":\"string\",\"description\":\"Object "
    "class name\"}},\"title\":\"System Description\",\"$schema\":\"http://json-sche"
    "ma.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Details of "
    "major system components like lidar sensors, cameras and navigation dev"
    "ices\",\"required\":[\"$class\",\"version\",\"author\",\"timestamp\",\"system\"]}"
    ,
    /* example: */
    "{\"system\":{\"details\":\"see documentation of RIEGL System Description\"},"
    "\"version\":\"1.2.1\",\"timestamp\":\"2022-09-30T11:56:26+00:00\",\"author\":\"RI"
    "EGL LMS GmbH, Austria\",\"$class\":\"Document\"}"
};

// Conversion of background radiation raw values to temperatures in °C
const MetaDataItemInfo RDB_RIEGL_TEMPERATURE_CALCULATION = {
    /* name        */ "riegl.temperature_calculation",
    /* title       */ "Temperature Calculation Table",
    /* description */ "Conversion of background radiation raw values to temperatures in °C",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"Si\":{\"$ref\":\"#/definitions/conversion_table\",\"descript"
    "ion\":\"Conversion table for Si channel\"},\"InGaAs_Si_Difference\":{\"$ref\""
    ":\"#/definitions/conversion_table\",\"description\":\"Conversion table for "
    "InGaAs - Si difference\"},\"InGaAs\":{\"$ref\":\"#/definitions/conversion_ta"
    "ble\",\"description\":\"Conversion table for InGaAs "
    "channel\"}},\"title\":\"Temperature Calculation Table\",\"$schema\":\"http://j"
    "son-schema.org/draft-04/schema#\",\"definitions\":{\"conversion_table\":{\"p"
    "roperties\":{\"value\":{\"type\":\"array\",\"description\":\"LSB [1]\",\"items\":{\""
    "type\":\"number\"}},\"temperature\":{\"type\":\"array\",\"description\":\"Temperat"
    "ure [\\u00b0C]\",\"items\":{\"type\":\"number\"}}},\"type\":\"object\",\"required\":"
    "[\"value\",\"temperature\"]}},\"description\":\"Conversion of background "
    "radiation raw values to temperatures in \\u00b0C\",\"type\":\"object\"}"
    ,
    /* example: */
    "{\"Si\":{\"value\":[0.0,64.00097659230323,128.0019531846065,192.0029297769"
    "097,256.0039063692129,320.00488296151616,384.0058595538194,448.0068361"
    "461226,512.0078127384259],\"temperature\":[546.300048828125,548.81640512"
    "12026,551.3143938500972,554.0144257850053,556.604252334815,559.2124464"
    "488079,561.8022729986177,564.4104671126105,567.0002936624203]},\"InGaAs"
    "_Si_Difference\":{\"value\":[1000.0,1100.090029602954,1200.04425183874,13"
    "00.1342814416948,1400.0885036774805,1500.0427259132668,1600.1327555162"
    "209,1700.0869777520065,1800.0411999877924],\"temperature\":[1749.9771111"
    "17893,1749.977111117893,1749.977111117893,1749.977111117893,1749.97711"
    "1117893,1749.977111117893,1744.7813348796044,1681.9971312601092,1622.3"
    "944822534868]},\"InGaAs\":{\"value\":[0.0,64.00097659230323,128.0019531846"
    "065,192.0029297769097,256.0039063692129,320.00488296151616,384.0058595"
    "538194,448.0068361461226,512.0078127384259],\"temperature\":[307.2219672"
    "2535614,309.1153478247277,311.1188086915047,313.10025350480055,315.213"
    "7946389828,317.2172555057597,319.2207163725366,321.2021611858325,323.3"
    "157023200148]}}"
};

// Base of timestamps (epoch)
const MetaDataItemInfo RDB_RIEGL_TIME_BASE = {
    /* name        */ "riegl.time_base",
    /* title       */ "Time Base",
    /* description */ "Base of timestamps (epoch)",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"system\":{\"enum\":[\"unknown\",\"UTC\",\"GPS\"],\"type\":\"string"
    "\",\"description\":\"Time system (time standard)\"},\"source\":{\"enum\":[\"unkn"
    "own\",\"RTC\",\"GNSS\"],\"type\":\"string\",\"description\":\"Timestamp "
    "source\"},\"epoch\":{\"type\":\"string\",\"description\":\"Date and time of "
    "timestamp '0' as proposed by RFC 3339 (e.g. "
    "2015-10-27T00:00:00+01:00).\"}},\"title\":\"Time Base\",\"$schema\":\"http://j"
    "son-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Base "
    "of timestamps (epoch)\",\"required\":[\"epoch\",\"source\"]}"
    ,
    /* example: */
    "{\"system\":\"UTC\",\"source\":\"GNSS\",\"epoch\":\"2015-10-27T00:00:00+00:00\"}"
};

// Details about position+orientation files
const MetaDataItemInfo RDB_RIEGL_TRAJECTORY_INFO = {
    /* name        */ "riegl.trajectory_info",
    /* title       */ "Trajectory Information",
    /* description */ "Details about position+orientation files",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"device\":{\"type\":\"string\",\"description\":\"Navigation "
    "device, e.g. "
    "name/type/serial\"},\"software\":{\"type\":\"string\",\"description\":\"Software"
    " that calculated the trajectory (this may be the same or different "
    "software than the one that created the "
    "file)\"},\"project\":{\"type\":\"string\",\"description\":\"Project "
    "name\"},\"settings\":{\"type\":\"string\",\"description\":\"Settings used to "
    "calculate the trajectory (descriptive "
    "text)\"},\"company\":{\"type\":\"string\",\"description\":\"Company name\"},\"navi"
    "gation_frame\":{\"enum\":[\"unknown\",\"NED\",\"ENU\"],\"type\":\"string\",\"descrip"
    "tion\":\"Navigation frame (NED: North-East-Down, ENU: East-North-Up)\"},\""
    "field_of_application\":{\"enum\":[\"unknown\",\"SLS\",\"TLS\",\"KLS\",\"MLS\",\"ULS\""
    ",\"ALS\",\"BLS\",\"ILS\"],\"type\":\"string\",\"description\":\"Field of "
    "application\"},\"location\":{\"type\":\"string\",\"description\":\"Project "
    "location, e.g. city/state/country\"},\"time_interval\":{\"properties\":{\"mi"
    "nimum\":{\"type\":\"number\",\"description\":\"Minimum time interval "
    "[s]\"},\"maximum\":{\"type\":\"number\",\"description\":\"Maximum time interval "
    "[s]\"},\"std_dev\":{\"type\":\"number\",\"description\":\"Standard deviation of "
    "intervals [s]\"},\"average\":{\"type\":\"number\",\"description\":\"Average time"
    " interval [s]\"}},\"type\":\"object\",\"description\":\"Time interval statisti"
    "cs\",\"required\":[\"minimum\",\"average\",\"maximum\",\"std_dev\"]}},\"title\":\"Tr"
    "ajectory Information\",\"$schema\":\"http://json-schema.org/draft-04/schem"
    "a#\",\"type\":\"object\",\"description\":\"Details about position+orientation "
    "files\",\"required\":[\"time_interval\",\"navigation_frame\"]}"
    ,
    /* example: */
    "{\"device\":\"IMU Model 12/1, Serial# 12345\",\"software\":\"Navigation "
    "Software XYZ\",\"project\":\"Campaign "
    "3\",\"settings\":\"default\",\"company\":\"RIEGL LMS\",\"navigation_frame\":\"NED\""
    ",\"field_of_application\":\"MLS\",\"location\":\"Horn\",\"time_interval\":{\"mini"
    "mum\":0.00500032,\"maximum\":0.005004883,\"std_dev\":5.51e-07,\"average\":0.0"
    "0500053}}"
};

// Trigger-Timestamping-Unit/IP configuration
const MetaDataItemInfo RDB_RIEGL_TTIP_CONFIGURATION = {
    /* name        */ "riegl.ttip_configuration",
    /* title       */ "TTIP Configuration",
    /* description */ "Trigger-Timestamping-Unit/IP configuration",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"ext_delay\":{\"minimum\":0,\"type\":\"integer\",\"description\""
    ":\"external trigger, time delay [0.1 "
    "msec]\"},\"ext_channel\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"ID "
    "of channel used as external trigger input, 32 indicates none\"},\"num_ch"
    "annel\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"number of "
    "input/output "
    "channels\"},\"dmi_incr\":{\"type\":\"integer\",\"description\":\"dmi, increment "
    "in ticks\"},\"in_min_duration\":{\"minimum\":0,\"type\":\"integer\",\"descriptio"
    "n\":\"input signals with smaller pulse durations are ignored [0.1 "
    "msec]\"},\"input_usage\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"0 "
    ".. deactivated, 1 .. just detecting and timestamping\"},\"ext_bitmask\":{"
    "\"minimum\":0,\"type\":\"integer\",\"description\":\"defines which of the "
    "internal pulse generators are to be started\"},\"out_interval\":{\"minimum"
    "\":0,\"type\":\"integer\",\"description\":\"output pulse interval [0.1 "
    "msec]\"},\"output_descr\":{\"type\":\"string\",\"description\":\"descriptive str"
    "ing\"},\"ttip_version\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"foll"
    "owing main.sub.ss.sss\"},\"input_descr\":{\"type\":\"string\",\"description\":\""
    "descriptive string\"},\"out_duration\":{\"minimum\":0,\"type\":\"integer\",\"des"
    "cription\":\"output pulse duration [0.1 "
    "msec]\"},\"output_usage\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"0 "
    ".. no output, 1 .. output derived from internal clock, 2 .. output "
    "derived from dmi, 3 .. output derived from external signal, 4 .. "
    "output static low, 5 .. output static high\"},\"dmi_min_time\":{\"minimum\""
    ":0,\"type\":\"integer\",\"description\":\"dmi, minimum time interval between "
    "trigger events [0.1 msec]\"},\"in_max_duration\":{\"minimum\":0,\"type\":\"int"
    "eger\",\"description\":\"stops measurement of pulse duration of input "
    "signal [0.1 msec]\"},\"dmi_max_time\":{\"minimum\":0,\"type\":\"integer\",\"desc"
    "ription\":\"dmi, maximum time interval between trigger events [0.1 "
    "msec]\"},\"in_polarity\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"0 "
    ".. positive edge, 1 .. negative "
    "edge\"},\"out_delay\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"output"
    " pulse initial delay after start [0.1 "
    "msec]\"},\"ext_signal\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"0 .."
    " use input signal, 1 .. use output signal of "
    "channel\"},\"dmi_dist_per_tick\":{\"type\":\"number\",\"description\":\"dmi, "
    "distance per tick, just informative "
    "[m]\"},\"out_polarity\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"0 .."
    " positive edge, 1 .. negative edge\"},\"out_num_pulses\":{\"minimum\":0,\"ty"
    "pe\":\"integer\",\"description\":\"number of output pulses to be generated, "
    "0 .. infinite\"},\"ext_subdivider\":{\"minimum\":0,\"type\":\"integer\",\"descri"
    "ption\":\"reduces the frequency, default "
    "1\"},\"channel\":{\"minimum\":0,\"type\":\"integer\",\"description\":\"ID of "
    "input/output channel\"},\"in_max_delay\":{\"minimum\":0,\"type\":\"integer\",\"d"
    "escription\":\"maximum delay to output pulse before fake event is "
    "generated [0.1 msec], zero indicates that no fake events are "
    "generated\"}},\"title\":\"TTIP Configuration\",\"$schema\":\"http://json-schem"
    "a.org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Trigger-Timesta"
    "mping-Unit/IP configuration\",\"required\":[\"ttip_version\",\"num_channel\","
    "\"ext_channel\",\"ext_signal\",\"ext_delay\",\"ext_subdivider\",\"ext_bitmask\","
    "\"dmi_incr\",\"dmi_min_time\",\"dmi_max_time\",\"dmi_dist_per_tick\",\"channel\""
    ",\"output_descr\",\"input_descr\",\"output_usage\",\"input_usage\",\"out_polari"
    "ty\",\"out_duration\",\"out_interval\",\"out_delay\",\"out_num_pulses\",\"in_pol"
    "arity\",\"in_min_duration\",\"in_max_duration\",\"in_max_delay\"]}"
    ,
    /* example: */
    "{\"ext_delay\":0,\"ext_channel\":32,\"num_channel\":9,\"dmi_incr\":0,\"in_min_d"
    "uration\":0,\"input_usage\":1,\"ext_bitmask\":0,\"out_interval\":10000,\"outpu"
    "t_descr\":\"Port 1 - Trigger\",\"ttip_version\":1,\"input_descr\":\"Port 1 - E"
    "xposure\",\"out_duration\":300,\"output_usage\":1,\"dmi_min_time\":0,\"in_max_"
    "duration\":10000,\"dmi_max_time\":0,\"in_polarity\":0,\"out_delay\":0,\"ext_si"
    "gnal\":0,\"dmi_dist_per_tick\":0.0,\"out_polarity\":0,\"out_num_pulses\":1,\"e"
    "xt_subdivider\":1,\"channel\":0,\"in_max_delay\":9990}"
};

// Details about vertex file
const MetaDataItemInfo RDB_RIEGL_VERTEX_INFO = {
    /* name        */ "riegl.vertex_info",
    /* title       */ "Vertex Information",
    /* description */ "Details about vertex file",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"vertex_file\":{\"properties\":{\"file_extension\":{\"type\":\""
    "string\",\"description\":\"Vertex file extension, without the leading "
    "dot\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"File's Universally "
    "Unique Identifier (RFC 4122)\"}},\"type\":\"object\",\"required\":[\"file_exte"
    "nsion\"]}},\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\""
    "object\",\"description\":\"Details about vertex file\",\"title\":\"Vertex "
    "Information\"}"
    ,
    /* example: */
    "{\"vertex_file\":{\"file_extension\":\"vtx\",\"file_uuid\":\"51534d95-d71f-4f36"
    "-ae1a-3e63a21fd1c7\"}}"
};

// Details about the voxels contained in the file
const MetaDataItemInfo RDB_RIEGL_VOXEL_INFO = {
    /* name        */ "riegl.voxel_info",
    /* title       */ "Voxel Information",
    /* description */ "Details about the voxels contained in the file",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"oneOf\":[{\"properties\":{\"voxel_type\":{\"$ref\":\"#/definitions/voxel_typ"
    "e\"},\"size\":{\"description\":\"Size of voxels in file coordinate system.\","
    "\"oneOf\":[{\"$ref\":\"#/definitions/voxel_size\"},{\"$ref\":\"#/definitions/vo"
    "xel_size_cubic\"}]},\"shape_thresholds\":{\"$ref\":\"#/definitions/shape_thr"
    "esholds\"},\"voxel_origin\":{\"$ref\":\"#/definitions/voxel_origin_enum\"}},\""
    "required\":[\"size\",\"voxel_origin\",\"voxel_type\"],\"additionalProperties\":"
    "false},{\"properties\":{\"size_llcs\":{\"$ref\":\"#/definitions/voxel_size\",\""
    "description\":\"Size of voxels in a locally levelled cartesian "
    "coordinate system (xyz). This is only used for voxels based on a map p"
    "rojection.\"},\"voxel_type\":{\"$ref\":\"#/definitions/voxel_type\"},\"referen"
    "ce_point\":{\"minItems\":2,\"type\":\"array\",\"description\":\"Point in WGS84 "
    "geodetic decimal degree (EPSG:4326) that was used to compute the "
    "projection distortion parameters. The coefficient order is latitude, "
    "longitude. Only voxels with corresponding geo_tag, voxel_size and "
    "reference_point can be reliably processed together. This entry is "
    "available for voxel files in projected CRS only.\",\"items\":{\"minimum\":-"
    "180,\"type\":\"number\",\"maximum\":180},\"maxItems\":2},\"voxel_origin\":{\"oneO"
    "f\":[{\"$ref\":\"#/definitions/voxel_origin_enum\"},{\"$ref\":\"#/definitions/"
    "voxel_origin_point\",\"description\":\"The base point of the voxel grid. "
    "Used together with <tt>voxel_size</tt> and <tt>voxel_index</tt> to "
    "compute actual point coordinates.\"}]},\"size\":{\"$ref\":\"#/definitions/vo"
    "xel_size\",\"description\":\"Size of voxels in file coordinate system.\"},\""
    "shape_thresholds\":{\"$ref\":\"#/definitions/shape_thresholds\"}},\"required"
    "\":[\"reference_point\",\"size_llcs\",\"size\",\"voxel_origin\",\"voxel_type\"],\""
    "additionalProperties\":false}],\"title\":\"Voxel Information\",\"$schema\":\"h"
    "ttp://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":"
    "\"Details about the voxels contained in the file\",\"definitions\":{\"voxel"
    "_type\":{\"enum\":[\"center\",\"centroid\",\"index\"],\"description\":\"Whether a "
    "point in a voxel represents its center or its centroid. If type is "
    "<tt>index</tt> there is no point but only an integer voxel index.\",\"de"
    "fault\":\"centroid\"},\"voxel_origin_point\":{\"minItems\":3,\"type\":\"array\",\""
    "description\":\"Origin point for all voxel indices in voxel CRS.\",\"items"
    "\":{\"type\":\"number\"},\"maxItems\":3},\"voxel_origin_enum\":{\"enum\":[\"center"
    "\",\"corner\"],\"description\":\"Defines whether the voxel's center or a "
    "corner is placed on CRS origin <tt>(0/0/0)</tt>.\",\"default\":\"corner\"},"
    "\"voxel_size\":{\"minItems\":3,\"type\":\"array\",\"description\":\"Size of voxel"
    "s.\",\"items\":{\"$ref\":\"#/definitions/edge_length\"},\"maxItems\":3},\"voxel_"
    "size_cubic\":{\"type\":\"number\",\"$ref\":\"#/definitions/edge_length\"},\"shap"
    "e_thresholds\":{\"properties\":{\"plane\":{\"exclusiveMaximum\":true,\"exclusi"
    "veMinimum\":true,\"minimum\":0,\"maximum\":1,\"description\":\"If the smallest"
    " eigenvalue is smaller than the median eigenvalue * plane_threshold, "
    "the voxel is considered a plane.\",\"type\":\"number\"},\"line\":{\"minimum\":1"
    ",\"type\":\"number\",\"description\":\"If the biggest eigenvalue is bigger "
    "than the median eigenvalue * line_threshold, the voxel is considered a"
    " line.\",\"exclusiveMinimum\":true}},\"required\":[\"plane\",\"line\"],\"descrip"
    "tion\":\"Thresholds used to compute the voxel's shape_id value.\",\"type\":"
    "\"object\"},\"edge_length\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Le"
    "ngth of voxel edge [m].\",\"exclusiveMinimum\":true}}}"
    ,
    /* example: */
    "{\"size_llcs\":[0.5156575252891171,0.5130835356683303,0.5143705304787237"
    "],\"voxel_type\":\"centroid\",\"reference_point\":[48,16],\"voxel_origin\":\"co"
    "rner\",\"size\":[0.5971642834779395,0.5971642834779395,0.5143705304787237"
    "],\"shape_thresholds\":{\"plane\":0.16,\"line\":6}}"
};

// Settings for waveform averaging
const MetaDataItemInfo RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS = {
    /* name        */ "riegl.waveform_averaging_settings",
    /* title       */ "Waveform Averaging Settings",
    /* description */ "Settings for waveform averaging",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"num_shots\":{\"minimum\":1,\"type\":\"integer\",\"description\""
    ":\"Number of consecutive shots to be used for averaging.\"},\"trim\":{\"min"
    "imum\":0,\"type\":\"number\",\"description\":\"Percentage for robust averaging"
    ".\",\"default\":0,\"maximum\":0.5},\"mta_zone\":{\"minimum\":1,\"type\":\"integer\""
    ",\"description\":\"Fixed MTA zone for averaging.\"}},\"title\":\"Waveform "
    "Averaging Settings\",\"$schema\":\"http://json-schema.org/draft-04/schema#"
    "\",\"type\":\"object\",\"description\":\"Settings for waveform "
    "averaging\",\"required\":[\"num_shots\",\"mta_zone\"]}"
    ,
    /* example: */
    "{\"num_shots\":7,\"trim\":0.05,\"mta_zone\":1}"
};

// Details about waveform files
const MetaDataItemInfo RDB_RIEGL_WAVEFORM_INFO = {
    /* name        */ "riegl.waveform_info",
    /* title       */ "Waveform Information",
    /* description */ "Details about waveform files",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"range_offset_m\":{\"type\":\"number\",\"description\":\"Calibr"
    "ated device specific range offset for waveform analysis by system "
    "response fitting in meters.\"},\"sample_data_files\":{\"type\":\"array\",\"ite"
    "ms\":{\"properties\":{\"delta_st\":{\"type\":\"number\",\"description\":\"reserved"
    "\"},\"laser_wavelength\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Lase"
    "r wavelength in meters (0 = unknown)\",\"exclusiveMinimum\":false},\"chann"
    "el_name\":{\"type\":\"string\",\"description\":\"Sample block channel name\"},\""
    "sample_bits\":{\"exclusiveMaximum\":false,\"exclusiveMinimum\":false,\"minim"
    "um\":0,\"type\":\"integer\",\"description\":\"Bitwidth of samples (e.g. 10 "
    "bit, 12 bit)\",\"maximum\":32},\"file_extension\":{\"type\":\"string\",\"descrip"
    "tion\":\"Sample data file extension, without the leading "
    "dot\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"File's Universally "
    "Unique Identifier (RFC 4122)\"},\"channel\":{\"exclusiveMaximum\":false,\"ex"
    "clusiveMinimum\":false,\"minimum\":0,\"type\":\"integer\",\"description\":\"Samp"
    "le block channel number (255 = invalid)\",\"maximum\":255},\"sample_interv"
    "al\":{\"minimum\":0,\"type\":\"number\",\"description\":\"Sampling interval in s"
    "econds\",\"exclusiveMinimum\":false}},\"type\":\"object\",\"required\":[\"channe"
    "l\",\"channel_name\",\"sample_interval\",\"sample_bits\",\"laser_wavelength\",\""
    "delta_st\",\"file_extension\"]}},\"range_offset_waveform_samples_m\":{\"type"
    "\":\"number\",\"description\":\"Calibrated device specific range offset for "
    "waveform samples in meters.\"},\"sample_block_file\":{\"properties\":{\"file"
    "_extension\":{\"type\":\"string\",\"description\":\"Sample block file "
    "extension, without the leading "
    "dot\"},\"file_uuid\":{\"type\":\"string\",\"description\":\"File's Universally "
    "Unique Identifier (RFC 4122)\"}},\"type\":\"object\",\"required\":[\"file_exte"
    "nsion\"]}},\"title\":\"Waveform Information\",\"$schema\":\"http://json-schema"
    ".org/draft-04/schema#\",\"type\":\"object\",\"description\":\"Details about "
    "waveform files\",\"required\":[\"sample_block_file\",\"sample_data_files\"]}"
    ,
    /* example: */
    "{\"range_offset_m\":3.1415,\"sample_data_files\":[{\"delta_st\":0,\"file_uuid"
    "\":\"da084413-e3e8-4655-a122-071de8490d8e\",\"channel_name\":\"high_power\",\""
    "channel\":0,\"file_extension\":\"sp0\",\"laser_wavelength\":0,\"sample_bits\":1"
    "2,\"sample_interval\":1.00503e-09},{\"delta_st\":0,\"file_uuid\":\"93585b5e-5"
    "ea9-43a1-947b-e7ba3be642d2\",\"channel_name\":\"low_power\",\"channel\":1,\"fi"
    "le_extension\":\"sp1\",\"laser_wavelength\":0,\"sample_bits\":12,\"sample_inte"
    "rval\":1.00503e-09},{\"delta_st\":0,\"file_uuid\":\"9d2298c4-1036-464f-b5cb-"
    "1cf8e517f3a0\",\"channel_name\":\"wwf\",\"channel\":5,\"file_extension\":\"sp5\","
    "\"laser_wavelength\":0,\"sample_bits\":12,\"sample_interval\":1.00503e-09}],"
    "\"range_offset_waveform_samples_m \":7.283,\"sample_block_file\":{\"file_ex"
    "tension\":\"sbx\",\"file_uuid\":\"93a03615-66c0-4bea-8ff8-c577378fe660\"}}"
};

// Scanner settings for waveform output
const MetaDataItemInfo RDB_RIEGL_WAVEFORM_SETTINGS = {
    /* name        */ "riegl.waveform_settings",
    /* title       */ "Waveform Settings",
    /* description */ "Scanner settings for waveform output",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"array\",\"d"
    "escription\":\"Scanner settings for waveform output\",\"items\":{\"propertie"
    "s\":{\"channel_idx_mask\":{\"type\":\"integer\",\"description\":\"Bit mask for "
    "channels which belong to sbl_name: Channel 0 = Bit0, Channel 1 = Bit1,"
    " ...\"},\"pass_dev_greater\":{\"type\":\"integer\",\"description\":\"Threshold "
    "for deviation greater than "
    "[1]\"},\"pass_dev_less\":{\"type\":\"integer\",\"description\":\"Threshold for "
    "deviation less than "
    "[1]\"},\"pass_ampl_greater\":{\"type\":\"number\",\"description\":\"Threshold "
    "for amplitude greater than "
    "[dB]\"},\"pass_ampl_less\":{\"type\":\"number\",\"description\":\"Threshold for "
    "amplitude less than "
    "[dB]\"},\"pass_rng_greater\":{\"type\":\"number\",\"description\":\"Threshold "
    "for range greater than "
    "[m]\"},\"logic_expression\":{\"type\":\"string\",\"description\":\"Logic "
    "expression of smart waveforms "
    "filter\"},\"sbl_name\":{\"type\":\"string\",\"description\":\"Name of sample "
    "block, e.g.: wfm, "
    "wwf\"},\"enabled\":{\"type\":\"boolean\",\"description\":\"Waveform output "
    "enabled\"},\"pass_rng_less\":{\"type\":\"number\",\"description\":\"Threshold "
    "for range less than "
    "[m]\"},\"smart_enabled\":{\"type\":\"boolean\",\"description\":\"Smart waveform "
    "output enabled\"}},\"type\":\"object\",\"required\":[\"sbl_name\",\"enabled\",\"ch"
    "annel_idx_mask\"]},\"title\":\"Waveform Settings\"}"
    ,
    /* example: */
    "[{\"channel_idx_mask\":11,\"pass_ampl_greater\":1.0,\"pass_ampl_less\":5.0,\""
    "pass_rng_greater\":9.27,\"sbl_name\":\"wfm\",\"enabled\":true,\"pass_rng_less\""
    ":13.11,\"smart_enabled\":true},{\"channel_idx_mask\":32,\"enabled\":false,\"s"
    "bl_name\":\"wwf\"}]"
};

// Window analysis data estimated from scandata and resulting filter parameters
const MetaDataItemInfo RDB_RIEGL_WINDOW_ANALYSIS = {
    /* name        */ "riegl.window_analysis",
    /* title       */ "Window Analysis",
    /* description */ "Window analysis data estimated from scandata and resulting filter parameters",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"result\":{\"properties\":{\"range_mean\":{\"type\":\"array\",\"d"
    "escription\":\"[m]\",\"items\":{\"type\":\"number\"}},\"amplitude_mean\":{\"type\":"
    "\"array\",\"description\":\"[dB]\",\"items\":{\"type\":\"number\"}},\"angle\":{\"type"
    "\":\"array\",\"description\":\"[deg]\",\"items\":{\"type\":\"number\"}},\"timestamp\""
    ":{\"type\":\"array\",\"description\":\"[s]\",\"items\":{\"type\":\"number\"}},\"ampli"
    "tude_offset\":{\"type\":\"array\",\"description\":\"[dB]\",\"items\":{\"type\":\"num"
    "ber\"}},\"range_sigma\":{\"type\":\"array\",\"description\":\"[m]\",\"items\":{\"typ"
    "e\":\"number\"}},\"amplitude_sigma\":{\"type\":\"array\",\"description\":\"[dB]\",\""
    "items\":{\"type\":\"number\"}}},\"type\":\"object\",\"required\":[\"angle\",\"range_"
    "mean\",\"range_sigma\",\"amplitude_mean\",\"amplitude_sigma\",\"amplitude_offs"
    "et\"]},\"settings\":{\"properties\":{\"range\":{\"properties\":{\"additive_value"
    "\":{\"type\":\"number\"},\"sigma_factor\":{\"type\":\"number\"}},\"type\":\"object\","
    "\"required\":[\"sigma_factor\",\"additive_value\"]},\"amplitude\":{\"properties"
    "\":{\"additive_value\":{\"type\":\"number\"},\"sigma_factor\":{\"type\":\"number\"}"
    "},\"type\":\"object\",\"required\":[\"sigma_factor\",\"additive_value\"]}},\"type"
    "\":\"object\",\"required\":[\"range\",\"amplitude\"]},\"filter\":{\"properties\":{\""
    "angle\":{\"type\":\"array\",\"description\":\"[deg]\",\"items\":{\"type\":\"number\"}"
    "},\"range_min\":{\"type\":\"array\",\"description\":\"[m]\",\"items\":{\"type\":\"num"
    "ber\"}},\"range_max\":{\"type\":\"array\",\"description\":\"[m]\",\"items\":{\"type\""
    ":\"number\"}},\"amplitude_max\":{\"type\":\"array\",\"description\":\"[dB]\",\"item"
    "s\":{\"type\":\"number\"}}},\"type\":\"object\",\"required\":[\"angle\",\"range_min\""
    ",\"range_max\",\"amplitude_max\"]}},\"title\":\"Window Analysis\",\"$schema\":\"h"
    "ttp://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"description\":"
    "\"Window analysis data estimated from scandata and resulting filter "
    "parameters\",\"required\":[\"result\",\"filter\",\"settings\"]}"
    ,
    /* example: */
    "{\"result\":{\"range_mean\":[0.1105621,0.1079564,0.1087088,0.1067261,0.105"
    "4582,0.1090412,0.102871,0.1019044,0.1051523,0.1058445,0.1031261],\"ampl"
    "itude_mean\":[5.347396,5.263155,5.224655,5.179926,5.097782,5.116479,5.0"
    "51756,4.983473,5.007885,5.002441,4.982],\"angle\":[14.9,15.0,15.1,15.2,1"
    "5.3,15.4,15.5,15.6,15.7,15.8,15.9],\"timestamp\":[408.4441,411.4443],\"am"
    "plitude_offset\":[1.9,1.9],\"range_sigma\":[0.01869652,0.02151435,0.01747"
    "969,0.01918765,0.01945776,0.01934862,0.01955329,0.02225589,0.02229977,"
    "0.01899122,0.02009433],\"amplitude_sigma\":[0.4272844,0.4298479,0.423681"
    "6,0.4283583,0.4362353,0.4315141,0.4373984,0.4472798,0.4346001,0.434548"
    "7,0.4540681]},\"settings\":{\"range\":{\"additive_value\":0.1,\"sigma_factor\""
    ":8},\"amplitude\":{\"additive_value\":1.0,\"sigma_factor\":4}},\"filter\":{\"an"
    "gle\":[14.9,15.0,15.1,15.2,15.3,15.4,15.5,15.6,15.7,15.8,15.9],\"range_m"
    "in\":[-0.208,-0.21,-0.212,-0.214,-0.216,-0.218,-0.219,-0.221,-0.223,-0."
    "225,-0.227],\"range_max\":[0.424,0.425,0.426,0.427,0.428,0.428,0.429,0.4"
    "3,0.431,0.431,0.432],\"amplitude_max\":[8.04,8.01,7.99,7.96,7.93,7.9,7.8"
    "8,7.85,7.83,7.8,7.78]}}"
};

// Correction parameters for window glass echoes
const MetaDataItemInfo RDB_RIEGL_WINDOW_ECHO_CORRECTION = {
    /* name        */ "riegl.window_echo_correction",
    /* title       */ "Window Echo Correction",
    /* description */ "Correction parameters for window glass echoes",
    /* status      */ RDB_STATUS_OPTIONAL,

    /* schema: */
    "{\"properties\":{\"amplitude\":{\"properties\":{\"minimum\":{\"minimum\":0.0,\"ty"
    "pe\":\"number\",\"description\":\"Minimum amplitude in "
    "dB\"},\"maximum\":{\"minimum\":0.0,\"type\":\"number\",\"description\":\"Maximum "
    "amplitude in "
    "dB\"},\"entries\":{\"minimum\":1,\"type\":\"integer\",\"description\":\"Number of "
    "amplitude entries\"}},\"type\":\"object\",\"description\":\"Amplitude axis of "
    "correction table\",\"required\":[\"minimum\",\"maximum\",\"entries\"]},\"range\":"
    "{\"properties\":{\"minimum\":{\"minimum\":-2.0,\"type\":\"number\",\"description\""
    ":\"Minimum range in m\",\"maximum\":2.0},\"maximum\":{\"minimum\":-2.0,\"type\":"
    "\"number\",\"description\":\"Maximum range in m\",\"maximum\":2.0},\"entries\":{"
    "\"minimum\":1,\"type\":\"integer\",\"description\":\"Number of range "
    "entries\"}},\"type\":\"object\",\"description\":\"Range axis of correction tab"
    "le\",\"required\":[\"minimum\",\"maximum\",\"entries\"]},\"slices\":{\"type\":\"arra"
    "y\",\"items\":{\"properties\":{\"amplitude\":{\"type\":\"number\",\"description\":\""
    "Window echo amplitude of slice in "
    "dB\"},\"table\":{\"minItems\":1,\"type\":\"array\",\"description\":\"Correction "
    "table (dimension defined by the 'amplitude' and 'range' "
    "objects)\",\"items\":{\"minItems\":1,\"type\":\"array\",\"description\":\"Table "
    "row (= amplitude "
    "axis)\",\"items\":{\"minItems\":3,\"type\":\"array\",\"description\":\"Table "
    "column (= range axis)\",\"items\":{\"type\":\"number\",\"description\":\"Table "
    "cell (item 0: amplitude in dB, 1: range in m, 2: "
    "flags)\"},\"maxItems\":3}}}},\"type\":\"object\",\"description\":\"Window echo "
    "correction parameter "
    "slice\",\"required\":[\"amplitude\",\"table\"]}}},\"title\":\"Window Echo Correc"
    "tion\",\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"obje"
    "ct\",\"description\":\"Correction parameters for window glass "
    "echoes\",\"required\":[\"amplitude\",\"range\",\"slices\"]}"
    ,
    /* example: */
    "{\"amplitude\":{\"minimum\":2,\"maximum\":20,\"entries\":128},\"range\":{\"minimu"
    "m\":-1.5060822940732335,\"maximum\":1.5060822940732335,\"entries\":128},\"sl"
    "ices\":[{\"amplitude\":1.5,\"table\":[[[6.23,0.3535,1]],[[5.54,0.72375,1]]]"
    "},{\"amplitude\":2.0,\"table\":[[[6.23,0.3535,1]],[[5.54,0.72375,1]]]}]}"
};

// Table of all meta data item details records
const MetaDataItemInfo* const RDB_META_DATA_ITEMS[] = {
    &RDB_RIEGL_ANGULAR_NOTCH_FILTER,
    &RDB_RIEGL_ATMOSPHERE,
    &RDB_RIEGL_BEAM_GEOMETRY,
    &RDB_RIEGL_CONTROL_OBJECT_CATALOG,
    &RDB_RIEGL_CONTROL_OBJECT_REFERENCE_FILE,
    &RDB_RIEGL_DETECTION_PROBABILITY,
    &RDB_RIEGL_DEVICE,
    &RDB_RIEGL_DEVICE_GEOMETRY,
    &RDB_RIEGL_DEVICE_GEOMETRY_PASSIVE_CHANNEL,
    &RDB_RIEGL_DEVICE_OUTPUT_LIMITS,
    &RDB_RIEGL_DEVICES,
    &RDB_RIEGL_DMI_CONFIG,
    &RDB_RIEGL_DYNTRIG,
    &RDB_RIEGL_ECHO_INFO,
    &RDB_RIEGL_EXPONENTIAL_DECOMPOSITION,
    &RDB_RIEGL_GAUSSIAN_DECOMPOSITION,
    &RDB_RIEGL_GEO_TAG,
    &RDB_RIEGL_GEOMETRIC_SCALE_FACTOR,
    &RDB_RIEGL_GEOREFERENCING_PARAMETERS,
    &RDB_RIEGL_GNSS_PROCESSING_INFO,
    &RDB_RIEGL_ITEM_NAMES,
    &RDB_RIEGL_LAG_ANGLE_CORRECTION,
    &RDB_RIEGL_LICENSES,
    &RDB_RIEGL_MTA_SETTINGS,
    &RDB_RIEGL_NEAR_RANGE_CORRECTION,
    &RDB_RIEGL_NOISE_ESTIMATES,
    &RDB_RIEGL_NOTCH_FILTER,
    &RDB_RIEGL_PIXEL_INFO,
    &RDB_RIEGL_PLANE_PATCH_MATCHING,
    &RDB_RIEGL_PLANE_PATCH_STATISTICS,
    &RDB_RIEGL_PLANE_SLOPE_CLASS_INFO,
    &RDB_RIEGL_POINT_ATTRIBUTE_GROUPS,
    &RDB_RIEGL_POINTCLOUD_INFO,
    &RDB_RIEGL_POSE_ESTIMATION,
    &RDB_RIEGL_POSE_SENSORS,
    &RDB_RIEGL_PULSE_POSITION_MODULATION,
    &RDB_RIEGL_RANGE_STATISTICS,
    &RDB_RIEGL_RECEIVER_INTERNALS,
    &RDB_RIEGL_REFLECTANCE_CALCULATION,
    &RDB_RIEGL_REFLECTANCE_CORRECTION,
    &RDB_RIEGL_RILOC_PROCESSING_INFO,
    &RDB_RIEGL_SCAN_PATTERN,
    &RDB_RIEGL_SHOT_INFO,
    &RDB_RIEGL_STORED_FILTERS,
    &RDB_RIEGL_SYSTEM_DESCRIPTION,
    &RDB_RIEGL_TEMPERATURE_CALCULATION,
    &RDB_RIEGL_TIME_BASE,
    &RDB_RIEGL_TRAJECTORY_INFO,
    &RDB_RIEGL_TTIP_CONFIGURATION,
    &RDB_RIEGL_VERTEX_INFO,
    &RDB_RIEGL_VOXEL_INFO,
    &RDB_RIEGL_WAVEFORM_AVERAGING_SETTINGS,
    &RDB_RIEGL_WAVEFORM_INFO,
    &RDB_RIEGL_WAVEFORM_SETTINGS,
    &RDB_RIEGL_WINDOW_ANALYSIS,
    &RDB_RIEGL_WINDOW_ECHO_CORRECTION
};
const size_t RDB_META_DATA_ITEM_COUNT(
    sizeof(RDB_META_DATA_ITEMS) / sizeof(RDB_META_DATA_ITEMS[0])
);

#endif // RDB_81EBCB65_FE94_471E_8D25_2B4D71CC91B1
