/*
 *******************************************************************************
 *
 *  Copyright 2026 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    transaction.h
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Point cloud transaction
 * \version 2015-10-14/AW: Initial version
 * \version 2017-02-16/AW: RDB library version string field added (#2515)
 *
 * \see riegl::rdb::pointcloud::Transactions
 *
 *******************************************************************************
 */

#ifndef RIEGL_RDB_POINTCLOUD_TRANSACTION_H
#define RIEGL_RDB_POINTCLOUD_TRANSACTION_H

//---< INCLUDES >---------------------------------------------------------------

#include "riegl/rdb.h"

//---< TYPE DEFINITIONS >-------------------------------------------------------

typedef struct RDBPointcloudTransaction RDBPointcloudTransaction; // forward declaration of implementation details

typedef uint32_t RDBPointcloudTransactionID; //!< transaction ID type

//---< FUNCTIONS >--------------------------------------------------------------

RDB_LIBRARY_API_BEGIN

//______________________________________________________________________________
/*!
 * \brief Create transaction object
 */
RDB_FUNCTION(rdb_pointcloud_transaction_new,
    RDBContext                *context,    //!< [in] library context
    RDBPointcloudTransaction **transaction //!< [out] transaction handle
);

//______________________________________________________________________________
/*!
 * \brief Delete transaction object
 */
RDB_FUNCTION(rdb_pointcloud_transaction_delete,
    RDBContext                *context,    //!< [in] library context
    RDBPointcloudTransaction **transaction //!< [in] transaction handle
);

//______________________________________________________________________________
/*!
 * \brief transaction number (TAN)
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_id,
    RDBContext                 *context,     //!< [in] library context
    RDBPointcloudTransaction   *transaction, //!< [in] transaction handle
    RDBPointcloudTransactionID *id           //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief RDB library version string
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_rdb,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *rdb          //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief short description, e.g. "Import"
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_title,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *title        //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief software name, e.g. "rdbimport v1.0"
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_agent,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *agent        //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief e.g. process details for humans
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_comments,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *comments     //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief e.g. process settings for software
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_settings,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *settings     //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief start time as "yyyy-mm-dd hh:mm:ss.zzz", e.g. "2015-10-14 13:48:35.801" (local time)
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_start,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *start        //!< [out] result value
);

//______________________________________________________________________________
/*!
 * \brief stop time as "yyyy-mm-dd hh:mm:ss.zzz", e.g. "2015-10-14 13:48:35.801" (local time)
 */
RDB_FUNCTION(rdb_pointcloud_transaction_get_stop,
    RDBContext               *context,     //!< [in] library context
    RDBPointcloudTransaction *transaction, //!< [in] transaction handle
    RDBString                *stop         //!< [out] result value
);

RDB_LIBRARY_API_END

#endif // RIEGL_RDB_POINTCLOUD_TRANSACTION_H
