(*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 *)
(*
 *******************************************************************************
 *
 * \file    riegl.rdb.inc
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Main RDB library include file (Pascal wrapper code)
 * \version 2015-10-14/AW: Initial version
 * \version 2016-11-08/AW: New "fill query" (class QueryFill) added (#1926)
 * \version 2016-11-21/AW: New "invert query" (class QueryInvert) added (#2406)
 * \version 2017-03-21/AW: Database management interface added (#2550)
 * \version 2020-07-03/AW: Changelog management interface added (#3614)
 *
 *  This file simply includes all RDB Pascal wrapper code files.
 *  To use it, just write:
 *
 *  uses
 *    [OptionallySomeOtherUnits,]
 *    {$INCLUDE 'riegl.rdb.inc'}[,
 *     OptionallySomeOtherUnits];
 *
 *******************************************************************************
 *)
                                                                               {
uses                                                                           }
  riegl.rdb,
  riegl.rdb.error,
  riegl.rdb.result,
  riegl.rdb.version,
  riegl.rdb.context,
  riegl.rdb.progress,
  riegl.rdb.pointcloud.dataTypes,
  riegl.rdb.pointcloud.pointAttribute,
  riegl.rdb.pointcloud.createSettings,
  riegl.rdb.pointcloud.openSettings,
  riegl.rdb.pointcloud.changelog,
  riegl.rdb.pointcloud.management,
  riegl.rdb.pointcloud.metaData,
  riegl.rdb.pointcloud.pointAttributes,
  riegl.rdb.pointcloud.transaction,
  riegl.rdb.pointcloud.transactions,
  riegl.rdb.pointcloud.transactionScope,
  riegl.rdb.pointcloud.graphNode,
  riegl.rdb.pointcloud.queryStat,
  riegl.rdb.pointcloud.queryFill,
  riegl.rdb.pointcloud.queryInvert,
  riegl.rdb.pointcloud.queryInsert,
  riegl.rdb.pointcloud.queryUpdate,
  riegl.rdb.pointcloud.queryRemove,
  riegl.rdb.pointcloud.querySelect,
  riegl.rdb.pointcloud
