/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \author RIEGL LMS GmbH, Austria
 * \brief  Description of RIEGL RDB 2 database file contents
 *
 *  NOTE: All information in this file is preliminary, since the
 *        definition of the database schemas is not yet complete.
 *
 *******************************************************************************
 */

#ifndef RDB_2125FB67_4790_4EE4_BC63_844F2ACC9D90
#define RDB_2125FB67_4790_4EE4_BC63_844F2ACC9D90

// File schema version
const char* const RDB_SCHEMA_VERSION = "ffc879de";
const char* const RDB_SCHEMA_DATE = "2025-04-18";

// Schema for ".avg.fwa" files
const char* const RDB_SCHEMA_RIEGL_AVG_FWA(
    "{\"attributes\":[\"riegl.id*\",\"riegl.amplitude\",\"riegl.gain\",\"riegl.raw_r"
    "ange\",\"riegl.wfm_echo_time_offset\",\"riegl.wfm_sbl_id\",\"riegl.deviation"
    "?\",\"riegl.pulse_width?\"],\"identifier\":\"avg.fwa\",\"extension\":\"avg.fwa\","
    "\"metadata\":[]}"
);

// Schema for ".avg.sbx" files
const char* const RDB_SCHEMA_RIEGL_AVG_SBX(
    "{\"attributes\":[\"riegl.id*\",\"riegl.wfm_sbl_channel\",\"riegl.wfm_sbl_mean"
    "\",\"riegl.wfm_sbl_std_dev\",\"riegl.wfm_sbl_time_offset\",\"riegl.wfm_sda_f"
    "irst\",\"riegl.wfm_sda_count\"],\"identifier\":\"avg.sbx\",\"extension\":\"avg.s"
    "bx\",\"metadata\":[]}"
);

// Schema for ".avg.sidx" files
const char* const RDB_SCHEMA_RIEGL_AVG_SIDX(
    "{\"attributes\":[\"riegl.id\",\"riegl.shot_timestamp_hr*\",\"riegl.wfm_sbl_fi"
    "rst\",\"riegl.wfm_sbl_count\",\"riegl.echo_first?\",\"riegl.echo_count?\"],\"i"
    "dentifier\":\"avg.sidx\",\"extension\":\"avg.sidx\",\"metadata\":[\"riegl.shot_i"
    "nfo\",\"riegl.waveform_info\",\"riegl.echo_info?\",\"riegl.waveform_averagin"
    "g_settings\"]}"
);

// Schema for ".avg.sp{C}" files
const char* const RDB_SCHEMA_RIEGL_AVG_SPC(
    "{\"attributes\":[\"riegl.id*\",\"riegl.wfm_sample_value\"],\"identifier\":\"avg"
    ".sp{C}\",\"extension\":\"avg.sp{C}\",\"metadata\":[]}"
);

// Schema for ".bsx" files
const char* const RDB_SCHEMA_RIEGL_BSX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.accelerometer_"
    "bias\",\"riegl.accelerometer_scale\",\"riegl.gyroscope_bias\",\"riegl.gyrosc"
    "ope_scale\"],\"identifier\":\"bsx\",\"extension\":\"bsx\",\"metadata\":[\"riegl.ti"
    "me_base\"]}"
);

// Schema for ".cpx" files
const char* const RDB_SCHEMA_RIEGL_CPX(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.xyz_accuracies\",\"riegl.c"
    "ontrol_object_type\",\"riegl.zenith_vector\",\"riegl.used_for_adjustment\","
    "\"riegl.acquisition_date?\",\"riegl.cp_surface_inclination_angle\",\"riegl."
    "cp_surface_inclination_tolerance_angle\",\"riegl.cp_surface_northing_ang"
    "le?\",\"riegl.cp_surface_northing_tolerance_angle?\",\"riegl.cp_search_rad"
    "ius?\",\"riegl.cp_maximum_distance?\",\"riegl.import_line_number\"],\"identi"
    "fier\":\"cpx\",\"extension\":\"cpx\",\"metadata\":[\"riegl.geo_tag\",\"riegl.contr"
    "ol_object_catalog\",\"riegl.item_names\",\"riegl.imported_files\"]}"
);

// Schema for ".cyl" files
const char* const RDB_SCHEMA_RIEGL_CYL(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.cylinder_axis_direction\""
    ",\"riegl.cylinder_radius\",\"riegl.cylinder_height\",\"riegl.cylinder_radiu"
    "s_confidence\",\"riegl.cylinder_direction_confidence\",\"riegl.std_dev\"],\""
    "identifier\":\"cyl\",\"extension\":\"cyl\",\"metadata\":[\"riegl.geo_tag\"]}"
);

// Schema for ".dmix" files
const char* const RDB_SCHEMA_RIEGL_DMIX(
    "{\"attributes\":[\"riegl.id\",\"riegl.dmi_count\",\"riegl.dmi_path_length_raw"
    "\",\"riegl.pof_timestamp*\"],\"identifier\":\"dmix\",\"extension\":\"dmix\",\"meta"
    "data\":[\"riegl.device?\",\"riegl.dmi_config\",\"riegl.time_base\"]}"
);

// Schema for ".doix" files
const char* const RDB_SCHEMA_RIEGL_DOIX(
    "{\"attributes\":[\"riegl.id\",\"riegl.shot_origin\",\"riegl.shot_direction*\","
    "\"riegl.scan_line_index\",\"riegl.shot_index_line\"],\"identifier\":\"doix\",\""
    "extension\":\"doix\",\"metadata\":[]}"
);

// Schema for ".eifx" files
const char* const RDB_SCHEMA_RIEGL_EIFX(
    "{\"attributes\":[\"riegl.id\",\"riegl.event_timestamp*\",\"riegl.event_index?"
    "\",\"riegl.event_pulse_width?\",\"riegl.event_fake_pulse?\",\"riegl.raw_line"
    "_angle?\",\"riegl.raw_frame_angle?\"],\"identifier\":\"eifx\",\"extension\":\"ei"
    "fx\",\"metadata\":[\"riegl.device?\",\"riegl.time_base\",\"riegl.ttip_configur"
    "ation?\"]}"
);

// Schema for ".epfx" files
const char* const RDB_SCHEMA_RIEGL_EPFX(
    "{\"attributes\":[\"riegl.id\",\"riegl.event_timestamp*\",\"riegl.event_index?"
    "\",\"riegl.event_pulse_width?\",\"riegl.event_fake_pulse?\",\"riegl.raw_line"
    "_angle?\",\"riegl.raw_frame_angle?\",\"riegl.xyz\",\"riegl.model_cs_axis_x\","
    "\"riegl.model_cs_axis_y\",\"riegl.model_cs_axis_z\"],\"identifier\":\"epfx\",\""
    "extension\":\"epfx\",\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.t"
    "ime_base\",\"riegl.ttip_configuration?\"]}"
);

// Schema for ".fwa" files
const char* const RDB_SCHEMA_RIEGL_FWA(
    "{\"attributes\":[\"riegl.id*\",\"riegl.amplitude\",\"riegl.gain\",\"riegl.raw_r"
    "ange\",\"riegl.wfm_echo_time_offset\",\"riegl.wfm_sbl_id\",\"riegl.deviation"
    "?\",\"riegl.pulse_width?\",\"riegl.extinction?\",\"riegl.svb_amplitude_volum"
    "etric?\",\"riegl.svb_attenuation_volumetric?\",\"riegl.svb_target_attenuat"
    "ion_coefficient_volumetric?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\","
    "\"riegl.svb_path_length?\"],\"identifier\":\"fwa\",\"extension\":\"fwa\",\"metada"
    "ta\":[]}"
);

// Schema for ".imux" files
const char* const RDB_SCHEMA_RIEGL_IMUX(
    "{\"attributes\":[\"riegl.id\",\"riegl.timestamp*\",\"riegl.temperature\",\"rieg"
    "l.accelerometer\",\"riegl.gyroscope\",\"riegl.accelerometer_raw\",\"riegl.gy"
    "roscope_raw\",\"riegl.magnetic_field_sensor_raw\",\"riegl.frame_angle_coar"
    "se\",\"riegl.line_angle_coarse\",\"riegl.frame_scan_active\",\"riegl.data_ac"
    "quisition_active\",\"riegl.barometric_height_amsl\"],\"identifier\":\"imux\","
    "\"extension\":\"imux\",\"metadata\":[\"riegl.device\",\"riegl.time_base\",\"riegl"
    ".riloc_sensor_information\",\"riegl.rxp_json_parameter_1\"]}"
);

// Schema for ".llhx" files
const char* const RDB_SCHEMA_RIEGL_LLHX(
    "{\"attributes\":[\"riegl.pof_latitude\",\"riegl.pof_longitude\",\"riegl.pof_h"
    "eight\",\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_ac"
    "curacy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_pdop\",\"riegl.pof_hdo"
    "p\",\"riegl.pof_vdop\",\"riegl.pof_age_of_corrections\",\"riegl.pof_baseline"
    "_length\",\"riegl.pof_solution_gnss\",\"riegl.pof_satellites_gnss\",\"riegl."
    "id\"],\"identifier\":\"llhx\",\"extension\":\"llhx\",\"metadata\":[\"riegl.device?"
    "\",\"riegl.geo_tag\",\"riegl.time_base\"]}"
);

// Schema for ".llhx" files
const char* const RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\","
    "\"riegl.pof_longitude\",\"riegl.pof_height\",\"riegl.pof_accuracy_north\",\"r"
    "iegl.pof_accuracy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_accuracy_"
    "north_east?\",\"riegl.pof_accuracy_east_down?\",\"riegl.pof_accuracy_down_"
    "north?\",\"riegl.pof_velocity_ned?\",\"riegl.pof_velocity_accuracy_north?\""
    ",\"riegl.pof_velocity_accuracy_east?\",\"riegl.pof_velocity_accuracy_down"
    "?\",\"riegl.pof_velocity_accuracy_north_east?\",\"riegl.pof_velocity_accur"
    "acy_east_down?\",\"riegl.pof_velocity_accuracy_down_north?\",\"riegl.pof_p"
    "dop\",\"riegl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_age_of_corrections?\""
    ",\"riegl.pof_baseline_length?\",\"riegl.pof_solution_gnss\",\"riegl.pof_sat"
    "ellites_gnss\",\"riegl.pof_path_length?\"],\"identifier\":\"trajectory.llhx\""
    ",\"extension\":\"llhx\",\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl"
    ".time_base\"]}"
);

// Schema for ".mpx" files
const char* const RDB_SCHEMA_RIEGL_MPX(
    "{\"attributes\":[\"riegl.id\",\"riegl.xy_map*\",\"riegl.amplitude\",\"riegl.ref"
    "lectance\",\"riegl.deviation\",\"riegl.timestamp_min?\",\"riegl.timestamp_ma"
    "x?\",\"riegl.point_count\",\"riegl.point_count_grid_cell\",\"riegl.pixel_lin"
    "ear_sums?\",\"riegl.pixel_square_sums?\",\"riegl.height_min\",\"riegl.height"
    "_max\",\"riegl.height_mean\",\"riegl.height_center\",\"riegl.surface_normal\""
    ",\"riegl.pca_thickness\",\"riegl.std_dev\",\"riegl.voxel_count\"],\"identifie"
    "r\":\"mpx\",\"extension\":\"mpx\",\"metadata\":[\"riegl.geo_tag\",\"riegl.pixel_in"
    "fo\",\"riegl.time_base?\"]}"
);

// Schema for ".mtch" files
const char* const RDB_SCHEMA_RIEGL_MTCH(
    "{\"attributes\":[\"riegl.xyz*\",\"riegl.plane_references\",\"riegl.plane_patc"
    "h_distance\",\"riegl.plane_patch_lateral_distance\",\"riegl.plane_patch_li"
    "nk_vector\",\"riegl.id\"],\"identifier\":\"mtch\",\"extension\":\"mtch\",\"metadat"
    "a\":[\"riegl.plane_patch_matching\"]}"
);

// Schema for ".mvx" files
const char* const RDB_SCHEMA_RIEGL_MVX(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz_map*\",\"riegl.amplitude\",\"riegl.re"
    "flectance\",\"riegl.deviation\",\"riegl.timestamp_min?\",\"riegl.timestamp_m"
    "ax?\",\"riegl.point_count\",\"riegl.shape_id\",\"riegl.covariances?\",\"riegl."
    "pca_axis_min\",\"riegl.pca_axis_max\",\"riegl.pca_extents\",\"riegl.std_dev\""
    ",\"riegl.voxel_collapsed\"],\"identifier\":\"mvx\",\"extension\":\"mvx\",\"metada"
    "ta\":[\"riegl.geo_tag\",\"riegl.time_base?\",\"riegl.voxel_info\"]}"
);

// Schema for ".obsx" files
const char* const RDB_SCHEMA_RIEGL_OBSX(
    "{\"attributes\":[\"riegl.xyz\",\"riegl.surface_normal\",\"riegl.plane_slope_c"
    "lass?\",\"riegl.id*\",\"riegl.sda1_plane_patch_one\",\"riegl.sda1_plane_patc"
    "h_two\",\"riegl.sda1_source_file_one\",\"riegl.sda1_source_file_two\"],\"ide"
    "ntifier\":\"obsx\",\"extension\":\"obsx\",\"metadata\":[\"riegl.geo_tag\",\"riegl."
    "plane_slope_class_info?\",\"riegl.pointcloud_info\",\"riegl.sda1_source_fi"
    "les\"]}"
);

// Schema for ".ocyl" files
const char* const RDB_SCHEMA_RIEGL_OCYL(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.cylinder_axis_direction\""
    ",\"riegl.cylinder_radius\",\"riegl.cylinder_height\",\"riegl.cylinder_radiu"
    "s_confidence\",\"riegl.cylinder_direction_confidence\",\"riegl.model_fit_q"
    "uality?\",\"riegl.std_dev\",\"riegl.xyz_socs\",\"riegl.direction\",\"riegl.mir"
    "ror_facet\",\"riegl.timestamp\"],\"identifier\":\"ocyl\",\"extension\":\"ocyl\",\""
    "metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"rie"
    "gl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base\"]"
    "}"
);

// Schema for ".opefx" files
const char* const RDB_SCHEMA_RIEGL_OPEFX(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.xyz_accuracies?\",\"riegl."
    "surface_normal\",\"riegl.plane_up\",\"riegl.point_count\",\"riegl.std_dev\",\""
    "riegl.plane_width\",\"riegl.plane_height\",\"riegl.plane_confidence_normal"
    "\",\"riegl.model_fit_quality?\",\"riegl.used_for_adjustment\",\"riegl.xyz_so"
    "cs\",\"riegl.timestamp\",\"riegl.mirror_facet\",\"riegl.platform_rpy_ROCS_NE"
    "D\",\"riegl.platform_drpy_ROCS_NED\",\"riegl.platform_xyz_ROCS_ENU\",\"riegl"
    ".platform_dxyz_ROCS_ENU\",\"riegl.sda.shift_vector\",\"riegl.raw_range\",\"r"
    "iegl.raw_frame_angle\",\"riegl.raw_line_angle\",\"riegl.reference_object_i"
    "d\"],\"identifier\":\"opefx\",\"extension\":\"opefx\",\"metadata\":[\"riegl.device"
    "\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parame"
    "ters\",\"riegl.scan_pattern?\",\"riegl.time_base\",\"riegl.item_names\",\"rieg"
    "l.control_object_reference_file\"]}"
);

// Schema for ".opp" files
const char* const RDB_SCHEMA_RIEGL_OPP(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.xyz_accuracies?\",\"riegl."
    "surface_normal\",\"riegl.plane_up\",\"riegl.point_count\",\"riegl.std_dev\",\""
    "riegl.plane_width\",\"riegl.plane_height\",\"riegl.plane_confidence_normal"
    "\",\"riegl.model_fit_quality?\",\"riegl.used_for_adjustment\",\"riegl.xyz_so"
    "cs\",\"riegl.timestamp\",\"riegl.mirror_facet\",\"riegl.platform_rpy_ROCS_NE"
    "D\",\"riegl.platform_drpy_ROCS_NED\",\"riegl.platform_xyz_ROCS_ENU\",\"riegl"
    ".platform_dxyz_ROCS_ENU\",\"riegl.sda.shift_vector\",\"riegl.raw_range\",\"r"
    "iegl.raw_frame_angle\",\"riegl.raw_line_angle\",\"riegl.reference_object_i"
    "d\"],\"identifier\":\"opp\",\"extension\":\"opp\",\"metadata\":[\"riegl.device\",\"r"
    "iegl.device_geometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters"
    "\",\"riegl.scan_pattern?\",\"riegl.time_base\",\"riegl.item_names\",\"riegl.co"
    "ntrol_object_reference_file\"]}"
);

// Schema for ".opx" files
const char* const RDB_SCHEMA_RIEGL_OPX(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.control_object_type\",\"ri"
    "egl.model_cs_axis_x?\",\"riegl.model_cs_axis_y?\",\"riegl.model_cs_axis_z?"
    "\",\"riegl.model_fit_quality?\",\"riegl.obs_confidence_xy?\",\"riegl.obs_con"
    "fidence_z?\",\"riegl.obs_signal_confidence_rot?\",\"riegl.obs_confidence_r"
    "ange?\",\"riegl.obs_confidence_theta?\",\"riegl.obs_confidence_phi?\",\"rieg"
    "l.point_count?\",\"riegl.used_for_adjustment\",\"riegl.xyz_socs\",\"riegl.ti"
    "mestamp\",\"riegl.mirror_facet\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.pla"
    "tform_drpy_ROCS_NED\",\"riegl.platform_xyz_ROCS_ENU\",\"riegl.platform_dxy"
    "z_ROCS_ENU\",\"riegl.sda.shift_vector\",\"riegl.raw_range\",\"riegl.raw_fram"
    "e_angle\",\"riegl.raw_line_angle\",\"riegl.reference_object_id\"],\"identifi"
    "er\":\"opx\",\"extension\":\"opx\",\"metadata\":[\"riegl.device\",\"riegl.device_g"
    "eometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters\",\"riegl.scan"
    "_pattern?\",\"riegl.time_base\",\"riegl.control_object_catalog\",\"riegl.ite"
    "m_names\",\"riegl.control_object_reference_file\"]}"
);

// Schema for ".owp" files
const char* const RDB_SCHEMA_RIEGL_OWP(
    "{\"attributes\":[\"riegl.id*\",\"riegl.raw_range\",\"riegl.amplitude\",\"riegl."
    "deviation\",\"riegl.gain\"],\"identifier\":\"owp\",\"extension\":\"owp\",\"metadat"
    "a\":[]}"
);

// Schema for ".pefx" files
const char* const RDB_SCHEMA_RIEGL_PEFX(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.xyz_accuracies?\",\"riegl."
    "surface_normal\",\"riegl.plane_up\",\"riegl.std_dev\",\"riegl.plane_confiden"
    "ce_normal\",\"riegl.plane_width\",\"riegl.plane_height\",\"riegl.vertex_firs"
    "t\",\"riegl.vertex_count\",\"riegl.used_for_adjustment\",\"riegl.acquisition"
    "_date?\",\"riegl.import_line_number\",\"riegl.import_line_count\"],\"identif"
    "ier\":\"pefx\",\"extension\":\"pefx\",\"metadata\":[\"riegl.geo_tag\",\"riegl.vert"
    "ex_info\",\"riegl.item_names\",\"riegl.imported_files\"]}"
);

// Schema for ".pofx" files
const char* const RDB_SCHEMA_RIEGL_PROJECT_POFX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\","
    "\"riegl.pof_longitude\",\"riegl.pof_height\",\"riegl.pof_roll\",\"riegl.pof_p"
    "itch\",\"riegl.pof_yaw\",\"riegl.pof_velocity_ned?\",\"riegl.pof_path_length"
    "?\"],\"identifier\":\"project.pofx\",\"extension\":\"pofx\",\"metadata\":[\"riegl."
    "device?\",\"riegl.geo_tag\",\"riegl.time_base\",\"riegl.trajectory_info\"]}"
);

// Schema for ".pofx" files
const char* const RDB_SCHEMA_RIEGL_SCAN_POFX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\","
    "\"riegl.pof_longitude\",\"riegl.pof_height\",\"riegl.pof_roll\",\"riegl.pof_p"
    "itch\",\"riegl.pof_yaw\",\"riegl.pof_path_length?\",\"riegl.pof_xyz\",\"riegl."
    "pof_roll_ned\",\"riegl.pof_pitch_ned\",\"riegl.pof_yaw_ned\"],\"identifier\":"
    "\"scan.pofx\",\"extension\":\"pofx\",\"metadata\":[\"riegl.device?\",\"riegl.time"
    "_base\",\"riegl.geo_tag\",\"riegl.trajectory_info\"]}"
);

// Schema for ".poqx" files
const char* const RDB_SCHEMA_RIEGL_PROJECT_POQX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_n"
    "orth\",\"riegl.pof_accuracy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_a"
    "ccuracy_north_east?\",\"riegl.pof_accuracy_east_down?\",\"riegl.pof_accura"
    "cy_down_north?\",\"riegl.pof_velocity_accuracy_north?\",\"riegl.pof_veloci"
    "ty_accuracy_east?\",\"riegl.pof_velocity_accuracy_down?\",\"riegl.pof_velo"
    "city_accuracy_north_east?\",\"riegl.pof_velocity_accuracy_east_down?\",\"r"
    "iegl.pof_velocity_accuracy_down_north?\",\"riegl.pof_accuracy_roll\",\"rie"
    "gl.pof_accuracy_pitch\",\"riegl.pof_accuracy_yaw\",\"riegl.pof_path_length"
    "?\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_satel"
    "lites_gnss?\",\"riegl.pof_satellites_gps?\",\"riegl.pof_satellites_glonass"
    "?\",\"riegl.pof_satellites_beidou?\",\"riegl.pof_satellites_galileo?\",\"rie"
    "gl.pof_satellites_qzss?\",\"riegl.pof_solution_gnss\",\"riegl.pof_baseline"
    "_length?\"],\"identifier\":\"project.poqx\",\"extension\":\"poqx\",\"metadata\":["
    "\"riegl.time_base\",\"riegl.trajectory_info\"]}"
);

// Schema for ".poqx" files
const char* const RDB_SCHEMA_RIEGL_SCAN_POQX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_n"
    "orth\",\"riegl.pof_accuracy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_a"
    "ccuracy_north_east?\",\"riegl.pof_accuracy_east_down?\",\"riegl.pof_accura"
    "cy_down_north?\",\"riegl.pof_velocity_accuracy_north?\",\"riegl.pof_veloci"
    "ty_accuracy_east?\",\"riegl.pof_velocity_accuracy_down?\",\"riegl.pof_velo"
    "city_accuracy_north_east?\",\"riegl.pof_velocity_accuracy_east_down?\",\"r"
    "iegl.pof_velocity_accuracy_down_north?\",\"riegl.pof_accuracy_roll\",\"rie"
    "gl.pof_accuracy_pitch\",\"riegl.pof_accuracy_yaw\",\"riegl.pof_path_length"
    "?\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_satel"
    "lites_gnss?\",\"riegl.pof_satellites_gps?\",\"riegl.pof_satellites_glonass"
    "?\",\"riegl.pof_satellites_beidou?\",\"riegl.pof_satellites_galileo?\",\"rie"
    "gl.pof_satellites_qzss?\",\"riegl.pof_solution_gnss\",\"riegl.pof_baseline"
    "_length?\"],\"identifier\":\"scan.poqx\",\"extension\":\"poqx\",\"metadata\":[\"ri"
    "egl.time_base\",\"riegl.trajectory_info\"]}"
);

// Schema for ".ppx" files
const char* const RDB_SCHEMA_RIEGL_PPX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pps_timestamp_intern*\",\"riegl.pps_tim"
    "estamp_extern\"],\"identifier\":\"ppx\",\"extension\":\"ppx\",\"metadata\":[\"rieg"
    "l.device\",\"riegl.time_base\"]}"
);

// Schema for ".ptch" files
const char* const RDB_SCHEMA_RIEGL_PROJECT_PTCH(
    "{\"attributes\":[\"riegl.xyz*\",\"riegl.surface_normal\",\"riegl.plane_up\",\"r"
    "iegl.reflectance?\",\"riegl.point_count\",\"riegl.std_dev\",\"riegl.plane_wi"
    "dth\",\"riegl.plane_height\",\"riegl.plane_count\",\"riegl.covariances\",\"rie"
    "gl.id\"],\"identifier\":\"project.ptch\",\"extension\":\"ptch\",\"metadata\":[\"ri"
    "egl.device\",\"riegl.geo_tag?\",\"riegl.scan_pattern?\",\"riegl.time_base?\","
    "\"riegl.plane_patch_statistics?\"]}"
);

// Schema for ".ptch" files
const char* const RDB_SCHEMA_RIEGL_SCAN_PTCH(
    "{\"attributes\":[\"riegl.xyz*\",\"riegl.xyz_socs\",\"riegl.direction?\",\"riegl"
    ".direction_medium?\",\"riegl.direction_coarse?\",\"riegl.surface_normal\",\""
    "riegl.plane_up\",\"riegl.timestamp\",\"riegl.reflectance?\",\"riegl.point_co"
    "unt\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.plane_height\",\"riegl.p"
    "lane_count\",\"riegl.mirror_facet\",\"riegl.covariances\",\"riegl.id\",\"riegl"
    ".plane_slope_class?\",\"riegl.plane_occupancy\",\"riegl.plane_confidence_n"
    "ormal\",\"riegl.plane_cog_link\",\"riegl.match_count\",\"riegl.platform_rpy_"
    "ROCS_NED\",\"riegl.platform_xyz_ROCS_ENU\",\"riegl.platform_drpy_ROCS_NED\""
    ",\"riegl.platform_dxyz_ROCS_ENU\",\"riegl.sda.shift_vector\",\"riegl.raw_ra"
    "nge\",\"riegl.raw_frame_angle\",\"riegl.raw_line_angle\"],\"identifier\":\"sca"
    "n.ptch\",\"extension\":\"ptch\",\"metadata\":[\"riegl.device\",\"riegl.device_ge"
    "ometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters\",\"riegl.scan_"
    "pattern?\",\"riegl.time_base\",\"riegl.plane_patch_statistics?\",\"riegl.pla"
    "ne_slope_class_info?\"]}"
);

// Schema for ".ptch" files
const char* const RDB_SCHEMA_RIEGL_SCANPOS_PTCH(
    "{\"attributes\":[\"riegl.xyz*\",\"riegl.surface_normal\",\"riegl.plane_up\",\"r"
    "iegl.reflectance?\",\"riegl.point_count\",\"riegl.std_dev\",\"riegl.plane_wi"
    "dth\",\"riegl.plane_height\",\"riegl.plane_count\",\"riegl.covariances\",\"rie"
    "gl.id\"],\"identifier\":\"scanpos.ptch\",\"extension\":\"ptch\",\"metadata\":[\"ri"
    "egl.device\",\"riegl.geo_tag?\",\"riegl.scan_pattern?\",\"riegl.time_base?\","
    "\"riegl.plane_patch_statistics?\"]}"
);

// Schema for ".rdbx" files
const char* const RDB_SCHEMA_RIEGL_RDBX(
    "{\"attributes\":[\"riegl.id\",\"riegl.timestamp\",\"riegl.xyz*\",\"riegl.xyz_so"
    "cs\",\"riegl.direction_medium?\",\"riegl.direction?\",\"riegl.amplitude\",\"ri"
    "egl.reflectance?\",\"riegl.deviation?\",\"riegl.pulse_width?\",\"riegl.targe"
    "t_index\",\"riegl.target_count\",\"riegl.mirror_facet?\",\"riegl.scan_segmen"
    "t?\",\"riegl.mta_uncertain_point?\",\"riegl.mta_zone?\",\"riegl.window_echo_"
    "impact_corrected?\",\"riegl.dyntrig_uncertain_point?\",\"riegl.rgba?\",\"rie"
    "gl.class?\",\"riegl.start_of_scan_line?\",\"riegl.end_of_scan_line?\",\"rieg"
    "l.source_indicator?\",\"riegl.fwa?\",\"riegl.waveform_available?\",\"riegl.w"
    "fm_sbl_id?\",\"riegl.wfm_echo_time_offset?\",\"riegl.scan_angle\",\"riegl.sc"
    "an_direction\",\"riegl.source_index?\",\"riegl.scan_line_index?\",\"riegl.sh"
    "ot_index_line?\",\"riegl.hydro_refraction_corrected?\",\"riegl.hydro_inter"
    "section_point?\",\"riegl.hydro_intersection_normal?\",\"riegl.extinction?\""
    ",\"riegl.svb_amplitude_volumetric?\",\"riegl.svb_reflectance_volumetric?\""
    ",\"riegl.svb_reflectance_bottom_uncorrected?\",\"riegl.svb_surface?\",\"rie"
    "gl.svb_bottom?\",\"riegl.svb_path_length?\"],\"identifier\":\"rdbx\",\"extensi"
    "on\":\"rdbx\",\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl"
    ".device_geometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"rieg"
    "l.exponential_decomposition?\",\"riegl.geo_tag\",\"riegl.georeferencing_pa"
    "rameters\",\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl."
    "noise_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\","
    "\"riegl.pointcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.ran"
    "ge_statistics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calcula"
    "tion?\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.tim"
    "e_base\",\"riegl.waveform_settings?\",\"riegl.window_analysis?\",\"riegl.win"
    "dow_echo_correction?\"]}"
);

// Schema for ".rmvx" files
const char* const RDB_SCHEMA_RIEGL_RMVX(
    "{\"attributes\":[\"riegl.id\",\"riegl.voxel_index*\",\"riegl.amplitude\",\"rieg"
    "l.reflectance\",\"riegl.deviation\",\"riegl.direction_medium\",\"riegl.point"
    "_count\",\"riegl.voxel_linear_sums\",\"riegl.voxel_square_sums\",\"riegl.tim"
    "estamp_min?\",\"riegl.timestamp_max?\"],\"identifier\":\"rmvx\",\"extension\":\""
    "rmvx\",\"metadata\":[\"riegl.geo_tag\",\"riegl.voxel_info\",\"riegl.time_base?"
    "\"]}"
);

// Schema for ".rt.llhx" files
const char* const RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX(
    "{\"attributes\":[\"riegl.id\",\"riegl.pof_latitude\",\"riegl.pof_longitude\",\""
    "riegl.pof_height\",\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_north\",\"r"
    "iegl.pof_accuracy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_pdop\",\"ri"
    "egl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_age_of_corrections\",\"riegl.p"
    "of_baseline_length\",\"riegl.pof_solution_gnss\",\"riegl.pof_satellites_gn"
    "ss\",\"riegl.pof_course?\",\"riegl.pof_xyz_ned_velocity?\"],\"identifier\":\"t"
    "rajectory.rt.llhx\",\"extension\":\"rt.llhx\",\"metadata\":[\"riegl.device?\",\""
    "riegl.geo_tag\",\"riegl.time_base\"]}"
);

// Schema for ".s10x" files
const char* const RDB_SCHEMA_RIEGL_S10X(
    "{\"attributes\":[\"riegl.id\",\"riegl.timestamp*\",\"riegl.frame_angle_coarse"
    "\",\"riegl.gyroscope_raw\",\"riegl.accelerometer_raw\",\"riegl.magnetic_fiel"
    "d_sensor_raw\",\"riegl.gyroscope\",\"riegl.accelerometer\",\"riegl.magnetic_"
    "field_sensor\",\"riegl.barometric_height_amsl\",\"riegl.temperature\",\"rieg"
    "l.line_scan_active\",\"riegl.frame_scan_active\",\"riegl.data_acquisition_"
    "active\"],\"identifier\":\"s10x\",\"extension\":\"s10x\",\"metadata\":[\"riegl.tim"
    "e_base\",\"riegl.device?\",\"riegl.pose_sensors\"]}"
);

// Schema for ".sbx" files
const char* const RDB_SCHEMA_RIEGL_SBX(
    "{\"attributes\":[\"riegl.id*\",\"riegl.wfm_sbl_channel\",\"riegl.wfm_sbl_mean"
    "\",\"riegl.wfm_sbl_std_dev\",\"riegl.wfm_sbl_time_offset\",\"riegl.wfm_sda_f"
    "irst\",\"riegl.wfm_sda_count\"],\"identifier\":\"sbx\",\"extension\":\"sbx\",\"met"
    "adata\":[]}"
);

// Schema for ".sdcx" files
const char* const RDB_SCHEMA_RIEGL_SDCX(
    "{\"attributes\":[\"riegl.id\",\"riegl.timestamp*\",\"riegl.xyz\",\"riegl.amplit"
    "ude\",\"riegl.reflectance?\",\"riegl.deviation?\",\"riegl.pulse_width?\",\"rie"
    "gl.target_index\",\"riegl.target_count\",\"riegl.mirror_facet?\",\"riegl.sca"
    "n_segment?\",\"riegl.mta_uncertain_point?\",\"riegl.mta_zone?\",\"riegl.wind"
    "ow_echo_impact_corrected?\",\"riegl.dyntrig_uncertain_point?\",\"riegl.cla"
    "ss?\",\"riegl.start_of_scan_line?\",\"riegl.end_of_scan_line?\",\"riegl.sour"
    "ce_indicator?\",\"riegl.fwa?\",\"riegl.waveform_available?\",\"riegl.wfm_sbl"
    "_id?\",\"riegl.wfm_echo_time_offset?\",\"riegl.extinction?\",\"riegl.svb_amp"
    "litude_volumetric?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\",\"riegl.sv"
    "b_path_length?\"],\"identifier\":\"sdcx\",\"extension\":\"sdcx\",\"metadata\":[\"r"
    "iegl.atmosphere\",\"riegl.beam_geometry\",\"riegl.device_geometry\",\"riegl."
    "device\",\"riegl.gaussian_decomposition?\",\"riegl.exponential_decompositi"
    "on?\",\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl.noise"
    "_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\",\"rieg"
    "l.pointcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.range_st"
    "atistics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calculation?"
    "\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.time_bas"
    "e\",\"riegl.window_analysis?\",\"riegl.window_echo_correction?\"]}"
);

// Schema for ".sidx" files
const char* const RDB_SCHEMA_RIEGL_SIDX(
    "{\"attributes\":[\"riegl.id\",\"riegl.shot_timestamp_hr*\",\"riegl.echo_first"
    "\",\"riegl.echo_count\"],\"identifier\":\"sidx\",\"extension\":\"sidx\",\"metadata"
    "\":[\"riegl.shot_info\",\"riegl.echo_info\"]}"
);

// Schema for ".sodx" files
const char* const RDB_SCHEMA_RIEGL_SODX(
    "{\"attributes\":[\"riegl.id\",\"riegl.shot_timestamp_hr*\",\"riegl.mirror_fac"
    "et\",\"riegl.scan_segment\",\"riegl.start_of_scan_line\",\"riegl.line_angle_"
    "coarse\",\"riegl.shot_origin\",\"riegl.shot_biaxial_shift?\",\"riegl.shot_di"
    "rection\",\"riegl.shot_direction_levelled?\",\"riegl.wfm_sbl_first?\",\"rieg"
    "l.wfm_sbl_count?\",\"riegl.echo_first?\",\"riegl.echo_count?\"],\"identifier"
    "\":\"sodx\",\"extension\":\"sodx\",\"metadata\":[\"riegl.atmosphere\",\"riegl.devi"
    "ce\",\"riegl.device_geometry\",\"riegl.device_output_limits\",\"riegl.beam_g"
    "eometry\",\"riegl.near_range_correction?\",\"riegl.window_echo_correction?"
    "\",\"riegl.receiver_internals?\",\"riegl.gaussian_decomposition?\",\"riegl.e"
    "xponential_decomposition?\",\"riegl.mta_settings?\",\"riegl.pulse_position"
    "_modulation?\",\"riegl.notch_filter?\",\"riegl.reflectance_calculation?\",\""
    "riegl.scan_pattern\",\"riegl.time_base\",\"riegl.waveform_info?\",\"riegl.ec"
    "ho_info?\"]}"
);

// Schema for ".sp{C}" files
const char* const RDB_SCHEMA_RIEGL_SPC(
    "{\"attributes\":[\"riegl.id*\",\"riegl.wfm_sample_value\"],\"identifier\":\"sp{"
    "C}\",\"extension\":\"sp{C}\",\"metadata\":[]}"
);

// Schema for ".vtx" files
const char* const RDB_SCHEMA_RIEGL_VTX(
    "{\"attributes\":[\"riegl.id*\",\"riegl.xyz\",\"riegl.xyz_accuracies?\"],\"ident"
    "ifier\":\"vtx\",\"extension\":\"vtx\",\"metadata\":[\"riegl.geo_tag\"]}"
);

// Schema for ".vxls" files
const char* const RDB_SCHEMA_RIEGL_VXLS(
    "{\"attributes\":[\"riegl.id\",\"riegl.xyz*\",\"riegl.covariances\",\"riegl.pca_"
    "axis_max\",\"riegl.pca_axis_min\",\"riegl.pca_extents\",\"riegl.point_count\""
    ",\"riegl.reflectance\",\"riegl.shape_id\",\"riegl.voxel_collapsed\",\"riegl.s"
    "td_dev?\"],\"identifier\":\"vxls\",\"extension\":\"vxls\",\"metadata\":[\"riegl.vo"
    "xel_info\",\"riegl.geo_tag?\"]}"
);

// Schema for ".wdcx" files
const char* const RDB_SCHEMA_RIEGL_WDCX(
    "{\"attributes\":[\"riegl.id\",\"riegl.timestamp\",\"riegl.xyz*\",\"riegl.xyz_so"
    "cs\",\"riegl.direction_medium?\",\"riegl.direction?\",\"riegl.amplitude\",\"ri"
    "egl.reflectance?\",\"riegl.deviation?\",\"riegl.pulse_width?\",\"riegl.targe"
    "t_index\",\"riegl.target_count\",\"riegl.mirror_facet?\",\"riegl.scan_segmen"
    "t?\",\"riegl.mta_uncertain_point?\",\"riegl.mta_zone?\",\"riegl.window_echo_"
    "impact_corrected?\",\"riegl.dyntrig_uncertain_point?\",\"riegl.rgba?\",\"rie"
    "gl.class?\",\"riegl.start_of_scan_line?\",\"riegl.end_of_scan_line?\",\"rieg"
    "l.source_indicator?\",\"riegl.fwa?\",\"riegl.waveform_available?\",\"riegl.w"
    "fm_sbl_id?\",\"riegl.wfm_echo_time_offset?\",\"riegl.scan_angle\",\"riegl.sc"
    "an_direction\",\"riegl.source_index?\",\"riegl.scan_line_index?\",\"riegl.sh"
    "ot_index_line?\",\"riegl.hydro_refraction_corrected?\",\"riegl.hydro_inter"
    "section_point?\",\"riegl.hydro_intersection_normal?\",\"riegl.extinction?\""
    ",\"riegl.svb_amplitude_volumetric?\",\"riegl.svb_reflectance_volumetric?\""
    ",\"riegl.svb_reflectance_bottom_uncorrected?\",\"riegl.svb_surface?\",\"rie"
    "gl.svb_bottom?\",\"riegl.svb_path_length?\"],\"identifier\":\"wdcx\",\"extensi"
    "on\":\"wdcx\",\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl"
    ".device_geometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"rieg"
    "l.exponential_decomposition?\",\"riegl.geo_tag\",\"riegl.georeferencing_pa"
    "rameters\",\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl."
    "noise_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\","
    "\"riegl.pointcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.ran"
    "ge_statistics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calcula"
    "tion?\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.tim"
    "e_base\",\"riegl.waveform_settings?\",\"riegl.window_analysis?\",\"riegl.win"
    "dow_echo_correction?\"]}"
);

// Schema for ".wex" files
const char* const RDB_SCHEMA_RIEGL_WEX(
    "{\"attributes\":[\"riegl.id\",\"riegl.timestamp*\",\"riegl.wex_filter_valid\","
    "\"riegl.wex_point_count\",\"riegl.wex_amplitude\",\"riegl.wex_amplitude_std"
    "_dev\",\"riegl.wex_amplitude_min\",\"riegl.wex_amplitude_max\",\"riegl.wex_a"
    "mplitude_offset\",\"riegl.wex_deviation\",\"riegl.wex_deviation_std_dev\",\""
    "riegl.wex_deviation_min\",\"riegl.wex_deviation_max\",\"riegl.wex_range\",\""
    "riegl.wex_range_std_dev\",\"riegl.wex_range_min\",\"riegl.wex_range_max\",\""
    "riegl.wex_filter_range_min\",\"riegl.wex_filter_range_max\",\"riegl.wex_fi"
    "lter_amplitude_max\"],\"identifier\":\"wex\",\"extension\":\"wex\",\"metadata\":["
    "\"riegl.device\",\"riegl.notch_filter\",\"riegl.window_analysis\"]}"
);

// Table of all RDB file schema strings
const char* const RDB_SCHEMA_ARRAY[] = {
    RDB_SCHEMA_RIEGL_AVG_FWA,
    RDB_SCHEMA_RIEGL_AVG_SBX,
    RDB_SCHEMA_RIEGL_AVG_SIDX,
    RDB_SCHEMA_RIEGL_AVG_SPC,
    RDB_SCHEMA_RIEGL_BSX,
    RDB_SCHEMA_RIEGL_CPX,
    RDB_SCHEMA_RIEGL_CYL,
    RDB_SCHEMA_RIEGL_DMIX,
    RDB_SCHEMA_RIEGL_DOIX,
    RDB_SCHEMA_RIEGL_EIFX,
    RDB_SCHEMA_RIEGL_EPFX,
    RDB_SCHEMA_RIEGL_FWA,
    RDB_SCHEMA_RIEGL_IMUX,
    RDB_SCHEMA_RIEGL_LLHX,
    RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX,
    RDB_SCHEMA_RIEGL_MPX,
    RDB_SCHEMA_RIEGL_MTCH,
    RDB_SCHEMA_RIEGL_MVX,
    RDB_SCHEMA_RIEGL_OBSX,
    RDB_SCHEMA_RIEGL_OCYL,
    RDB_SCHEMA_RIEGL_OPEFX,
    RDB_SCHEMA_RIEGL_OPP,
    RDB_SCHEMA_RIEGL_OPX,
    RDB_SCHEMA_RIEGL_OWP,
    RDB_SCHEMA_RIEGL_PEFX,
    RDB_SCHEMA_RIEGL_PROJECT_POFX,
    RDB_SCHEMA_RIEGL_SCAN_POFX,
    RDB_SCHEMA_RIEGL_PROJECT_POQX,
    RDB_SCHEMA_RIEGL_SCAN_POQX,
    RDB_SCHEMA_RIEGL_PPX,
    RDB_SCHEMA_RIEGL_PROJECT_PTCH,
    RDB_SCHEMA_RIEGL_SCAN_PTCH,
    RDB_SCHEMA_RIEGL_SCANPOS_PTCH,
    RDB_SCHEMA_RIEGL_RDBX,
    RDB_SCHEMA_RIEGL_RMVX,
    RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX,
    RDB_SCHEMA_RIEGL_S10X,
    RDB_SCHEMA_RIEGL_SBX,
    RDB_SCHEMA_RIEGL_SDCX,
    RDB_SCHEMA_RIEGL_SIDX,
    RDB_SCHEMA_RIEGL_SODX,
    RDB_SCHEMA_RIEGL_SPC,
    RDB_SCHEMA_RIEGL_VTX,
    RDB_SCHEMA_RIEGL_VXLS,
    RDB_SCHEMA_RIEGL_WDCX,
    RDB_SCHEMA_RIEGL_WEX
};
const size_t RDB_SCHEMA_COUNT(
    sizeof(RDB_SCHEMA_ARRAY) / sizeof(RDB_SCHEMA_ARRAY[0])
);

#endif // RDB_2125FB67_4790_4EE4_BC63_844F2ACC9D90
