/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    transaction.hpp
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Point cloud transaction
 * \version 2015-10-14/AW: Initial version
 * \version 2017-02-16/AW: RDB library version string field added (#2515)
 * \version 2017-11-24/AW: Constructors declared as "explicit" (#2825)
 *
 *******************************************************************************
 */

#ifndef RIEGL_RDB_POINTCLOUD_TRANSACTION_HPP
#define RIEGL_RDB_POINTCLOUD_TRANSACTION_HPP

//---< INCLUDES >---------------------------------------------------------------

#include <string>
#include <cstdlib>
#include <cstdint>

#include "riegl/rdb/context.hpp"

//---< NAMESPACE >--------------------------------------------------------------

namespace riegl {
namespace rdb {
namespace pointcloud {

//---< CLASS Transaction >------------------------------------------------------
/*!
 * \brief Point cloud transaction
 * \see riegl::rdb::pointcloud::Transactions
 */
class Transaction
{
public:
    typedef std::uint32_t ID;

    ID          id;       //!< transaction number (TAN)
    std::string rdb;      //!< RDB library version string
    std::string title;    //!< short description, e.g. "Import"
    std::string agent;    //!< software name, e.g. "rdbimport v1.0"
    std::string comments; //!< e.g. process details for humans
    std::string settings; //!< e.g. process settings for software
    std::string start;    //!< start time as "yyyy-mm-dd hh:mm:ss.zzz", e.g. "2015-10-14 13:48:35.801" (local time)
    std::string stop;     //!< stop  time as "yyyy-mm-dd hh:mm:ss.zzz", e.g. "2015-10-14 13:48:35.801" (local time)

    Transaction();
    explicit Transaction(riegl::rdb::Context &context);
};

}}} // namespace riegl::rdb::pointcloud

#endif // RIEGL_RDB_POINTCLOUD_TRANSACTION_HPP
