/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \author RIEGL LMS GmbH, Austria
 * \brief  Description of RIEGL RDB 2 database file contents
 *
 *  NOTE: All information in this file is preliminary, since the
 *        definition of the database schemas is not yet complete.
 *
 *******************************************************************************
 */

#ifndef RDB_2125FB67_4790_4EE4_BC63_844F2ACC9D90
#define RDB_2125FB67_4790_4EE4_BC63_844F2ACC9D90

// File schema version
const char* const RDB_SCHEMA_VERSION = "ffc879de";
const char* const RDB_SCHEMA_DATE = "2025-04-18";

// Schema for ".avg.fwa" files
const char* const RDB_SCHEMA_RIEGL_AVG_FWA(
    "{\"identifier\":\"avg.fwa\",\"extension\":\"avg.fwa\",\"attributes\":[\"riegl.id*"
    "\",\"riegl.amplitude\",\"riegl.gain\",\"riegl.raw_range\",\"riegl.wfm_echo_tim"
    "e_offset\",\"riegl.wfm_sbl_id\",\"riegl.deviation?\",\"riegl.pulse_width?\"],"
    "\"metadata\":[]}"
);

// Schema for ".avg.sbx" files
const char* const RDB_SCHEMA_RIEGL_AVG_SBX(
    "{\"identifier\":\"avg.sbx\",\"extension\":\"avg.sbx\",\"attributes\":[\"riegl.id*"
    "\",\"riegl.wfm_sbl_channel\",\"riegl.wfm_sbl_mean\",\"riegl.wfm_sbl_std_dev\""
    ",\"riegl.wfm_sbl_time_offset\",\"riegl.wfm_sda_first\",\"riegl.wfm_sda_coun"
    "t\"],\"metadata\":[]}"
);

// Schema for ".avg.sidx" files
const char* const RDB_SCHEMA_RIEGL_AVG_SIDX(
    "{\"identifier\":\"avg.sidx\",\"extension\":\"avg.sidx\",\"attributes\":[\"riegl.i"
    "d\",\"riegl.shot_timestamp_hr*\",\"riegl.wfm_sbl_first\",\"riegl.wfm_sbl_cou"
    "nt\",\"riegl.echo_first?\",\"riegl.echo_count?\"],\"metadata\":[\"riegl.shot_i"
    "nfo\",\"riegl.waveform_info\",\"riegl.echo_info?\",\"riegl.waveform_averagin"
    "g_settings\"]}"
);

// Schema for ".avg.sp{C}" files
const char* const RDB_SCHEMA_RIEGL_AVG_SPC(
    "{\"identifier\":\"avg.sp{C}\",\"extension\":\"avg.sp{C}\",\"attributes\":[\"riegl"
    ".id*\",\"riegl.wfm_sample_value\"],\"metadata\":[]}"
);

// Schema for ".bsx" files
const char* const RDB_SCHEMA_RIEGL_BSX(
    "{\"identifier\":\"bsx\",\"extension\":\"bsx\",\"attributes\":[\"riegl.id\",\"riegl."
    "pof_timestamp*\",\"riegl.accelerometer_bias\",\"riegl.accelerometer_scale\""
    ",\"riegl.gyroscope_bias\",\"riegl.gyroscope_scale\"],\"metadata\":[\"riegl.ti"
    "me_base\"]}"
);

// Schema for ".cpx" files
const char* const RDB_SCHEMA_RIEGL_CPX(
    "{\"identifier\":\"cpx\",\"extension\":\"cpx\",\"attributes\":[\"riegl.id\",\"riegl."
    "xyz*\",\"riegl.xyz_accuracies\",\"riegl.control_object_type\",\"riegl.zenith"
    "_vector\",\"riegl.used_for_adjustment\",\"riegl.acquisition_date?\",\"riegl."
    "cp_surface_inclination_angle\",\"riegl.cp_surface_inclination_tolerance_"
    "angle\",\"riegl.cp_surface_northing_angle?\",\"riegl.cp_surface_northing_t"
    "olerance_angle?\",\"riegl.cp_search_radius?\",\"riegl.cp_maximum_distance?"
    "\",\"riegl.import_line_number\"],\"metadata\":[\"riegl.geo_tag\",\"riegl.contr"
    "ol_object_catalog\",\"riegl.item_names\",\"riegl.imported_files\"]}"
);

// Schema for ".cyl" files
const char* const RDB_SCHEMA_RIEGL_CYL(
    "{\"identifier\":\"cyl\",\"extension\":\"cyl\",\"attributes\":[\"riegl.id\",\"riegl."
    "xyz*\",\"riegl.cylinder_axis_direction\",\"riegl.cylinder_radius\",\"riegl.c"
    "ylinder_height\",\"riegl.cylinder_radius_confidence\",\"riegl.cylinder_dir"
    "ection_confidence\",\"riegl.std_dev\"],\"metadata\":[\"riegl.geo_tag\"]}"
);

// Schema for ".dmix" files
const char* const RDB_SCHEMA_RIEGL_DMIX(
    "{\"identifier\":\"dmix\",\"extension\":\"dmix\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.dmi_count\",\"riegl.dmi_path_length_raw\",\"riegl.pof_timestamp*\"],\"meta"
    "data\":[\"riegl.device?\",\"riegl.dmi_config\",\"riegl.time_base\"]}"
);

// Schema for ".doix" files
const char* const RDB_SCHEMA_RIEGL_DOIX(
    "{\"identifier\":\"doix\",\"extension\":\"doix\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.shot_origin\",\"riegl.shot_direction*\",\"riegl.scan_line_index\",\"riegl."
    "shot_index_line\"],\"metadata\":[]}"
);

// Schema for ".eifx" files
const char* const RDB_SCHEMA_RIEGL_EIFX(
    "{\"identifier\":\"eifx\",\"extension\":\"eifx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.event_timestamp*\",\"riegl.event_index?\",\"riegl.event_pulse_width?\",\"r"
    "iegl.event_fake_pulse?\",\"riegl.raw_line_angle?\",\"riegl.raw_frame_angle"
    "?\"],\"metadata\":[\"riegl.device?\",\"riegl.time_base\",\"riegl.ttip_configur"
    "ation?\"]}"
);

// Schema for ".epfx" files
const char* const RDB_SCHEMA_RIEGL_EPFX(
    "{\"identifier\":\"epfx\",\"extension\":\"epfx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.event_timestamp*\",\"riegl.event_index?\",\"riegl.event_pulse_width?\",\"r"
    "iegl.event_fake_pulse?\",\"riegl.raw_line_angle?\",\"riegl.raw_frame_angle"
    "?\",\"riegl.xyz\",\"riegl.model_cs_axis_x\",\"riegl.model_cs_axis_y\",\"riegl."
    "model_cs_axis_z\"],\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl.t"
    "ime_base\",\"riegl.ttip_configuration?\"]}"
);

// Schema for ".fwa" files
const char* const RDB_SCHEMA_RIEGL_FWA(
    "{\"identifier\":\"fwa\",\"extension\":\"fwa\",\"attributes\":[\"riegl.id*\",\"riegl"
    ".amplitude\",\"riegl.gain\",\"riegl.raw_range\",\"riegl.wfm_echo_time_offset"
    "\",\"riegl.wfm_sbl_id\",\"riegl.deviation?\",\"riegl.pulse_width?\",\"riegl.ex"
    "tinction?\",\"riegl.svb_amplitude_volumetric?\",\"riegl.svb_attenuation_vo"
    "lumetric?\",\"riegl.svb_target_attenuation_coefficient_volumetric?\",\"rie"
    "gl.svb_surface?\",\"riegl.svb_bottom?\",\"riegl.svb_path_length?\"],\"metada"
    "ta\":[]}"
);

// Schema for ".imux" files
const char* const RDB_SCHEMA_RIEGL_IMUX(
    "{\"identifier\":\"imux\",\"extension\":\"imux\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.timestamp*\",\"riegl.temperature\",\"riegl.accelerometer\",\"riegl.gyrosco"
    "pe\",\"riegl.accelerometer_raw\",\"riegl.gyroscope_raw\",\"riegl.magnetic_fi"
    "eld_sensor_raw\",\"riegl.frame_angle_coarse\",\"riegl.line_angle_coarse\",\""
    "riegl.frame_scan_active\",\"riegl.data_acquisition_active\",\"riegl.barome"
    "tric_height_amsl\"],\"metadata\":[\"riegl.device\",\"riegl.time_base\",\"riegl"
    ".riloc_sensor_information\",\"riegl.rxp_json_parameter_1\"]}"
);

// Schema for ".llhx" files
const char* const RDB_SCHEMA_RIEGL_LLHX(
    "{\"identifier\":\"llhx\",\"extension\":\"llhx\",\"attributes\":[\"riegl.pof_latit"
    "ude\",\"riegl.pof_longitude\",\"riegl.pof_height\",\"riegl.pof_timestamp*\",\""
    "riegl.pof_accuracy_north\",\"riegl.pof_accuracy_east\",\"riegl.pof_accurac"
    "y_down\",\"riegl.pof_pdop\",\"riegl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_"
    "age_of_corrections\",\"riegl.pof_baseline_length\",\"riegl.pof_solution_gn"
    "ss\",\"riegl.pof_satellites_gnss\",\"riegl.id\"],\"metadata\":[\"riegl.device?"
    "\",\"riegl.geo_tag\",\"riegl.time_base\"]}"
);

// Schema for ".llhx" files
const char* const RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX(
    "{\"identifier\":\"trajectory.llhx\",\"extension\":\"llhx\",\"attributes\":[\"rieg"
    "l.id\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\",\"riegl.pof_longitude"
    "\",\"riegl.pof_height\",\"riegl.pof_accuracy_north\",\"riegl.pof_accuracy_ea"
    "st\",\"riegl.pof_accuracy_down\",\"riegl.pof_accuracy_north_east?\",\"riegl."
    "pof_accuracy_east_down?\",\"riegl.pof_accuracy_down_north?\",\"riegl.pof_v"
    "elocity_ned?\",\"riegl.pof_velocity_accuracy_north?\",\"riegl.pof_velocity"
    "_accuracy_east?\",\"riegl.pof_velocity_accuracy_down?\",\"riegl.pof_veloci"
    "ty_accuracy_north_east?\",\"riegl.pof_velocity_accuracy_east_down?\",\"rie"
    "gl.pof_velocity_accuracy_down_north?\",\"riegl.pof_pdop\",\"riegl.pof_hdop"
    "\",\"riegl.pof_vdop\",\"riegl.pof_age_of_corrections?\",\"riegl.pof_baseline"
    "_length?\",\"riegl.pof_solution_gnss\",\"riegl.pof_satellites_gnss\",\"riegl"
    ".pof_path_length?\"],\"metadata\":[\"riegl.device?\",\"riegl.geo_tag\",\"riegl"
    ".time_base\"]}"
);

// Schema for ".mpx" files
const char* const RDB_SCHEMA_RIEGL_MPX(
    "{\"identifier\":\"mpx\",\"extension\":\"mpx\",\"attributes\":[\"riegl.id\",\"riegl."
    "xy_map*\",\"riegl.amplitude\",\"riegl.reflectance\",\"riegl.deviation\",\"rieg"
    "l.timestamp_min?\",\"riegl.timestamp_max?\",\"riegl.point_count\",\"riegl.po"
    "int_count_grid_cell\",\"riegl.pixel_linear_sums?\",\"riegl.pixel_square_su"
    "ms?\",\"riegl.height_min\",\"riegl.height_max\",\"riegl.height_mean\",\"riegl."
    "height_center\",\"riegl.surface_normal\",\"riegl.pca_thickness\",\"riegl.std"
    "_dev\",\"riegl.voxel_count\"],\"metadata\":[\"riegl.geo_tag\",\"riegl.pixel_in"
    "fo\",\"riegl.time_base?\"]}"
);

// Schema for ".mtch" files
const char* const RDB_SCHEMA_RIEGL_MTCH(
    "{\"identifier\":\"mtch\",\"extension\":\"mtch\",\"attributes\":[\"riegl.xyz*\",\"ri"
    "egl.plane_references\",\"riegl.plane_patch_distance\",\"riegl.plane_patch_"
    "lateral_distance\",\"riegl.plane_patch_link_vector\",\"riegl.id\"],\"metadat"
    "a\":[\"riegl.plane_patch_matching\"]}"
);

// Schema for ".mvx" files
const char* const RDB_SCHEMA_RIEGL_MVX(
    "{\"identifier\":\"mvx\",\"extension\":\"mvx\",\"attributes\":[\"riegl.id\",\"riegl."
    "xyz_map*\",\"riegl.amplitude\",\"riegl.reflectance\",\"riegl.deviation\",\"rie"
    "gl.timestamp_min?\",\"riegl.timestamp_max?\",\"riegl.point_count\",\"riegl.s"
    "hape_id\",\"riegl.covariances?\",\"riegl.pca_axis_min\",\"riegl.pca_axis_max"
    "\",\"riegl.pca_extents\",\"riegl.std_dev\",\"riegl.voxel_collapsed\"],\"metada"
    "ta\":[\"riegl.geo_tag\",\"riegl.time_base?\",\"riegl.voxel_info\"]}"
);

// Schema for ".obsx" files
const char* const RDB_SCHEMA_RIEGL_OBSX(
    "{\"identifier\":\"obsx\",\"extension\":\"obsx\",\"attributes\":[\"riegl.xyz\",\"rie"
    "gl.surface_normal\",\"riegl.plane_slope_class?\",\"riegl.id*\",\"riegl.sda1_"
    "plane_patch_one\",\"riegl.sda1_plane_patch_two\",\"riegl.sda1_source_file_"
    "one\",\"riegl.sda1_source_file_two\"],\"metadata\":[\"riegl.geo_tag\",\"riegl."
    "plane_slope_class_info?\",\"riegl.pointcloud_info\",\"riegl.sda1_source_fi"
    "les\"]}"
);

// Schema for ".ocyl" files
const char* const RDB_SCHEMA_RIEGL_OCYL(
    "{\"identifier\":\"ocyl\",\"extension\":\"ocyl\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.xyz*\",\"riegl.cylinder_axis_direction\",\"riegl.cylinder_radius\",\"riegl"
    ".cylinder_height\",\"riegl.cylinder_radius_confidence\",\"riegl.cylinder_d"
    "irection_confidence\",\"riegl.model_fit_quality?\",\"riegl.std_dev\",\"riegl"
    ".xyz_socs\",\"riegl.direction\",\"riegl.mirror_facet\",\"riegl.timestamp\"],\""
    "metadata\":[\"riegl.device\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"rie"
    "gl.georeferencing_parameters\",\"riegl.scan_pattern?\",\"riegl.time_base\"]"
    "}"
);

// Schema for ".opefx" files
const char* const RDB_SCHEMA_RIEGL_OPEFX(
    "{\"identifier\":\"opefx\",\"extension\":\"opefx\",\"attributes\":[\"riegl.id\",\"ri"
    "egl.xyz*\",\"riegl.xyz_accuracies?\",\"riegl.surface_normal\",\"riegl.plane_"
    "up\",\"riegl.point_count\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.pla"
    "ne_height\",\"riegl.plane_confidence_normal\",\"riegl.model_fit_quality?\","
    "\"riegl.used_for_adjustment\",\"riegl.xyz_socs\",\"riegl.timestamp\",\"riegl."
    "mirror_facet\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.platform_drpy_ROCS_"
    "NED\",\"riegl.platform_xyz_ROCS_ENU\",\"riegl.platform_dxyz_ROCS_ENU\",\"rie"
    "gl.sda.shift_vector\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\"riegl."
    "raw_line_angle\",\"riegl.reference_object_id\"],\"metadata\":[\"riegl.device"
    "\",\"riegl.device_geometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parame"
    "ters\",\"riegl.scan_pattern?\",\"riegl.time_base\",\"riegl.item_names\",\"rieg"
    "l.control_object_reference_file\"]}"
);

// Schema for ".opp" files
const char* const RDB_SCHEMA_RIEGL_OPP(
    "{\"identifier\":\"opp\",\"extension\":\"opp\",\"attributes\":[\"riegl.id\",\"riegl."
    "xyz*\",\"riegl.xyz_accuracies?\",\"riegl.surface_normal\",\"riegl.plane_up\","
    "\"riegl.point_count\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.plane_h"
    "eight\",\"riegl.plane_confidence_normal\",\"riegl.model_fit_quality?\",\"rie"
    "gl.used_for_adjustment\",\"riegl.xyz_socs\",\"riegl.timestamp\",\"riegl.mirr"
    "or_facet\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.platform_drpy_ROCS_NED\""
    ",\"riegl.platform_xyz_ROCS_ENU\",\"riegl.platform_dxyz_ROCS_ENU\",\"riegl.s"
    "da.shift_vector\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\"riegl.raw_"
    "line_angle\",\"riegl.reference_object_id\"],\"metadata\":[\"riegl.device\",\"r"
    "iegl.device_geometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters"
    "\",\"riegl.scan_pattern?\",\"riegl.time_base\",\"riegl.item_names\",\"riegl.co"
    "ntrol_object_reference_file\"]}"
);

// Schema for ".opx" files
const char* const RDB_SCHEMA_RIEGL_OPX(
    "{\"identifier\":\"opx\",\"extension\":\"opx\",\"attributes\":[\"riegl.id\",\"riegl."
    "xyz*\",\"riegl.control_object_type\",\"riegl.model_cs_axis_x?\",\"riegl.mode"
    "l_cs_axis_y?\",\"riegl.model_cs_axis_z?\",\"riegl.model_fit_quality?\",\"rie"
    "gl.obs_confidence_xy?\",\"riegl.obs_confidence_z?\",\"riegl.obs_signal_con"
    "fidence_rot?\",\"riegl.obs_confidence_range?\",\"riegl.obs_confidence_thet"
    "a?\",\"riegl.obs_confidence_phi?\",\"riegl.point_count?\",\"riegl.used_for_a"
    "djustment\",\"riegl.xyz_socs\",\"riegl.timestamp\",\"riegl.mirror_facet\",\"ri"
    "egl.platform_rpy_ROCS_NED\",\"riegl.platform_drpy_ROCS_NED\",\"riegl.platf"
    "orm_xyz_ROCS_ENU\",\"riegl.platform_dxyz_ROCS_ENU\",\"riegl.sda.shift_vect"
    "or\",\"riegl.raw_range\",\"riegl.raw_frame_angle\",\"riegl.raw_line_angle\",\""
    "riegl.reference_object_id\"],\"metadata\":[\"riegl.device\",\"riegl.device_g"
    "eometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters\",\"riegl.scan"
    "_pattern?\",\"riegl.time_base\",\"riegl.control_object_catalog\",\"riegl.ite"
    "m_names\",\"riegl.control_object_reference_file\"]}"
);

// Schema for ".owp" files
const char* const RDB_SCHEMA_RIEGL_OWP(
    "{\"identifier\":\"owp\",\"extension\":\"owp\",\"attributes\":[\"riegl.id*\",\"riegl"
    ".raw_range\",\"riegl.amplitude\",\"riegl.deviation\",\"riegl.gain\"],\"metadat"
    "a\":[]}"
);

// Schema for ".pefx" files
const char* const RDB_SCHEMA_RIEGL_PEFX(
    "{\"identifier\":\"pefx\",\"extension\":\"pefx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.xyz*\",\"riegl.xyz_accuracies?\",\"riegl.surface_normal\",\"riegl.plane_up"
    "\",\"riegl.std_dev\",\"riegl.plane_confidence_normal\",\"riegl.plane_width\","
    "\"riegl.plane_height\",\"riegl.vertex_first\",\"riegl.vertex_count\",\"riegl."
    "used_for_adjustment\",\"riegl.acquisition_date?\",\"riegl.import_line_numb"
    "er\",\"riegl.import_line_count\"],\"metadata\":[\"riegl.geo_tag\",\"riegl.vert"
    "ex_info\",\"riegl.item_names\",\"riegl.imported_files\"]}"
);

// Schema for ".pofx" files
const char* const RDB_SCHEMA_RIEGL_PROJECT_POFX(
    "{\"identifier\":\"project.pofx\",\"extension\":\"pofx\",\"attributes\":[\"riegl.i"
    "d\",\"riegl.pof_timestamp*\",\"riegl.pof_latitude\",\"riegl.pof_longitude\",\""
    "riegl.pof_height\",\"riegl.pof_roll\",\"riegl.pof_pitch\",\"riegl.pof_yaw\",\""
    "riegl.pof_velocity_ned?\",\"riegl.pof_path_length?\"],\"metadata\":[\"riegl."
    "device?\",\"riegl.geo_tag\",\"riegl.time_base\",\"riegl.trajectory_info\"]}"
);

// Schema for ".pofx" files
const char* const RDB_SCHEMA_RIEGL_SCAN_POFX(
    "{\"identifier\":\"scan.pofx\",\"extension\":\"pofx\",\"attributes\":[\"riegl.id\","
    "\"riegl.pof_timestamp*\",\"riegl.pof_latitude\",\"riegl.pof_longitude\",\"rie"
    "gl.pof_height\",\"riegl.pof_roll\",\"riegl.pof_pitch\",\"riegl.pof_yaw\",\"rie"
    "gl.pof_path_length?\",\"riegl.pof_xyz\",\"riegl.pof_roll_ned\",\"riegl.pof_p"
    "itch_ned\",\"riegl.pof_yaw_ned\"],\"metadata\":[\"riegl.device?\",\"riegl.time"
    "_base\",\"riegl.geo_tag\",\"riegl.trajectory_info\"]}"
);

// Schema for ".poqx" files
const char* const RDB_SCHEMA_RIEGL_PROJECT_POQX(
    "{\"identifier\":\"project.poqx\",\"extension\":\"poqx\",\"attributes\":[\"riegl.i"
    "d\",\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_accura"
    "cy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_accuracy_north_east?\",\"r"
    "iegl.pof_accuracy_east_down?\",\"riegl.pof_accuracy_down_north?\",\"riegl."
    "pof_velocity_accuracy_north?\",\"riegl.pof_velocity_accuracy_east?\",\"rie"
    "gl.pof_velocity_accuracy_down?\",\"riegl.pof_velocity_accuracy_north_eas"
    "t?\",\"riegl.pof_velocity_accuracy_east_down?\",\"riegl.pof_velocity_accur"
    "acy_down_north?\",\"riegl.pof_accuracy_roll\",\"riegl.pof_accuracy_pitch\","
    "\"riegl.pof_accuracy_yaw\",\"riegl.pof_path_length?\",\"riegl.pof_pdop\",\"ri"
    "egl.pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_satellites_gnss?\",\"riegl.pof"
    "_satellites_gps?\",\"riegl.pof_satellites_glonass?\",\"riegl.pof_satellite"
    "s_beidou?\",\"riegl.pof_satellites_galileo?\",\"riegl.pof_satellites_qzss?"
    "\",\"riegl.pof_solution_gnss\",\"riegl.pof_baseline_length?\"],\"metadata\":["
    "\"riegl.time_base\",\"riegl.trajectory_info\"]}"
);

// Schema for ".poqx" files
const char* const RDB_SCHEMA_RIEGL_SCAN_POQX(
    "{\"identifier\":\"scan.poqx\",\"extension\":\"poqx\",\"attributes\":[\"riegl.id\","
    "\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_accuracy_"
    "east\",\"riegl.pof_accuracy_down\",\"riegl.pof_accuracy_north_east?\",\"rieg"
    "l.pof_accuracy_east_down?\",\"riegl.pof_accuracy_down_north?\",\"riegl.pof"
    "_velocity_accuracy_north?\",\"riegl.pof_velocity_accuracy_east?\",\"riegl."
    "pof_velocity_accuracy_down?\",\"riegl.pof_velocity_accuracy_north_east?\""
    ",\"riegl.pof_velocity_accuracy_east_down?\",\"riegl.pof_velocity_accuracy"
    "_down_north?\",\"riegl.pof_accuracy_roll\",\"riegl.pof_accuracy_pitch\",\"ri"
    "egl.pof_accuracy_yaw\",\"riegl.pof_path_length?\",\"riegl.pof_pdop\",\"riegl"
    ".pof_hdop\",\"riegl.pof_vdop\",\"riegl.pof_satellites_gnss?\",\"riegl.pof_sa"
    "tellites_gps?\",\"riegl.pof_satellites_glonass?\",\"riegl.pof_satellites_b"
    "eidou?\",\"riegl.pof_satellites_galileo?\",\"riegl.pof_satellites_qzss?\",\""
    "riegl.pof_solution_gnss\",\"riegl.pof_baseline_length?\"],\"metadata\":[\"ri"
    "egl.time_base\",\"riegl.trajectory_info\"]}"
);

// Schema for ".ppx" files
const char* const RDB_SCHEMA_RIEGL_PPX(
    "{\"identifier\":\"ppx\",\"extension\":\"ppx\",\"attributes\":[\"riegl.id\",\"riegl."
    "pps_timestamp_intern*\",\"riegl.pps_timestamp_extern\"],\"metadata\":[\"rieg"
    "l.device\",\"riegl.time_base\"]}"
);

// Schema for ".ptch" files
const char* const RDB_SCHEMA_RIEGL_PROJECT_PTCH(
    "{\"identifier\":\"project.ptch\",\"extension\":\"ptch\",\"attributes\":[\"riegl.x"
    "yz*\",\"riegl.surface_normal\",\"riegl.plane_up\",\"riegl.reflectance?\",\"rie"
    "gl.point_count\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.plane_heigh"
    "t\",\"riegl.plane_count\",\"riegl.covariances\",\"riegl.id\"],\"metadata\":[\"ri"
    "egl.device\",\"riegl.geo_tag?\",\"riegl.scan_pattern?\",\"riegl.time_base?\","
    "\"riegl.plane_patch_statistics?\"]}"
);

// Schema for ".ptch" files
const char* const RDB_SCHEMA_RIEGL_SCAN_PTCH(
    "{\"identifier\":\"scan.ptch\",\"extension\":\"ptch\",\"attributes\":[\"riegl.xyz*"
    "\",\"riegl.xyz_socs\",\"riegl.direction?\",\"riegl.direction_medium?\",\"riegl"
    ".direction_coarse?\",\"riegl.surface_normal\",\"riegl.plane_up\",\"riegl.tim"
    "estamp\",\"riegl.reflectance?\",\"riegl.point_count\",\"riegl.std_dev\",\"rieg"
    "l.plane_width\",\"riegl.plane_height\",\"riegl.plane_count\",\"riegl.mirror_"
    "facet\",\"riegl.covariances\",\"riegl.id\",\"riegl.plane_slope_class?\",\"rieg"
    "l.plane_occupancy\",\"riegl.plane_confidence_normal\",\"riegl.plane_cog_li"
    "nk\",\"riegl.match_count\",\"riegl.platform_rpy_ROCS_NED\",\"riegl.platform_"
    "xyz_ROCS_ENU\",\"riegl.platform_drpy_ROCS_NED\",\"riegl.platform_dxyz_ROCS"
    "_ENU\",\"riegl.sda.shift_vector\",\"riegl.raw_range\",\"riegl.raw_frame_angl"
    "e\",\"riegl.raw_line_angle\"],\"metadata\":[\"riegl.device\",\"riegl.device_ge"
    "ometry\",\"riegl.geo_tag\",\"riegl.georeferencing_parameters\",\"riegl.scan_"
    "pattern?\",\"riegl.time_base\",\"riegl.plane_patch_statistics?\",\"riegl.pla"
    "ne_slope_class_info?\"]}"
);

// Schema for ".ptch" files
const char* const RDB_SCHEMA_RIEGL_SCANPOS_PTCH(
    "{\"identifier\":\"scanpos.ptch\",\"extension\":\"ptch\",\"attributes\":[\"riegl.x"
    "yz*\",\"riegl.surface_normal\",\"riegl.plane_up\",\"riegl.reflectance?\",\"rie"
    "gl.point_count\",\"riegl.std_dev\",\"riegl.plane_width\",\"riegl.plane_heigh"
    "t\",\"riegl.plane_count\",\"riegl.covariances\",\"riegl.id\"],\"metadata\":[\"ri"
    "egl.device\",\"riegl.geo_tag?\",\"riegl.scan_pattern?\",\"riegl.time_base?\","
    "\"riegl.plane_patch_statistics?\"]}"
);

// Schema for ".rdbx" files
const char* const RDB_SCHEMA_RIEGL_RDBX(
    "{\"identifier\":\"rdbx\",\"extension\":\"rdbx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.timestamp\",\"riegl.xyz*\",\"riegl.xyz_socs\",\"riegl.direction_medium?\",\""
    "riegl.direction?\",\"riegl.amplitude\",\"riegl.reflectance?\",\"riegl.deviat"
    "ion?\",\"riegl.pulse_width?\",\"riegl.target_index\",\"riegl.target_count\",\""
    "riegl.mirror_facet?\",\"riegl.scan_segment?\",\"riegl.mta_uncertain_point?"
    "\",\"riegl.mta_zone?\",\"riegl.window_echo_impact_corrected?\",\"riegl.dyntr"
    "ig_uncertain_point?\",\"riegl.rgba?\",\"riegl.class?\",\"riegl.start_of_scan"
    "_line?\",\"riegl.end_of_scan_line?\",\"riegl.source_indicator?\",\"riegl.fwa"
    "?\",\"riegl.waveform_available?\",\"riegl.wfm_sbl_id?\",\"riegl.wfm_echo_tim"
    "e_offset?\",\"riegl.scan_angle\",\"riegl.scan_direction\",\"riegl.source_ind"
    "ex?\",\"riegl.scan_line_index?\",\"riegl.shot_index_line?\",\"riegl.hydro_re"
    "fraction_corrected?\",\"riegl.hydro_intersection_point?\",\"riegl.hydro_in"
    "tersection_normal?\",\"riegl.extinction?\",\"riegl.svb_amplitude_volumetri"
    "c?\",\"riegl.svb_reflectance_volumetric?\",\"riegl.svb_reflectance_bottom_"
    "uncorrected?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\",\"riegl.svb_path"
    "_length?\"],\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl"
    ".device_geometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"rieg"
    "l.exponential_decomposition?\",\"riegl.geo_tag\",\"riegl.georeferencing_pa"
    "rameters\",\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl."
    "noise_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\","
    "\"riegl.pointcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.ran"
    "ge_statistics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calcula"
    "tion?\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.tim"
    "e_base\",\"riegl.waveform_settings?\",\"riegl.window_analysis?\",\"riegl.win"
    "dow_echo_correction?\"]}"
);

// Schema for ".rmvx" files
const char* const RDB_SCHEMA_RIEGL_RMVX(
    "{\"identifier\":\"rmvx\",\"extension\":\"rmvx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.voxel_index*\",\"riegl.amplitude\",\"riegl.reflectance\",\"riegl.deviation"
    "\",\"riegl.direction_medium\",\"riegl.point_count\",\"riegl.voxel_linear_sum"
    "s\",\"riegl.voxel_square_sums\",\"riegl.timestamp_min?\",\"riegl.timestamp_m"
    "ax?\"],\"metadata\":[\"riegl.geo_tag\",\"riegl.voxel_info\",\"riegl.time_base?"
    "\"]}"
);

// Schema for ".rt.llhx" files
const char* const RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX(
    "{\"identifier\":\"trajectory.rt.llhx\",\"extension\":\"rt.llhx\",\"attributes\":"
    "[\"riegl.id\",\"riegl.pof_latitude\",\"riegl.pof_longitude\",\"riegl.pof_heig"
    "ht\",\"riegl.pof_timestamp*\",\"riegl.pof_accuracy_north\",\"riegl.pof_accur"
    "acy_east\",\"riegl.pof_accuracy_down\",\"riegl.pof_pdop\",\"riegl.pof_hdop\","
    "\"riegl.pof_vdop\",\"riegl.pof_age_of_corrections\",\"riegl.pof_baseline_le"
    "ngth\",\"riegl.pof_solution_gnss\",\"riegl.pof_satellites_gnss\",\"riegl.pof"
    "_course?\",\"riegl.pof_xyz_ned_velocity?\"],\"metadata\":[\"riegl.device?\",\""
    "riegl.geo_tag\",\"riegl.time_base\"]}"
);

// Schema for ".s10x" files
const char* const RDB_SCHEMA_RIEGL_S10X(
    "{\"identifier\":\"s10x\",\"extension\":\"s10x\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.timestamp*\",\"riegl.frame_angle_coarse\",\"riegl.gyroscope_raw\",\"riegl."
    "accelerometer_raw\",\"riegl.magnetic_field_sensor_raw\",\"riegl.gyroscope\""
    ",\"riegl.accelerometer\",\"riegl.magnetic_field_sensor\",\"riegl.barometric"
    "_height_amsl\",\"riegl.temperature\",\"riegl.line_scan_active\",\"riegl.fram"
    "e_scan_active\",\"riegl.data_acquisition_active\"],\"metadata\":[\"riegl.tim"
    "e_base\",\"riegl.device?\",\"riegl.pose_sensors\"]}"
);

// Schema for ".sbx" files
const char* const RDB_SCHEMA_RIEGL_SBX(
    "{\"identifier\":\"sbx\",\"extension\":\"sbx\",\"attributes\":[\"riegl.id*\",\"riegl"
    ".wfm_sbl_channel\",\"riegl.wfm_sbl_mean\",\"riegl.wfm_sbl_std_dev\",\"riegl."
    "wfm_sbl_time_offset\",\"riegl.wfm_sda_first\",\"riegl.wfm_sda_count\"],\"met"
    "adata\":[]}"
);

// Schema for ".sdcx" files
const char* const RDB_SCHEMA_RIEGL_SDCX(
    "{\"identifier\":\"sdcx\",\"extension\":\"sdcx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.timestamp*\",\"riegl.xyz\",\"riegl.amplitude\",\"riegl.reflectance?\",\"rieg"
    "l.deviation?\",\"riegl.pulse_width?\",\"riegl.target_index\",\"riegl.target_"
    "count\",\"riegl.mirror_facet?\",\"riegl.scan_segment?\",\"riegl.mta_uncertai"
    "n_point?\",\"riegl.mta_zone?\",\"riegl.window_echo_impact_corrected?\",\"rie"
    "gl.dyntrig_uncertain_point?\",\"riegl.class?\",\"riegl.start_of_scan_line?"
    "\",\"riegl.end_of_scan_line?\",\"riegl.source_indicator?\",\"riegl.fwa?\",\"ri"
    "egl.waveform_available?\",\"riegl.wfm_sbl_id?\",\"riegl.wfm_echo_time_offs"
    "et?\",\"riegl.extinction?\",\"riegl.svb_amplitude_volumetric?\",\"riegl.svb_"
    "surface?\",\"riegl.svb_bottom?\",\"riegl.svb_path_length?\"],\"metadata\":[\"r"
    "iegl.atmosphere\",\"riegl.beam_geometry\",\"riegl.device_geometry\",\"riegl."
    "device\",\"riegl.gaussian_decomposition?\",\"riegl.exponential_decompositi"
    "on?\",\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl.noise"
    "_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\",\"rieg"
    "l.pointcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.range_st"
    "atistics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calculation?"
    "\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.time_bas"
    "e\",\"riegl.window_analysis?\",\"riegl.window_echo_correction?\"]}"
);

// Schema for ".sidx" files
const char* const RDB_SCHEMA_RIEGL_SIDX(
    "{\"identifier\":\"sidx\",\"extension\":\"sidx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.shot_timestamp_hr*\",\"riegl.echo_first\",\"riegl.echo_count\"],\"metadata"
    "\":[\"riegl.shot_info\",\"riegl.echo_info\"]}"
);

// Schema for ".sodx" files
const char* const RDB_SCHEMA_RIEGL_SODX(
    "{\"identifier\":\"sodx\",\"extension\":\"sodx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.shot_timestamp_hr*\",\"riegl.mirror_facet\",\"riegl.scan_segment\",\"riegl"
    ".start_of_scan_line\",\"riegl.line_angle_coarse\",\"riegl.shot_origin\",\"ri"
    "egl.shot_biaxial_shift?\",\"riegl.shot_direction\",\"riegl.shot_direction_"
    "levelled?\",\"riegl.wfm_sbl_first?\",\"riegl.wfm_sbl_count?\",\"riegl.echo_f"
    "irst?\",\"riegl.echo_count?\"],\"metadata\":[\"riegl.atmosphere\",\"riegl.devi"
    "ce\",\"riegl.device_geometry\",\"riegl.device_output_limits\",\"riegl.beam_g"
    "eometry\",\"riegl.near_range_correction?\",\"riegl.window_echo_correction?"
    "\",\"riegl.receiver_internals?\",\"riegl.gaussian_decomposition?\",\"riegl.e"
    "xponential_decomposition?\",\"riegl.mta_settings?\",\"riegl.pulse_position"
    "_modulation?\",\"riegl.notch_filter?\",\"riegl.reflectance_calculation?\",\""
    "riegl.scan_pattern\",\"riegl.time_base\",\"riegl.waveform_info?\",\"riegl.ec"
    "ho_info?\"]}"
);

// Schema for ".sp{C}" files
const char* const RDB_SCHEMA_RIEGL_SPC(
    "{\"identifier\":\"sp{C}\",\"extension\":\"sp{C}\",\"attributes\":[\"riegl.id*\",\"r"
    "iegl.wfm_sample_value\"],\"metadata\":[]}"
);

// Schema for ".vtx" files
const char* const RDB_SCHEMA_RIEGL_VTX(
    "{\"identifier\":\"vtx\",\"extension\":\"vtx\",\"attributes\":[\"riegl.id*\",\"riegl"
    ".xyz\",\"riegl.xyz_accuracies?\"],\"metadata\":[\"riegl.geo_tag\"]}"
);

// Schema for ".vxls" files
const char* const RDB_SCHEMA_RIEGL_VXLS(
    "{\"identifier\":\"vxls\",\"extension\":\"vxls\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.xyz*\",\"riegl.covariances\",\"riegl.pca_axis_max\",\"riegl.pca_axis_min\","
    "\"riegl.pca_extents\",\"riegl.point_count\",\"riegl.reflectance\",\"riegl.sha"
    "pe_id\",\"riegl.voxel_collapsed\",\"riegl.std_dev?\"],\"metadata\":[\"riegl.vo"
    "xel_info\",\"riegl.geo_tag?\"]}"
);

// Schema for ".wdcx" files
const char* const RDB_SCHEMA_RIEGL_WDCX(
    "{\"identifier\":\"wdcx\",\"extension\":\"wdcx\",\"attributes\":[\"riegl.id\",\"rieg"
    "l.timestamp\",\"riegl.xyz*\",\"riegl.xyz_socs\",\"riegl.direction_medium?\",\""
    "riegl.direction?\",\"riegl.amplitude\",\"riegl.reflectance?\",\"riegl.deviat"
    "ion?\",\"riegl.pulse_width?\",\"riegl.target_index\",\"riegl.target_count\",\""
    "riegl.mirror_facet?\",\"riegl.scan_segment?\",\"riegl.mta_uncertain_point?"
    "\",\"riegl.mta_zone?\",\"riegl.window_echo_impact_corrected?\",\"riegl.dyntr"
    "ig_uncertain_point?\",\"riegl.rgba?\",\"riegl.class?\",\"riegl.start_of_scan"
    "_line?\",\"riegl.end_of_scan_line?\",\"riegl.source_indicator?\",\"riegl.fwa"
    "?\",\"riegl.waveform_available?\",\"riegl.wfm_sbl_id?\",\"riegl.wfm_echo_tim"
    "e_offset?\",\"riegl.scan_angle\",\"riegl.scan_direction\",\"riegl.source_ind"
    "ex?\",\"riegl.scan_line_index?\",\"riegl.shot_index_line?\",\"riegl.hydro_re"
    "fraction_corrected?\",\"riegl.hydro_intersection_point?\",\"riegl.hydro_in"
    "tersection_normal?\",\"riegl.extinction?\",\"riegl.svb_amplitude_volumetri"
    "c?\",\"riegl.svb_reflectance_volumetric?\",\"riegl.svb_reflectance_bottom_"
    "uncorrected?\",\"riegl.svb_surface?\",\"riegl.svb_bottom?\",\"riegl.svb_path"
    "_length?\"],\"metadata\":[\"riegl.atmosphere\",\"riegl.beam_geometry\",\"riegl"
    ".device_geometry\",\"riegl.device\",\"riegl.gaussian_decomposition?\",\"rieg"
    "l.exponential_decomposition?\",\"riegl.geo_tag\",\"riegl.georeferencing_pa"
    "rameters\",\"riegl.mta_settings?\",\"riegl.near_range_correction?\",\"riegl."
    "noise_estimates?\",\"riegl.angular_notch_filter?\",\"riegl.notch_filter?\","
    "\"riegl.pointcloud_info?\",\"riegl.pulse_position_modulation?\",\"riegl.ran"
    "ge_statistics?\",\"riegl.receiver_internals?\",\"riegl.reflectance_calcula"
    "tion?\",\"riegl.reflectance_correction?\",\"riegl.scan_pattern\",\"riegl.tim"
    "e_base\",\"riegl.waveform_settings?\",\"riegl.window_analysis?\",\"riegl.win"
    "dow_echo_correction?\"]}"
);

// Schema for ".wex" files
const char* const RDB_SCHEMA_RIEGL_WEX(
    "{\"identifier\":\"wex\",\"extension\":\"wex\",\"attributes\":[\"riegl.id\",\"riegl."
    "timestamp*\",\"riegl.wex_filter_valid\",\"riegl.wex_point_count\",\"riegl.we"
    "x_amplitude\",\"riegl.wex_amplitude_std_dev\",\"riegl.wex_amplitude_min\",\""
    "riegl.wex_amplitude_max\",\"riegl.wex_amplitude_offset\",\"riegl.wex_devia"
    "tion\",\"riegl.wex_deviation_std_dev\",\"riegl.wex_deviation_min\",\"riegl.w"
    "ex_deviation_max\",\"riegl.wex_range\",\"riegl.wex_range_std_dev\",\"riegl.w"
    "ex_range_min\",\"riegl.wex_range_max\",\"riegl.wex_filter_range_min\",\"rieg"
    "l.wex_filter_range_max\",\"riegl.wex_filter_amplitude_max\"],\"metadata\":["
    "\"riegl.device\",\"riegl.notch_filter\",\"riegl.window_analysis\"]}"
);

// Table of all RDB file schema strings
const char* const RDB_SCHEMA_ARRAY[] = {
    RDB_SCHEMA_RIEGL_AVG_FWA,
    RDB_SCHEMA_RIEGL_AVG_SBX,
    RDB_SCHEMA_RIEGL_AVG_SIDX,
    RDB_SCHEMA_RIEGL_AVG_SPC,
    RDB_SCHEMA_RIEGL_BSX,
    RDB_SCHEMA_RIEGL_CPX,
    RDB_SCHEMA_RIEGL_CYL,
    RDB_SCHEMA_RIEGL_DMIX,
    RDB_SCHEMA_RIEGL_DOIX,
    RDB_SCHEMA_RIEGL_EIFX,
    RDB_SCHEMA_RIEGL_EPFX,
    RDB_SCHEMA_RIEGL_FWA,
    RDB_SCHEMA_RIEGL_IMUX,
    RDB_SCHEMA_RIEGL_LLHX,
    RDB_SCHEMA_RIEGL_TRAJECTORY_LLHX,
    RDB_SCHEMA_RIEGL_MPX,
    RDB_SCHEMA_RIEGL_MTCH,
    RDB_SCHEMA_RIEGL_MVX,
    RDB_SCHEMA_RIEGL_OBSX,
    RDB_SCHEMA_RIEGL_OCYL,
    RDB_SCHEMA_RIEGL_OPEFX,
    RDB_SCHEMA_RIEGL_OPP,
    RDB_SCHEMA_RIEGL_OPX,
    RDB_SCHEMA_RIEGL_OWP,
    RDB_SCHEMA_RIEGL_PEFX,
    RDB_SCHEMA_RIEGL_PROJECT_POFX,
    RDB_SCHEMA_RIEGL_SCAN_POFX,
    RDB_SCHEMA_RIEGL_PROJECT_POQX,
    RDB_SCHEMA_RIEGL_SCAN_POQX,
    RDB_SCHEMA_RIEGL_PPX,
    RDB_SCHEMA_RIEGL_PROJECT_PTCH,
    RDB_SCHEMA_RIEGL_SCAN_PTCH,
    RDB_SCHEMA_RIEGL_SCANPOS_PTCH,
    RDB_SCHEMA_RIEGL_RDBX,
    RDB_SCHEMA_RIEGL_RMVX,
    RDB_SCHEMA_RIEGL_TRAJECTORY_RT_LLHX,
    RDB_SCHEMA_RIEGL_S10X,
    RDB_SCHEMA_RIEGL_SBX,
    RDB_SCHEMA_RIEGL_SDCX,
    RDB_SCHEMA_RIEGL_SIDX,
    RDB_SCHEMA_RIEGL_SODX,
    RDB_SCHEMA_RIEGL_SPC,
    RDB_SCHEMA_RIEGL_VTX,
    RDB_SCHEMA_RIEGL_VXLS,
    RDB_SCHEMA_RIEGL_WDCX,
    RDB_SCHEMA_RIEGL_WEX
};
const size_t RDB_SCHEMA_COUNT(
    sizeof(RDB_SCHEMA_ARRAY) / sizeof(RDB_SCHEMA_ARRAY[0])
);

#endif // RDB_2125FB67_4790_4EE4_BC63_844F2ACC9D90
