#*
#*******************************************************************************
#*
#*  Copyright 2025 RIEGL Laser Measurement Systems
#*
#*  Licensed under the Apache License, Version 2.0 (the "License");
#*  you may not use this file except in compliance with the License.
#*  You may obtain a copy of the License at
#*
#*      http://www.apache.org/licenses/LICENSE-2.0
#*
#*  Unless required by applicable law or agreed to in writing, software
#*  distributed under the License is distributed on an "AS IS" BASIS,
#*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#*  See the License for the specific language governing permissions and
#*  limitations under the License.
#*
#*  SPDX-License-Identifier: Apache-2.0
#*
#*******************************************************************************
#*
#*
#*******************************************************************************
#*
#* \file    rdb-config-version.cmake
#* \author  RIEGL LMS GmbH, Austria
#* \brief   Basic version file for the Config-mode of find_package()
#* \version 2016-11-30/GC: Initial version
#*
#*  This is a basic version file for the Config-mode of find_package().
#*  It is used by write_basic_package_version_file() as input file for configure_file()
#*  to create a version-file which can be installed along a config.cmake file.
#*
#*  The created file sets PACKAGE_VERSION_EXACT if the current version string and
#*  the requested version string are exactly the same and it sets
#*  PACKAGE_VERSION_COMPATIBLE if the current version is >= requested version.
#*  The variable CVF_VERSION must be set before calling configure_file().
#*
#*******************************************************************************
#*

# rdblib-2.5.6-arm-linux
set(PACKAGE_VERSION "2.5.6")
set(_PACKAGE_SIZEOF_VOID_P "4")

if(PACKAGE_VERSION VERSION_LESS PACKAGE_FIND_VERSION)
	set(PACKAGE_VERSION_COMPATIBLE FALSE)
else()
	set(PACKAGE_VERSION_COMPATIBLE TRUE)
	if(PACKAGE_FIND_VERSION STREQUAL PACKAGE_VERSION)
		set(PACKAGE_VERSION_EXACT TRUE)
	endif()
endif()

# if the installed or the using project don't have CMAKE_SIZEOF_VOID_P set, ignore it:
if("${CMAKE_SIZEOF_VOID_P}" STREQUAL "" OR "${_PACKAGE_SIZEOF_VOID_P}" STREQUAL "")
	return()
endif()

# check that the installed version has the same 32/64bit-ness as the one which is currently searching:
if(NOT CMAKE_SIZEOF_VOID_P STREQUAL "${_PACKAGE_SIZEOF_VOID_P}")
	math(EXPR installedBits "${_PACKAGE_SIZEOF_VOID_P} * 8")
	set(PACKAGE_VERSION "${PACKAGE_VERSION} (${installedBits}bit)")
	set(PACKAGE_VERSION_UNSUITABLE TRUE)
endif()
