/*
 *******************************************************************************
 *
 *  Copyright 2025 RIEGL Laser Measurement Systems
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *******************************************************************************
 */
/*!
 *******************************************************************************
 *
 * \file    result.h
 * \author  RIEGL LMS GmbH, Austria
 * \brief   Function result for context-free functions
 * \version 2020-02-21/AW: Initial version
 *
 *******************************************************************************
 */

#ifndef RIEGL_RDB_RESULT_H
#define RIEGL_RDB_RESULT_H

//---< INCLUDES >---------------------------------------------------------------

#include "riegl/rdb.h"

//---< FUNCTIONS >--------------------------------------------------------------

RDB_LIBRARY_API_BEGIN

//______________________________________________________________________________
/*!
 * \brief Query function result error code
 */
RDB_FUNCTION_CF(rdb_result_get_error_code_cf,
    RDBResultCF handle, //!< [in]  function result handle
    int32_t    *value   //!< [out] result error code
);

//______________________________________________________________________________
/*!
 * \brief Query function result error text
 */
RDB_FUNCTION_CF(rdb_result_get_error_text_cf,
    RDBResultCF handle, //!< [in]  function result handle
    RDBString  *value   //!< [out] result error text
);

//______________________________________________________________________________
/*!
 * \brief Query function result error details
 */
RDB_FUNCTION_CF(rdb_result_get_error_details_cf,
    RDBResultCF handle, //!< [in]  function result handle
    RDBString  *value   //!< [out] result error details
);

//______________________________________________________________________________
/*!
 * \brief Delete function result structure
 */
RDB_FUNCTION_CF(rdb_result_delete_cf,
    RDBResultCF *handle //!< [in] function result handle
);

//______________________________________________________________________________
/*!
 * \brief Delete string
 *
 * All strings returned by context-free functions ("*_cf") must be deleted.
 */
RDB_FUNCTION_CF(rdb_string_delete_cf,
    RDBString *handle //!< [in] string to be deleted
);

RDB_LIBRARY_API_END

#endif // RIEGL_RDB_RESULT_H
